/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.application.PathCustomizer;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.system.CpuArch;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class PathManager {
    public static final String PROPERTIES_FILE = "idea.properties.file";
    public static final String PROPERTIES_FILE_NAME = "idea.properties";
    public static final String PROPERTY_HOME_PATH = "idea.home.path";
    public static final String PROPERTY_CONFIG_PATH = "idea.config.path";
    public static final String PROPERTY_SYSTEM_PATH = "idea.system.path";
    public static final String PROPERTY_SCRATCH_PATH = "idea.scratch.path";
    public static final String PROPERTY_PLUGINS_PATH = "idea.plugins.path";
    public static final String PROPERTY_LOG_PATH = "idea.log.path";
    public static final String PROPERTY_LOG_CONFIG_FILE = "idea.log.config.properties.file";
    public static final String PROPERTY_PATHS_SELECTOR = "idea.paths.selector";
    public static final String SYSTEM_PATHS_CUSTOMIZER = "idea.paths.customizer";
    public static final String OPTIONS_DIRECTORY = "options";
    public static final String DEFAULT_EXT = ".xml";
    private static final String PROPERTY_HOME = "idea.home";
    private static final String PROPERTY_VENDOR_NAME = "idea.vendor.name";
    private static final String JRE_DIRECTORY = "jbr";
    private static final String LIB_DIRECTORY = "lib";
    private static final String PLUGINS_DIRECTORY = "plugins";
    private static final String BIN_DIRECTORY = "bin";
    private static final String LOG_DIRECTORY = "log";
    private static final String CONFIG_DIRECTORY = "config";
    private static final String SYSTEM_DIRECTORY = "system";
    private static final String PATHS_SELECTOR = System.getProperty("idea.paths.selector");
    private static volatile String ourHomePath;
    private static volatile List<Path> ourBinDirectories;
    private static Path ourCommonDataPath;
    private static String ourConfigPath;
    private static String ourSystemPath;
    private static String ourScratchPath;
    private static String ourPluginPath;
    private static String ourLogPath;
    private static Path ourStartupScriptDir;

    @NotNull
    public static String getHomePath() {
        String string2 = PathManager.getHomePath(true);
        if (string2 == null) {
            PathManager.$$$reportNull$$$0(0);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Contract(value="true -> !null")
    public static String getHomePath(boolean insideIde) {
        String result2 = ourHomePath;
        if (result2 != null) {
            return result2;
        }
        Class<PathManager> clazz = PathManager.class;
        synchronized (PathManager.class) {
            result2 = ourHomePath;
            if (result2 != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return result2;
            }
            String explicit = PathManager.getExplicitPath(PROPERTY_HOME_PATH);
            if (explicit == null) {
                explicit = PathManager.getExplicitPath(PROPERTY_HOME);
            }
            if (explicit != null) {
                result2 = explicit;
                if (!Files.isDirectory(Paths.get(result2, new String[0]), new LinkOption[0])) {
                    ourHomePath = result2;
                    throw new RuntimeException("Invalid home path '" + result2 + "'");
                }
            } else if (insideIde && (result2 = PathManager.getHomePathFor(PathManager.class)) == null) {
                String advice = SystemInfoRt.isMac ? "reinstall the software." : "make sure bin/idea.properties is present in the installation directory.";
                throw new RuntimeException("Could not find installation home path. Please " + advice);
            }
            if (result2 != null && SystemInfoRt.isWindows) {
                try {
                    result2 = Paths.get(result2, new String[0]).toRealPath(LinkOption.NOFOLLOW_LINKS).toString();
                }
                catch (IOException advice) {
                    // empty catch block
                }
            }
            if (result2 == null) {
                ourBinDirectories = Collections.emptyList();
            } else {
                Path root = Paths.get(result2, new String[0]);
                if (Boolean.getBoolean("idea.use.dev.build.server")) {
                    root = root.resolve("../../..").normalize();
                }
                ourBinDirectories = PathManager.getBinDirectories(root);
            }
            ourHomePath = result2;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return result2;
        }
    }

    private static List<Path> getBinDirectories() {
        List<Path> result2 = ourBinDirectories;
        if (result2 == null) {
            PathManager.getHomePath(true);
            result2 = ourBinDirectories;
        }
        return result2;
    }

    public static boolean isUnderHomeDirectory(@NotNull String path) {
        if (path == null) {
            PathManager.$$$reportNull$$$0(1);
        }
        try {
            return PathManager.isUnderHomeDirectory(Paths.get(path, new String[0]));
        }
        catch (InvalidPathException e) {
            return false;
        }
    }

    public static boolean isUnderHomeDirectory(@NotNull Path target) {
        if (target == null) {
            PathManager.$$$reportNull$$$0(2);
        }
        Path home = Paths.get(PathManager.getHomePath(), new String[0]);
        try {
            home = home.toRealPath(new LinkOption[0]);
            target = target.toRealPath(new LinkOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return target.startsWith(home);
    }

    @Nullable
    public static String getHomePathFor(@NotNull Class<?> aClass) {
        Path result2;
        if (aClass == null) {
            PathManager.$$$reportNull$$$0(3);
        }
        return (result2 = PathManager.getHomeDirFor(aClass)) == null ? null : result2.toString();
    }

    @Nullable
    public static Path getHomeDirFor(@NotNull Class<?> aClass) {
        if (aClass == null) {
            PathManager.$$$reportNull$$$0(4);
        }
        Path result2 = null;
        String rootPath = PathManager.getResourceRoot(aClass, '/' + aClass.getName().replace('.', '/') + ".class");
        if (rootPath != null) {
            Path root = Paths.get(rootPath, new String[0]).toAbsolutePath();
            while ((root = root.getParent()) != null && !PathManager.isIdeaHome(root)) {
            }
            result2 = root;
        }
        return result2;
    }

    private static boolean isIdeaHome(Path root) {
        for (Path binDir : PathManager.getBinDirectories(root)) {
            if (!Files.isRegularFile(binDir.resolve(PROPERTIES_FILE_NAME), new LinkOption[0])) continue;
            return true;
        }
        return false;
    }

    private static List<Path> getBinDirectories(Path root) {
        ArrayList<Path> binDirs = new ArrayList<Path>();
        Path[] candidates = new Path[]{root.resolve(BIN_DIRECTORY), Paths.get(PathManager.getCommunityHomePath(root.toString()), BIN_DIRECTORY)};
        String osSuffix = SystemInfoRt.isWindows ? "win" : (SystemInfoRt.isMac ? "mac" : "linux");
        for (Path dir : candidates) {
            String arch;
            if (binDirs.contains(dir) || !Files.isDirectory(dir, new LinkOption[0])) continue;
            binDirs.add(dir);
            dir = dir.resolve(osSuffix);
            if (!Files.isDirectory(dir, new LinkOption[0])) continue;
            binDirs.add(dir);
            if (!SystemInfoRt.isWindows && !SystemInfoRt.isLinux) continue;
            String string2 = CpuArch.isIntel64() ? "amd64" : (arch = CpuArch.isArm64() ? "aarch64" : null);
            if (arch == null || !Files.isDirectory(dir = dir.resolve(arch), new LinkOption[0])) continue;
            binDirs.add(dir);
        }
        return binDirs;
    }

    @NotNull
    public static String getBinPath() {
        String string2 = PathManager.getHomePath() + '/' + BIN_DIRECTORY;
        if (string2 == null) {
            PathManager.$$$reportNull$$$0(5);
        }
        return string2;
    }

    @Nullable
    public static Path findBinFile(@NotNull String fileName) {
        if (fileName == null) {
            PathManager.$$$reportNull$$$0(6);
        }
        for (Path binDir : PathManager.getBinDirectories()) {
            Path candidate = binDir.resolve(fileName);
            if (!Files.isRegularFile(candidate, new LinkOption[0])) continue;
            return candidate;
        }
        return null;
    }

    @NotNull
    public static Path findBinFileWithException(@NotNull String fileName) {
        Path file2;
        if (fileName == null) {
            PathManager.$$$reportNull$$$0(7);
        }
        if ((file2 = PathManager.findBinFile(fileName)) != null) {
            Path path = file2;
            if (path == null) {
                PathManager.$$$reportNull$$$0(8);
            }
            return path;
        }
        StringBuilder message = new StringBuilder();
        message.append('\'').append(fileName).append("' not found in directories:");
        for (Path directory : PathManager.getBinDirectories()) {
            message.append('\n').append(directory);
        }
        throw new RuntimeException(message.toString());
    }

    @NotNull
    public static String getLibPath() {
        String string2 = PathManager.getHomePath() + '/' + LIB_DIRECTORY;
        if (string2 == null) {
            PathManager.$$$reportNull$$$0(9);
        }
        return string2;
    }

    @NotNull
    public static String getPreInstalledPluginsPath() {
        String string2 = PathManager.getHomePath() + '/' + PLUGINS_DIRECTORY;
        if (string2 == null) {
            PathManager.$$$reportNull$$$0(10);
        }
        return string2;
    }

    @NotNull
    public static String getBundledRuntimePath() {
        String string2 = PathManager.getHomePath() + '/' + JRE_DIRECTORY + (SystemInfoRt.isMac ? "/Contents/Home" : "");
        if (string2 == null) {
            PathManager.$$$reportNull$$$0(11);
        }
        return string2;
    }

    @NotNull
    public static synchronized Path getCommonDataPath() {
        if (ourCommonDataPath == null) {
            Path path = Paths.get(PathManager.platformPath("", "Application Support", "", "APPDATA", "", "XDG_DATA_HOME", ".local/share", ""), new String[0]);
            if (!Files.exists(path, LinkOption.NOFOLLOW_LINKS)) {
                try {
                    Files.createDirectories(path, new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            ourCommonDataPath = path;
        }
        Path path = ourCommonDataPath;
        if (path == null) {
            PathManager.$$$reportNull$$$0(12);
        }
        return path;
    }

    @Nullable
    public static String getPathsSelector() {
        return PATHS_SELECTOR;
    }

    @NotNull
    public static Path getConfigDir() {
        Path path = Paths.get(PathManager.getConfigPath(), new String[0]);
        if (path == null) {
            PathManager.$$$reportNull$$$0(13);
        }
        return path;
    }

    @NotNull
    public static String getConfigPath() {
        if (ourConfigPath != null) {
            String string2 = ourConfigPath;
            if (string2 == null) {
                PathManager.$$$reportNull$$$0(14);
            }
            return string2;
        }
        String explicit = PathManager.getExplicitPath(PROPERTY_CONFIG_PATH);
        ourConfigPath = explicit != null ? explicit : (PATHS_SELECTOR != null ? PathManager.getDefaultConfigPathFor(PATHS_SELECTOR) : PathManager.getHomePath() + '/' + CONFIG_DIRECTORY);
        String string3 = ourConfigPath;
        if (string3 == null) {
            PathManager.$$$reportNull$$$0(15);
        }
        return string3;
    }

    @TestOnly
    public static void setExplicitConfigPath(@Nullable String path) {
        ourConfigPath = path;
    }

    @NotNull
    public static String getScratchPath() {
        if (ourScratchPath != null) {
            String string2 = ourScratchPath;
            if (string2 == null) {
                PathManager.$$$reportNull$$$0(16);
            }
            return string2;
        }
        String explicit = PathManager.getExplicitPath(PROPERTY_SCRATCH_PATH);
        ourScratchPath = explicit != null ? explicit : PathManager.getConfigPath();
        String string3 = ourScratchPath;
        if (string3 == null) {
            PathManager.$$$reportNull$$$0(17);
        }
        return string3;
    }

    @NotNull
    public static String getDefaultConfigPathFor(@NotNull String selector) {
        if (selector == null) {
            PathManager.$$$reportNull$$$0(18);
        }
        String string2 = PathManager.platformPath(selector, "Application Support", "", "APPDATA", "", "XDG_CONFIG_HOME", ".config", "");
        if (string2 == null) {
            PathManager.$$$reportNull$$$0(19);
        }
        return string2;
    }

    @NotNull
    public static String getOptionsPath() {
        String string2 = PathManager.getConfigPath() + '/' + OPTIONS_DIRECTORY;
        if (string2 == null) {
            PathManager.$$$reportNull$$$0(20);
        }
        return string2;
    }

    @NotNull
    public static File getOptionsFile(@NotNull String fileName) {
        if (fileName == null) {
            PathManager.$$$reportNull$$$0(21);
        }
        File file2 = Paths.get(PathManager.getOptionsPath(), fileName + DEFAULT_EXT).toFile();
        if (file2 == null) {
            PathManager.$$$reportNull$$$0(22);
        }
        return file2;
    }

    @NotNull
    public static Path getPluginsDir() {
        Path path = Paths.get(PathManager.getPluginsPath(), new String[0]);
        if (path == null) {
            PathManager.$$$reportNull$$$0(23);
        }
        return path;
    }

    @NotNull
    public static String getPluginsPath() {
        if (ourPluginPath != null) {
            String string2 = ourPluginPath;
            if (string2 == null) {
                PathManager.$$$reportNull$$$0(24);
            }
            return string2;
        }
        String explicit = PathManager.getExplicitPath(PROPERTY_PLUGINS_PATH);
        ourPluginPath = explicit != null ? explicit : (PATHS_SELECTOR != null && System.getProperty(PROPERTY_CONFIG_PATH) == null ? PathManager.getDefaultPluginPathFor(PATHS_SELECTOR) : PathManager.getConfigPath() + '/' + PLUGINS_DIRECTORY);
        String string3 = ourPluginPath;
        if (string3 == null) {
            PathManager.$$$reportNull$$$0(25);
        }
        return string3;
    }

    @NotNull
    public static String getDefaultPluginPathFor(@NotNull String selector) {
        if (selector == null) {
            PathManager.$$$reportNull$$$0(26);
        }
        String string2 = PathManager.platformPath(selector, "Application Support", PLUGINS_DIRECTORY, "APPDATA", PLUGINS_DIRECTORY, "XDG_DATA_HOME", ".local/share", "");
        if (string2 == null) {
            PathManager.$$$reportNull$$$0(27);
        }
        return string2;
    }

    @Nullable
    public static String getCustomOptionsDirectory() {
        return PATHS_SELECTOR != null ? PathManager.getDefaultConfigPathFor(PATHS_SELECTOR) : null;
    }

    @NotNull
    public static Path getSystemDir() {
        Path path = Paths.get(PathManager.getSystemPath(), new String[0]);
        if (path == null) {
            PathManager.$$$reportNull$$$0(28);
        }
        return path;
    }

    @NotNull
    public static String getSystemPath() {
        if (ourSystemPath != null) {
            String string2 = ourSystemPath;
            if (string2 == null) {
                PathManager.$$$reportNull$$$0(29);
            }
            return string2;
        }
        String explicit = PathManager.getExplicitPath(PROPERTY_SYSTEM_PATH);
        ourSystemPath = explicit != null ? explicit : (PATHS_SELECTOR != null ? PathManager.getDefaultSystemPathFor(PATHS_SELECTOR) : PathManager.getHomePath() + '/' + SYSTEM_DIRECTORY);
        String string3 = ourSystemPath;
        if (string3 == null) {
            PathManager.$$$reportNull$$$0(30);
        }
        return string3;
    }

    @NotNull
    public static String getDefaultSystemPathFor(@NotNull String selector) {
        if (selector == null) {
            PathManager.$$$reportNull$$$0(31);
        }
        String string2 = PathManager.platformPath(selector, "Caches", "", "LOCALAPPDATA", "", "XDG_CACHE_HOME", ".cache", "");
        if (string2 == null) {
            PathManager.$$$reportNull$$$0(32);
        }
        return string2;
    }

    @NotNull
    public static String getDefaultUnixSystemPath(@NotNull String userHome, @NotNull String selector) {
        if (userHome == null) {
            PathManager.$$$reportNull$$$0(33);
        }
        if (selector == null) {
            PathManager.$$$reportNull$$$0(34);
        }
        String string2 = PathManager.getUnixPlatformPath(userHome, selector, null, ".cache", "");
        if (string2 == null) {
            PathManager.$$$reportNull$$$0(35);
        }
        return string2;
    }

    @NotNull
    public static String getTempPath() {
        String string2 = PathManager.getSystemPath() + "/tmp";
        if (string2 == null) {
            PathManager.$$$reportNull$$$0(36);
        }
        return string2;
    }

    @NotNull
    public static Path getIndexRoot() {
        String indexRootPath = PathManager.getExplicitPath("index_root_path");
        if (indexRootPath == null) {
            indexRootPath = PathManager.getSystemPath() + "/index";
        }
        Path path = Paths.get(indexRootPath, new String[0]);
        if (path == null) {
            PathManager.$$$reportNull$$$0(37);
        }
        return path;
    }

    @NotNull
    public static Path getLogDir() {
        Path path = Paths.get(PathManager.getLogPath(), new String[0]);
        if (path == null) {
            PathManager.$$$reportNull$$$0(38);
        }
        return path;
    }

    @NotNull
    public static String getLogPath() {
        if (ourLogPath != null) {
            String string2 = ourLogPath;
            if (string2 == null) {
                PathManager.$$$reportNull$$$0(39);
            }
            return string2;
        }
        String explicit = PathManager.getExplicitPath(PROPERTY_LOG_PATH);
        ourLogPath = explicit != null ? explicit : (PATHS_SELECTOR != null && System.getProperty(PROPERTY_SYSTEM_PATH) == null ? PathManager.getDefaultLogPathFor(PATHS_SELECTOR) : PathManager.getSystemPath() + '/' + LOG_DIRECTORY);
        String string3 = ourLogPath;
        if (string3 == null) {
            PathManager.$$$reportNull$$$0(40);
        }
        return string3;
    }

    @NotNull
    public static String getDefaultLogPathFor(@NotNull String selector) {
        if (selector == null) {
            PathManager.$$$reportNull$$$0(41);
        }
        String string2 = PathManager.platformPath(selector, "Logs", "", "LOCALAPPDATA", LOG_DIRECTORY, "XDG_CACHE_HOME", ".cache", LOG_DIRECTORY);
        if (string2 == null) {
            PathManager.$$$reportNull$$$0(42);
        }
        return string2;
    }

    @ApiStatus.Internal
    @NotNull
    public static Path getStartupScriptDir() {
        if (ourStartupScriptDir != null) {
            Path path = ourStartupScriptDir;
            if (path == null) {
                PathManager.$$$reportNull$$$0(43);
            }
            return path;
        }
        Path path = PathManager.getSystemDir().resolve(PLUGINS_DIRECTORY);
        if (path == null) {
            PathManager.$$$reportNull$$$0(44);
        }
        return path;
    }

    @ApiStatus.Obsolete
    @NotNull
    public static String getPluginTempPath() {
        String string2 = PathManager.getSystemPath() + '/' + PLUGINS_DIRECTORY;
        if (string2 == null) {
            PathManager.$$$reportNull$$$0(45);
        }
        return string2;
    }

    @Nullable
    public static String getResourceRoot(@NotNull Class<?> context, @NotNull String path) {
        URL url;
        if (context == null) {
            PathManager.$$$reportNull$$$0(46);
        }
        if (path == null) {
            PathManager.$$$reportNull$$$0(47);
        }
        if ((url = context.getResource(path)) == null) {
            url = ClassLoader.getSystemResource(path.substring(1));
        }
        return url != null ? PathManager.extractRoot(url, path) : null;
    }

    @Nullable
    public static String getResourceRoot(@NotNull ClassLoader classLoader, @NotNull String resourcePath) {
        URL url;
        if (classLoader == null) {
            PathManager.$$$reportNull$$$0(48);
        }
        if (resourcePath == null) {
            PathManager.$$$reportNull$$$0(49);
        }
        return (url = classLoader.getResource(resourcePath)) == null ? null : PathManager.extractRoot(url, "/" + resourcePath);
    }

    @Nullable
    private static String extractRoot(URL resourceURL, String resourcePath) {
        if (resourcePath.isEmpty() || resourcePath.charAt(0) != '/' && resourcePath.charAt(0) != '\\') {
            PathManager.log("precondition failed: " + resourcePath);
            return null;
        }
        String resultPath = null;
        String protocol = resourceURL.getProtocol();
        if ("file".equals(protocol)) {
            File result2;
            try {
                result2 = new File(resourceURL.toURI().getSchemeSpecificPart());
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("URL='" + resourceURL + "'", e);
            }
            String path = result2.getPath();
            String testPath = path.replace('\\', '/');
            String testResourcePath = resourcePath.replace('\\', '/');
            if (StringUtilRt.endsWithIgnoreCase((CharSequence)testPath, (CharSequence)testResourcePath)) {
                resultPath = path.substring(0, path.length() - resourcePath.length());
            }
        } else if ("jar".equals(protocol)) {
            String jarPath = PathManager.splitJarUrl(resourceURL.getFile());
            if (jarPath != null) {
                resultPath = jarPath;
            }
        } else if ("jrt".equals(protocol)) {
            return null;
        }
        if (resultPath == null) {
            PathManager.log("cannot extract '" + resourcePath + "' from '" + resourceURL + "'");
            return null;
        }
        return Paths.get(resultPath, new String[0]).normalize().toString();
    }

    @Nullable
    private static String splitJarUrl(@NotNull String url) {
        int pivot;
        if (url == null) {
            PathManager.$$$reportNull$$$0(50);
        }
        if ((pivot = url.indexOf("!/")) < 0) {
            return null;
        }
        String jarPath = url.substring(0, pivot);
        boolean startsWithConcatenation = true;
        int offset = 0;
        for (String prefix : new String[]{"jar", ":"}) {
            int prefixLen = prefix.length();
            if (!jarPath.regionMatches(offset, prefix, 0, prefixLen)) {
                startsWithConcatenation = false;
                break;
            }
            offset += prefixLen;
        }
        if (startsWithConcatenation) {
            jarPath = jarPath.substring("jar".length() + 1);
        }
        if (!jarPath.startsWith("file")) {
            return jarPath;
        }
        try {
            File result2;
            URL parsedUrl = new URL(jarPath);
            try {
                result2 = new File(parsedUrl.toURI().getSchemeSpecificPart());
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("URL='" + parsedUrl + "'", e);
            }
            return result2.getPath().replace('\\', '/');
        }
        catch (Exception e) {
            jarPath = jarPath.substring("file".length());
            if (jarPath.startsWith("://")) {
                return jarPath.substring("://".length());
            }
            if (!jarPath.isEmpty() && jarPath.charAt(0) == ':') {
                return jarPath.substring(1);
            }
            return jarPath;
        }
    }

    public static void loadProperties() {
        LinkedHashSet<String> paths = new LinkedHashSet<String>();
        paths.add(System.getProperty(PROPERTIES_FILE));
        paths.add(PathManager.getCustomPropertiesFile());
        paths.add(System.getProperty("user.home") + '/' + PROPERTIES_FILE_NAME);
        final String homePath = PathManager.getHomePath(true);
        for (Path binDir : PathManager.getBinDirectories()) {
            paths.add(binDir.resolve(PROPERTIES_FILE_NAME).toString());
        }
        final Properties sysProperties = System.getProperties();
        for (final String path : paths) {
            Path file2;
            Path path2 = file2 = path == null ? null : Paths.get(path, new String[0]);
            if (file2 == null) continue;
            try {
                BufferedReader reader = Files.newBufferedReader(file2);
                try {
                    new Properties(){

                        @Override
                        public Object put(Object key, Object value) {
                            if (PathManager.PROPERTY_HOME_PATH.equals(key) || PathManager.PROPERTY_HOME.equals(key)) {
                                PathManager.log(path + ": '" + key + "' cannot be redefined");
                            } else if (!sysProperties.containsKey(key)) {
                                sysProperties.put(key, PathManager.substituteVars((String)value, homePath));
                            }
                            return null;
                        }
                    }.load(reader);
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
            catch (AccessDeniedException | NoSuchFileException reader) {
            }
            catch (IOException e) {
                PathManager.log("Can't read property file '" + path + "': " + e.getMessage());
            }
        }
        if ("true".equals(sysProperties.getProperty("jbScreenMenuBar.enabled"))) {
            sysProperties.setProperty("apple.laf.useScreenMenuBar", "false");
        }
    }

    public static void customizePaths() {
        String property = System.getProperty(SYSTEM_PATHS_CUSTOMIZER);
        if (property == null) {
            return;
        }
        try {
            PathCustomizer.CustomPaths paths;
            Class<?> aClass = PathManager.class.getClassLoader().loadClass(property);
            Object customizer2 = aClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            if (customizer2 instanceof PathCustomizer && (paths = ((PathCustomizer)customizer2).customizePaths()) != null) {
                if (paths.configPath != null) {
                    System.setProperty(PROPERTY_CONFIG_PATH, paths.configPath);
                }
                if (paths.systemPath != null) {
                    System.setProperty(PROPERTY_SYSTEM_PATH, paths.systemPath);
                }
                if (paths.pluginsPath != null) {
                    System.setProperty(PROPERTY_PLUGINS_PATH, paths.pluginsPath);
                }
                if (paths.logDirPath != null) {
                    System.setProperty(PROPERTY_LOG_PATH, paths.logDirPath);
                }
                if (paths.startupScriptDir != null) {
                    ourStartupScriptDir = paths.startupScriptDir;
                }
                ourConfigPath = null;
                ourSystemPath = null;
                ourPluginPath = null;
                ourScratchPath = null;
                ourLogPath = null;
            }
        }
        catch (Throwable e) {
            PathManager.log(e.getMessage());
        }
    }

    private static String getCustomPropertiesFile() {
        String configPath = PathManager.getCustomOptionsDirectory();
        return configPath != null ? configPath + '/' + PROPERTIES_FILE_NAME : null;
    }

    @Contract(value="null -> null")
    public static String substituteVars(String s) {
        return PathManager.substituteVars(s, PathManager.getHomePath());
    }

    @Contract(value="null, _ -> null")
    public static String substituteVars(String s, @NotNull String ideaHomePath) {
        if (ideaHomePath == null) {
            PathManager.$$$reportNull$$$0(51);
        }
        if (s == null) {
            return null;
        }
        if (s.startsWith("..")) {
            s = ideaHomePath + '/' + BIN_DIRECTORY + '/' + s;
        }
        Matcher m = Lazy.PROPERTY_REF.matcher(s);
        while (m.find()) {
            String key = m.group(1);
            String value = System.getProperty(key);
            if (value == null) {
                switch (key) {
                    case "idea.home.path": 
                    case "idea.home": {
                        value = ideaHomePath;
                        break;
                    }
                    case "idea.config.path": {
                        value = PathManager.getConfigPath();
                        break;
                    }
                    case "idea.system.path": {
                        value = PathManager.getSystemPath();
                    }
                }
            }
            if (value == null) {
                PathManager.log("Unknown property: " + key);
                value = "";
            }
            s = s.replace(m.group(), value);
            m = Lazy.PROPERTY_REF.matcher(s);
        }
        return s;
    }

    @NotNull
    public static File findFileInLibDirectory(@NotNull String relativePath) {
        Path file2;
        if (relativePath == null) {
            PathManager.$$$reportNull$$$0(52);
        }
        if (!Files.exists(file2 = Paths.get(PathManager.getLibPath(), relativePath), new LinkOption[0])) {
            file2 = Paths.get(PathManager.getHomePath(), "community/lib/" + relativePath);
        }
        File file3 = file2.toFile();
        if (file3 == null) {
            PathManager.$$$reportNull$$$0(53);
        }
        return file3;
    }

    @NotNull
    public static String getCommunityHomePath() {
        return PathManager.getCommunityHomePath(PathManager.getHomePath());
    }

    @NotNull
    private static String getCommunityHomePath(@NotNull String homePath) {
        boolean isRunningFromSources;
        if (homePath == null) {
            PathManager.$$$reportNull$$$0(54);
        }
        if (!(isRunningFromSources = Files.isDirectory(Paths.get(homePath, ".idea"), new LinkOption[0]))) {
            String string2 = homePath;
            if (string2 == null) {
                PathManager.$$$reportNull$$$0(55);
            }
            return string2;
        }
        if (Files.isDirectory(Paths.get(homePath, "community/.idea"), new LinkOption[0])) {
            String string3 = homePath + "/community";
            if (string3 == null) {
                PathManager.$$$reportNull$$$0(56);
            }
            return string3;
        }
        if (Files.isDirectory(Paths.get(homePath, "ultimate/community/.idea"), new LinkOption[0])) {
            String string4 = homePath + "/ultimate/community";
            if (string4 == null) {
                PathManager.$$$reportNull$$$0(57);
            }
            return string4;
        }
        if (Files.isDirectory(Paths.get(homePath, "../../../community/.idea"), new LinkOption[0])) {
            String string5 = homePath + "/../../../community";
            if (string5 == null) {
                PathManager.$$$reportNull$$$0(58);
            }
            return string5;
        }
        if (Files.isRegularFile(Paths.get(homePath, "../../.dotnet-products.root.marker"), new LinkOption[0])) {
            String string6 = homePath + "/../ultimate/community";
            if (string6 == null) {
                PathManager.$$$reportNull$$$0(59);
            }
            return string6;
        }
        String string7 = homePath;
        if (string7 == null) {
            PathManager.$$$reportNull$$$0(60);
        }
        return string7;
    }

    @Nullable
    public static String getJarPathForClass(@NotNull Class<?> aClass) {
        Path resourceRoot;
        if (aClass == null) {
            PathManager.$$$reportNull$$$0(61);
        }
        return (resourceRoot = PathManager.getJarForClass(aClass)) == null ? null : resourceRoot.toString();
    }

    @Nullable
    public static Path getJarForClass(@NotNull Class<?> aClass) {
        String resourceRoot;
        if (aClass == null) {
            PathManager.$$$reportNull$$$0(62);
        }
        return (resourceRoot = PathManager.getResourceRoot(aClass, '/' + aClass.getName().replace('.', '/') + ".class")) == null ? null : Paths.get(resourceRoot, new String[0]).toAbsolutePath();
    }

    private static void log(String x) {
        System.err.println(x);
    }

    @NotNull
    public static String getAbsolutePath(@NotNull String path) {
        if (path == null) {
            PathManager.$$$reportNull$$$0(63);
        }
        if (path.startsWith("~/") || path.startsWith("~\\")) {
            path = System.getProperty("user.home") + path.substring(1);
        }
        String string2 = Paths.get(path, new String[0]).toAbsolutePath().normalize().toString();
        if (string2 == null) {
            PathManager.$$$reportNull$$$0(64);
        }
        return string2;
    }

    @Nullable
    private static String getExplicitPath(@NotNull String property) {
        String path;
        if (property == null) {
            PathManager.$$$reportNull$$$0(65);
        }
        if ((path = System.getProperty(property)) == null) {
            return null;
        }
        boolean quoted = path.length() > 1 && '\"' == path.charAt(0) && '\"' == path.charAt(path.length() - 1);
        return PathManager.getAbsolutePath(quoted ? path.substring(1, path.length() - 1) : path);
    }

    private static String platformPath(String selector, String macDir, String macSub, String winVar, String winSub, String xdgVar, String xdgDfl, String xdgSub) {
        String userHome = System.getProperty("user.home");
        String vendorName = PathManager.vendorName();
        if (SystemInfoRt.isMac) {
            String dir = userHome + "/Library/" + macDir + '/' + vendorName;
            if (!selector.isEmpty()) {
                dir = dir + '/' + selector;
            }
            if (!macSub.isEmpty()) {
                dir = dir + '/' + macSub;
            }
            return dir;
        }
        if (SystemInfoRt.isWindows) {
            String dir = System.getenv(winVar);
            if (dir == null || dir.isEmpty()) {
                dir = userHome + "\\AppData\\" + (winVar.startsWith("LOCAL") ? "Local" : "Roaming");
            }
            dir = dir + '\\' + vendorName;
            if (!selector.isEmpty()) {
                dir = dir + '\\' + selector;
            }
            if (!winSub.isEmpty()) {
                dir = dir + '\\' + winSub;
            }
            return dir;
        }
        if (SystemInfoRt.isUnix) {
            return PathManager.getUnixPlatformPath(userHome, selector, xdgVar, xdgDfl, xdgSub);
        }
        throw new UnsupportedOperationException("Unsupported OS: " + SystemInfoRt.OS_NAME);
    }

    private static String getUnixPlatformPath(String userHome, String selector, @Nullable String xdgVar, String xdgDfl, String xdgSub) {
        String dir;
        String string2 = dir = xdgVar != null ? System.getenv(xdgVar) : null;
        if (dir == null || dir.isEmpty()) {
            dir = userHome + '/' + xdgDfl;
        }
        dir = dir + '/' + PathManager.vendorName();
        if (!selector.isEmpty()) {
            dir = dir + '/' + selector;
        }
        if (!xdgSub.isEmpty()) {
            dir = dir + '/' + xdgSub;
        }
        return dir;
    }

    private static String vendorName() {
        String property = System.getProperty(PROPERTY_VENDOR_NAME);
        if (property == null) {
            try {
                Class<?> ex = Class.forName("com.intellij.openapi.application.ex.ApplicationInfoEx");
                Class<?> impl = Class.forName("com.intellij.openapi.application.impl.ApplicationInfoImpl");
                MethodHandles.Lookup lookup = MethodHandles.lookup();
                Object instance = lookup.findStatic(impl, "getShadowInstance", MethodType.methodType(ex)).invoke();
                property = lookup.findVirtual(impl, "getShortCompanyName", MethodType.methodType(String.class)).invoke(instance);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            System.setProperty(PROPERTY_VENDOR_NAME, property != null ? property : "JetBrains");
        }
        return property;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 18: 
            case 21: 
            case 26: 
            case 31: 
            case 33: 
            case 34: 
            case 41: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 61: 
            case 62: 
            case 63: 
            case 65: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 18: 
            case 21: 
            case 26: 
            case 31: 
            case 33: 
            case 34: 
            case 41: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 61: 
            case 62: 
            case 63: 
            case 65: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/application/PathManager";
                break;
            }
            case 1: 
            case 47: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 3: 
            case 4: 
            case 61: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 6: 
            case 7: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 18: 
            case 26: 
            case 31: 
            case 34: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selector";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userHome";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classLoader";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourcePath";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideaHomePath";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "homePath";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getHomePath";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 18: 
            case 21: 
            case 26: 
            case 31: 
            case 33: 
            case 34: 
            case 41: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 61: 
            case 62: 
            case 63: 
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/application/PathManager";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinPath";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findBinFileWithException";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibPath";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreInstalledPluginsPath";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getBundledRuntimePath";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonDataPath";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigDir";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigPath";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getScratchPath";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultConfigPathFor";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPath";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsFile";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginsDir";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginsPath";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultPluginPathFor";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemDir";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemPath";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultSystemPathFor";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultUnixSystemPath";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempPath";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexRoot";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogDir";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogPath";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLogPathFor";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getStartupScriptDir";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginTempPath";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "findFileInLibDirectory";
                break;
            }
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommunityHomePath";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "getAbsolutePath";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isUnderHomeDirectory";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getHomePathFor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getHomeDirFor";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findBinFile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findBinFileWithException";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultConfigPathFor";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getOptionsFile";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultPluginPathFor";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultSystemPathFor";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultUnixSystemPath";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultLogPathFor";
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getResourceRoot";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "splitJarUrl";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "substituteVars";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "findFileInLibDirectory";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getCommunityHomePath";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "getJarPathForClass";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "getJarForClass";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "getAbsolutePath";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "getExplicitPath";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 18: 
            case 21: 
            case 26: 
            case 31: 
            case 33: 
            case 34: 
            case 41: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 61: 
            case 62: 
            case 63: 
            case 65: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class Lazy {
        private static final Pattern PROPERTY_REF = Pattern.compile("\\$\\{(.+?)}");

        private Lazy() {
        }
    }
}

