/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import com.intellij.openapi.util.io.FileUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0001\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\n\u0010\u0004\u001a\u00020\u0001*\u00020\u0001\u001a\u0012\u0010\u0004\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u001e\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u0006*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0012\u0010\u0007\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u001a\u0010\b\u001a\u00020\t*\u00020\u00012\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\t\u001a\n\u0010\f\u001a\u00020\u0003*\u00020\u0001\u001a\n\u0010\r\u001a\u00020\u0001*\u00020\u0003\u001a\f\u0010\u000e\u001a\u0004\u0018\u00010\u0001*\u00020\u0003\u00a8\u0006\u000f"}, d2={"findOrCreateDirectory", "Ljava/nio/file/Path;", "relativePath", "", "findOrCreateFile", "getNormalizedBaseAndRelativePaths", "Lkotlin/Pair;", "getResolvedPath", "isAncestor", "", "path", "strict", "toCanonicalPath", "toNioPath", "toNioPathOrNull", "intellij.platform.util"})
@JvmName(name="NioPathUtil")
public final class NioPathUtil {
    @NotNull
    public static final String toCanonicalPath(@NotNull Path $this$toCanonicalPath) {
        Intrinsics.checkNotNullParameter($this$toCanonicalPath, "<this>");
        Path path = $this$toCanonicalPath.normalize();
        Intrinsics.checkNotNullExpressionValue(path, "normalize()");
        return PathsKt.getInvariantSeparatorsPathString(path);
    }

    @NotNull
    public static final Path getResolvedPath(@NotNull Path $this$getResolvedPath, @NotNull String relativePath) {
        Intrinsics.checkNotNullParameter($this$getResolvedPath, "<this>");
        Intrinsics.checkNotNullParameter(relativePath, "relativePath");
        Path path = $this$getResolvedPath.resolve(FileUtil.toSystemDependentName(relativePath)).normalize();
        Intrinsics.checkNotNullExpressionValue(path, "resolve(FileUtil.toSyste\u2026elativePath)).normalize()");
        return path;
    }

    @NotNull
    public static final Pair<Path, Path> getNormalizedBaseAndRelativePaths(@NotNull Path $this$getNormalizedBaseAndRelativePaths, @NotNull String relativePath) {
        Path name;
        Pair pair;
        Path baseName;
        Intrinsics.checkNotNullParameter($this$getNormalizedBaseAndRelativePaths, "<this>");
        Intrinsics.checkNotNullParameter(relativePath, "relativePath");
        Path normalizedPath = NioPathUtil.getResolvedPath($this$getNormalizedBaseAndRelativePaths, relativePath);
        Path normalizedBasePath = $this$getNormalizedBaseAndRelativePaths.normalize();
        int normalizedBasePathNameCount = 0;
        Path path = normalizedBasePath;
        Intrinsics.checkNotNullExpressionValue(path, "normalizedBasePath");
        Iterator iterator2 = CollectionsKt.zip((Iterable)path, normalizedPath).iterator();
        while (iterator2.hasNext() && Intrinsics.areEqual(baseName = (Path)(pair = iterator2.next()).component1(), name = (Path)pair.component2())) {
            ++normalizedBasePathNameCount;
        }
        int n = $this$getNormalizedBaseAndRelativePaths.getNameCount();
        for (int i = normalizedBasePathNameCount; i < n; ++i) {
            if (normalizedBasePath.getParent() != null) continue;
            boolean bl = false;
            String string2 = "Cannot resolve normalized base path for: " + $this$getNormalizedBaseAndRelativePaths + '/' + relativePath;
            throw new IllegalStateException(string2.toString());
        }
        Path normalizedRelativePath = normalizedBasePath.relativize(normalizedPath);
        return TuplesKt.to(normalizedBasePath, normalizedRelativePath);
    }

    public static final boolean isAncestor(@NotNull Path $this$isAncestor, @NotNull Path path, boolean strict) {
        Intrinsics.checkNotNullParameter($this$isAncestor, "<this>");
        Intrinsics.checkNotNullParameter(path, "path");
        return FileUtil.isAncestor($this$isAncestor, path, strict);
    }

    @NotNull
    public static final Path findOrCreateFile(@NotNull Path $this$findOrCreateFile) {
        Path path;
        Intrinsics.checkNotNullParameter($this$findOrCreateFile, "<this>");
        Path path2 = $this$findOrCreateFile.getParent();
        if (path2 != null) {
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            Path path3 = Files.createDirectories(path2, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
            path = path3;
            Intrinsics.checkNotNullExpressionValue(path3, "createDirectories(this, *attributes)");
        } else {
            path = null;
        }
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists($this$findOrCreateFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            Intrinsics.checkNotNullExpressionValue(Files.createFile($this$findOrCreateFile, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), "createFile(this, *attributes)");
        }
        LinkOption[] linkOptionArray2 = new LinkOption[]{};
        if (!Files.isRegularFile($this$findOrCreateFile, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
            throw new IOException("Expected file instead of directory: " + $this$findOrCreateFile);
        }
        return $this$findOrCreateFile;
    }

    @NotNull
    public static final Path findOrCreateDirectory(@NotNull Path $this$findOrCreateDirectory) {
        Intrinsics.checkNotNullParameter($this$findOrCreateDirectory, "<this>");
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue(Files.createDirectories($this$findOrCreateDirectory, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), "createDirectories(this, *attributes)");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.isDirectory($this$findOrCreateDirectory, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            throw new IOException("Expected directory instead of file: " + $this$findOrCreateDirectory);
        }
        return $this$findOrCreateDirectory;
    }

    @NotNull
    public static final Path findOrCreateFile(@NotNull Path $this$findOrCreateFile, @NotNull String relativePath) {
        Intrinsics.checkNotNullParameter($this$findOrCreateFile, "<this>");
        Intrinsics.checkNotNullParameter(relativePath, "relativePath");
        return NioPathUtil.findOrCreateFile(NioPathUtil.getResolvedPath($this$findOrCreateFile, relativePath));
    }

    @NotNull
    public static final Path findOrCreateDirectory(@NotNull Path $this$findOrCreateDirectory, @NotNull String relativePath) {
        Intrinsics.checkNotNullParameter($this$findOrCreateDirectory, "<this>");
        Intrinsics.checkNotNullParameter(relativePath, "relativePath");
        return NioPathUtil.findOrCreateDirectory(NioPathUtil.getResolvedPath($this$findOrCreateDirectory, relativePath));
    }

    @NotNull
    public static final Path toNioPath(@NotNull String $this$toNioPath) {
        Intrinsics.checkNotNullParameter($this$toNioPath, "<this>");
        Path path = Paths.get(FileUtil.toSystemDependentName($this$toNioPath), new String[0]);
        Intrinsics.checkNotNullExpressionValue(path, "get(FileUtil.toSystemDependentName(this))");
        return path;
    }

    @Nullable
    public static final Path toNioPathOrNull(@NotNull String $this$toNioPathOrNull) {
        Path path;
        Intrinsics.checkNotNullParameter($this$toNioPathOrNull, "<this>");
        try {
            path = NioPathUtil.toNioPath($this$toNioPathOrNull);
        }
        catch (InvalidPathException ex) {
            path = null;
        }
        return path;
    }
}

