/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ref;

import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.Ref;
import com.intellij.reference.SoftReference;
import com.intellij.util.MemoryDumpHelper;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ref.GCUtil;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public final class GCWatcher {
    private final ReferenceQueue<Object> myQueue;
    private final Set<Reference<?>> myReferences;

    private GCWatcher(@NotNull Collection<?> objects) {
        if (objects == null) {
            GCWatcher.$$$reportNull$$$0(0);
        }
        this.myQueue = new ReferenceQueue();
        this.myReferences = ContainerUtil.newConcurrentSet();
        for (Object o : objects) {
            if (o == null) continue;
            this.myReferences.add(new WeakReference<Object>(o, this.myQueue));
        }
    }

    @Contract(pure=true)
    @NotNull
    public static GCWatcher tracking(Object o1) {
        return new GCWatcher(Collections.singletonList(o1));
    }

    @Contract(pure=true)
    @NotNull
    public static GCWatcher tracking(Object o1, Object o2) {
        return GCWatcher.tracking(Arrays.asList(o1, o2));
    }

    @Contract(pure=true)
    @NotNull
    public static GCWatcher tracking(Object o1, Object o2, Object o3) {
        return GCWatcher.tracking(Arrays.asList(o1, o2, o3));
    }

    @Contract(pure=true)
    @NotNull
    public static GCWatcher tracking(Object o1, Object o2, Object o3, Object o4) {
        return GCWatcher.tracking(Arrays.asList(o1, o2, o3, o4));
    }

    @Contract(pure=true)
    @NotNull
    public static GCWatcher tracking(Object o1, Object o2, Object o3, Object o4, Object o5) {
        return GCWatcher.tracking(Arrays.asList(o1, o2, o3, o4, o5));
    }

    @Contract(pure=true)
    @NotNull
    public static GCWatcher tracking(Object ... objects) {
        throw new UnsupportedOperationException("Use a method with fixed number of arguments instead");
    }

    @Contract(pure=true)
    @NotNull
    public static GCWatcher tracking(@NotNull Collection<?> objects) {
        if (objects == null) {
            GCWatcher.$$$reportNull$$$0(1);
        }
        return new GCWatcher(objects);
    }

    @NotNull
    public static GCWatcher fromClearedRef(@NotNull Ref<?> ref) {
        if (ref == null) {
            GCWatcher.$$$reportNull$$$0(2);
        }
        GCWatcher result2 = GCWatcher.tracking(ref.get());
        ref.set(null);
        GCWatcher gCWatcher = result2;
        if (gCWatcher == null) {
            GCWatcher.$$$reportNull$$$0(3);
        }
        return gCWatcher;
    }

    private boolean isEverythingCollected() {
        boolean removed;
        while (true) {
            Reference<Object> ref;
            if ((ref = this.myQueue.poll()) == null) {
                return this.myReferences.isEmpty();
            }
            removed = this.myReferences.remove(ref);
            assert (removed);
        }
    }

    public boolean tryCollect(int timeoutMs) {
        return LowMemoryWatcher.runWithNotificationsSuppressed(() -> {
            long startTime = System.currentTimeMillis();
            try {
                GCUtil.allocateTonsOfMemory(new StringBuilder(), EmptyRunnable.getInstance(), () -> this.isEverythingCollected() || System.currentTimeMillis() - startTime > (long)timeoutMs);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                // empty catch block
            }
            return this.isEverythingCollected();
        });
    }

    @TestOnly
    public void ensureCollected() throws IllegalStateException {
        this.ensureCollected(EmptyRunnable.getInstance());
    }

    @TestOnly
    public void ensureCollected(@NotNull Runnable runWhileWaiting) throws IllegalStateException {
        StringBuilder log;
        if (runWhileWaiting == null) {
            GCWatcher.$$$reportNull$$$0(4);
        }
        if (GCUtil.allocateTonsOfMemory(log = new StringBuilder(), runWhileWaiting, this::isEverythingCollected)) {
            return;
        }
        String message = "Couldn't garbage-collect some objects, they might still be reachable from GC roots: " + ContainerUtil.mapNotNull(this.myReferences, SoftReference::dereference);
        try {
            Path file2 = Paths.get(System.getProperty("teamcity.build.tempDir", System.getProperty("java.io.tmpdir")), "GCWatcher.hprof.zip");
            MemoryDumpHelper.captureMemoryDumpZipped(file2);
            System.out.println("##teamcity[publishArtifacts '" + file2 + "']");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (this.isEverythingCollected()) {
            message = message + "\nEverything is collected after taking the heap dump.";
        }
        message = message + " Log:\n" + log;
        throw new IllegalStateException(message);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ref/GCWatcher";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runWhileWaiting";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ref/GCWatcher";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "fromClearedRef";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "tracking";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "fromClearedRef";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "ensureCollected";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

