/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.List;
import org.assertj.core.api.Assert;
import org.assertj.core.api.AssertionErrorCollector;
import org.assertj.core.api.DefaultAssertionErrorCollector;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.SoftAssertionsProvider;
import org.assertj.core.api.SoftProxies;
import org.assertj.core.error.AssertionErrorCreator;
import org.assertj.core.internal.Failures;
import org.assertj.core.util.CanIgnoreReturnValue;

public abstract class AbstractSoftAssertions
extends DefaultAssertionErrorCollector
implements SoftAssertionsProvider,
InstanceOfAssertFactories {
    final SoftProxies proxies = new SoftProxies(this);
    private static final AssertionErrorCreator ASSERTION_ERROR_CREATOR = new AssertionErrorCreator();

    protected AbstractSoftAssertions() {
    }

    public static void assertAll(AssertionErrorCollector collector) {
        List<AssertionError> errors = collector.assertionErrorsCollected();
        if (!errors.isEmpty()) {
            throw ASSERTION_ERROR_CREATOR.multipleSoftAssertionsError(errors);
        }
    }

    @Override
    public void assertAll() {
        AbstractSoftAssertions.assertAll(this);
    }

    @Override
    public <SELF extends Assert<? extends SELF, ? extends ACTUAL>, ACTUAL> SELF proxy(Class<SELF> assertClass, Class<ACTUAL> actualClass, ACTUAL actual) {
        return this.proxies.createSoftAssertionProxy(assertClass, actualClass, actual);
    }

    @CanIgnoreReturnValue
    public <T> T fail(String failureMessage) {
        AssertionError error = Failures.instance().failure(failureMessage);
        this.collectAssertionError(error);
        return null;
    }

    @CanIgnoreReturnValue
    public <T> T fail(String failureMessage, Object ... args) {
        return this.fail(String.format(failureMessage, args));
    }

    @CanIgnoreReturnValue
    public <T> T fail(String failureMessage, Throwable realCause) {
        AssertionError error = Failures.instance().failure(failureMessage);
        ((Throwable)((Object)error)).initCause(realCause);
        this.collectAssertionError(error);
        return null;
    }

    public void failBecauseExceptionWasNotThrown(Class<? extends Throwable> throwableClass) {
        this.shouldHaveThrown(throwableClass);
    }

    public void shouldHaveThrown(Class<? extends Throwable> throwableClass) {
        AssertionError error = Failures.instance().expectedThrowableNotThrown(throwableClass);
        this.collectAssertionError(error);
    }

    public List<Throwable> errorsCollected() {
        return this.decorateErrorsCollected(super.assertionErrorsCollected());
    }
}

