/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.util.Streams;

public final class Lists {
    @SafeVarargs
    public static <T> List<T> list(T ... elements) {
        return Lists.newArrayList(elements);
    }

    @SafeVarargs
    public static <T> ArrayList<T> newArrayList(T ... elements) {
        if (elements == null) {
            return null;
        }
        ArrayList<T> list2 = Lists.newArrayList();
        Collections.addAll(list2, elements);
        return list2;
    }

    public static <T> ArrayList<T> newArrayList(Iterable<? extends T> elements) {
        if (elements == null) {
            return null;
        }
        return Streams.stream(elements).collect(Collectors.toCollection(ArrayList::new));
    }

    public static <T> ArrayList<T> newArrayList(Iterator<? extends T> elements) {
        if (elements == null) {
            return null;
        }
        return Streams.stream(elements).collect(Collectors.toCollection(ArrayList::new));
    }

    public static <T> ArrayList<T> newArrayList() {
        return new ArrayList();
    }

    @Deprecated
    public static <T> List<T> emptyList() {
        return Collections.emptyList();
    }

    private Lists() {
    }
}

