/*
 * Decompiled with CFR 0.152.
 */
package git4idea.changes;

import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import git4idea.changes.GitFileHistory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\u0018\u0000 \u001f2\u00020\u0001:\u0002\u001f B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0004H\u0016J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0016J\n\u0010\u001b\u001a\u0004\u0018\u00010\u0004H\u0016J\u001e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00120\u00032\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u0004H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\f\u001a\u0004\u0018\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\b\u00a8\u0006!"}, d2={"Lgit4idea/changes/MutableLinearGitFileHistory;", "Lgit4idea/changes/GitFileHistory;", "commitHashes", "", "", "(Ljava/util/List;)V", "firstKnownFilePath", "getFirstKnownFilePath", "()Ljava/lang/String;", "history", "", "Lgit4idea/changes/MutableLinearGitFileHistory$Entry;", "lastKnownFilePath", "getLastKnownFilePath", "append", "", "commitSha", "patch", "Lcom/intellij/openapi/diff/impl/patch/TextFilePatch;", "compare", "", "commitSha1", "commitSha2", "contains", "", "filePath", "findFirstParent", "findStartCommit", "getPatchesBetween", "parent", "child", "Companion", "Entry", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nMutableLinearGitFileHistory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MutableLinearGitFileHistory.kt\ngit4idea/changes/MutableLinearGitFileHistory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,98:1\n1#2:99\n*E\n"})
public final class MutableLinearGitFileHistory
implements GitFileHistory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<String> commitHashes;
    @NotNull
    private final Map<String, Entry> history;

    public MutableLinearGitFileHistory(@NotNull List<String> commitHashes) {
        Intrinsics.checkNotNullParameter(commitHashes, (String)"commitHashes");
        this.commitHashes = commitHashes;
        this.history = new LinkedHashMap();
        for (String sha : this.commitHashes) {
            this.history.put(sha, new Entry(null));
        }
    }

    @Nullable
    public final String getFirstKnownFilePath() {
        Entry entry;
        Object v0;
        block2: {
            Iterable iterable = this.history.values();
            for (Object t : iterable) {
                Entry it = (Entry)t;
                boolean bl = false;
                if (!(it.getPatch() != null)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        if ((entry = (Entry)v0) == null || (entry = entry.getPatch()) == null) {
            throw new IllegalStateException("Empty history".toString());
        }
        return entry.getBeforeName();
    }

    @Nullable
    public final String getLastKnownFilePath() {
        Iterable iterable = this.history.values();
        Object var3_2 = null;
        for (Object t : iterable) {
            Entry it = (Entry)t;
            boolean bl = false;
            if (!(it.getPatch() != null)) continue;
            var3_2 = t;
        }
        Entry entry = var3_2;
        if (entry == null || (entry = entry.getPatch()) == null) {
            throw new IllegalStateException("Empty history".toString());
        }
        String lastFilePath = entry.getAfterName();
        String string = lastFilePath;
        if (string == null) {
            string = this.getFirstKnownFilePath();
        }
        return string;
    }

    @Override
    @Nullable
    public String findStartCommit() {
        return (String)CollectionsKt.firstOrNull(this.commitHashes);
    }

    @Override
    @Nullable
    public String findFirstParent(@NotNull String commitSha) {
        Intrinsics.checkNotNullParameter((Object)commitSha, (String)"commitSha");
        String parentSha = null;
        for (String commitHash : this.commitHashes) {
            if (Intrinsics.areEqual((Object)commitSha, (Object)commitHash)) break;
            parentSha = commitHash;
        }
        return parentSha;
    }

    public final void append(@NotNull String commitSha, @NotNull TextFilePatch patch) {
        Intrinsics.checkNotNullParameter((Object)commitSha, (String)"commitSha");
        Intrinsics.checkNotNullParameter((Object)patch, (String)"patch");
        Entry entry = this.history.get(commitSha);
        if (!(entry != null)) {
            boolean $i$a$-check-MutableLinearGitFileHistory$append$32 = false;
            String $i$a$-check-MutableLinearGitFileHistory$append$32 = "Adding entry for an unknown commit " + commitSha + ". Known commits - " + this.commitHashes;
            throw new IllegalStateException($i$a$-check-MutableLinearGitFileHistory$append$32.toString());
        }
        if (!(entry.getPatch() == null)) {
            boolean bl = false;
            TextFilePatch textFilePatch = entry.getPatch();
            String string = "Entry patch was already recorded for commit " + commitSha + ". Existing patch - " + (textFilePatch != null ? MutableLinearGitFileHistory.Companion.getHeaderString(textFilePatch) : null) + ". New patch - " + MutableLinearGitFileHistory.Companion.getHeaderString(patch);
            throw new IllegalStateException(string.toString());
        }
        this.history.put(commitSha, new Entry(patch));
    }

    @Override
    public boolean contains(@NotNull String commitSha, @NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)commitSha, (String)"commitSha");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        String lastPath = null;
        for (Map.Entry<String, Entry> entry : this.history.entrySet()) {
            String sha = entry.getKey();
            Entry entry2 = entry.getValue();
            String entryPath = entry2.getFilePath();
            if (entryPath != null) {
                lastPath = entryPath;
            }
            if (!Intrinsics.areEqual((Object)sha, (Object)commitSha) || !Intrinsics.areEqual((Object)lastPath, (Object)filePath)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int compare(@NotNull String commitSha1, @NotNull String commitSha2) {
        Intrinsics.checkNotNullParameter((Object)commitSha1, (String)"commitSha1");
        Intrinsics.checkNotNullParameter((Object)commitSha2, (String)"commitSha2");
        if (Intrinsics.areEqual((Object)commitSha1, (Object)commitSha2)) {
            return 0;
        }
        Iterator<Map.Entry<String, Entry>> iterator = this.history.entrySet().iterator();
        while (iterator.hasNext()) {
            String sha = iterator.next().getKey();
            if (Intrinsics.areEqual((Object)sha, (Object)commitSha1)) {
                return -1;
            }
            if (!Intrinsics.areEqual((Object)sha, (Object)commitSha2)) continue;
            return 1;
        }
        throw new IllegalStateException("Unknown commit sha".toString());
    }

    @Override
    @NotNull
    public List<TextFilePatch> getPatchesBetween(@NotNull String parent, @NotNull String child) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        List patches = new ArrayList();
        boolean foundParent = false;
        for (Map.Entry<String, Entry> entry : this.history.entrySet()) {
            String sha = entry.getKey();
            Entry entry2 = entry.getValue();
            if (!foundParent) {
                if (!Intrinsics.areEqual((Object)sha, (Object)parent)) continue;
                foundParent = true;
                continue;
            }
            if (entry2.getPatch() != null) {
                TextFilePatch it;
                boolean bl = false;
                patches.add(it);
            }
            if (!Intrinsics.areEqual((Object)sha, (Object)child)) continue;
            break;
        }
        return patches;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0018\u0010\u0003\u001a\u00020\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\u00020\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\n"}, d2={"Lgit4idea/changes/MutableLinearGitFileHistory$Companion;", "", "()V", "filePath", "", "Lcom/intellij/openapi/diff/impl/patch/TextFilePatch;", "getFilePath", "(Lcom/intellij/openapi/diff/impl/patch/TextFilePatch;)Ljava/lang/String;", "headerString", "getHeaderString", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        private final String getFilePath(TextFilePatch $this$filePath) {
            String string = $this$filePath.getAfterName();
            if (string == null) {
                string = $this$filePath.getBeforeName();
            }
            Intrinsics.checkNotNull((Object)string);
            return string;
        }

        private final String getHeaderString(TextFilePatch $this$headerString) {
            return $this$headerString.getBeforeVersionId() + " " + $this$headerString.getBeforeName() + " -> " + $this$headerString.getAfterVersionId() + " " + $this$headerString.getAfterName();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lgit4idea/changes/MutableLinearGitFileHistory$Entry;", "", "patch", "Lcom/intellij/openapi/diff/impl/patch/TextFilePatch;", "(Lcom/intellij/openapi/diff/impl/patch/TextFilePatch;)V", "filePath", "", "getFilePath", "()Ljava/lang/String;", "getPatch", "()Lcom/intellij/openapi/diff/impl/patch/TextFilePatch;", "intellij.vcs.git"})
    private static final class Entry {
        @Nullable
        private final TextFilePatch patch;
        @Nullable
        private final String filePath;

        public Entry(@Nullable TextFilePatch patch) {
            TextFilePatch textFilePatch = this.patch = patch;
            this.filePath = textFilePatch != null ? Companion.getFilePath(textFilePatch) : null;
        }

        @Nullable
        public final TextFilePatch getPatch() {
            return this.patch;
        }

        @Nullable
        public final String getFilePath() {
            return this.filePath;
        }
    }
}

