/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase.log.squash;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.vcs.log.VcsCommitMetadata;
import git4idea.i18n.GitBundle;
import git4idea.rebase.log.GitCommitEditingActionBase;
import git4idea.rebase.log.GitCommitEditingNotificationsKt;
import git4idea.rebase.log.GitCommitEditingOperationResult;
import git4idea.rebase.log.GitLogCommitDetailsLoaderKt;
import git4idea.rebase.log.GitMultipleCommitEditingAction;
import git4idea.rebase.log.GitNewCommitMessageActionDialog;
import git4idea.rebase.log.squash.GitSquashLogAction;
import git4idea.rebase.log.squash.GitSquashOperation;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\u0012\u0010\u0007\u001a\f0\b\u00a2\u0006\u0002\b\t\u00a2\u0006\u0002\b\nH\u0014J&\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\bH\u0002J\u0018\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0013"}, d2={"Lgit4idea/rebase/log/squash/GitSquashLogAction;", "Lgit4idea/rebase/log/GitMultipleCommitEditingAction;", "()V", "actionPerformedAfterChecks", "", "commitEditingData", "Lgit4idea/rebase/log/GitCommitEditingActionBase$MultipleCommitEditingData;", "getFailureTitle", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "squashInBackground", "selectedCommitsDetails", "", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "newMessage", "update", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.vcs.git"})
public final class GitSquashLogAction
extends GitMultipleCommitEditingAction {
    @Override
    protected void update(@NotNull AnActionEvent e, @NotNull GitCommitEditingActionBase.MultipleCommitEditingData commitEditingData) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)commitEditingData, (String)"commitEditingData");
        if (commitEditingData.getSelection().getSize() < 2) {
            e.getPresentation().setEnabledAndVisible(false);
        }
    }

    @Override
    protected void actionPerformedAfterChecks(@NotNull GitCommitEditingActionBase.MultipleCommitEditingData commitEditingData) {
        Intrinsics.checkNotNullParameter((Object)commitEditingData, (String)"commitEditingData");
        List<VcsCommitMetadata> selectedCommitDetails = GitLogCommitDetailsLoaderKt.getOrLoadDetails(commitEditingData.getProject(), commitEditingData.getLogData(), commitEditingData.getSelection());
        String string = CollectionsKt.joinToString$default((Iterable)selectedCommitDetails, (CharSequence)StringsKt.repeat((CharSequence)"\n", (int)3), null, null, (int)0, null, (Function1)actionPerformedAfterChecks.dialog.1.INSTANCE, (int)30, null);
        String string2 = GitBundle.message("rebase.log.squash.new.message.dialog.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"rebase.log.squa\u2026ew.message.dialog.title\")");
        String string3 = GitBundle.message("rebase.log.squash.new.message.dialog.label", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(\"rebase.log.squa\u2026ew.message.dialog.label\")");
        GitNewCommitMessageActionDialog<GitCommitEditingActionBase.MultipleCommitEditingData> dialog2 = new GitNewCommitMessageActionDialog<GitCommitEditingActionBase.MultipleCommitEditingData>(commitEditingData, string, string2, string3);
        dialog2.show((Function1<String, Unit>)((Function1)new Function1<String, Unit>(this, commitEditingData, selectedCommitDetails){
            final /* synthetic */ GitSquashLogAction this$0;
            final /* synthetic */ GitCommitEditingActionBase.MultipleCommitEditingData $commitEditingData;
            final /* synthetic */ List<VcsCommitMetadata> $selectedCommitDetails;
            {
                this.this$0 = $receiver;
                this.$commitEditingData = $commitEditingData;
                this.$selectedCommitDetails = $selectedCommitDetails;
                super(1);
            }

            public final void invoke(@NotNull String newMessage) {
                Intrinsics.checkNotNullParameter((Object)newMessage, (String)"newMessage");
                GitSquashLogAction.access$squashInBackground(this.this$0, this.$commitEditingData, this.$selectedCommitDetails, newMessage);
            }
        }));
    }

    private final void squashInBackground(GitCommitEditingActionBase.MultipleCommitEditingData commitEditingData, List<? extends VcsCommitMetadata> selectedCommitsDetails, String newMessage) {
        Project project = commitEditingData.getProject();
        String string = GitBundle.message("rebase.log.squash.progress.indicator.title", new Object[0]);
        new Task.Backgroundable(commitEditingData, selectedCommitsDetails, newMessage, project, string){
            final /* synthetic */ GitCommitEditingActionBase.MultipleCommitEditingData $commitEditingData;
            final /* synthetic */ List<VcsCommitMetadata> $selectedCommitsDetails;
            final /* synthetic */ String $newMessage;
            {
                this.$commitEditingData = $commitEditingData;
                this.$selectedCommitsDetails = $selectedCommitsDetails;
                this.$newMessage = $newMessage;
                super($super_call_param$1, $super_call_param$2);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                GitCommitEditingOperationResult operationResult = new GitSquashOperation(this.$commitEditingData.getRepository()).execute(this.$selectedCommitsDetails, this.$newMessage);
                if (operationResult instanceof GitCommitEditingOperationResult.Complete) {
                    GitCommitEditingOperationResult.Complete complete = (GitCommitEditingOperationResult.Complete)operationResult;
                    String string = GitBundle.message("rebase.log.squash.success.notification.title", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"rebase.log.squa\u2026cess.notification.title\")");
                    String string2 = GitBundle.message("rebase.log.squash.undo.progress.title", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"rebase.log.squash.undo.progress.title\")");
                    String string3 = GitBundle.message("rebase.log.squash.undo.impossible.title", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(\"rebase.log.squash.undo.impossible.title\")");
                    String string4 = GitBundle.message("rebase.log.squash.undo.failed.title", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(\"rebase.log.squash.undo.failed.title\")");
                    GitCommitEditingNotificationsKt.notifySuccess(complete, string, string2, string3, string4);
                }
            }
        }.queue();
    }

    @Override
    @NotNull
    protected String getFailureTitle() {
        String string = GitBundle.message("rebase.log.squash.action.failure.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"rebase.log.squash.action.failure.title\")");
        return string;
    }

    public static final /* synthetic */ void access$squashInBackground(GitSquashLogAction $this, GitCommitEditingActionBase.MultipleCommitEditingData commitEditingData, List selectedCommitsDetails, String newMessage) {
        $this.squashInBackground(commitEditingData, selectedCommitsDetails, newMessage);
    }
}

