/*
 * Decompiled with CFR 0.152.
 */
package git4idea.stash.ui;

import com.intellij.openapi.vcs.changes.savedPatches.SavedPatchesProvider;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.ChangesTreeCellRenderer;
import com.intellij.openapi.vcs.changes.ui.CurrentBranchComponent;
import com.intellij.openapi.vcs.changes.ui.HoverChangesTree;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.vcs.log.RefGroup;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.ui.render.LabelIconCache;
import com.intellij.vcs.log.ui.render.LabelPainter;
import git4idea.GitReference;
import git4idea.log.GitRefManager;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.ui.StashInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTree;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u001dB\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u001e\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0018J \u0010\u0019\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bH\u0002J\u0010\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001e"}, d2={"Lgit4idea/stash/ui/GitStashPainter;", "Lcom/intellij/vcs/log/ui/render/LabelPainter;", "Lcom/intellij/openapi/vcs/changes/savedPatches/SavedPatchesProvider$PatchObject$Painter;", "tree", "Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;", "renderer", "Lcom/intellij/openapi/vcs/changes/ui/ChangesTreeCellRenderer;", "iconCache", "Lcom/intellij/vcs/log/ui/render/LabelIconCache;", "(Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;Lcom/intellij/openapi/vcs/changes/ui/ChangesTreeCellRenderer;Lcom/intellij/vcs/log/ui/render/LabelIconCache;)V", "endLocation", "", "labelRightGap", "rowHeight", "startLocation", "getTree", "()Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;", "clearPainter", "", "customise", "stashInfo", "Lgit4idea/ui/StashInfo;", "row", "selected", "", "customizeLocation", "paint", "g2", "Ljava/awt/Graphics2D;", "StashRefGroup", "intellij.vcs.git"})
public final class GitStashPainter
extends LabelPainter
implements SavedPatchesProvider.PatchObject.Painter {
    @NotNull
    private final ChangesTree tree;
    @NotNull
    private final ChangesTreeCellRenderer renderer;
    private final int labelRightGap;
    private int startLocation;
    private int endLocation;
    private int rowHeight;

    public GitStashPainter(@NotNull ChangesTree tree2, @NotNull ChangesTreeCellRenderer renderer2, @NotNull LabelIconCache iconCache) {
        Intrinsics.checkNotNullParameter((Object)tree2, (String)"tree");
        Intrinsics.checkNotNullParameter((Object)renderer2, (String)"renderer");
        Intrinsics.checkNotNullParameter((Object)iconCache, (String)"iconCache");
        super((JComponent)tree2, iconCache);
        this.tree = tree2;
        this.renderer = renderer2;
        this.labelRightGap = JBUI.scale((int)1);
    }

    @NotNull
    public final ChangesTree getTree() {
        return this.tree;
    }

    public final void customise(@NotNull StashInfo stashInfo, int row, boolean selected) {
        Intrinsics.checkNotNullParameter((Object)stashInfo, (String)"stashInfo");
        String branchName = StashInfo.Companion.getBranchName(stashInfo);
        if (branchName == null) {
            this.clearPainter();
            return;
        }
        GitRepository repository = (GitRepository)GitRepositoryManager.getInstance(this.tree.getProject()).getRepositoryForRootQuick(stashInfo.getRoot());
        Object object = repository;
        boolean isCurrentBranch = Intrinsics.areEqual((Object)(object != null && (object = object.getCurrentBranch()) != null ? ((GitReference)object).getName() : null), (Object)branchName);
        int nodeLocation = TreeUtil.getNodeRowX((JTree)((JTree)this.tree), (int)row) + this.tree.getInsets().left;
        int availableWidth = this.tree.getVisibleRect().width - HoverChangesTree.Companion.getTransparentScrollbarWidth((Component)this.tree) - RangesKt.coerceAtLeast((int)(nodeLocation - this.tree.getVisibleRect().x), (int)0);
        Color color = selected ? UIUtil.getLabelForeground() : (Color)CurrentBranchComponent.TEXT_COLOR;
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"if (selected) UIUtil.get\u2026ranchComponent.TEXT_COLOR");
        Color foreground = color;
        this.customizePainter(HoverChangesTree.Companion.getBackground((Tree)this.tree, row, selected), foreground, selected, availableWidth, CollectionsKt.listOf((Object)new StashRefGroup(branchName, isCurrentBranch)));
        int labelEndLocation = this.tree.getVisibleRect().x + this.tree.getVisibleRect().width - nodeLocation;
        int labelStartLocation = labelEndLocation - this.getSize().width - this.labelRightGap - HoverChangesTree.Companion.getTransparentScrollbarWidth((Component)this.tree);
        this.customizeLocation(labelStartLocation, labelEndLocation, HoverChangesTree.Companion.getRowHeight(this.tree, this.renderer));
    }

    private final void customizeLocation(int startLocation, int endLocation, int rowHeight) {
        this.startLocation = startLocation;
        this.endLocation = endLocation;
        this.rowHeight = rowHeight;
    }

    private final void clearPainter() {
        this.myLabels.clear();
    }

    public void paint(@NotNull Graphics2D g2) {
        int labelEnd;
        Intrinsics.checkNotNullParameter((Object)g2, (String)"g2");
        this.paint(g2, this.startLocation, 0, this.rowHeight);
        List list2 = this.myLabels;
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"myLabels");
        if (!((Collection)list2).isEmpty() && (labelEnd = this.startLocation + this.getSize().width) != this.endLocation) {
            g2.setColor(this.myBackground);
            g2.fillRect(labelEnd, 0, this.endLocation - labelEnd, this.rowHeight);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001a\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J\r\u0010\u000b\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004H\u0016J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\b\u0010\u000f\u001a\u00020\u0006H\u0016R\u0013\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lgit4idea/stash/ui/GitStashPainter$StashRefGroup;", "Lcom/intellij/vcs/log/RefGroup;", "branchName", "", "Lcom/intellij/openapi/util/NlsSafe;", "isCurrent", "", "(Ljava/lang/String;Z)V", "getColors", "", "Ljava/awt/Color;", "getName", "getRefs", "", "Lcom/intellij/vcs/log/VcsRef;", "isExpanded", "intellij.vcs.git"})
    private static final class StashRefGroup
    implements RefGroup {
        @NotNull
        private final String branchName;
        private final boolean isCurrent;

        public StashRefGroup(@NotNull String branchName, boolean isCurrent) {
            Intrinsics.checkNotNullParameter((Object)branchName, (String)"branchName");
            this.branchName = branchName;
            this.isCurrent = isCurrent;
        }

        @NotNull
        public String getName() {
            return this.branchName;
        }

        @NotNull
        public List<VcsRef> getRefs() {
            return new ArrayList();
        }

        public boolean isExpanded() {
            return false;
        }

        @NotNull
        public List<Color> getColors() {
            if (this.isCurrent) {
                Color color = GitRefManager.HEAD.getBackgroundColor();
                Intrinsics.checkNotNullExpressionValue((Object)color, (String)"HEAD.backgroundColor");
                return CollectionsKt.listOf((Object)color);
            }
            Color color = GitRefManager.LOCAL_BRANCH.getBackgroundColor();
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"LOCAL_BRANCH.backgroundColor");
            return CollectionsKt.listOf((Object)color);
        }
    }
}

