/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.JavaCoverageOptionsProvider;
import com.intellij.coverage.JavaCoverageRunner;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.configurations.coverage.JavaCoverageEnabledConfiguration;
import com.intellij.execution.target.java.JavaTargetParameter;
import com.intellij.execution.target.java.TargetPaths;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.util.CoverageReport;
import com.intellij.rt.coverage.util.ProjectDataLoader;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PathUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Stream;
import kotlin.Unit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IDEACoverageRunner
extends JavaCoverageRunner {
    private static final Logger LOG = Logger.getInstance(IDEACoverageRunner.class);
    private static final String COVERAGE_AGENT_PATH_PROPERTY = "idea.coverage.agent.path";

    public ProjectData loadCoverageData(@NotNull File sessionDataFile, @Nullable CoverageSuite coverageSuite) {
        if (sessionDataFile == null) {
            IDEACoverageRunner.$$$reportNull$$$0(0);
        }
        ProjectData projectData = ProjectDataLoader.load((File)sessionDataFile);
        File sourceMapFile = new File(JavaCoverageEnabledConfiguration.getSourceMapPath(sessionDataFile.getPath()));
        if (sourceMapFile.exists()) {
            try {
                CoverageReport.loadAndApplySourceMap((ProjectData)projectData, (File)sourceMapFile);
            }
            catch (IOException e) {
                LOG.warn("Error reading source map associated with coverage data", (Throwable)e);
            }
        }
        return projectData;
    }

    @Override
    public void appendCoverageArgument(String sessionDataFilePath, String @Nullable [] patterns, SimpleJavaParameters parameters, boolean testTracking, boolean branchCoverage) {
        this.appendCoverageArgument(sessionDataFilePath, patterns, null, parameters, testTracking, branchCoverage, null, null);
    }

    @Override
    public void appendCoverageArgument(String sessionDataFilePath, String[] patterns, String[] excludePatterns, SimpleJavaParameters javaParameters, boolean testTracking, boolean branchCoverage, @Nullable String sourceMapPath, @Nullable Project project) {
        String agentPath = IDEACoverageRunner.getAgentPath();
        if (agentPath == null) {
            return;
        }
        String[] excludeAnnotations = IDEACoverageRunner.getExcludeAnnotations(project);
        List targetParameters = javaParameters.getTargetDependentParameters().asTargetParameters();
        targetParameters.add(request -> IDEACoverageRunner.createArgumentTargetParameter(agentPath, sessionDataFilePath, patterns, excludePatterns, excludeAnnotations, testTracking, branchCoverage, sourceMapPath));
        if (!Registry.is((String)"idea.coverage.thread.safe.enabled")) {
            targetParameters.add(request -> JavaTargetParameter.fixed((String)"-Didea.coverage.thread-safe.enabled=false"));
        }
        if (!branchCoverage && Registry.is((String)"idea.coverage.new.sampling.enabled")) {
            targetParameters.add(request -> JavaTargetParameter.fixed((String)"-Didea.new.sampling.coverage=true"));
        }
        if (branchCoverage && Registry.is((String)"idea.coverage.new.tracing.enabled")) {
            targetParameters.add(request -> JavaTargetParameter.fixed((String)"-Didea.new.tracing.coverage=true"));
            if (testTracking && !Registry.is((String)"idea.coverage.new.test.tracking.enabled")) {
                targetParameters.add(request -> JavaTargetParameter.fixed((String)"-Didea.new.test.tracking.coverage=false"));
            }
        }
    }

    @Nullable
    private static String getAgentPath() {
        String userDefinedAgentPath = System.getProperty(COVERAGE_AGENT_PATH_PROPERTY);
        String bundledAgentPath = PathUtil.getJarPathForClass(ProjectData.class);
        String agentPath = userDefinedAgentPath != null ? userDefinedAgentPath : bundledAgentPath;
        return IDEACoverageRunner.handleSpacesInAgentPath(agentPath);
    }

    @Nullable
    private static JavaTargetParameter createArgumentTargetParameter(String agentPath, String sessionDataFilePath, String @Nullable [] patterns, String[] excludePatterns, String[] excludeAnnotations, boolean testTracking, boolean branchCoverage, String sourceMapPath) {
        try {
            File tempFile = IDEACoverageRunner.createTempFile();
            tempFile.deleteOnExit();
            Ref writeOnceRef = new Ref((Object)false);
            String tempFilePath = tempFile.getAbsolutePath();
            TargetPaths targetPaths = TargetPaths.ordered(builder -> {
                builder.download(sessionDataFilePath, __ -> {
                    IDEACoverageRunner.createFileOrClearExisting(sessionDataFilePath);
                    return Unit.INSTANCE;
                }, targetSessionDataPath -> {
                    if (!((Boolean)writeOnceRef.get()).booleanValue()) {
                        try {
                            IDEACoverageRunner.writeOptionsToFile(tempFile, targetSessionDataPath, patterns, excludePatterns, excludeAnnotations, testTracking, branchCoverage, sourceMapPath);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                        finally {
                            writeOnceRef.set((Object)true);
                        }
                    }
                    return Unit.INSTANCE;
                }).upload(agentPath, __ -> Unit.INSTANCE, __ -> Unit.INSTANCE).upload(tempFilePath, __ -> Unit.INSTANCE, __ -> Unit.INSTANCE);
                return Unit.INSTANCE;
            });
            return new JavaTargetParameter.Builder(targetPaths).fixed("-javaagent:").resolved(agentPath).fixed("=").resolved(tempFilePath).build();
        }
        catch (IOException e) {
            LOG.info("Coverage was not enabled", (Throwable)e);
            return null;
        }
    }

    private static void createFileOrClearExisting(@NotNull String sessionDataFilePath) {
        if (sessionDataFilePath == null) {
            IDEACoverageRunner.$$$reportNull$$$0(1);
        }
        File file = new File(sessionDataFilePath);
        FileUtil.createIfDoesntExist((File)file);
        try {
            new FileOutputStream(file).close();
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private static void writeOptionsToFile(File file, String sessionDataFilePath, String @Nullable [] patterns, String[] excludePatterns, String[] excludeAnnotations, boolean testTracking, boolean branchCoverage, String sourceMapPath) throws IOException {
        IDEACoverageRunner.write2file(file, sessionDataFilePath);
        IDEACoverageRunner.write2file(file, String.valueOf(testTracking));
        IDEACoverageRunner.write2file(file, Boolean.FALSE.toString());
        IDEACoverageRunner.write2file(file, String.valueOf(Registry.is((String)"idea.coverage.merge.report")));
        IDEACoverageRunner.write2file(file, String.valueOf(!branchCoverage));
        if (sourceMapPath != null) {
            IDEACoverageRunner.write2file(file, Boolean.TRUE.toString());
            IDEACoverageRunner.write2file(file, sourceMapPath);
        }
        if (patterns != null) {
            IDEACoverageRunner.writePatterns(file, patterns);
        }
        if (excludePatterns != null) {
            IDEACoverageRunner.write2file(file, "-exclude");
            IDEACoverageRunner.writePatterns(file, excludePatterns);
        }
        if (!ArrayUtil.isEmpty((Object[])excludeAnnotations)) {
            IDEACoverageRunner.write2file(file, "-excludeAnnotations");
            IDEACoverageRunner.writePatterns(file, excludeAnnotations);
        }
    }

    private static String[] convertToPatterns(String[] patterns) {
        String[] result = new String[patterns.length];
        for (int i = 0; i < patterns.length; ++i) {
            Object coveragePattern = patterns[i];
            if (!((String)(coveragePattern = ((String)coveragePattern).replace("$", "\\$").replace(".", "\\.").replaceAll("\\*", ".*"))).endsWith(".*")) {
                coveragePattern = (String)coveragePattern + "(\\$.*)*";
            }
            result[i] = coveragePattern;
        }
        return result;
    }

    private static void writePatterns(File tempFile, String[] patterns) throws IOException {
        for (String coveragePattern : IDEACoverageRunner.convertToPatterns(patterns)) {
            IDEACoverageRunner.write2file(tempFile, coveragePattern);
        }
    }

    private static String[] getExcludeAnnotations(@Nullable Project project) {
        if (project == null) {
            return null;
        }
        JavaCoverageOptionsProvider optionsProvider = JavaCoverageOptionsProvider.getInstance(project);
        return ArrayUtil.toStringArray(optionsProvider.getExcludeAnnotationPatterns());
    }

    @NotNull
    public String getPresentableName() {
        return "IntelliJ IDEA";
    }

    @NotNull
    public String getId() {
        return "idea";
    }

    @NotNull
    public String getDataFileExtension() {
        return "ic";
    }

    public boolean isCoverageByTestApplicable() {
        return true;
    }

    static void setExcludeAnnotations(Project project, ProjectData projectData) {
        JavaCoverageOptionsProvider optionsProvider = JavaCoverageOptionsProvider.getInstance(project);
        try {
            String[] patterns = ArrayUtil.toStringArray(optionsProvider.getExcludeAnnotationPatterns());
            String[] regexps = IDEACoverageRunner.convertToPatterns(patterns);
            projectData.setAnnotationsToIgnore(Stream.of(regexps).map(s -> Pattern.compile(s)).toList());
        }
        catch (PatternSyntaxException e) {
            LOG.info("Failed to collect exclude annotation patterns", (Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionDataFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionDataFilePath";
                break;
            }
        }
        objectArray2[1] = "com/intellij/coverage/IDEACoverageRunner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "loadCoverageData";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createFileOrClearExisting";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

