/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.CommonBundle;
import com.intellij.codeEditor.printing.ExportToHTMLSettings;
import com.intellij.codeInsight.TestFrameworks;
import com.intellij.coverage.CoverageAnnotator;
import com.intellij.coverage.CoverageBundle;
import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageFileProvider;
import com.intellij.coverage.CoverageNotifications;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.JavaCoverageAnnotator;
import com.intellij.coverage.JavaCoverageClassesEnumerator;
import com.intellij.coverage.JavaCoverageEngineExtension;
import com.intellij.coverage.JavaCoverageOptionsProvider;
import com.intellij.coverage.JavaCoverageRunner;
import com.intellij.coverage.JavaCoverageSuite;
import com.intellij.coverage.SourceLineCounterUtil;
import com.intellij.coverage.listeners.java.CoverageListener;
import com.intellij.coverage.view.CoverageViewExtension;
import com.intellij.coverage.view.CoverageViewManager;
import com.intellij.coverage.view.JavaCoverageViewExtension;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.application.ApplicationConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.coverage.CoverageEnabledConfiguration;
import com.intellij.execution.configurations.coverage.JavaCoverageEnabledConfiguration;
import com.intellij.execution.target.RunTargetsEnabled;
import com.intellij.execution.target.TargetEnvironmentAwareRunProfile;
import com.intellij.execution.target.TargetEnvironmentConfigurations;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.wsl.WslPath;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.java.coverage.JavaCoverageBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.TestSourcesFilter;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalLoopStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.controlFlow.AllVariablesControlFlowPolicy;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ConditionalBranchingInstruction;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowPolicy;
import com.intellij.psi.controlFlow.Instruction;
import com.intellij.psi.impl.source.tree.java.PsiSwitchStatementImpl;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.rt.coverage.data.JumpData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.task.ProjectTaskManager;
import com.intellij.task.impl.ProjectTaskManagerImpl;
import com.intellij.testIntegration.TestFramework;
import com.intellij.util.containers.ContainerUtil;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import jetbrains.coverage.report.ReportGenerationFailedException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

public class JavaCoverageEngine
extends CoverageEngine {
    private static final Logger LOG = Logger.getInstance((String)JavaCoverageEngine.class.getName());

    public static JavaCoverageEngine getInstance() {
        return (JavaCoverageEngine)((Object)EP_NAME.findExtensionOrFail(JavaCoverageEngine.class));
    }

    public boolean isApplicableTo(@NotNull RunConfigurationBase conf) {
        if (conf == null) {
            JavaCoverageEngine.$$$reportNull$$$0(0);
        }
        if (conf instanceof CommonJavaRunConfigurationParameters) {
            return true;
        }
        if (RunTargetsEnabled.get() && conf instanceof TargetEnvironmentAwareRunProfile && JavaCoverageEngine.willRunOnTarget((TargetEnvironmentAwareRunProfile)conf)) {
            return false;
        }
        for (JavaCoverageEngineExtension extension : JavaCoverageEngineExtension.EP_NAME.getExtensionList()) {
            if (!extension.isApplicableTo(conf)) continue;
            return true;
        }
        return false;
    }

    private static boolean willRunOnTarget(@NotNull TargetEnvironmentAwareRunProfile configuration) {
        Project project;
        if (configuration == null) {
            JavaCoverageEngine.$$$reportNull$$$0(1);
        }
        return TargetEnvironmentConfigurations.getEffectiveTargetName((TargetEnvironmentAwareRunProfile)configuration, (Project)(project = ((RunConfigurationBase)configuration).getProject())) != null || JavaCoverageEngine.isProjectUnderWsl(project);
    }

    private static boolean isProjectUnderWsl(@NotNull Project project) {
        Sdk projectSdk;
        if (project == null) {
            JavaCoverageEngine.$$$reportNull$$$0(2);
        }
        if ((projectSdk = ProjectRootManager.getInstance((Project)project).getProjectSdk()) == null) {
            return false;
        }
        String projectSdkHomePath = projectSdk.getHomePath();
        return projectSdkHomePath != null && WslPath.isWslUncPath((String)projectSdkHomePath);
    }

    public boolean canHavePerTestCoverage(@NotNull RunConfigurationBase conf) {
        if (conf == null) {
            JavaCoverageEngine.$$$reportNull$$$0(3);
        }
        return !(conf instanceof ApplicationConfiguration) && conf instanceof CommonJavaRunConfigurationParameters;
    }

    public Set<String> getTestsForLine(Project project, String classFQName, int lineNumber) {
        return JavaCoverageEngine.extractTracedTests(project, classFQName, lineNumber);
    }

    public boolean wasTestDataCollected(Project project) {
        File[] files = JavaCoverageEngine.getTraceFiles(project);
        return files != null && files.length > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<String> extractTracedTests(Project project, String classFQName, int lineNumber) {
        HashSet<String> tests = new HashSet<String>();
        File[] traceFiles = JavaCoverageEngine.getTraceFiles(project);
        if (traceFiles == null) {
            return tests;
        }
        for (File traceFile : traceFiles) {
            FilterInputStream in = null;
            try {
                in = new DataInputStream(new FileInputStream(traceFile));
                JavaCoverageEngine.extractTests(traceFile, (DataInputStream)in, tests, classFQName, lineNumber);
            }
            catch (Exception ex) {
                LOG.error(traceFile.getName(), (Throwable)ex);
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException ex) {
                    LOG.error((Throwable)ex);
                }
            }
        }
        return tests;
    }

    private static void extractTests(File traceFile, DataInputStream in, Set<? super String> tests, String classFQName, int lineNumber) throws IOException {
        long traceSize = in.readInt();
        int i = 0;
        while ((long)i < traceSize) {
            String className = in.readUTF();
            int linesSize = in.readInt();
            for (int l = 0; l < linesSize; ++l) {
                int line = in.readInt();
                if (!Comparing.strEqual((String)className, (String)classFQName) || lineNumber != line) continue;
                tests.add(FileUtilRt.getNameWithoutExtension((String)traceFile.getName()));
                return;
            }
            ++i;
        }
    }

    private static File @Nullable [] getTraceFiles(Project project) {
        CoverageSuitesBundle currentSuite = CoverageDataManager.getInstance((Project)project).getCurrentSuitesBundle();
        if (currentSuite == null) {
            return null;
        }
        ArrayList files = new ArrayList();
        for (CoverageSuite coverageSuite : currentSuite.getSuites()) {
            File tracesDir = JavaCoverageEngine.getTracesDirectory(coverageSuite);
            File[] suiteFiles = tracesDir.listFiles();
            if (suiteFiles == null) continue;
            Collections.addAll(files, suiteFiles);
        }
        return files.isEmpty() ? null : files.toArray(new File[0]);
    }

    private static File getTracesDirectory(CoverageSuite coverageSuite) {
        String filePath = coverageSuite.getCoverageDataFileName();
        String dirName = FileUtilRt.getNameWithoutExtension((String)new File(filePath).getName());
        File parentDir = new File(filePath).getParentFile();
        return new File(parentDir, dirName);
    }

    public void collectTestLines(List<String> sanitizedTestNames, CoverageSuite suite, Map<String, Set<Integer>> executionTrace) {
        File tracesDir = JavaCoverageEngine.getTracesDirectory(suite);
        for (String testName : sanitizedTestNames) {
            File file = new File(tracesDir, testName + ".tr");
            if (!file.exists()) continue;
            try (DataInputStream in = new DataInputStream(new FileInputStream(file));){
                int traceSize = in.readInt();
                for (int i = 0; i < traceSize; ++i) {
                    String className = in.readUTF();
                    int linesSize = in.readInt();
                    Set lines = executionTrace.computeIfAbsent(className, k -> new HashSet());
                    for (int l = 0; l < linesSize; ++l) {
                        lines.add(in.readInt());
                    }
                }
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }

    protected void deleteAssociatedTraces(CoverageSuite suite) {
        File tracesDirectory;
        if (suite.isTracingEnabled() && (tracesDirectory = JavaCoverageEngine.getTracesDirectory(suite)).exists()) {
            FileUtil.delete((File)tracesDirectory);
        }
    }

    @NotNull
    public CoverageEnabledConfiguration createCoverageEnabledConfiguration(@NotNull RunConfigurationBase conf) {
        if (conf == null) {
            JavaCoverageEngine.$$$reportNull$$$0(4);
        }
        return new JavaCoverageEnabledConfiguration(conf, this);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public CoverageSuite createCoverageSuite(@NotNull CoverageRunner covRunner, @NotNull String name, @NotNull CoverageFileProvider coverageDataFileProvider, String[] filters, long lastCoverageTimeStamp, String suiteToMerge, boolean coverageByTestEnabled, boolean branchCoverage, boolean trackTestFolders, Project project) {
        void project2;
        if (covRunner == null) {
            JavaCoverageEngine.$$$reportNull$$$0(5);
        }
        if (name == null) {
            JavaCoverageEngine.$$$reportNull$$$0(6);
        }
        if (coverageDataFileProvider == null) {
            JavaCoverageEngine.$$$reportNull$$$0(7);
        }
        return this.createSuite(covRunner, name, coverageDataFileProvider, filters, null, lastCoverageTimeStamp, coverageByTestEnabled, branchCoverage, trackTestFolders, (Project)project2);
    }

    public CoverageSuite createCoverageSuite(@NotNull CoverageRunner covRunner, @NotNull String name, @NotNull CoverageFileProvider coverageDataFileProvider, @NotNull CoverageEnabledConfiguration config) {
        if (covRunner == null) {
            JavaCoverageEngine.$$$reportNull$$$0(8);
        }
        if (name == null) {
            JavaCoverageEngine.$$$reportNull$$$0(9);
        }
        if (coverageDataFileProvider == null) {
            JavaCoverageEngine.$$$reportNull$$$0(10);
        }
        if (config == null) {
            JavaCoverageEngine.$$$reportNull$$$0(11);
        }
        if (config instanceof JavaCoverageEnabledConfiguration) {
            JavaCoverageEnabledConfiguration javaConfig = (JavaCoverageEnabledConfiguration)config;
            return this.createSuite(covRunner, name, coverageDataFileProvider, javaConfig.getPatterns(), javaConfig.getExcludePatterns(), new Date().getTime(), javaConfig.isTrackPerTestCoverage() && javaConfig.isTracingEnabled(), javaConfig.isTracingEnabled(), javaConfig.isTrackTestFolders(), config.getConfiguration().getProject());
        }
        return null;
    }

    @Nullable
    public CoverageSuite createEmptyCoverageSuite(@NotNull CoverageRunner coverageRunner) {
        if (coverageRunner == null) {
            JavaCoverageEngine.$$$reportNull$$$0(12);
        }
        return new JavaCoverageSuite(this);
    }

    @NotNull
    public CoverageAnnotator getCoverageAnnotator(@NotNull Project project) {
        if (project == null) {
            JavaCoverageEngine.$$$reportNull$$$0(13);
        }
        JavaCoverageAnnotator javaCoverageAnnotator = JavaCoverageAnnotator.getInstance(project);
        if (javaCoverageAnnotator == null) {
            JavaCoverageEngine.$$$reportNull$$$0(14);
        }
        return javaCoverageAnnotator;
    }

    public boolean coverageEditorHighlightingApplicableTo(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            JavaCoverageEngine.$$$reportNull$$$0(15);
        }
        if (!(psiFile instanceof PsiClassOwner)) {
            return false;
        }
        Module module = (Module)ReadAction.compute(() -> ModuleUtilCore.findModuleForPsiElement((PsiElement)psiFile));
        return module != null;
    }

    public boolean acceptedByFilters(@NotNull PsiFile psiFile, @NotNull CoverageSuitesBundle suite) {
        VirtualFile virtualFile;
        if (psiFile == null) {
            JavaCoverageEngine.$$$reportNull$$$0(16);
        }
        if (suite == null) {
            JavaCoverageEngine.$$$reportNull$$$0(17);
        }
        if ((virtualFile = psiFile.getVirtualFile()) == null) {
            return false;
        }
        Project project = psiFile.getProject();
        if (!suite.isTrackTestFolders() && ((Boolean)ReadAction.compute(() -> TestSourcesFilter.isTestSources((VirtualFile)virtualFile, (Project)project))).booleanValue()) {
            return false;
        }
        for (CoverageSuite coverageSuite : suite.getSuites()) {
            JavaCoverageSuite javaSuite = (JavaCoverageSuite)coverageSuite;
            if (psiFile instanceof PsiClassOwner && javaSuite.isPackageFiltered((String)ReadAction.compute(() -> ((PsiClassOwner)psiFile).getPackageName()))) {
                return true;
            }
            List<PsiClass> classes = javaSuite.getCurrentSuiteClasses(project);
            for (PsiClass aClass : classes) {
                PsiFile containingFile = (PsiFile)ReadAction.compute(() -> ((PsiClass)aClass).getContainingFile());
                if (!psiFile.equals(containingFile)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean recompileProjectAndRerunAction(@NotNull Module module, @NotNull CoverageSuitesBundle suite, @NotNull Runnable chooseSuiteAction) {
        boolean rootsExist;
        if (module == null) {
            JavaCoverageEngine.$$$reportNull$$$0(18);
        }
        if (suite == null) {
            JavaCoverageEngine.$$$reportNull$$$0(19);
        }
        if (chooseSuiteAction == null) {
            JavaCoverageEngine.$$$reportNull$$$0(20);
        }
        if (suite.isModuleChecked(module)) {
            return false;
        }
        for (JavaCoverageEngineExtension extension : JavaCoverageEngineExtension.EP_NAME.getExtensionList()) {
            Module moduleCandidate = extension.getModuleWithOutput(module);
            if (moduleCandidate == null) continue;
            module = moduleCandidate;
            break;
        }
        CoverageDataManager dataManager = CoverageDataManager.getInstance((Project)module.getProject());
        boolean includeTests = suite.isTrackTestFolders();
        Object[] roots = JavaCoverageClassesEnumerator.getRoots(dataManager, module, includeTests);
        boolean bl = rootsExist = roots.length >= (includeTests ? 2 : 1) && ContainerUtil.all((Object[])roots, root -> root != null && root.exists());
        if (!rootsExist) {
            Project project = module.getProject();
            suite.checkModule(module);
            LOG.debug("Going to ask to rebuild project. Include tests:" + includeTests + ". Module: " + module.getName() + ".  Output roots are: ");
            for (Object root2 : roots) {
                LOG.debug(root2.getPath() + " exists: " + root2.exists());
            }
            Notification notification = new Notification("Coverage", JavaCoverageBundle.message("project.is.out.of.date", new Object[0]), JavaCoverageBundle.message("project.class.files.are.out.of.date", new Object[0]), NotificationType.INFORMATION);
            notification.addAction((AnAction)NotificationAction.createSimpleExpiring((String)JavaCoverageBundle.message("coverage.recompile", new Object[0]), () -> {
                ProjectTaskManagerImpl.putBuildOriginator((Project)project, ((Object)((Object)this)).getClass());
                ProjectTaskManager taskManager = ProjectTaskManager.getInstance((Project)project);
                Promise promise = taskManager.buildAllModules();
                promise.onSuccess(result -> ApplicationManager.getApplication().invokeLater(() -> CoverageDataManager.getInstance((Project)project).chooseSuitesBundle(suite), o -> project.isDisposed()));
            }));
            CoverageNotifications.getInstance(project).addNotification(notification);
            notification.notify(project);
        }
        return false;
    }

    @Nullable
    private static File getOutputpath(CompilerModuleExtension compilerModuleExtension) {
        @Nullable String outputpathUrl = compilerModuleExtension.getCompilerOutputUrl();
        @Nullable File outputpath = outputpathUrl != null ? new File(VfsUtilCore.urlToPath((String)outputpathUrl)) : null;
        return outputpath;
    }

    @Nullable
    private static File getTestOutputpath(CompilerModuleExtension compilerModuleExtension) {
        @Nullable String outputpathUrl = compilerModuleExtension.getCompilerOutputUrlForTests();
        @Nullable File outputpath = outputpathUrl != null ? new File(VfsUtilCore.urlToPath((String)outputpathUrl)) : null;
        return outputpath;
    }

    @Nullable
    public List<Integer> collectSrcLinesForUntouchedFile(@NotNull File classFile, @NotNull CoverageSuitesBundle suite) {
        byte[] content;
        if (classFile == null) {
            JavaCoverageEngine.$$$reportNull$$$0(21);
        }
        if (suite == null) {
            JavaCoverageEngine.$$$reportNull$$$0(22);
        }
        try {
            content = FileUtil.loadFileBytes((File)classFile);
        }
        catch (IOException e) {
            return null;
        }
        ArrayList<Integer> uncoveredLines = new ArrayList<Integer>();
        try {
            SourceLineCounterUtil.collectSrcLinesForUntouchedFiles(uncoveredLines, content, suite.getProject());
        }
        catch (Exception e) {
            if (e instanceof ControlFlowException) {
                throw e;
            }
            LOG.error("Fail to process class from: " + classFile.getPath(), (Throwable)e);
        }
        return uncoveredLines;
    }

    public boolean includeUntouchedFileInCoverage(@NotNull String qualifiedName, @NotNull File outputFile, @NotNull PsiFile sourceFile, @NotNull CoverageSuitesBundle suite) {
        if (qualifiedName == null) {
            JavaCoverageEngine.$$$reportNull$$$0(23);
        }
        if (outputFile == null) {
            JavaCoverageEngine.$$$reportNull$$$0(24);
        }
        if (sourceFile == null) {
            JavaCoverageEngine.$$$reportNull$$$0(25);
        }
        if (suite == null) {
            JavaCoverageEngine.$$$reportNull$$$0(26);
        }
        for (CoverageSuite coverageSuite : suite.getSuites()) {
            JavaCoverageSuite javaSuite = (JavaCoverageSuite)coverageSuite;
            if (!javaSuite.isClassFiltered(qualifiedName) && !javaSuite.isPackageFiltered(JavaCoverageEngine.getPackageName(sourceFile))) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public String getQualifiedName(@NotNull File outputFile, @NotNull PsiFile sourceFile) {
        if (outputFile == null) {
            JavaCoverageEngine.$$$reportNull$$$0(27);
        }
        if (sourceFile == null) {
            JavaCoverageEngine.$$$reportNull$$$0(28);
        }
        String packageFQName = JavaCoverageEngine.getPackageName(sourceFile);
        String string = StringUtil.getQualifiedName((String)packageFQName, (String)FileUtilRt.getNameWithoutExtension((String)outputFile.getName()));
        if (string == null) {
            JavaCoverageEngine.$$$reportNull$$$0(29);
        }
        return string;
    }

    @NotNull
    public Set<String> getQualifiedNames(@NotNull PsiFile sourceFile) {
        if (sourceFile == null) {
            JavaCoverageEngine.$$$reportNull$$$0(30);
        }
        PsiClass[] classes = (PsiClass[])ReadAction.compute(() -> ((PsiClassOwner)sourceFile).getClasses());
        HashSet<String> qNames = new HashSet<String>();
        for (JavaCoverageEngineExtension nameExtension : JavaCoverageEngineExtension.EP_NAME.getExtensionList()) {
            if (!((Boolean)ReadAction.compute(() -> nameExtension.suggestQualifiedName(sourceFile, classes, qNames))).booleanValue()) continue;
            HashSet<String> hashSet = qNames;
            if (hashSet == null) {
                JavaCoverageEngine.$$$reportNull$$$0(31);
            }
            return hashSet;
        }
        for (PsiClass aClass : classes) {
            String qName = (String)ReadAction.compute(() -> aClass.getQualifiedName());
            if (qName == null) continue;
            qNames.add(qName);
        }
        HashSet<String> hashSet = qNames;
        if (hashSet == null) {
            JavaCoverageEngine.$$$reportNull$$$0(32);
        }
        return hashSet;
    }

    @NotNull
    public Set<File> getCorrespondingOutputFiles(@NotNull PsiFile srcFile, @Nullable Module module, @NotNull CoverageSuitesBundle suite) {
        PsiClass[] classes;
        if (srcFile == null) {
            JavaCoverageEngine.$$$reportNull$$$0(33);
        }
        if (suite == null) {
            JavaCoverageEngine.$$$reportNull$$$0(34);
        }
        if (module == null) {
            Set<File> set = Collections.emptySet();
            if (set == null) {
                JavaCoverageEngine.$$$reportNull$$$0(35);
            }
            return set;
        }
        HashSet<File> classFiles = new HashSet<File>();
        CompilerModuleExtension moduleExtension = Objects.requireNonNull(CompilerModuleExtension.getInstance((Module)module));
        @Nullable File outputpath = JavaCoverageEngine.getOutputpath(moduleExtension);
        @Nullable File testOutputpath = JavaCoverageEngine.getTestOutputpath(moduleExtension);
        @Nullable VirtualFile outputpathVirtualFile = JavaCoverageEngine.fileToVirtualFileWithRefresh(outputpath);
        @Nullable VirtualFile testOutputpathVirtualFile = JavaCoverageEngine.fileToVirtualFileWithRefresh(testOutputpath);
        for (JavaCoverageEngineExtension extension : JavaCoverageEngineExtension.EP_NAME.getExtensionList()) {
            if (!extension.collectOutputFiles(srcFile, outputpathVirtualFile, testOutputpathVirtualFile, suite, classFiles)) continue;
            HashSet<File> hashSet = classFiles;
            if (hashSet == null) {
                JavaCoverageEngine.$$$reportNull$$$0(36);
            }
            return hashSet;
        }
        Project project = module.getProject();
        CoverageDataManager dataManager = CoverageDataManager.getInstance((Project)project);
        boolean includeTests = suite.isTrackTestFolders();
        VirtualFile[] roots = JavaCoverageClassesEnumerator.getRoots(dataManager, module, includeTests);
        String packageFQName = JavaCoverageEngine.getPackageName(srcFile);
        String packageVmName = packageFQName.replace('.', '/');
        ArrayList children = new ArrayList();
        for (VirtualFile root : roots) {
            File[] files;
            File dir;
            VirtualFile packageDir;
            if (root == null || (packageDir = root.findFileByRelativePath(packageVmName)) == null || !(dir = VfsUtilCore.virtualToIoFile((VirtualFile)packageDir)).exists() || (files = dir.listFiles()) == null) continue;
            Collections.addAll(children, files);
        }
        for (PsiClass psiClass : classes = (PsiClass[])ReadAction.compute(() -> ((PsiClassOwner)srcFile).getClasses())) {
            String className = (String)ReadAction.compute(() -> psiClass.getName());
            for (File child : children) {
                String childName;
                if (!FileUtilRt.extensionEquals((String)child.getName(), (String)JavaClassFileType.INSTANCE.getDefaultExtension()) || !(childName = FileUtilRt.getNameWithoutExtension((String)child.getName())).equals(className) && (!childName.startsWith(className) || childName.charAt(className.length()) != '$')) continue;
                classFiles.add(child);
            }
        }
        HashSet<File> hashSet = classFiles;
        if (hashSet == null) {
            JavaCoverageEngine.$$$reportNull$$$0(37);
        }
        return hashSet;
    }

    @Nullable
    private static VirtualFile fileToVirtualFileWithRefresh(@Nullable File file) {
        if (file == null) {
            return null;
        }
        return (VirtualFile)WriteAction.computeAndWait(() -> VfsUtil.findFileByIoFile((File)file, (boolean)true));
    }

    public String generateBriefReport(@NotNull Editor editor, @NotNull PsiFile psiFile, int lineNumber, int startOffset, int endOffset, @Nullable LineData lineData) {
        if (editor == null) {
            JavaCoverageEngine.$$$reportNull$$$0(38);
        }
        if (psiFile == null) {
            JavaCoverageEngine.$$$reportNull$$$0(39);
        }
        StringBuilder buf = new StringBuilder();
        buf.append(CoverageBundle.message((String)"hits.title", (Object[])new Object[]{""}));
        if (lineData == null) {
            buf.append(0);
            return buf.toString();
        }
        buf.append(lineData.getHits()).append("\n");
        for (JavaCoverageEngineExtension extension : JavaCoverageEngineExtension.EP_NAME.getExtensionList()) {
            String report = extension.generateBriefReport(editor, psiFile, lineNumber, startOffset, endOffset, lineData);
            if (report == null) continue;
            buf.append(report);
            return report;
        }
        ArrayList<PsiExpression> expressions = new ArrayList<PsiExpression>();
        Project project = editor.getProject();
        for (int offset = startOffset; offset < endOffset; ++offset) {
            PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)psiFile.findElementAt(offset), PsiStatement.class);
            PsiExpression condition = null;
            if (parent instanceof PsiIfStatement) {
                condition = ((PsiIfStatement)parent).getCondition();
            } else if (parent instanceof PsiSwitchStatement) {
                condition = ((PsiSwitchStatement)parent).getExpression();
            } else if (parent instanceof PsiConditionalLoopStatement) {
                condition = ((PsiConditionalLoopStatement)parent).getCondition();
            } else if (parent instanceof PsiForeachStatement) {
                condition = ((PsiForeachStatement)parent).getIteratedValue();
            } else if (parent instanceof PsiAssertStatement) {
                condition = ((PsiAssertStatement)parent).getAssertCondition();
            }
            if (!PsiTreeUtil.isAncestor((PsiElement)condition, (PsiElement)Objects.requireNonNull(psiFile.findElementAt(offset)), (boolean)false)) continue;
            try {
                ControlFlow controlFlow = ControlFlowFactory.getInstance((Project)Objects.requireNonNull(project)).getControlFlow(parent, (ControlFlowPolicy)AllVariablesControlFlowPolicy.getInstance());
                for (Instruction instruction : controlFlow.getInstructions()) {
                    PsiExpression psiExpression;
                    if (!(instruction instanceof ConditionalBranchingInstruction) || expressions.contains(psiExpression = ((ConditionalBranchingInstruction)instruction).expression)) continue;
                    expressions.add(psiExpression);
                }
                continue;
            }
            catch (AnalysisCanceledException e) {
                return buf.toString();
            }
        }
        try {
            int idx = 0;
            int hits = 0;
            String indent = "    ";
            if (lineData.getJumps() != null) {
                for (JumpData jumpData : lineData.getJumps()) {
                    PsiExpression expression;
                    PsiElement parentExpression;
                    if (jumpData.getTrueHits() + jumpData.getFalseHits() <= 0) continue;
                    boolean reverse = (parentExpression = (expression = (PsiExpression)expressions.get(idx++)).getParent()) instanceof PsiPolyadicExpression && ((PsiPolyadicExpression)parentExpression).getOperationTokenType() == JavaTokenType.OROR || parentExpression instanceof PsiDoWhileStatement || parentExpression instanceof PsiAssertStatement;
                    buf.append("    ").append(expression.getText()).append("\n");
                    buf.append("    ").append("    ").append("true").append(" ").append(CoverageBundle.message((String)"hits.message", (Object[])new Object[]{reverse ? jumpData.getFalseHits() : jumpData.getTrueHits()})).append("\n");
                    buf.append("    ").append("    ").append("false").append(" ").append(CoverageBundle.message((String)"hits.message", (Object[])new Object[]{reverse ? jumpData.getTrueHits() : jumpData.getFalseHits()})).append("\n");
                    hits += jumpData.getTrueHits() + jumpData.getFalseHits();
                }
            }
            if (lineData.getSwitches() != null) {
                for (JumpData jumpData : lineData.getSwitches()) {
                    PsiExpression conditionExpression = (PsiExpression)expressions.get(idx++);
                    buf.append("    ").append(conditionExpression.getText()).append("\n");
                    int i = 0;
                    for (int key : jumpData.getKeys()) {
                        int switchHits = jumpData.getHits()[i++];
                        buf.append("    ").append("    ").append("case ").append(key).append(": ").append(switchHits).append("\n");
                        hits += switchHits;
                    }
                    int defaultHits = jumpData.getDefaultHits();
                    boolean hasDefaultLabel = JavaCoverageEngine.hasDefaultLabel((PsiElement)conditionExpression);
                    if (!hasDefaultLabel && defaultHits <= 0) continue;
                    if (!hasDefaultLabel) {
                        defaultHits -= hits;
                    }
                    if (!hasDefaultLabel && defaultHits <= 0) continue;
                    buf.append("    ").append("    ").append("default: ").append(defaultHits).append("\n");
                    hits += defaultHits;
                }
            }
            if (lineData.getHits() > hits && hits > 0) {
                buf.append(JavaCoverageBundle.message("report.unknown.outcome", lineData.getHits() - hits));
            }
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
            return CoverageBundle.message((String)"hits.title", (Object[])new Object[]{lineData.getHits()});
        }
        return buf.toString();
    }

    @Nullable
    public String getTestMethodName(@NotNull PsiElement element, @NotNull AbstractTestProxy testProxy) {
        String qualifiedName;
        PsiMethod method;
        PsiClass aClass;
        if (element == null) {
            JavaCoverageEngine.$$$reportNull$$$0(40);
        }
        if (testProxy == null) {
            JavaCoverageEngine.$$$reportNull$$$0(41);
        }
        if (element instanceof PsiMethod && (aClass = (method = (PsiMethod)element).getContainingClass()) != null && (qualifiedName = ClassUtil.getJVMClassName((PsiClass)aClass)) != null) {
            return qualifiedName + "," + CoverageListener.sanitize((String)method.getName(), (int)qualifiedName.length());
        }
        return testProxy.toString();
    }

    @NotNull
    public List<PsiElement> findTestsByNames(String @NotNull [] testNames, @NotNull Project project) {
        if (project == null) {
            JavaCoverageEngine.$$$reportNull$$$0(42);
        }
        if (testNames == null) {
            JavaCoverageEngine.$$$reportNull$$$0(43);
        }
        ArrayList<PsiElement> elements = new ArrayList<PsiElement>();
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        for (String testName : testNames) {
            int index = testName.indexOf(",");
            if (index <= 0) {
                ArrayList<PsiElement> arrayList = elements;
                if (arrayList == null) {
                    JavaCoverageEngine.$$$reportNull$$$0(44);
                }
                return arrayList;
            }
            JavaCoverageEngine.collectTestsByName(elements, testName.substring(index + 1), testName.substring(0, index), psiManager);
        }
        ArrayList<PsiElement> arrayList = elements;
        if (arrayList == null) {
            JavaCoverageEngine.$$$reportNull$$$0(45);
        }
        return arrayList;
    }

    private static void collectTestsByName(List<? super PsiElement> elements, String testName, String className, PsiManager psiManager) {
        PsiClass psiClass = ClassUtil.findPsiClass((PsiManager)psiManager, (String)className);
        if (psiClass == null) {
            return;
        }
        TestFramework testFramework = TestFrameworks.detectFramework((PsiClass)psiClass);
        if (testFramework == null) {
            return;
        }
        Arrays.stream(psiClass.getAllMethods()).filter(method -> testFramework.isTestMethod((PsiElement)method) && testName.equals(CoverageListener.sanitize((String)method.getName(), (int)className.length()))).forEach(elements::add);
    }

    private static boolean hasDefaultLabel(PsiElement conditionExpression) {
        PsiElement bodyElement;
        boolean hasDefault = false;
        PsiSwitchStatement switchStatement = (PsiSwitchStatement)PsiTreeUtil.getParentOfType((PsiElement)conditionExpression, PsiSwitchStatement.class);
        PsiCodeBlock body = ((PsiSwitchStatementImpl)conditionExpression.getParent()).getBody();
        if (body != null && (bodyElement = body.getFirstBodyElement()) != null) {
            PsiSwitchLabelStatement label = (PsiSwitchLabelStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)bodyElement, PsiSwitchLabelStatement.class);
            while (label != null) {
                if (label.getEnclosingSwitchStatement() == switchStatement) {
                    hasDefault |= label.isDefaultCase();
                }
                label = (PsiSwitchLabelStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)label, PsiSwitchLabelStatement.class);
            }
        }
        return hasDefault;
    }

    protected JavaCoverageSuite createSuite(CoverageRunner acceptedCovRunner, String name, CoverageFileProvider coverageDataFileProvider, String[] filters, String[] excludePatterns, long lastCoverageTimeStamp, boolean coverageByTestEnabled, boolean branchCoverage, boolean trackTestFolders, Project project) {
        return new JavaCoverageSuite(name, coverageDataFileProvider, filters, excludePatterns, lastCoverageTimeStamp, coverageByTestEnabled, branchCoverage, trackTestFolders, acceptedCovRunner, this, project);
    }

    @NotNull
    protected static String getPackageName(PsiFile sourceFile) {
        String string = (String)ReadAction.compute(() -> ((PsiClassOwner)sourceFile).getPackageName());
        if (string == null) {
            JavaCoverageEngine.$$$reportNull$$$0(46);
        }
        return string;
    }

    public boolean isReportGenerationAvailable(@NotNull Project project, @NotNull DataContext dataContext, @NotNull CoverageSuitesBundle currentSuite) {
        Sdk projectSdk;
        if (project == null) {
            JavaCoverageEngine.$$$reportNull$$$0(47);
        }
        if (dataContext == null) {
            JavaCoverageEngine.$$$reportNull$$$0(48);
        }
        if (currentSuite == null) {
            JavaCoverageEngine.$$$reportNull$$$0(49);
        }
        return (projectSdk = ProjectRootManager.getInstance((Project)project).getProjectSdk()) != null;
    }

    public final void generateReport(final @NotNull Project project, @NotNull DataContext dataContext, final @NotNull CoverageSuitesBundle currentSuite) {
        if (project == null) {
            JavaCoverageEngine.$$$reportNull$$$0(50);
        }
        if (dataContext == null) {
            JavaCoverageEngine.$$$reportNull$$$0(51);
        }
        if (currentSuite == null) {
            JavaCoverageEngine.$$$reportNull$$$0(52);
        }
        final ExportToHTMLSettings settings = ExportToHTMLSettings.getInstance((Project)project);
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, JavaCoverageBundle.message("generating.coverage.report", new Object[0])){
            final Exception[] myExceptions;
            {
                super(arg0, arg1);
                this.myExceptions = new Exception[1];
            }

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    ((JavaCoverageRunner)currentSuite.getSuites()[0].getRunner()).generateReport(currentSuite, project);
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
                catch (ReportGenerationFailedException e) {
                    this.myExceptions[0] = e;
                }
            }

            public void onSuccess() {
                if (this.myExceptions[0] != null) {
                    Messages.showErrorDialog((Project)project, (String)this.myExceptions[0].getMessage(), (String)CommonBundle.getErrorTitle());
                    return;
                }
                if (settings.OPEN_IN_BROWSER) {
                    BrowserUtil.browse((File)new File(settings.OUTPUT_DIRECTORY, "index.html"));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/coverage/JavaCoverageEngine$1", "run"));
            }
        });
    }

    @Nls
    public String getPresentableText() {
        return JavaCoverageBundle.message("java.coverage.engine.presentable.text", new Object[0]);
    }

    public boolean isGeneratedCode(Project project, String qualifiedName, Object lineData) {
        if (JavaCoverageOptionsProvider.getInstance(project).isGeneratedConstructor(qualifiedName, ((LineData)lineData).getMethodSignature())) {
            return true;
        }
        return super.isGeneratedCode(project, qualifiedName, lineData);
    }

    public CoverageViewExtension createCoverageViewExtension(Project project, CoverageSuitesBundle suiteBundle, CoverageViewManager.StateBean stateBean) {
        return new JavaCoverageViewExtension((JavaCoverageAnnotator)this.getCoverageAnnotator(project), project, suiteBundle, stateBean);
    }

    public static boolean isSourceMapNeeded(RunConfigurationBase configuration) {
        for (JavaCoverageEngineExtension extension : JavaCoverageEngineExtension.EP_NAME.getExtensionList()) {
            if (!extension.isSourceMapNeeded(configuration)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 14, 29, 31, 32, 35, 36, 37, 44, 45, 46 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conf";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: 
            case 13: 
            case 42: 
            case 47: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "covRunner";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coverageDataFileProvider";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coverageRunner";
                break;
            }
            case 14: 
            case 29: 
            case 31: 
            case 32: 
            case 35: 
            case 36: 
            case 37: 
            case 44: 
            case 45: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/coverage/JavaCoverageEngine";
                break;
            }
            case 15: 
            case 16: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 17: 
            case 19: 
            case 22: 
            case 26: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suite";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chooseSuiteAction";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classFile";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputFile";
                break;
            }
            case 25: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFile";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "srcFile";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testProxy";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testNames";
                break;
            }
            case 48: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 49: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentSuite";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/coverage/JavaCoverageEngine";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoverageAnnotator";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedNames";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getCorrespondingOutputFiles";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "findTestsByNames";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableTo";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "willRunOnTarget";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isProjectUnderWsl";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "canHavePerTestCoverage";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createCoverageEnabledConfiguration";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createCoverageSuite";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createEmptyCoverageSuite";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getCoverageAnnotator";
                break;
            }
            case 14: 
            case 29: 
            case 31: 
            case 32: 
            case 35: 
            case 36: 
            case 37: 
            case 44: 
            case 45: 
            case 46: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "coverageEditorHighlightingApplicableTo";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "acceptedByFilters";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "recompileProjectAndRerunAction";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "collectSrcLinesForUntouchedFile";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "includeUntouchedFileInCoverage";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedName";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedNames";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getCorrespondingOutputFiles";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "generateBriefReport";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getTestMethodName";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "findTestsByNames";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "isReportGenerationAvailable";
                break;
            }
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "generateReport";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 14, 29, 31, 32, 35, 36, 37, 44, 45, 46 -> new IllegalStateException(string);
        };
    }
}

