/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.security.extension.go;

import com.goide.sdk.GoSdkService;
import com.goide.vgo.configuration.VgoProjectSettings;
import com.goide.vgo.mod.psi.VgoModuleSpec;
import com.goide.vgo.project.VgoDependency;
import com.goide.vgo.project.VgoModule;
import com.goide.vgo.project.VgoModulesRegistry;
import com.goide.vgo.project.workspaceModel.entities.VgoDependencyEntity;
import com.goide.vgo.project.workspaceModel.entities.VgoStandaloneModuleEntity;
import com.goide.vgo.project.workspaceModel.entities.VgoWorkspaceEntity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.workspace.jps.entities.ModuleEntity;
import com.intellij.platform.workspace.jps.entities.ModuleId;
import com.intellij.platform.workspace.storage.EntityChange;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.EntityStorageSnapshot;
import com.intellij.platform.workspace.storage.SymbolicEntityId;
import com.intellij.platform.workspace.storage.VersionedStorageChange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.workspaceModel.ide.impl.legacyBridge.module.ModuleEntityUtils;
import com.intellij.workspaceModel.ide.legacyBridge.ModuleBridge;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CompletableJob;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.SupervisorKt;
import kotlinx.coroutines.flow.FlowCollector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.security.api.PackageDeclaration;
import org.jetbrains.security.extension.go.GoLibraryDependency;
import org.jetbrains.security.extension.go.UtilsKt;
import org.jetbrains.security.model.Dependency;
import org.jetbrains.security.model.LibraryDependency;
import org.jetbrains.security.model.impl.MutableModuleModel;
import org.jetbrains.security.model.impl.ProjectDependenciesModelBase;
import org.jetbrains.security.package.Package;
import org.jetbrains.security.service.PackageCheckerDisposable;
import org.jetbrains.security.service.VulnerableApiService;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000fH\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J$\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00170\bH\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010\u001b\u001a\u0004\u0018\u00010\t*\u00020\u001cH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/security/extension/go/GoProjectDependenciesModel;", "Lorg/jetbrains/security/model/impl/ProjectDependenciesModelBase;", "Lorg/jetbrains/security/model/impl/MutableModuleModel;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "declaredDependencies", "", "Lorg/jetbrains/security/api/PackageDeclaration;", "module", "Lcom/intellij/openapi/module/Module;", "psiFile", "Lcom/intellij/psi/PsiFile;", "getAllModules", "", "libraryDependencies", "Lorg/jetbrains/security/model/LibraryDependency;", "refreshVulnerableApiService", "", "event", "Lcom/intellij/platform/workspace/storage/VersionedStorageChange;", "changes", "Lcom/intellij/platform/workspace/storage/EntityChange;", "Lcom/goide/vgo/project/workspaceModel/entities/VgoDependencyEntity;", "supports", "", "toPackageDeclaration", "Lcom/goide/vgo/mod/psi/VgoModuleSpec;", "intellij.packageChecker"})
@SourceDebugExtension(value={"SMAP\nGoProjectDependenciesModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoProjectDependenciesModel.kt\norg/jetbrains/security/extension/go/GoProjectDependenciesModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,116:1\n1603#2,9:117\n1855#2:126\n1856#2:128\n1612#2:129\n1549#2:130\n1620#2,3:131\n1603#2,9:134\n1855#2:143\n1856#2:145\n1612#2:146\n1603#2,9:147\n1855#2:156\n1856#2:158\n1612#2:159\n1360#2:160\n1446#2,5:161\n1360#2:167\n1446#2,5:168\n1549#2:173\n1620#2,3:174\n1#3:127\n1#3:144\n1#3:157\n1#3:166\n*S KotlinDebug\n*F\n+ 1 GoProjectDependenciesModel.kt\norg/jetbrains/security/extension/go/GoProjectDependenciesModel\n*L\n81#1:117,9\n81#1:126\n81#1:128\n81#1:129\n82#1:130\n82#1:131,3\n101#1:134,9\n101#1:143\n101#1:145\n101#1:146\n105#1:147,9\n105#1:156\n105#1:158\n105#1:159\n106#1:160\n106#1:161,5\n114#1:167\n114#1:168,5\n115#1:173\n115#1:174,3\n81#1:127\n101#1:144\n105#1:157\n*E\n"})
public final class GoProjectDependenciesModel
extends ProjectDependenciesModelBase<MutableModuleModel>
implements Disposable {
    @NotNull
    private final Project project;

    public GoProjectDependenciesModel(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        CompletableJob completableJob = SupervisorKt.SupervisorJob$default(null, (int)1, null);
        String string = GoProjectDependenciesModel.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GoProjectDependenciesModel::class.java.name");
        super(completableJob.plus((CoroutineContext)new CoroutineName(string)));
        this.project = project;
        BuildersKt.launch$default((CoroutineScope)this.getCoroutineScope$intellij_packageChecker(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ GoProjectDependenciesModel this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = WorkspaceModel.Companion.getInstance(this.this$0.project).getChangesEventFlow().collect(new FlowCollector(){

                            @Nullable
                            public final Object emit(@NotNull VersionedStorageChange event, @NotNull Continuation<? super Unit> $completion) {
                                List changes = event.getChanges(VgoDependencyEntity.class);
                                if (!((Collection)changes).isEmpty()) {
                                    this$0.refresh(this$0.project);
                                    this$0.refreshVulnerableApiService(event, changes);
                                }
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        Disposer.register((Disposable)PackageCheckerDisposable.Companion.getInstance(this.project), (Disposable)this);
        this.init();
    }

    private final void refreshVulnerableApiService(VersionedStorageChange event, List<? extends EntityChange<VgoDependencyEntity>> changes) {
        Set moduleIds = new LinkedHashSet();
        for (EntityChange<VgoDependencyEntity> entityChange : changes) {
            VgoDependencyEntity vgoDependencyEntity;
            EntityChange<VgoDependencyEntity> entityChange2 = entityChange;
            if (entityChange2 instanceof EntityChange.Added) {
                vgoDependencyEntity = (VgoDependencyEntity)((EntityChange.Added)entityChange).getEntity();
            } else if (entityChange2 instanceof EntityChange.Removed) {
                vgoDependencyEntity = (VgoDependencyEntity)((EntityChange.Removed)entityChange).getEntity();
            } else if (entityChange2 instanceof EntityChange.Replaced) {
                vgoDependencyEntity = (VgoDependencyEntity)((EntityChange.Replaced)entityChange).getNewEntity();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            VgoDependencyEntity dependency = vgoDependencyEntity;
            VgoStandaloneModuleEntity vgoStandaloneModuleEntity = dependency.getModule();
            ModuleId standaloneModuleId = vgoStandaloneModuleEntity != null ? vgoStandaloneModuleEntity.getModuleId() : null;
            VgoWorkspaceEntity vgoWorkspaceEntity = dependency.getWorkspace();
            ModuleId workspaceModuleId = vgoWorkspaceEntity != null ? vgoWorkspaceEntity.getModuleId() : null;
            Collection collection = moduleIds;
            ModuleId moduleId = standaloneModuleId;
            if (moduleId == null && (moduleId = workspaceModuleId) == null) continue;
            collection.add(moduleId);
        }
        EntityStorageSnapshot snapshot = event.getStorageAfter();
        for (ModuleId moduleId : moduleIds) {
            ModuleEntity moduleEntity = (ModuleEntity)snapshot.resolve((SymbolicEntityId)moduleId);
            if (moduleEntity == null || (moduleEntity = ModuleEntityUtils.findModule((ModuleEntity)moduleEntity, (EntityStorage)((EntityStorage)snapshot))) == null) continue;
            ModuleEntity module = moduleEntity;
            BuildersKt.launch$default((CoroutineScope)this.getCoroutineScope$intellij_packageChecker(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((ModuleBridge)module, null){
                int label;
                final /* synthetic */ ModuleBridge $module;
                {
                    this.$module = $module;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            ComponentManager $this$service$iv = (ComponentManager)this.$module;
                            boolean $i$f$service = false;
                            Class<VulnerableApiService> serviceClass$iv = VulnerableApiService.class;
                            Object object3 = $this$service$iv.getService(serviceClass$iv);
                            if (object3 == null) {
                                throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
                            }
                            this.label = 1;
                            Object object4 = ((VulnerableApiService)object3).refreshLibraries$intellij_packageChecker((Continuation<? super Unit>)((Continuation)this));
                            if (object4 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object4 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Iterable<MutableModuleModel> getAllModules() {
        Module[] modules = ModuleManager.Companion.getInstance(this.project).getModules();
        List result = new ArrayList();
        for (Module module : modules) {
            Collection vgoModules;
            ProgressManager.checkCanceled();
            if (!UtilsKt.isEnabled(module)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)VgoModulesRegistry.getInstance((Project)this.project).getModules(module), (String)"getInstance(project).getModules(module)");
            for (VgoModule vgoModule : vgoModules) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv;
                ProgressManager.checkCanceled();
                String string = vgoModule.getImportPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"vgoModule.importPath");
                MutableModuleModel moduleModel = new MutableModuleModel(string, module, vgoModule.getRoot().findChild("go.mod"), this.project);
                Collection collection = vgoModule.getDependencies();
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"vgoModule.dependencies");
                Iterable iterable = collection;
                boolean $i$f$mapNotNull = false;
                void var13_13 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Object object = $this$forEach$iv$iv$iv.iterator();
                while (object.hasNext()) {
                    Package it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = object.next();
                    boolean bl = false;
                    VgoDependency it = (VgoDependency)element$iv$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    if (UtilsKt.toPackage(it) == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                $this$mapNotNull$iv = (List)destination$iv$iv;
                boolean $i$f$map = false;
                $this$mapNotNullTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void pkg;
                    object = (Package)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl = false;
                    collection2.add(new Dependency((Package)pkg, CollectionsKt.emptyList(), null, 4, null));
                }
                List dependencies = (List)destination$iv$iv;
                moduleModel.setDependencies(dependencies);
                ((Collection)result).add(moduleModel);
            }
        }
        return result;
    }

    @Override
    public boolean supports(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return UtilsKt.ifClassesLoaded((Function0<Boolean>)((Function0)new Function0<Boolean>(project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Boolean invoke() {
                boolean bl;
                block1: {
                    void $this$any$iv;
                    Module[] moduleArray = ModuleManager.Companion.getInstance(this.$project).getModules();
                    Project project = this.$project;
                    boolean $i$f$any = false;
                    int n = ((void)$this$any$iv).length;
                    for (int i = 0; i < n; ++i) {
                        void element$iv;
                        void it = element$iv = $this$any$iv[i];
                        boolean bl2 = false;
                        if (!GoSdkService.getInstance((Project)project).isGoModule((Module)it)) continue;
                        bl = true;
                        break block1;
                    }
                    bl = false;
                }
                return bl && VgoProjectSettings.getInstance((Project)this.$project).isIntegrationEnabled();
            }
        }));
    }

    @Override
    public boolean supports(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        return UtilsKt.isEnabled(psiFile);
    }

    @Override
    public boolean supports(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return ArraysKt.contains((Object[])ModuleManager.Companion.getInstance(this.project).getModules(), (Object)module);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<PackageDeclaration> declaredDependencies(@NotNull PsiFile psiFile) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Iterable $this$mapNotNull$iv = UtilsKt.getDependencies(psiFile);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            PackageDeclaration it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            VgoModuleSpec it = (VgoModuleSpec)element$iv$iv;
            boolean bl2 = false;
            if (this.toPackageDeclaration(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<PackageDeclaration> declaredDependencies(@NotNull Module module) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Collection collection = VgoModulesRegistry.getInstance((Project)module.getProject()).getModules(module);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getInstance(module.project).getModules(module)");
        Iterable $this$mapNotNull$iv = collection;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            PsiFile it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            VgoModule it = (VgoModule)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            if (UtilsKt.getModuleRoot(this.project, (VgoDependency)it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$mapNotNullTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            PsiFile it = (PsiFile)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.declaredDependencies(it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final PackageDeclaration toPackageDeclaration(VgoModuleSpec $this$toPackageDeclaration) {
        PackageDeclaration packageDeclaration;
        Package package_ = UtilsKt.toPackage($this$toPackageDeclaration);
        if (package_ != null) {
            Package pkg = package_;
            boolean bl = false;
            packageDeclaration = new PackageDeclaration(pkg, (PsiElement)$this$toPackageDeclaration, null, 4, null);
        } else {
            packageDeclaration = null;
        }
        return packageDeclaration;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<LibraryDependency> libraryDependencies(@NotNull Module module) {
        void $this$mapTo$iv$iv;
        Iterable list$iv$iv;
        VgoModule it;
        Iterable $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Collection collection = VgoModulesRegistry.getInstance((Project)this.project).getModules(module);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getInstance(project).getModules(module)");
        Iterable $this$flatMap$iv = collection;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (VgoModule)element$iv$iv;
            boolean bl = false;
            Collection collection2 = it.getDependencies();
            Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"it.dependencies");
            list$iv$iv = collection2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            list$iv$iv = (VgoDependency)item$iv$iv;
            Collection collection3 = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            collection3.add(new GoLibraryDependency((VgoDependency)it));
        }
        return (List)destination$iv$iv;
    }
}

