/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.security.extension.go;

import com.goide.inspections.core.GoCallableDescriptor;
import com.goide.inspections.core.GoFunctionDescriptor;
import com.goide.inspections.core.GoInspectionBase;
import com.goide.inspections.core.GoMethodDescriptor;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoFile;
import com.goide.psi.GoVisitor;
import com.goide.util.GoUtil;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.security.PackageCheckerBundle;
import org.jetbrains.security.extension.go.UtilsKt;
import org.jetbrains.security.problems.vulnerabilities.Vulnerability;
import org.jetbrains.security.service.VulnerableApiCallResult;
import org.jetbrains.security.service.VulnerableApiService;
import org.jetbrains.security.toolwindow.preview.PackageHtmlRenderer;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/security/extension/go/GoVulnerableCodeUsagesInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "intellij.packageChecker"})
@SourceDebugExtension(value={"SMAP\nGoVulnerableCodeUsagesInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoVulnerableCodeUsagesInspection.kt\norg/jetbrains/security/extension/go/GoVulnerableCodeUsagesInspection\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,42:1\n1#2:43\n10#3:44\n*S KotlinDebug\n*F\n+ 1 GoVulnerableCodeUsagesInspection.kt\norg/jetbrains/security/extension/go/GoVulnerableCodeUsagesInspection\n*L\n22#1:44\n*E\n"})
public final class GoVulnerableCodeUsagesInspection
extends LocalInspectionTool {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        GoFile file2;
        void $this$asSafely$iv;
        PsiFile psiFile;
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        PsiFile it = psiFile = holder.getFile();
        boolean bl = false;
        psiFile = UtilsKt.ifClassesLoaded((Function0<Boolean>)((Function0)new Function0<Boolean>(it){
            final /* synthetic */ PsiFile $it;
            {
                this.$it = $it;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return this.$it instanceof GoFile;
            }
        })) ? psiFile : null;
        boolean $i$f$asSafely = false;
        Object v0 = $this$asSafely$iv;
        if (!(v0 instanceof GoFile)) {
            v0 = null;
        }
        if ((file2 = (GoFile)v0) == null || !GoInspectionBase.shouldProcessFile((GoFile)file2)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        Module module = GoUtil.module((PsiElement)((PsiElement)holder.getFile()));
        if (module == null) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        Module module2 = module;
        VulnerableApiService vulnerableApiService = VulnerableApiService.Companion.getInstance(module2);
        return (PsiElementVisitor)new GoVisitor(vulnerableApiService, holder){
            final /* synthetic */ VulnerableApiService $vulnerableApiService;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$vulnerableApiService = $vulnerableApiService;
                this.$holder = $holder;
            }

            public void visitCallExpr(@NotNull GoCallExpr o) {
                String string;
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                super.visitCallExpr(o);
                GoCallableDescriptor callable = GoCallableDescriptor.of((GoCallExpr)o, (boolean)false);
                if (callable instanceof GoFunctionDescriptor) {
                    string = ((GoFunctionDescriptor)callable).getImportPath() + "." + ((GoFunctionDescriptor)callable).getName();
                } else if (callable instanceof GoMethodDescriptor) {
                    string = ((GoMethodDescriptor)callable).getImportPath() + "." + ((GoMethodDescriptor)callable).getReceiver() + "." + ((GoMethodDescriptor)callable).getName();
                } else {
                    return;
                }
                String fqn = string;
                VulnerableApiCallResult vulnerableApiCallResult = this.$vulnerableApiService.isVulnerable(fqn);
                boolean isVulnerable = vulnerableApiCallResult.component1();
                List<Vulnerability> vulns = vulnerableApiCallResult.component2();
                if (isVulnerable) {
                    Object[] objectArray = new Object[]{PackageHtmlRenderer.INSTANCE.getVulnerabilityList(vulns)};
                    this.$holder.registerProblem((PsiElement)o, PackageCheckerBundle.message("inspection.message.vulnerable.api.usage", objectArray), new LocalQuickFix[0]);
                }
            }
        };
    }
}

