/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.security.service;

import com.intellij.ide.actions.QualifiedNameProviderUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.impl.scopes.LibraryScope;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.PsiJavaParserFacadeImpl;
import com.intellij.psi.impl.PsiShortNamesCacheImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.security.PackageUtilKt;
import org.jetbrains.security.model.LibraryDependency;
import org.jetbrains.security.package.Package;
import org.jetbrains.security.problems.vulnerabilities.VulnerablePath;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\n\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\u0010\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\t\u0010\u0018\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/security/service/JavaLibraryDependency;", "Lorg/jetbrains/security/model/LibraryDependency;", "library", "Lcom/intellij/openapi/roots/libraries/Library;", "(Lcom/intellij/openapi/roots/libraries/Library;)V", "getLibrary", "()Lcom/intellij/openapi/roots/libraries/Library;", "component1", "copy", "createPackage", "Lorg/jetbrains/security/package/Package;", "equals", "", "other", "", "getVulnerableElementQualifiedName", "", "project", "Lcom/intellij/openapi/project/Project;", "path", "Lorg/jetbrains/security/problems/vulnerabilities/VulnerablePath;", "hashCode", "", "isJavaPath", "toString", "intellij.packageChecker"})
@SourceDebugExtension(value={"SMAP\nVulnerableApiService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VulnerableApiService.kt\norg/jetbrains/security/service/JavaLibraryDependency\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,233:1\n10#2:234\n10#3:235\n10#3:236\n*S KotlinDebug\n*F\n+ 1 VulnerableApiService.kt\norg/jetbrains/security/service/JavaLibraryDependency\n*L\n174#1:234\n178#1:235\n203#1:236\n*E\n"})
public final class JavaLibraryDependency
implements LibraryDependency {
    @NotNull
    private final Library library;

    public JavaLibraryDependency(@NotNull Library library) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        this.library = library;
    }

    @NotNull
    public final Library getLibrary() {
        return this.library;
    }

    @Override
    @Nullable
    public String getVulnerableElementQualifiedName(@NotNull Project project, @NotNull VulnerablePath path) {
        String classFqn;
        String[] $this$asSafely$iv;
        block13: {
            block12: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                if (project.isDisposed()) break block12;
                $this$asSafely$iv = this.library;
                boolean $i$f$asSafely = false;
                String[] stringArray = $this$asSafely$iv;
                if (!($this$asSafely$iv instanceof LibraryEx)) {
                    stringArray = null;
                }
                LibraryEx libraryEx = (LibraryEx)stringArray;
                boolean bl = libraryEx != null ? libraryEx.isDisposed() : false;
                if (!bl) break block13;
            }
            return null;
        }
        if (!this.isJavaPath(path)) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(JavaLibraryDependency.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
            logger.debug("Not a Java path: " + path.getFileName());
            return null;
        }
        $this$asSafely$iv = new String[]{" "};
        String className = (String)CollectionsKt.first((List)StringsKt.split$default((CharSequence)((Object)StringsKt.trim((CharSequence)StringsKt.replaceFirst$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)path.getClass(), (String)"public class", (String)"", (boolean)false, (int)4, null), (String)"private class", (String)"", (boolean)false, (int)4, null), (String)"class ", (String)"", (boolean)false, (int)4, null))).toString(), (String[])$this$asSafely$iv, (boolean)false, (int)0, (int)6, null));
        Object[] objectArray = PsiShortNamesCacheImpl.getInstance((Project)project).getClassesByName(className, (GlobalSearchScope)new LibraryScope(project, this.library));
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getInstance(project)\n   \u2026yScope(project, library))");
        Object[] classesByName = objectArray;
        PsiClass psiClass = (PsiClass)ArraysKt.firstOrNull((Object[])classesByName);
        if (psiClass == null) {
            return null;
        }
        PsiClass clazz = psiClass;
        if (!StringsKt.isBlank((CharSequence)path.getFunctionName())) {
            String methodName;
            PsiMethod psiMethod;
            String signature = ((Object)StringsKt.trim((CharSequence)(path.getFunctionModifier() + " " + path.getFunctionName() + " " + path.getFunctionParams()))).toString();
            try {
                psiMethod = new PsiJavaParserFacadeImpl(project).createMethodFromText(signature, null);
            }
            catch (IncorrectOperationException ioe) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(JavaLibraryDependency.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
                logger.warn("Unable to parse as Java method signature: " + signature);
                return null;
            }
            PsiMethod psiMethod2 = psiMethod;
            Intrinsics.checkNotNullExpressionValue((Object)psiMethod2, (String)"try {\n        PsiJavaPar\u2026      return null\n      }");
            PsiMethod methodSignatureFromText = psiMethod2;
            PsiMethod methodBySignature = clazz.findMethodBySignature(methodSignatureFromText, true);
            if (methodBySignature != null && (methodName = QualifiedNameProviderUtil.getQualifiedName((PsiElement)((PsiElement)methodBySignature))) != null) {
                return methodName;
            }
        }
        if ((classFqn = QualifiedNameProviderUtil.getQualifiedName((PsiElement)((PsiElement)clazz))) != null) {
            return classFqn;
        }
        return null;
    }

    private final boolean isJavaPath(VulnerablePath path) {
        return StringsKt.endsWith$default((String)path.getFileName(), (String)".java", (boolean)false, (int)2, null);
    }

    @Override
    @Nullable
    public Package createPackage() {
        return PackageUtilKt.createPackage(this.library);
    }

    @NotNull
    public final Library component1() {
        return this.library;
    }

    @NotNull
    public final JavaLibraryDependency copy(@NotNull Library library) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        return new JavaLibraryDependency(library);
    }

    public static /* synthetic */ JavaLibraryDependency copy$default(JavaLibraryDependency javaLibraryDependency, Library library, int n, Object object) {
        if ((n & 1) != 0) {
            library = javaLibraryDependency.library;
        }
        return javaLibraryDependency.copy(library);
    }

    @NotNull
    public String toString() {
        return "JavaLibraryDependency(library=" + this.library + ")";
    }

    public int hashCode() {
        return this.library.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JavaLibraryDependency)) {
            return false;
        }
        JavaLibraryDependency javaLibraryDependency = (JavaLibraryDependency)other;
        return Intrinsics.areEqual((Object)this.library, (Object)javaLibraryDependency.library);
    }
}

