/*
 * Decompiled with CFR 0.152.
 */
package com.android.adblib;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\r\b&\u0018\u0000 \u00072\u00020\u0001:\u000b\u0006\u0007\b\t\n\u000b\f\r\u000e\u000f\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H&J\b\u0010\u0005\u001a\u00020\u0004H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/android/adblib/SocketSpec;", "", "()V", "toQueryString", "", "toString", "AcceptFD", "Companion", "Jdwp", "Local", "LocalAbstract", "LocalFileSystem", "LocalReserved", "PassThrough", "Service", "Tcp", "VSock", "android.sdktools.adblib"})
public abstract class SocketSpec {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public abstract String toQueryString();

    @NotNull
    public String toString() {
        return "socket-spec: " + this.toQueryString();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/android/adblib/SocketSpec$Tcp;", "Lcom/android/adblib/SocketSpec;", "port", "", "(I)V", "getPort", "()I", "toQueryString", "", "android.sdktools.adblib"})
    public static final class Tcp
    extends SocketSpec {
        private final int port;

        public Tcp(int port) {
            this.port = port;
        }

        public /* synthetic */ Tcp(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                n = 0;
            }
            this(n);
        }

        public final int getPort() {
            return this.port;
        }

        @Override
        @NotNull
        public String toQueryString() {
            return "tcp:" + this.port;
        }

        public Tcp() {
            this(0, 1, null);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lcom/android/adblib/SocketSpec$VSock;", "Lcom/android/adblib/SocketSpec;", "cid", "", "port", "(II)V", "getCid", "()I", "getPort", "toQueryString", "", "android.sdktools.adblib"})
    public static final class VSock
    extends SocketSpec {
        private final int cid;
        private final int port;

        public VSock(int cid, int port) {
            this.cid = cid;
            this.port = port;
        }

        public final int getCid() {
            return this.cid;
        }

        public final int getPort() {
            return this.port;
        }

        @Override
        @NotNull
        public String toQueryString() {
            return "vsock:" + this.cid + ":" + this.port;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/android/adblib/SocketSpec$AcceptFD;", "Lcom/android/adblib/SocketSpec;", "fd", "", "(I)V", "getFd", "()I", "toQueryString", "", "android.sdktools.adblib"})
    public static final class AcceptFD
    extends SocketSpec {
        private final int fd;

        public AcceptFD(int fd) {
            this.fd = fd;
        }

        public final int getFd() {
            return this.fd;
        }

        @Override
        @NotNull
        public String toQueryString() {
            return "acceptfd:" + this.fd;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\b"}, d2={"Lcom/android/adblib/SocketSpec$Local;", "Lcom/android/adblib/SocketSpec;", "path", "", "(Ljava/lang/String;)V", "getPath", "()Ljava/lang/String;", "toQueryString", "android.sdktools.adblib"})
    public static final class Local
    extends SocketSpec {
        @NotNull
        private final String path;

        public Local(@NotNull String path2) {
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            this.path = path2;
        }

        @NotNull
        public final String getPath() {
            return this.path;
        }

        @Override
        @NotNull
        public String toQueryString() {
            return "local:" + this.path;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\b"}, d2={"Lcom/android/adblib/SocketSpec$LocalAbstract;", "Lcom/android/adblib/SocketSpec;", "name", "", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "toQueryString", "android.sdktools.adblib"})
    public static final class LocalAbstract
    extends SocketSpec {
        @NotNull
        private final String name;

        public LocalAbstract(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @Override
        @NotNull
        public String toQueryString() {
            return "localabstract:" + this.name;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\b"}, d2={"Lcom/android/adblib/SocketSpec$LocalReserved;", "Lcom/android/adblib/SocketSpec;", "name", "", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "toQueryString", "android.sdktools.adblib"})
    public static final class LocalReserved
    extends SocketSpec {
        @NotNull
        private final String name;

        public LocalReserved(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @Override
        @NotNull
        public String toQueryString() {
            return "localreserved:" + this.name;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\b"}, d2={"Lcom/android/adblib/SocketSpec$LocalFileSystem;", "Lcom/android/adblib/SocketSpec;", "name", "", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "toQueryString", "android.sdktools.adblib"})
    public static final class LocalFileSystem
    extends SocketSpec {
        @NotNull
        private final String name;

        public LocalFileSystem(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @Override
        @NotNull
        public String toQueryString() {
            return "localfilesystem:" + this.name;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\b"}, d2={"Lcom/android/adblib/SocketSpec$PassThrough;", "Lcom/android/adblib/SocketSpec;", "value", "", "(Ljava/lang/String;)V", "getValue", "()Ljava/lang/String;", "toQueryString", "android.sdktools.adblib"})
    public static final class PassThrough
    extends SocketSpec {
        @NotNull
        private final String value;

        public PassThrough(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.value = value;
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        @Override
        @NotNull
        public String toQueryString() {
            return this.value;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/android/adblib/SocketSpec$Jdwp;", "Lcom/android/adblib/SocketSpec;", "pid", "", "(I)V", "getPid", "()I", "toQueryString", "", "android.sdktools.adblib"})
    public static final class Jdwp
    extends SocketSpec {
        private final int pid;

        public Jdwp(int pid) {
            this.pid = pid;
        }

        public final int getPid() {
            return this.pid;
        }

        @Override
        @NotNull
        public String toQueryString() {
            return "jdwp:" + this.pid;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/android/adblib/SocketSpec$Service;", "Lcom/android/adblib/SocketSpec;", "service", "", "(Ljava/lang/String;)V", "toQueryString", "android.sdktools.adblib"})
    public static final class Service
    extends SocketSpec {
        @NotNull
        private final String service;

        public Service(@NotNull String service) {
            Intrinsics.checkNotNullParameter((Object)service, (String)"service");
            this.service = service;
        }

        @Override
        @NotNull
        public String toQueryString() {
            return this.service;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/android/adblib/SocketSpec$Companion;", "", "()V", "fromQueryString", "Lcom/android/adblib/SocketSpec;", "value", "", "android.sdktools.adblib"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SocketSpec fromQueryString(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            int colonIndex = StringsKt.indexOf$default((CharSequence)value, (String)":", (int)0, (boolean)false, (int)6, null);
            if (colonIndex < 0) {
                return new PassThrough(value);
            }
            String string = value.substring(0, colonIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String prefix = string;
            String string2 = value.substring(colonIndex + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
            String suffix = string2;
            switch (prefix) {
                case "tcp": {
                    Integer port = StringsKt.toIntOrNull((String)suffix);
                    return port == null ? (SocketSpec)new PassThrough(value) : (SocketSpec)new Tcp(port);
                }
                case "vsock": {
                    int suffixColonIndex = StringsKt.indexOf$default((CharSequence)suffix, (String)":", (int)0, (boolean)false, (int)6, null);
                    if (suffixColonIndex < 0) {
                        return new PassThrough(value);
                    }
                    String string3 = suffix.substring(0, suffixColonIndex);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    Integer cid = StringsKt.toIntOrNull((String)string3);
                    String string4 = suffix.substring(suffixColonIndex + 1);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).substring(startIndex)");
                    Integer port = StringsKt.toIntOrNull((String)string4);
                    return cid == null || port == null ? (SocketSpec)new PassThrough(value) : (SocketSpec)new VSock(cid, port);
                }
                case "acceptfd": {
                    Integer fd = StringsKt.toIntOrNull((String)suffix);
                    return fd == null ? (SocketSpec)new PassThrough(value) : (SocketSpec)new AcceptFD(fd);
                }
                case "local": {
                    return new Local(suffix);
                }
                case "localabstract": {
                    return new LocalAbstract(suffix);
                }
                case "localreserved": {
                    return new LocalReserved(suffix);
                }
                case "localfilesystem": {
                    return new LocalFileSystem(suffix);
                }
                case "jdwp": {
                    Integer pid = StringsKt.toIntOrNull((String)suffix);
                    return pid == null ? (SocketSpec)new PassThrough(value) : (SocketSpec)new Jdwp(pid);
                }
            }
            return new PassThrough(value);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

