/*
 * Decompiled with CFR 0.152.
 */
package com.android.adblib.tools.debugging.impl;

import com.android.adblib.AdbLogger;
import com.android.adblib.AdbLoggerFactory;
import com.android.adblib.AdbSession;
import com.android.adblib.AdbSessionHost;
import com.android.adblib.AppProcessEntry;
import com.android.adblib.ConnectedDevice;
import com.android.adblib.ConnectedDeviceKt;
import com.android.adblib.CoroutineScopeCache;
import com.android.adblib.tools.debugging.AppProcess;
import com.android.adblib.tools.debugging.JdwpProcess;
import com.android.adblib.tools.debugging.impl.JdwpProcessImpl;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010(\u001a\u00020)H\u0016J\u0006\u0010*\u001a\u00020)J\b\u0010+\u001a\u00020\u000bH\u0016R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0016\u0010\u0018\u001a\u0004\u0018\u00010\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0014\u0010&\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u0015\u00a8\u0006,"}, d2={"Lcom/android/adblib/tools/debugging/impl/AppProcessImpl;", "Lcom/android/adblib/tools/debugging/AppProcess;", "Ljava/lang/AutoCloseable;", "session", "Lcom/android/adblib/AdbSession;", "device", "Lcom/android/adblib/ConnectedDevice;", "process", "Lcom/android/adblib/AppProcessEntry;", "(Lcom/android/adblib/AdbSession;Lcom/android/adblib/ConnectedDevice;Lcom/android/adblib/AppProcessEntry;)V", "architecture", "", "getArchitecture", "()Ljava/lang/String;", "cache", "Lcom/android/adblib/CoroutineScopeCache;", "getCache", "()Lcom/android/adblib/CoroutineScopeCache;", "debuggable", "", "getDebuggable", "()Z", "getDevice", "()Lcom/android/adblib/ConnectedDevice;", "jdwpProcess", "Lcom/android/adblib/tools/debugging/JdwpProcess;", "getJdwpProcess", "()Lcom/android/adblib/tools/debugging/JdwpProcess;", "jdwpProcessImpl", "Lcom/android/adblib/tools/debugging/impl/JdwpProcessImpl;", "logger", "Lcom/android/adblib/AdbLogger;", "pid", "", "getPid", "()I", "getProcess", "()Lcom/android/adblib/AppProcessEntry;", "profileable", "getProfileable", "close", "", "startMonitoring", "toString", "android.sdktools.adblib.tools"})
public final class AppProcessImpl
implements AppProcess,
AutoCloseable {
    @NotNull
    private final ConnectedDevice device;
    @NotNull
    private final AppProcessEntry process;
    @NotNull
    private final AdbLogger logger;
    @Nullable
    private final JdwpProcessImpl jdwpProcessImpl;
    @NotNull
    private final CoroutineScopeCache cache;

    /*
     * WARNING - void declaration
     */
    public AppProcessImpl(@NotNull AdbSession session, @NotNull ConnectedDevice device2, @NotNull AppProcessEntry process) {
        void $this$thisLogger$iv$iv;
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        this.device = device2;
        this.process = process;
        AppProcessImpl $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        AppProcessImpl appProcessImpl = $this$thisLogger$iv;
        AdbSessionHost host$iv$iv = session.getHost();
        boolean $i$f$thisLogger2 = false;
        void var9_9 = $this$thisLogger$iv$iv;
        AdbLoggerFactory loggerFactory$iv$iv$iv = host$iv$iv.getLoggerFactory();
        boolean $i$f$thisLogger3 = false;
        this.logger = loggerFactory$iv$iv$iv.createLogger(AppProcessImpl.class);
        this.jdwpProcessImpl = this.process.getDebuggable() ? new JdwpProcessImpl(session, this.getDevice(), this.process.getPid()) : (JdwpProcessImpl)null;
        this.cache = CoroutineScopeCache.Companion.create(ConnectedDeviceKt.getScope(this.getDevice()));
    }

    @Override
    @NotNull
    public ConnectedDevice getDevice() {
        return this.device;
    }

    @NotNull
    public final AppProcessEntry getProcess() {
        return this.process;
    }

    @Override
    @NotNull
    public CoroutineScopeCache getCache() {
        return this.cache;
    }

    @Override
    public int getPid() {
        return this.process.getPid();
    }

    @Override
    public boolean getDebuggable() {
        return this.process.getDebuggable();
    }

    @Override
    public boolean getProfileable() {
        return this.process.getProfileable();
    }

    @Override
    @NotNull
    public String getArchitecture() {
        return this.process.getArchitecture();
    }

    @Override
    @Nullable
    public JdwpProcess getJdwpProcess() {
        return this.jdwpProcessImpl;
    }

    public final void startMonitoring() {
        block0: {
            JdwpProcessImpl jdwpProcessImpl = this.jdwpProcessImpl;
            if (jdwpProcessImpl == null) break block0;
            jdwpProcessImpl.startMonitoring();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void close() {
        block1: {
            void this_$iv$iv;
            String msg = "Closing coroutine scope of JDWP process " + this.getPid();
            AdbLogger this_$iv = this.logger;
            boolean $i$f$debug = false;
            AdbLogger adbLogger = this_$iv;
            AdbLogger.Level level$iv$iv = AdbLogger.Level.DEBUG;
            boolean $i$f$logIf = false;
            if (this_$iv$iv.getMinLevel().compareTo((Enum)level$iv$iv) <= 0) {
                AdbLogger.Level level = level$iv$iv;
                void var8_8 = this_$iv$iv;
                boolean bl = false;
                String string = msg;
                var8_8.log(level, string);
            }
            this.getCache().close();
            JdwpProcessImpl jdwpProcessImpl = this.jdwpProcessImpl;
            if (jdwpProcessImpl == null) break block1;
            jdwpProcessImpl.close();
        }
    }

    @NotNull
    public String toString() {
        return "AppProcess(device=" + ConnectedDeviceKt.getSerialNumber(this.getDevice()) + ", pid=" + this.getPid() + ", debuggable=" + this.getDebuggable() + ", profileable=" + this.getProfileable() + ", architecture=" + this.getArchitecture() + ", jdwpProcess=" + this.getJdwpProcess() + ")";
    }
}

