/*
 * Decompiled with CFR 0.152.
 */
package com.android.adblib.tools.debugging.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001d\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u0014J\u0006\u0010\u0015\u001a\u00020\u0011J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0007H\u0002J(\u0010\u0017\u001a\u00020\u00112\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00070\u00192\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u00000\u001bR\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lcom/android/adblib/tools/debugging/impl/ProcessMap;", "T", "Ljava/lang/AutoCloseable;", "", "()V", "map", "Ljava/util/SortedMap;", "", "pids", "", "getPids", "()Ljava/util/Set;", "values", "", "getValues", "()Ljava/util/Collection;", "add", "", "pid", "item", "(ILjava/lang/AutoCloseable;)V", "clear", "remove", "update", "keys", "", "valueFactory", "Lkotlin/Function1;", "android.sdktools.adblib.tools"})
public final class ProcessMap<T extends AutoCloseable> {
    @NotNull
    private final SortedMap<Integer, T> map = new TreeMap();

    @NotNull
    public final Set<Integer> getPids() {
        Set<Integer> set = this.map.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"map.keys");
        return set;
    }

    @NotNull
    public final Collection<T> getValues() {
        Collection<T> collection = this.map.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"map.values");
        return collection;
    }

    public final void update(@NotNull Iterable<Integer> keys, @NotNull Function1<? super Integer, ? extends T> valueFactory) {
        int pid;
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        Intrinsics.checkNotNullParameter(valueFactory, (String)"valueFactory");
        ProcessMap map2 = this;
        Set<Integer> lastKnownPids = map2.getPids();
        HashSet effectivePids = CollectionsKt.toHashSet(keys);
        Set added2 = SetsKt.minus((Set)effectivePids, (Iterable)lastKnownPids);
        Set removed2 = SetsKt.minus(lastKnownPids, (Iterable)effectivePids);
        Iterable $this$forEach$iv = removed2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            pid = ((Number)element$iv).intValue();
            boolean bl = false;
            map2.remove(pid);
        }
        $this$forEach$iv = added2;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            pid = ((Number)element$iv).intValue();
            boolean bl = false;
            map2.add(pid, (AutoCloseable)valueFactory.invoke((Object)pid));
        }
    }

    public final void clear() {
        Collection<T> collection = this.map.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"map.values");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AutoCloseable it = (AutoCloseable)element$iv;
            boolean bl = false;
            it.close();
        }
        this.map.clear();
    }

    private final void add(int pid, T item) {
        AutoCloseable autoCloseable = (AutoCloseable)this.map.put(pid, item);
        if (autoCloseable != null) {
            AutoCloseable it = autoCloseable;
            boolean bl = false;
            it.close();
            throw new IllegalStateException("Error adding an entry for pid " + pid + ": the collection contained an existing entry (" + it + ")");
        }
    }

    private final void remove(int pid) {
        block0: {
            AutoCloseable autoCloseable = (AutoCloseable)this.map.remove(pid);
            if (autoCloseable == null) break block0;
            autoCloseable.close();
        }
    }
}

