/*
 * Decompiled with CFR 0.152.
 */
package com.android.adblib.utils;

import com.android.adblib.utils.AdbProtocolUtils;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\"\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000e0\u0011J,\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000e0\u0011H\u0002J\u001c\u0010\u0014\u001a\u00020\u000e2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000e0\u0011H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/android/adblib/utils/AdbBufferDecoder;", "", "bufferCapacity", "", "charset", "Ljava/nio/charset/Charset;", "(ILjava/nio/charset/Charset;)V", "charBuffer", "Ljava/nio/CharBuffer;", "decoder", "Ljava/nio/charset/CharsetDecoder;", "leftoverBuffer", "Ljava/nio/ByteBuffer;", "decodeBuffer", "", "buffer", "processor", "Lkotlin/Function1;", "decodeLeftoverBuffer", "leftovers", "flushCharBuffer", "android.sdktools.adblib"})
public final class AdbBufferDecoder {
    @NotNull
    private final CharsetDecoder decoder;
    @NotNull
    private final CharBuffer charBuffer;
    @Nullable
    private ByteBuffer leftoverBuffer;

    public AdbBufferDecoder(int bufferCapacity, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        CharsetDecoder charsetDecoder = charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).replaceWith("?");
        Intrinsics.checkNotNullExpressionValue((Object)charsetDecoder, (String)"charset.newDecoder()\n   \u2026        .replaceWith(\"?\")");
        this.decoder = charsetDecoder;
        CharBuffer charBuffer = CharBuffer.allocate(bufferCapacity);
        Intrinsics.checkNotNullExpressionValue((Object)charBuffer, (String)"allocate(bufferCapacity)");
        this.charBuffer = charBuffer;
    }

    public /* synthetic */ AdbBufferDecoder(int n, Charset charset, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 256;
        }
        if ((n2 & 2) != 0) {
            charset = AdbProtocolUtils.INSTANCE.getADB_CHARSET();
        }
        this(n, charset);
    }

    public final void decodeBuffer(@NotNull ByteBuffer buffer2, @NotNull Function1<? super CharBuffer, Unit> processor) {
        CoderResult result;
        Intrinsics.checkNotNullParameter((Object)buffer2, (String)"buffer");
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        ByteBuffer byteBuffer = this.leftoverBuffer;
        if (byteBuffer != null) {
            ByteBuffer byteBuffer2;
            ByteBuffer $this$decodeBuffer_u24lambda_u240 = byteBuffer2 = byteBuffer;
            boolean bl = false;
            this.decodeLeftoverBuffer($this$decodeBuffer_u24lambda_u240, buffer2, processor);
        }
        while (true) {
            result = this.decoder.decode(buffer2, this.charBuffer, false);
            if (result.isMalformed() || result.isUnmappable()) continue;
            if (!result.isOverflow()) break;
            this.flushCharBuffer(processor);
        }
        if (result.isUnderflow()) {
            this.flushCharBuffer(processor);
            if (buffer2.hasRemaining()) {
                boolean bl;
                ByteBuffer byteBuffer3 = this.leftoverBuffer = ByteBuffer.allocate(10);
                if (byteBuffer3 != null) {
                    byteBuffer3.put(buffer2);
                }
                boolean bl2 = bl = !buffer2.hasRemaining();
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
            }
        } else {
            throw new IllegalStateException();
        }
    }

    private final void decodeLeftoverBuffer(ByteBuffer leftovers, ByteBuffer buffer2, Function1<? super CharBuffer, Unit> processor) {
        if (leftovers.position() == 0) {
            return;
        }
        this.flushCharBuffer(processor);
        while (buffer2.hasRemaining()) {
            boolean bl;
            leftovers.put(buffer2.get());
            int count = leftovers.position();
            leftovers.flip();
            CoderResult result = this.decoder.decode(leftovers, this.charBuffer, false);
            if (result.isMalformed()) {
                bl = true;
            } else if (result.isUnmappable()) {
                bl = true;
            } else {
                if (result.isOverflow()) {
                    throw new IllegalStateException();
                }
                if (result.isUnderflow()) {
                    bl = !leftovers.hasRemaining();
                } else {
                    throw new IllegalStateException();
                }
            }
            boolean done = bl;
            if (done) {
                boolean bl2;
                boolean bl3 = bl2 = !leftovers.hasRemaining();
                if (_Assertions.ENABLED && !bl2) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                leftovers.clear();
                break;
            }
            leftovers.clear();
            leftovers.position(count);
        }
    }

    private final void flushCharBuffer(Function1<? super CharBuffer, Unit> processor) {
        if (this.charBuffer.position() > 0) {
            this.charBuffer.flip();
            processor.invoke((Object)this.charBuffer);
        }
        this.charBuffer.clear();
    }

    public AdbBufferDecoder() {
        this(0, null, 3, null);
    }
}

