/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

public class ByteBufferUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer mapFile(File f, long offset, ByteOrder byteOrder) throws IOException {
        try (FileInputStream dataFile = new FileInputStream(f);){
            FileChannel fc = dataFile.getChannel();
            MappedByteBuffer buffer2 = fc.map(FileChannel.MapMode.READ_ONLY, offset, f.length() - offset);
            buffer2.order(byteOrder);
            MappedByteBuffer mappedByteBuffer = buffer2;
            return mappedByteBuffer;
        }
    }

    public static String getString(ByteBuffer buf, int len) {
        char[] data = new char[len];
        for (int i = 0; i < len; ++i) {
            data[i] = buf.getChar();
        }
        return new String(data);
    }

    public static void putString(ByteBuffer buf, String str) {
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            buf.putChar(str.charAt(i));
        }
    }

    public static boolean cleanBuffer(ByteBuffer buffer2) {
        if (!buffer2.isDirect()) {
            return true;
        }
        try {
            Class<?> unsafeClass = ByteBufferUtil.class.getClassLoader().loadClass("sun.misc.Unsafe");
            Field f = unsafeClass.getDeclaredField("theUnsafe");
            f.setAccessible(true);
            Object unsafe = f.get(null);
            MethodType type2 = MethodType.methodType(Void.TYPE, ByteBuffer.class);
            MethodHandle handle2 = MethodHandles.lookup().findVirtual(unsafeClass, "invokeCleaner", type2);
            handle2.invoke(unsafeClass.cast(unsafe), buffer2);
            return true;
        }
        catch (Throwable ex) {
            Log.w("ddmlib", "ByteBufferUtil.cleanBuffer() failed " + ex);
            return false;
        }
    }
}

