/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.IShellOutputReceiver;
import com.google.common.base.Charsets;
import java.util.ArrayList;
import java.util.Collection;

public abstract class MultiLineReceiver
implements IShellOutputReceiver {
    private boolean mTrimLines = true;
    private String mUnfinishedLine = null;
    private final Collection<String> mArray = new ArrayList<String>();

    public void setTrimLine(boolean trim) {
        this.mTrimLines = trim;
    }

    @Override
    public final void addOutput(byte[] data, int offset, int length) {
        if (!this.isCancelled()) {
            String s = new String(data, offset, length, Charsets.UTF_8);
            if (this.mUnfinishedLine != null) {
                s = this.mUnfinishedLine + s;
                this.mUnfinishedLine = null;
            }
            this.mArray.clear();
            int start2 = 0;
            while (true) {
                int index2;
                if ((index2 = s.indexOf(10, start2)) == -1) break;
                int newlineLength = 1;
                if (index2 > 0 && s.charAt(index2 - 1) == '\r') {
                    --index2;
                    newlineLength = 2;
                }
                String line = s.substring(start2, index2);
                if (this.mTrimLines) {
                    line = line.trim();
                }
                this.mArray.add(line);
                start2 = index2 + newlineLength;
            }
            this.mUnfinishedLine = s.substring(start2);
            if (!this.mArray.isEmpty()) {
                String[] lines = this.mArray.toArray(new String[0]);
                this.processNewLines(lines);
            }
        }
    }

    @Override
    public void flush() {
        if (this.mUnfinishedLine != null) {
            this.processNewLines(new String[]{this.mUnfinishedLine});
        }
        this.done();
    }

    public void done() {
    }

    public abstract void processNewLines(String[] var1);
}

