/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib.internal;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.AvdData;
import com.android.ddmlib.Client;
import com.android.ddmlib.ClientTracker;
import com.android.ddmlib.CommandFailedException;
import com.android.ddmlib.DdmPreferences;
import com.android.ddmlib.EmulatorConsole;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.Log;
import com.android.ddmlib.clientmanager.DeviceClientManager;
import com.android.ddmlib.clientmanager.DeviceClientManagerUtils;
import com.android.ddmlib.internal.ClientImpl;
import com.android.ddmlib.internal.CommandService;
import com.android.ddmlib.internal.DeviceClientMonitorTask;
import com.android.ddmlib.internal.DeviceImpl;
import com.android.ddmlib.internal.DeviceListMonitorTask;
import com.android.ddmlib.internal.commands.DisconnectCommand;
import com.android.ddmlib.internal.jdwp.JdwpProxyServer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public final class DeviceMonitor
implements ClientTracker {
    private final AndroidDebugBridge mServer;
    private final MonitorErrorHandler mMonitorErrorHandler;
    private DeviceListMonitorTask mDeviceListMonitorTask;
    private Thread mDeviceListMonitorThread;
    private DeviceClientMonitorTask myDeviceClientMonitorTask;
    private Thread mDeviceClientMonitorThread;
    private JdwpProxyServer mJdwpProxy;
    private CommandService mDdmlibCommandService;
    private final Object mDevicesGuard = new Object();
    private ImmutableList<DeviceImpl> mDevices = ImmutableList.of();
    private static final long STOP_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(5L);

    public DeviceMonitor(AndroidDebugBridge server, MonitorErrorHandler monitorErrorHandler) {
        this.mServer = server;
        this.mMonitorErrorHandler = monitorErrorHandler;
    }

    public void start() {
        try {
            if (DdmPreferences.isJdwpProxyEnabled()) {
                this.mJdwpProxy = new JdwpProxyServer(DdmPreferences.getJdwpProxyPort(), this::jdwpProxyChangedState);
                this.mJdwpProxy.start();
            }
            if (DdmPreferences.isDdmlibCommandServiceEnabled()) {
                this.mDdmlibCommandService = new CommandService(DdmPreferences.getDdmCommandPort());
                this.mDdmlibCommandService.addCommand("disconnect", new DisconnectCommand(this));
                this.mDdmlibCommandService.start();
            }
            this.mDeviceListMonitorTask = new DeviceListMonitorTask(this.mServer, new DeviceListUpdateListener());
            if (AndroidDebugBridge.getClientSupport()) {
                this.myDeviceClientMonitorTask = new DeviceClientMonitorTask();
                this.mDeviceClientMonitorThread = new Thread((Runnable)this.myDeviceClientMonitorTask, "Device Client Monitor");
                this.mDeviceClientMonitorThread.start();
            }
            this.mDeviceListMonitorThread = new Thread((Runnable)this.mDeviceListMonitorTask, "Device List Monitor");
            this.mDeviceListMonitorThread.start();
        }
        catch (IOException ex) {
            Log.e("DeviceMonitor", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jdwpProxyChangedState() {
        DeviceImpl[] deviceImplArray = this.mDevicesGuard;
        synchronized (this.mDevicesGuard) {
            DeviceImpl[] devices2 = (DeviceImpl[])this.mDevices.toArray((Object[])new DeviceImpl[0]);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            for (DeviceImpl device2 : devices2) {
                this.trackDeviceToDropAndReopen(device2);
            }
            return;
        }
    }

    public void stop() {
        if (this.mJdwpProxy != null) {
            this.mJdwpProxy.stop();
        }
        if (this.mDeviceListMonitorTask != null) {
            this.mDeviceListMonitorTask.stop();
            try {
                if (this.mDeviceListMonitorThread != null) {
                    this.mDeviceListMonitorThread.join(STOP_TIMEOUT_MILLIS);
                    this.mDeviceListMonitorThread = null;
                }
            }
            catch (InterruptedException ex) {
                Log.e("DeviceMonitor.stop", ex);
            }
        }
        if (this.myDeviceClientMonitorTask != null) {
            this.myDeviceClientMonitorTask.stop();
            try {
                if (this.mDeviceClientMonitorThread != null) {
                    this.mDeviceClientMonitorThread.join(STOP_TIMEOUT_MILLIS);
                    this.mDeviceClientMonitorThread = null;
                }
            }
            catch (InterruptedException ex) {
                Log.e("DeviceMonitor.stop", ex);
            }
        }
        if (this.mDdmlibCommandService != null) {
            this.mDdmlibCommandService.stop();
        }
    }

    public boolean isMonitoring() {
        return this.mDeviceListMonitorTask != null && this.mDeviceListMonitorTask.isMonitoring();
    }

    public int getConnectionAttemptCount() {
        return this.mDeviceListMonitorTask == null ? 0 : this.mDeviceListMonitorTask.getConnectionAttemptCount();
    }

    public int getRestartAttemptCount() {
        return this.mDeviceListMonitorTask == null ? 0 : this.mDeviceListMonitorTask.getRestartAttemptCount();
    }

    public boolean hasInitialDeviceList() {
        return this.mDeviceListMonitorTask != null && this.mDeviceListMonitorTask.hasInitialDeviceList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDevice[] getDevices() {
        ImmutableList<DeviceImpl> devices2;
        Object object = this.mDevicesGuard;
        synchronized (object) {
            devices2 = this.mDevices;
        }
        return (IDevice[])devices2.toArray((Object[])new IDevice[0]);
    }

    public void disconnectClient(IDevice device2, int pid) {
        if (this.isMonitoring()) {
            for (Client client : device2.getClients()) {
                if (client.getClientData().getPid() != pid) continue;
                assert (this.myDeviceClientMonitorTask != null);
                this.myDeviceClientMonitorTask.disconnectClient((ClientImpl)client);
                return;
            }
        } else {
            Log.w("ddms", "Client disconnect ignored, not currently monitoring");
        }
    }

    AndroidDebugBridge getServer() {
        return this.mServer;
    }

    @Override
    public void trackClientToDropAndReopen(ClientImpl client) {
        assert (this.myDeviceClientMonitorTask != null);
        this.myDeviceClientMonitorTask.registerClientToDropAndReopen(client);
    }

    @Override
    public void trackDisconnectedClient(ClientImpl client) {
        assert (this.myDeviceClientMonitorTask != null);
        this.myDeviceClientMonitorTask.free(client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void trackDeviceToDropAndReopen(DeviceImpl device2) {
        boolean hasDevice;
        Object object = this.mDevicesGuard;
        synchronized (object) {
            hasDevice = this.mDevices.contains((Object)device2);
        }
        if (hasDevice && AndroidDebugBridge.getClientSupport() && this.myDeviceClientMonitorTask != null) {
            Log.d("DeviceMonitor", "Restarting monitoring service for " + device2);
            if (!this.myDeviceClientMonitorTask.register(device2)) {
                Log.e("DeviceMonitor", "Failed to start monitoring " + device2.getSerialNumber());
            }
        }
    }

    private static ImmutableList<DeviceImpl> addRemove(Collection<DeviceImpl> original, Collection<IDevice> toAdd, Collection<IDevice> toRemove) {
        HashSet removed2 = Sets.newHashSet(toRemove);
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        for (DeviceImpl deviceImpl : original) {
            if (removed2.contains(deviceImpl)) continue;
            resultBuilder.add((Object)deviceImpl);
        }
        for (IDevice iDevice : toAdd) {
            if (!(iDevice instanceof DeviceImpl)) continue;
            resultBuilder.add((Object)((DeviceImpl)iDevice));
        }
        return resultBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDevices(List<DeviceImpl> newList) {
        ImmutableList<DeviceImpl> oldDevices;
        Object object = this.mDevicesGuard;
        synchronized (object) {
            oldDevices = this.mDevices;
        }
        DeviceListComparisonResult result = DeviceListComparisonResult.compare(oldDevices, newList);
        ImmutableList<DeviceImpl> newDevices = DeviceMonitor.addRemove(oldDevices, result.added, result.removed);
        Iterator<IDevice> iterator = this.mDevicesGuard;
        synchronized (iterator) {
            this.mDevices = newDevices;
        }
        for (IDevice device2 : result.removed) {
            this.removeDevice((DeviceImpl)device2);
            AndroidDebugBridge.deviceDisconnected(device2);
        }
        ArrayList newlyOnline = Lists.newArrayListWithExpectedSize((int)newDevices.size());
        for (Map.Entry<IDevice, IDevice.DeviceState> entry : result.updated.entrySet()) {
            DeviceImpl device3 = (DeviceImpl)entry.getKey();
            device3.setState(entry.getValue());
            device3.update(1);
            if (!device3.isOnline()) continue;
            newlyOnline.add(device3);
        }
        for (IDevice device4 : result.added) {
            AndroidDebugBridge.deviceConnected(device4);
            if (!device4.isOnline()) continue;
            newlyOnline.add((DeviceImpl)device4);
        }
        if (AndroidDebugBridge.getClientSupport()) {
            for (IDevice device4 : newlyOnline) {
                if (this.myDeviceClientMonitorTask.register((DeviceImpl)device4)) continue;
                Log.e("DeviceMonitor", "Failed to start monitoring " + ((DeviceImpl)device4).getSerialNumber());
            }
        }
        for (IDevice device4 : newlyOnline) {
            DeviceMonitor.setProperties((DeviceImpl)device4);
            ((DeviceImpl)device4).getSystemProperty("ro.build.version.sdk");
        }
    }

    private void removeDevice(DeviceImpl device2) {
        device2.setState(IDevice.DeviceState.DISCONNECTED);
        device2.clearClientList();
        SocketChannel channel = device2.getClientMonitoringSocket();
        if (channel != null) {
            try {
                channel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setProperties(DeviceImpl device2) {
        String avdPath2;
        EmulatorConsole console;
        AvdData avdData;
        block7: {
            block6: {
                avdData = null;
                try {
                    if (device2.isEmulator()) break block6;
                    device2.setAvdData(null);
                    device2.setAvdData(avdData);
                    return;
                }
                catch (Throwable throwable) {
                    device2.setAvdData(avdData);
                    throw throwable;
                }
            }
            console = EmulatorConsole.getConsole(device2);
            if (console != null) break block7;
            device2.setAvdData(null);
            device2.setAvdData(avdData);
            return;
        }
        String avdName2 = console.getAvdName();
        try {
            avdPath2 = console.getAvdPath();
        }
        catch (CommandFailedException exception) {
            Log.e("DeviceMonitor", exception);
            avdPath2 = null;
        }
        console.close();
        avdData = new AvdData(avdName2, avdPath2);
        device2.setAvdData(avdData);
    }

    public static interface MonitorErrorHandler {
        public void initializationError(Exception var1);
    }

    private class DeviceListUpdateListener
    implements DeviceListMonitorTask.UpdateListener {
        private DeviceListUpdateListener() {
        }

        @Override
        public void initializationError(Exception e) {
            DeviceMonitor.this.mMonitorErrorHandler.initializationError(e);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void listFetchError(Exception e) {
            ImmutableList devices2;
            Object object = DeviceMonitor.this.mDevicesGuard;
            synchronized (object) {
                devices2 = DeviceMonitor.this.mDevices;
                DeviceMonitor.this.mDevices = ImmutableList.of();
            }
            for (DeviceImpl device2 : devices2) {
                DeviceMonitor.this.removeDevice(device2);
                AndroidDebugBridge.deviceDisconnected(device2);
            }
        }

        @Override
        public void deviceListUpdate(Map<String, IDevice.DeviceState> devices2) {
            Function<IDevice, DeviceClientManager> deviceClientManagerProvider = DeviceMonitor.this.mServer.getClientManager() == null ? null : device2 -> DeviceClientManagerUtils.createDeviceClientManager(DeviceMonitor.this.mServer, device2);
            ArrayList l = Lists.newArrayListWithExpectedSize((int)devices2.size());
            for (Map.Entry<String, IDevice.DeviceState> entry : devices2.entrySet()) {
                l.add(new DeviceImpl(DeviceMonitor.this, deviceClientManagerProvider, entry.getKey(), entry.getValue()));
            }
            DeviceMonitor.this.updateDevices(l);
        }
    }

    @VisibleForTesting
    public static class DeviceListComparisonResult {
        public final Map<IDevice, IDevice.DeviceState> updated;
        public final List<IDevice> added;
        public final List<IDevice> removed;

        private DeviceListComparisonResult(Map<IDevice, IDevice.DeviceState> updated, List<IDevice> added2, List<IDevice> removed2) {
            this.updated = updated;
            this.added = added2;
            this.removed = removed2;
        }

        public static DeviceListComparisonResult compare(List<? extends IDevice> previous, List<? extends IDevice> current) {
            current = Lists.newArrayList((Iterable)current);
            HashMap updated = Maps.newHashMapWithExpectedSize((int)current.size());
            ArrayList added2 = Lists.newArrayListWithExpectedSize((int)1);
            ArrayList removed2 = Lists.newArrayListWithExpectedSize((int)1);
            for (IDevice iDevice : previous) {
                IDevice currentDevice = DeviceListComparisonResult.find(current, iDevice);
                if (currentDevice != null) {
                    if (currentDevice.getState() != iDevice.getState()) {
                        updated.put(iDevice, currentDevice.getState());
                    }
                    current.remove(currentDevice);
                    continue;
                }
                removed2.add(iDevice);
            }
            added2.addAll(current);
            return new DeviceListComparisonResult(updated, added2, removed2);
        }

        private static IDevice find(List<? extends IDevice> devices2, IDevice device2) {
            for (IDevice iDevice : devices2) {
                if (!iDevice.getSerialNumber().equals(device2.getSerialNumber())) continue;
                return iDevice;
            }
            return null;
        }
    }
}

