/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib.internal.jdwp.chunkhandler;

import com.android.ddmlib.ClientData;
import com.android.ddmlib.Log;
import com.android.ddmlib.internal.ClientImpl;
import com.android.ddmlib.internal.MonitorThread;
import com.android.ddmlib.internal.jdwp.chunkhandler.ChunkHandler;
import java.nio.ByteBuffer;

public final class HandleWait
extends ChunkHandler {
    public static final int CHUNK_WAIT = ChunkHandler.type("WAIT");
    private static final HandleWait mInst = new HandleWait();

    private HandleWait() {
    }

    public static void register(MonitorThread mt) {
        mt.registerChunkHandler(CHUNK_WAIT, mInst);
    }

    @Override
    public void clientReady(ClientImpl client) {
    }

    @Override
    public void clientDisconnected(ClientImpl client) {
    }

    @Override
    public void handleChunk(ClientImpl client, int type2, ByteBuffer data, boolean isReply, int msgId) {
        Log.d("ddm-wait", "handling " + ChunkHandler.name(type2));
        if (type2 == CHUNK_WAIT) {
            assert (!isReply);
            HandleWait.handleWAIT(client, data);
        } else {
            this.handleUnknownChunk(client, type2, data, isReply, msgId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleWAIT(ClientImpl client, ByteBuffer data) {
        ClientData cd;
        byte reason = data.get();
        Log.d("ddm-wait", "WAIT: reason=" + reason);
        ClientData clientData = cd = client.getClientData();
        synchronized (clientData) {
            cd.setDebuggerConnectionStatus(ClientData.DebuggerStatus.WAITING);
        }
        client.update(2);
    }
}

