/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib.internal.jdwp.interceptor;

import com.android.ddmlib.TimeoutException;
import com.android.ddmlib.internal.jdwp.JdwpProxyClient;
import com.android.ddmlib.internal.jdwp.chunkhandler.ChunkHandler;
import com.android.ddmlib.internal.jdwp.chunkhandler.HandleHeap;
import com.android.ddmlib.internal.jdwp.chunkhandler.HandleHello;
import com.android.ddmlib.internal.jdwp.chunkhandler.HandleProfiling;
import com.android.ddmlib.internal.jdwp.chunkhandler.JdwpPacket;
import com.android.ddmlib.internal.jdwp.interceptor.Interceptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ClientInitializationInterceptor
implements Interceptor {
    private static int PACKET_ID_OFFSET = 4;
    private final Set<Integer> mCachePacketFilter = new HashSet<Integer>();
    private final Set<Integer> mReplyPacketFilter = new HashSet<Integer>();
    private final Map<Integer, byte[]> mCachedPackets = new HashMap<Integer, byte[]>();
    private final HashMap<Integer, Set<ClientRequestId>> mPendingPackets = new HashMap();

    public ClientInitializationInterceptor() {
        this.mCachePacketFilter.add(HandleHello.CHUNK_HELO);
        this.mCachePacketFilter.add(HandleHello.CHUNK_FEAT);
        this.mReplyPacketFilter.add(HandleProfiling.CHUNK_MPRQ);
        this.mReplyPacketFilter.add(HandleHeap.CHUNK_HPIF);
        this.mReplyPacketFilter.add(HandleHeap.CHUNK_REAQ);
    }

    @Override
    public boolean filterToDevice(JdwpProxyClient from, JdwpPacket packet) throws IOException, TimeoutException {
        if (packet.isEmpty() || packet.isError() || packet.getLength() < 15) {
            return false;
        }
        ByteBuffer payload = packet.getPayload();
        int type2 = payload.getInt();
        if (!this.mCachePacketFilter.contains(type2) && !this.mReplyPacketFilter.contains(type2)) {
            return false;
        }
        if (this.mCachedPackets.containsKey(type2)) {
            this.sendCachedPacket(from, type2, packet.getId());
            return true;
        }
        boolean alreadyPending = this.mPendingPackets.containsKey(type2);
        this.mPendingPackets.computeIfAbsent(type2, key2 -> new HashSet()).add(new ClientRequestId(from, packet.getId()));
        return alreadyPending;
    }

    @Override
    public boolean filterToClient(JdwpProxyClient to, JdwpPacket packet) throws IOException, TimeoutException {
        if (!packet.isReply() || packet.isEmpty() || packet.isError() || packet.getLength() < 15) {
            return false;
        }
        ByteBuffer payload = packet.getPayload();
        int type2 = payload.getInt();
        if (!this.mPendingPackets.containsKey(type2)) {
            return false;
        }
        if (this.mCachePacketFilter.contains(type2)) {
            ByteBuffer buffer2 = ByteBuffer.allocate(packet.getLength());
            buffer2.order(ChunkHandler.CHUNK_ORDER);
            packet.copy(buffer2);
            this.mCachedPackets.put(type2, buffer2.array());
            for (ClientRequestId pending : this.mPendingPackets.get(type2)) {
                this.sendCachedPacket(pending.client, type2, pending.requestId);
            }
        } else if (this.mReplyPacketFilter.contains(type2)) {
            for (ClientRequestId pending : this.mPendingPackets.get(type2)) {
                ClientInitializationInterceptor.sendPacketWithUpdatedPacketId(pending.client, pending.requestId, packet);
            }
        }
        this.mPendingPackets.remove(type2);
        return true;
    }

    private void sendCachedPacket(JdwpProxyClient to, int type2, int id) throws IOException, TimeoutException {
        ByteBuffer buffer2 = ByteBuffer.wrap(this.mCachedPackets.get(type2));
        buffer2.order(ChunkHandler.CHUNK_ORDER);
        buffer2.putInt(PACKET_ID_OFFSET, id);
        to.write(buffer2.array(), buffer2.limit());
    }

    private static void sendPacketWithUpdatedPacketId(JdwpProxyClient to, int id, JdwpPacket packet) throws IOException, TimeoutException {
        ByteBuffer buffer2 = ByteBuffer.allocate(packet.getLength());
        buffer2.order(ChunkHandler.CHUNK_ORDER);
        packet.copy(buffer2);
        buffer2.putInt(PACKET_ID_OFFSET, id);
        to.write(buffer2.array(), buffer2.limit());
    }

    private static class ClientRequestId {
        public JdwpProxyClient client;
        public int requestId;

        ClientRequestId(JdwpProxyClient client, int requestId) {
            this.client = client;
            this.requestId = requestId;
        }
    }
}

