/*
 * Decompiled with CFR 0.152.
 */
package com.android.jdwppacket;

import com.android.jdwppacket.IDSizes;
import com.android.jdwppacket.Location;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0014J\u0006\u0010\u0016\u001a\u00020\u0014J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0012H\u0002J\u0006\u0010\u0019\u001a\u00020\u0012J\u0006\u0010\u001a\u001a\u00020\u001bJ\u0006\u0010\u001c\u001a\u00020\u0014J\u0006\u0010\u001d\u001a\u00020\u0014J\u0006\u0010\u001e\u001a\u00020\u0014J\u0006\u0010\u001f\u001a\u00020\u0014J\u0006\u0010 \u001a\u00020!J\u0006\u0010\"\u001a\u00020\u0010J\u0006\u0010#\u001a\u00020$J\u0006\u0010%\u001a\u00020$J\u0006\u0010&\u001a\u00020\u0014J\u0006\u0010'\u001a\u00020\u000eJ\u0006\u0010(\u001a\u00020\fJ\u0006\u0010)\u001a\u00020\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006*"}, d2={"Lcom/android/jdwppacket/MessageReader;", "", "idSizes", "Lcom/android/jdwppacket/IDSizes;", "buffer", "Ljava/nio/ByteBuffer;", "(Lcom/android/jdwppacket/IDSizes;Ljava/nio/ByteBuffer;)V", "getBuffer", "()Ljava/nio/ByteBuffer;", "getIdSizes", "()Lcom/android/jdwppacket/IDSizes;", "getBoolean", "", "getByte", "", "getCharString", "", "len", "", "getClassID", "", "getFieldID", "getFrameID", "getID", "size", "getInt", "getLocation", "Lcom/android/jdwppacket/Location;", "getLong", "getMethodID", "getObjectID", "getReferenceTypeID", "getShort", "", "getString", "getTagValue", "", "getTaggedObjectID", "getThreadID", "getTypeTag", "hasRemaining", "remaining", "android.sdktools.jdwppacket"})
public final class MessageReader {
    @NotNull
    private final IDSizes idSizes;
    @NotNull
    private final ByteBuffer buffer;

    public MessageReader(@NotNull IDSizes idSizes, @NotNull ByteBuffer buffer2) {
        Intrinsics.checkNotNullParameter((Object)idSizes, (String)"idSizes");
        Intrinsics.checkNotNullParameter((Object)buffer2, (String)"buffer");
        this.idSizes = idSizes;
        this.buffer = buffer2;
    }

    @NotNull
    public final IDSizes getIdSizes() {
        return this.idSizes;
    }

    @NotNull
    public final ByteBuffer getBuffer() {
        return this.buffer;
    }

    public final byte getByte() {
        return this.buffer.get();
    }

    public final byte getTypeTag() {
        return this.getByte();
    }

    public final boolean getBoolean() {
        return this.buffer.get() != 0;
    }

    public final short getShort() {
        return this.buffer.getShort();
    }

    public final int getInt() {
        return this.buffer.getInt();
    }

    public final long getLong() {
        return this.buffer.getLong();
    }

    @NotNull
    public final Location getLocation() {
        return Location.Companion.parse(this);
    }

    public final void getTagValue() {
        char c = (char)this.getByte();
        if (c == '[') {
            this.getObjectID();
        } else if (c == 'B') {
            this.getByte();
        } else if (c == 'C') {
            this.getShort();
        } else if (c == 'L') {
            this.getObjectID();
        } else if (c == 'F') {
            this.getInt();
        } else if (c == 'D') {
            this.getLong();
        } else if (c == 'I') {
            this.getInt();
        } else if (c == 'J') {
            this.getLong();
        } else if (c == 'S') {
            this.getShort();
        } else if (c != 'V') {
            if (c == 'Z') {
                this.getByte();
            } else if (c == 's') {
                this.getObjectID();
            } else if (c == 't') {
                this.getObjectID();
            } else if (c == 'g') {
                this.getObjectID();
            } else if (c == 'l') {
                this.getObjectID();
            } else if (c == 'c') {
                this.getObjectID();
            }
        }
    }

    public final long getFieldID() {
        return this.getID(this.idSizes.getFieldIDSize());
    }

    public final long getMethodID() {
        return this.getID(this.idSizes.getMethodIDSize());
    }

    public final long getClassID() {
        return this.getReferenceTypeID();
    }

    public final long getObjectID() {
        return this.getID(this.idSizes.getObjectIDSize());
    }

    public final long getThreadID() {
        return this.getObjectID();
    }

    public final void getTaggedObjectID() {
        this.getObjectID();
        this.getByte();
    }

    public final long getReferenceTypeID() {
        return this.getID(this.idSizes.getReferenceTypeIDSize());
    }

    public final long getFrameID() {
        return this.getID(this.idSizes.getFrameIDSize());
    }

    @NotNull
    public final String getString() {
        byte[] bytes = new byte[this.getInt()];
        this.buffer.get(bytes);
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        Charset charset2 = charset;
        return new String(bytes, charset2);
    }

    private final long getID(int size) {
        long l;
        switch (size) {
            case 1: {
                l = this.buffer.get();
                break;
            }
            case 2: {
                l = this.buffer.getShort();
                break;
            }
            case 4: {
                l = this.buffer.getInt();
                break;
            }
            case 8: {
                l = this.buffer.getLong();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported id size: " + size);
            }
        }
        return l;
    }

    public final int remaining() {
        return this.buffer.remaining();
    }

    public final boolean hasRemaining() {
        return this.buffer.hasRemaining();
    }

    @NotNull
    public final String getCharString(int len) {
        int n = 0;
        char[] cArray = new char[len];
        while (n < len) {
            int n2 = n++;
            cArray[n2] = this.buffer.getChar();
        }
        char[] cArray2 = cArray;
        return new String(cArray2);
    }
}

