/*
 * Decompiled with CFR 0.152.
 */
package com.android.jdwptracer;

import com.android.jdwppacket.IsObsoleteCmd;
import com.android.jdwppacket.IsObsoleteReply;
import com.android.jdwppacket.LineTableCmd;
import com.android.jdwppacket.LineTableReply;
import com.android.jdwppacket.MessageReader;
import com.android.jdwptracer.CmdSet;
import com.android.jdwptracer.Message;
import com.android.jdwptracer.Session;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

class CmdSetMethod
extends CmdSet {
    protected CmdSetMethod() {
        super(6, "METHOD");
        this.add(1, "LineTable", CmdSetMethod::parseLineTableCmd, CmdSetMethod::parseLineTableReply);
        this.add(2, "VariableTable");
        this.add(3, "Bytecodes");
        this.add(4, "IsObsolete", CmdSetMethod::parseIsObsoleteCmd, CmdSetMethod::parseIsObsoleteReply);
        this.add(5, "VariableTableWithGenerics");
    }

    private static Message parseIsObsoleteReply(MessageReader reader, Session session) {
        Message message2 = new Message(reader);
        IsObsoleteReply reply = IsObsoleteReply.parse(reader);
        message2.addArg("isObsolete", Boolean.toString(reply.getObsolete()));
        return message2;
    }

    private static Message parseIsObsoleteCmd(MessageReader reader, Session session) {
        Message message2 = new Message(reader);
        IsObsoleteCmd cmd = IsObsoleteCmd.parse(reader);
        message2.addArg("refType", cmd.getRefType());
        message2.addArg("methodID", cmd.getMethodID());
        return message2;
    }

    private static Message parseLineTableReply(MessageReader reader, Session session) {
        Message message2 = new Message(reader);
        LineTableReply reply = LineTableReply.parse(reader);
        message2.addArg("start", reply.getStart());
        message2.addArg("end", reply.getEnd());
        JsonArray linesJson = new JsonArray();
        message2.addArg("lines", (JsonElement)linesJson);
        for (LineTableReply.Line line : reply.getLines()) {
            JsonObject lineJson = new JsonObject();
            linesJson.add((JsonElement)lineJson);
            lineJson.addProperty("lineCodeIndex", (Number)line.getLineCodeIndex());
            lineJson.addProperty("lineNumber", (Number)line.getLineNumber());
        }
        return message2;
    }

    private static Message parseLineTableCmd(MessageReader reader, Session session) {
        Message message2 = new Message(reader);
        LineTableCmd cmd = LineTableCmd.parse(reader);
        message2.addArg("refType", cmd.getRefType());
        message2.addArg("methodID", cmd.getMethodID());
        return message2;
    }
}

