/*
 * Decompiled with CFR 0.152.
 */
package com.android.jdwptracer;

import com.android.jdwptracer.Log;
import com.android.jdwptracer.Session;
import com.android.jdwptracer.SystraceOutput;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Path;
import java.nio.file.Paths;

public class JDWPTracer {
    private Session session;
    private final boolean enabled;
    private final Path outputFolder;
    private final Log log;

    public JDWPTracer(boolean enabled) {
        this(enabled, Paths.get(System.getProperty("java.io.tmpdir"), new String[0]));
    }

    public JDWPTracer(boolean enabled, Path folder) {
        this(enabled, folder, new Log());
    }

    public JDWPTracer(boolean enabled, Log log2) {
        this(enabled, Paths.get(System.getProperty("java.io.tmpdir"), new String[0]), log2);
    }

    JDWPTracer(boolean enabled, Path folder, Log log2) {
        this.enabled = enabled;
        this.outputFolder = folder;
        if (enabled) {
            this.session = new Session(log2);
        }
        this.log = log2;
    }

    public synchronized void addPacket(ByteBuffer buffer2) {
        if (!this.enabled) {
            return;
        }
        ByteBuffer packet = buffer2.duplicate();
        packet.order(ByteOrder.BIG_ENDIAN);
        try {
            this.session.addPacket(packet);
        }
        catch (Exception e) {
            this.log.warn("Unable to trace packet: " + this.session.details(buffer2.duplicate()), e);
        }
    }

    public synchronized void close() {
        if (!this.enabled) {
            return;
        }
        Path outputPath = this.outputFolder.resolve("perfetto-trace-" + this.session.name() + ".json");
        SystraceOutput.genOutput(this.session, outputPath);
        this.log.info("JDWTrace written to '" + outputPath.toAbsolutePath() + "'");
        this.session = new Session(this.log);
    }

    public synchronized void addEvent(String name) {
        if (!this.enabled) {
            return;
        }
        this.session.addEvent(name);
    }
}

