/*
 * Decompiled with CFR 0.152.
 */
package com.android.jdwptracer;

import com.android.jdwppacket.IDSizes;
import com.android.jdwppacket.MessageReader;
import com.android.jdwptracer.CmdSet;
import com.android.jdwptracer.CmdSets;
import com.android.jdwptracer.Command;
import com.android.jdwptracer.DdmJDWPTiming;
import com.android.jdwptracer.Event;
import com.android.jdwptracer.Log;
import com.android.jdwptracer.Message;
import com.android.jdwptracer.NamedEvent;
import com.android.jdwptracer.Packet;
import com.android.jdwptracer.Reply;
import com.android.jdwptracer.Transmission;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

class Session {
    private IDSizes idSizes = new IDSizes();
    private final HashMap<Integer, Transmission> idToTransmission = new HashMap();
    private final List<Event> events = new ArrayList<Event>();
    private Map<Integer, DdmJDWPTiming> timings = new HashMap<Integer, DdmJDWPTiming>();
    private String name = "unknown";
    private final Log log;

    Session(Log log2) {
        this.log = log2;
    }

    void addPacket(ByteBuffer packet) {
        long now_ns = System.nanoTime();
        int length = packet.getInt();
        int id = packet.getInt();
        byte flag = packet.get();
        if (Packet.isReply(flag)) {
            this.processReplyPacket(now_ns, length, id, packet);
        } else {
            this.processCmdPacket(now_ns, length, id, packet);
        }
    }

    private void processCmdPacket(long time_ns, int length, int id, ByteBuffer packet) {
        int cmdSetID = packet.get() & 0xFF;
        int cmdID = packet.get() & 0xFF;
        MessageReader messageReader = new MessageReader(this.idSizes, packet);
        CmdSet cmdSet = CmdSets.get(cmdSetID);
        Message message2 = cmdSet.getCmd(cmdID).getCmdParser().parse(messageReader, this);
        Command command = new Command(id, cmdSetID, cmdID, length, time_ns, message2);
        Transmission t = new Transmission(command, id, this.events.size());
        this.idToTransmission.put(id, t);
        this.events.add(t);
    }

    private void processReplyPacket(long time_ns, int length, int id, ByteBuffer packet) {
        short error = packet.getShort();
        if (!this.idToTransmission.containsKey(id)) {
            String msg = String.format(Locale.US, "Found reply id=%d packet without a cmd", id);
            this.log.warn(msg);
            return;
        }
        Transmission t = this.idToTransmission.get(id);
        int cmdSetID = t.cmd().cmdSetID();
        int cmdID = t.cmd().cmdID();
        MessageReader messageReader = new MessageReader(this.idSizes, packet);
        CmdSet cmdSet = CmdSets.get(cmdSetID);
        Message message2 = cmdSet.getCmd(cmdID).getReplyParser().parse(messageReader, this);
        Reply reply = new Reply(id, length, error, time_ns, message2);
        t.addReply(reply);
    }

    void addEvent(String name) {
        long now = System.nanoTime();
        this.events.add(new NamedEvent(name, now, this.events.size()));
    }

    List<Event> events() {
        return this.events;
    }

    Map<Integer, DdmJDWPTiming> timings() {
        return this.timings;
    }

    void addTimings(Map<Integer, DdmJDWPTiming> timings) {
        this.timings.putAll(timings);
    }

    void setName(String name) {
        this.name = name;
    }

    String name() {
        return this.name;
    }

    String details(ByteBuffer buffer2) {
        String details = "";
        if (buffer2.remaining() < 4) {
            details = details + "Empty";
            return details;
        }
        details = details + "Length=" + buffer2.getInt();
        if (buffer2.remaining() < 4) {
            details = details + ", no ID";
            return details;
        }
        details = details + ", ID=" + buffer2.getInt();
        if (buffer2.remaining() < 1) {
            details = details + ", no FLAGS";
            return details;
        }
        byte flag = buffer2.get();
        details = details + ", flags=0x" + Integer.toHexString(flag);
        details = Packet.isReply(flag) ? details + this.detailsReply(buffer2) : details + this.detailsCmd(buffer2);
        return details;
    }

    private String detailsCmd(ByteBuffer buffer2) {
        String details = "";
        if (buffer2.remaining() < 1) {
            details = details + ", no cmdset";
            return details;
        }
        details = details + ", cmdset=" + buffer2.get();
        if (buffer2.remaining() < 1) {
            details = details + ", no cmd";
            return details;
        }
        details = details + ", cmd=" + buffer2.get();
        return details;
    }

    private String detailsReply(ByteBuffer buffer2) {
        String details = "";
        if (buffer2.remaining() < 2) {
            details = details + ", no errorCode";
            return details;
        }
        details = details + ", errorCode=" + buffer2.getShort();
        return details;
    }

    void setIDSizes(IDSizes idSizes) {
        this.idSizes = idSizes;
    }
}

