/*
 * Decompiled with CFR 0.152.
 */
package com.android.processmonitor.monitor.adblib;

import com.android.adblib.AdbLogger;
import com.android.adblib.AdbSession;
import com.android.adblib.ConnectedDeviceKt;
import com.android.processmonitor.agenttracker.AgentProcessTrackerConfig;
import com.android.processmonitor.common.ProcessTracker;
import com.android.processmonitor.monitor.BaseProcessTrackerFactory;
import com.android.processmonitor.monitor.adblib.JdwpProcessTracker;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.deviceprovisioner.DeviceState;
import com.android.sdklib.devices.Abi;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0016J\u001b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\f\u001a\u00020\u0002H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000fJ\u0019\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\u0002H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0013"}, d2={"Lcom/android/processmonitor/monitor/adblib/ProcessTrackerFactoryAdblib;", "Lcom/android/processmonitor/monitor/BaseProcessTrackerFactory;", "Lcom/android/sdklib/deviceprovisioner/DeviceState$Connected;", "adbSession", "Lcom/android/adblib/AdbSession;", "agentConfig", "Lcom/android/processmonitor/agenttracker/AgentProcessTrackerConfig;", "logger", "Lcom/android/adblib/AdbLogger;", "(Lcom/android/adblib/AdbSession;Lcom/android/processmonitor/agenttracker/AgentProcessTrackerConfig;Lcom/android/adblib/AdbLogger;)V", "createMainTracker", "Lcom/android/processmonitor/common/ProcessTracker;", "device", "getDeviceAbi", "", "(Lcom/android/sdklib/deviceprovisioner/DeviceState$Connected;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getDeviceApiLevel", "", "getDeviceSerialNumber", "android.sdktools.process-monitor"})
public final class ProcessTrackerFactoryAdblib
extends BaseProcessTrackerFactory<DeviceState.Connected> {
    @NotNull
    private final AdbLogger logger;

    public ProcessTrackerFactoryAdblib(@NotNull AdbSession adbSession, @Nullable AgentProcessTrackerConfig agentConfig, @NotNull AdbLogger logger) {
        Intrinsics.checkNotNullParameter((Object)adbSession, (String)"adbSession");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        super(adbSession, agentConfig, logger);
        this.logger = logger;
    }

    @Override
    @NotNull
    public ProcessTracker createMainTracker(@NotNull DeviceState.Connected device2) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        return new JdwpProcessTracker(device2.getConnectedDevice(), this.logger, null, 4, null);
    }

    @Override
    @Nullable
    public Object getDeviceApiLevel(@NotNull DeviceState.Connected device2, @NotNull Continuation<? super Integer> $completion) {
        AndroidVersion androidVersion = device2.getProperties().getAndroidVersion();
        return Boxing.boxInt((int)(androidVersion != null ? androidVersion.getApiLevel() : 1));
    }

    @Override
    @Nullable
    public Object getDeviceAbi(@NotNull DeviceState.Connected device2, @NotNull Continuation<? super String> $completion) {
        Abi abi = device2.getProperties().getAbi();
        return abi != null ? abi.toString() : null;
    }

    @Override
    @NotNull
    public String getDeviceSerialNumber(@NotNull DeviceState.Connected device2) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        return ConnectedDeviceKt.getSerialNumber(device2.getConnectedDevice());
    }
}

