/*
 * Decompiled with CFR 0.152.
 */
package com.android.processmonitor.monitor.ddmlib;

import com.android.adblib.AdbLogger;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.processmonitor.monitor.ddmlib.ClientMonitorListener;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.channels.ChannelResult;
import kotlinx.coroutines.channels.ChannelsKt;
import kotlinx.coroutines.channels.ProducerScope;
import kotlinx.coroutines.channels.SendChannel;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u0016B#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\u0004H\u0016J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\u0004H\u0016J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0007H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/android/processmonitor/monitor/ddmlib/ClientMonitorListener;", "Lcom/android/ddmlib/AndroidDebugBridge$IDeviceChangeListener;", "Lcom/android/ddmlib/AndroidDebugBridge$IClientChangeListener;", "device", "Lcom/android/ddmlib/IDevice;", "flow", "Lkotlinx/coroutines/channels/ProducerScope;", "Lcom/android/processmonitor/monitor/ddmlib/ClientMonitorListener$ClientEvent;", "logger", "Lcom/android/adblib/AdbLogger;", "(Lcom/android/ddmlib/IDevice;Lkotlinx/coroutines/channels/ProducerScope;Lcom/android/adblib/AdbLogger;)V", "clientChanged", "", "client", "Lcom/android/ddmlib/Client;", "changeMask", "", "deviceChanged", "deviceConnected", "deviceDisconnected", "send", "event", "ClientEvent", "android.sdktools.process-monitor"})
public final class ClientMonitorListener
implements AndroidDebugBridge.IDeviceChangeListener,
AndroidDebugBridge.IClientChangeListener {
    @NotNull
    private final IDevice device;
    @NotNull
    private final ProducerScope<ClientEvent> flow;
    @NotNull
    private final AdbLogger logger;

    public ClientMonitorListener(@NotNull IDevice device2, @NotNull ProducerScope<? super ClientEvent> flow2, @NotNull AdbLogger logger) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        Intrinsics.checkNotNullParameter(flow2, (String)"flow");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.device = device2;
        this.flow = flow2;
        this.logger = logger;
    }

    @Override
    public void deviceConnected(@NotNull IDevice device2) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
    }

    @Override
    public void deviceDisconnected(@NotNull IDevice device2) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
    }

    @Override
    public void deviceChanged(@NotNull IDevice device2, int changeMask) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        if (Intrinsics.areEqual((Object)this.device, (Object)device2) && (changeMask & 2) != 0) {
            Client[] clientArray = device2.getClients();
            Intrinsics.checkNotNullExpressionValue((Object)clientArray, (String)"device.clients");
            this.send(new ClientEvent.ClientListChanged(clientArray));
        }
    }

    @Override
    public void clientChanged(@NotNull Client client, int changeMask) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        if ((changeMask & 1) != 0 && Intrinsics.areEqual((Object)client.getDevice(), (Object)this.device)) {
            this.send(new ClientEvent.ClientChanged(client));
        }
    }

    private final void send(ClientEvent event) {
        Object $this$onFailure_u2dWpGqRn0$iv = ChannelsKt.trySendBlocking((SendChannel)((SendChannel)this.flow), (Object)event);
        boolean bl = false;
        if ($this$onFailure_u2dWpGqRn0$iv instanceof ChannelResult.Failed) {
            Throwable it = ChannelResult.exceptionOrNull-impl((Object)$this$onFailure_u2dWpGqRn0$iv);
            boolean bl2 = false;
            this.logger.warn(it, "Failed to send ClientEvent");
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001:\u0002\u0003\u0004B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0002\u0005\u0006\u00a8\u0006\u0007"}, d2={"Lcom/android/processmonitor/monitor/ddmlib/ClientMonitorListener$ClientEvent;", "", "()V", "ClientChanged", "ClientListChanged", "Lcom/android/processmonitor/monitor/ddmlib/ClientMonitorListener$ClientEvent$ClientChanged;", "Lcom/android/processmonitor/monitor/ddmlib/ClientMonitorListener$ClientEvent$ClientListChanged;", "android.sdktools.process-monitor"})
    public static abstract class ClientEvent {
        private ClientEvent() {
        }

        public /* synthetic */ ClientEvent(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\t\u001a\u00020\nH\u0016R\u001b\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lcom/android/processmonitor/monitor/ddmlib/ClientMonitorListener$ClientEvent$ClientListChanged;", "Lcom/android/processmonitor/monitor/ddmlib/ClientMonitorListener$ClientEvent;", "clients", "", "Lcom/android/ddmlib/Client;", "([Lcom/android/ddmlib/Client;)V", "getClients", "()[Lcom/android/ddmlib/Client;", "[Lcom/android/ddmlib/Client;", "toString", "", "android.sdktools.process-monitor"})
        public static final class ClientListChanged
        extends ClientEvent {
            @NotNull
            private final Client[] clients;

            public ClientListChanged(@NotNull Client[] clients) {
                Intrinsics.checkNotNullParameter((Object)clients, (String)"clients");
                super(null);
                this.clients = clients;
            }

            @NotNull
            public final Client[] getClients() {
                return this.clients;
            }

            @NotNull
            public String toString() {
                return ArraysKt.joinToString$default((Object[])this.clients, null, (CharSequence)"ClientListChanged: ", null, (int)0, null, (Function1)toString.1.INSTANCE, (int)29, null);
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/android/processmonitor/monitor/ddmlib/ClientMonitorListener$ClientEvent$ClientChanged;", "Lcom/android/processmonitor/monitor/ddmlib/ClientMonitorListener$ClientEvent;", "client", "Lcom/android/ddmlib/Client;", "(Lcom/android/ddmlib/Client;)V", "getClient", "()Lcom/android/ddmlib/Client;", "toString", "", "android.sdktools.process-monitor"})
        public static final class ClientChanged
        extends ClientEvent {
            @NotNull
            private final Client client;

            public ClientChanged(@NotNull Client client) {
                Intrinsics.checkNotNullParameter((Object)client, (String)"client");
                super(null);
                this.client = client;
            }

            @NotNull
            public final Client getClient() {
                return this.client;
            }

            @NotNull
            public String toString() {
                return "ClientChanged: " + this.client.getClientData().getPid() + ": " + this.client.getClientData().getPackageName() + " " + this.client.getClientData().getClientDescription();
            }
        }
    }
}

