/*
 * Decompiled with CFR 0.152.
 */
package com.android.resources.base;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.util.PathString;
import com.android.resources.Density;
import com.android.resources.ResourceType;
import com.android.resources.ResourceVisibility;
import com.android.resources.base.BasicDensityBasedFileResourceItem;
import com.android.resources.base.BasicResourceItemBase;
import com.android.resources.base.RepositoryConfiguration;
import com.android.resources.base.ResourceSourceFile;
import com.android.utils.Base128InputStream;
import com.android.utils.Base128OutputStream;
import com.android.utils.HashCodes;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasicFileResourceItem
extends BasicResourceItemBase {
    @NotNull
    private final RepositoryConfiguration myConfiguration;
    @NotNull
    private final String myRelativePath;

    public BasicFileResourceItem(@NotNull ResourceType type2, @NotNull String name, @NotNull RepositoryConfiguration configuration, @NotNull ResourceVisibility visibility, @NotNull String relativePath) {
        super(type2, name, visibility);
        this.myConfiguration = configuration;
        this.myRelativePath = relativePath;
    }

    public final boolean isFileBased() {
        return true;
    }

    @Nullable
    public final ResourceReference getReference() {
        return null;
    }

    @Override
    @NotNull
    public RepositoryConfiguration getRepositoryConfiguration() {
        return this.myConfiguration;
    }

    @NotNull
    public final ResourceNamespace.Resolver getNamespaceResolver() {
        return ResourceNamespace.Resolver.EMPTY_RESOLVER;
    }

    @NotNull
    public String getValue() {
        return this.getRepository().getResourceUrl(this.myRelativePath);
    }

    @NotNull
    public final PathString getSource() {
        return this.getRepository().getSourceFile(this.myRelativePath, true);
    }

    @Nullable
    public final PathString getOriginalSource() {
        return this.getRepository().getOriginalSourceFile(this.myRelativePath, true);
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        BasicFileResourceItem other = (BasicFileResourceItem)obj;
        return this.myConfiguration.equals(other.myConfiguration) && this.myRelativePath.equals(other.myRelativePath);
    }

    @Override
    public int hashCode() {
        return HashCodes.mix((int)super.hashCode(), (int)this.myRelativePath.hashCode());
    }

    @Override
    public void serialize(@NotNull Base128OutputStream stream, @NotNull Object2IntMap<String> configIndexes, @NotNull Object2IntMap<ResourceSourceFile> sourceFileIndexes, @NotNull Object2IntMap<ResourceNamespace.Resolver> namespaceResolverIndexes) throws IOException {
        super.serialize(stream, configIndexes, sourceFileIndexes, namespaceResolverIndexes);
        stream.writeString(this.myRelativePath);
        String qualifierString = this.getConfiguration().getQualifierString();
        int index2 = configIndexes.getInt((Object)qualifierString);
        assert (index2 >= 0);
        stream.writeInt(index2);
        stream.writeInt(this.getEncodedDensityForSerialization());
    }

    @NotNull
    static BasicFileResourceItem deserialize(@NotNull Base128InputStream stream, @NotNull ResourceType resourceType, @NotNull String name, @NotNull ResourceVisibility visibility, @NotNull List<RepositoryConfiguration> configurations) throws IOException {
        String relativePath = stream.readString();
        if (relativePath == null) {
            throw Base128InputStream.StreamFormatException.invalidFormat();
        }
        RepositoryConfiguration configuration = configurations.get(stream.readInt());
        int encodedDensity = stream.readInt();
        if (encodedDensity == 0) {
            return new BasicFileResourceItem(resourceType, name, configuration, visibility, relativePath);
        }
        Density density = Density.values()[encodedDensity - 1];
        return new BasicDensityBasedFileResourceItem(resourceType, name, configuration, visibility, relativePath, density);
    }

    protected int getEncodedDensityForSerialization() {
        return 0;
    }
}

