/*
 * Decompiled with CFR 0.152.
 */
package com.android.resources.base;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.util.PathString;
import com.android.resources.ResourceType;
import com.android.resources.ResourceVisibility;
import com.android.resources.base.BasicArrayResourceItem;
import com.android.resources.base.BasicAttrResourceItem;
import com.android.resources.base.BasicPluralsResourceItem;
import com.android.resources.base.BasicResourceItemBase;
import com.android.resources.base.BasicStyleResourceItem;
import com.android.resources.base.BasicStyleableResourceItem;
import com.android.resources.base.BasicValueResourceItem;
import com.android.resources.base.RepositoryConfiguration;
import com.android.resources.base.ResourceSourceFile;
import com.android.utils.Base128InputStream;
import com.android.utils.Base128OutputStream;
import com.android.utils.HashCodes;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BasicValueResourceItemBase
extends BasicResourceItemBase {
    @NotNull
    private final ResourceSourceFile mySourceFile;
    @NotNull
    private ResourceNamespace.Resolver myNamespaceResolver = ResourceNamespace.Resolver.EMPTY_RESOLVER;

    public BasicValueResourceItemBase(@NotNull ResourceType type2, @NotNull String name, @NotNull ResourceSourceFile sourceFile, @NotNull ResourceVisibility visibility) {
        super(type2, name, visibility);
        this.mySourceFile = sourceFile;
    }

    @Nullable
    public String getValue() {
        return null;
    }

    public final boolean isFileBased() {
        return false;
    }

    @Override
    @NotNull
    public final RepositoryConfiguration getRepositoryConfiguration() {
        return this.mySourceFile.getConfiguration();
    }

    @NotNull
    public final ResourceNamespace.Resolver getNamespaceResolver() {
        return this.myNamespaceResolver;
    }

    public final void setNamespaceResolver(@NotNull ResourceNamespace.Resolver resolver) {
        this.myNamespaceResolver = resolver;
    }

    @Nullable
    public final PathString getSource() {
        return this.getOriginalSource();
    }

    @Nullable
    public final PathString getOriginalSource() {
        String sourcePath = this.mySourceFile.getRelativePath();
        return sourcePath == null ? null : this.getRepository().getOriginalSourceFile(sourcePath, false);
    }

    @NotNull
    public final ResourceSourceFile getSourceFile() {
        return this.mySourceFile;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        BasicValueResourceItemBase other = (BasicValueResourceItemBase)obj;
        return Objects.equals(this.mySourceFile, other.mySourceFile);
    }

    @Override
    public int hashCode() {
        return HashCodes.mix((int)super.hashCode(), (int)Objects.hashCode(this.mySourceFile));
    }

    @Override
    public void serialize(@NotNull Base128OutputStream stream, @NotNull Object2IntMap<String> configIndexes, @NotNull Object2IntMap<ResourceSourceFile> sourceFileIndexes, @NotNull Object2IntMap<ResourceNamespace.Resolver> namespaceResolverIndexes) throws IOException {
        super.serialize(stream, configIndexes, sourceFileIndexes, namespaceResolverIndexes);
        int index2 = sourceFileIndexes.getInt((Object)this.mySourceFile);
        assert (index2 >= 0);
        stream.writeInt(index2);
        index2 = namespaceResolverIndexes.getInt((Object)this.myNamespaceResolver);
        assert (index2 >= 0);
        stream.writeInt(index2);
    }

    @NotNull
    static BasicValueResourceItemBase deserialize(@NotNull Base128InputStream stream, @NotNull ResourceType resourceType, @NotNull String name, @NotNull ResourceVisibility visibility, @NotNull List<RepositoryConfiguration> configurations, @NotNull List<ResourceSourceFile> sourceFiles, @NotNull List<ResourceNamespace.Resolver> namespaceResolvers) throws IOException {
        ResourceSourceFile sourceFile = sourceFiles.get(stream.readInt());
        ResourceNamespace.Resolver resolver = namespaceResolvers.get(stream.readInt());
        switch (resourceType) {
            case ARRAY: {
                return BasicArrayResourceItem.deserialize(stream, name, visibility, sourceFile, resolver);
            }
            case ATTR: {
                return BasicAttrResourceItem.deserialize(stream, name, visibility, sourceFile, resolver);
            }
            case PLURALS: {
                return BasicPluralsResourceItem.deserialize(stream, name, visibility, sourceFile, resolver);
            }
            case STYLE: {
                return BasicStyleResourceItem.deserialize(stream, name, visibility, sourceFile, resolver, namespaceResolvers);
            }
            case STYLEABLE: {
                return BasicStyleableResourceItem.deserialize(stream, name, visibility, sourceFile, resolver, configurations, sourceFiles, namespaceResolvers);
            }
        }
        return BasicValueResourceItem.deserialize(stream, resourceType, name, visibility, sourceFile, resolver);
    }
}

