/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer;

import com.android.ddmlib.InstallReceiver;
import com.android.tools.deploy.proto.Deploy;
import com.android.tools.deployer.AdbClient;
import com.android.tools.deployer.ApkDiffer;
import com.android.tools.deployer.ApkParser;
import com.android.tools.deployer.ApplicationDumper;
import com.android.tools.deployer.DeployMetric;
import com.android.tools.deployer.Deployer;
import com.android.tools.deployer.DeployerException;
import com.android.tools.deployer.InstallOptions;
import com.android.tools.deployer.InstallStatus;
import com.android.tools.deployer.Installer;
import com.android.tools.deployer.PatchSet;
import com.android.tools.deployer.PatchSetGenerator;
import com.android.tools.deployer.Timeouts;
import com.android.tools.deployer.UIService;
import com.android.tools.deployer.model.Apk;
import com.android.tools.deployer.model.FileDiff;
import com.android.utils.ILogger;
import java.io.IOException;
import java.util.Collection;
import java.util.List;

public class ApkInstaller {
    private final AdbClient adb;
    private final UIService service;
    private final Installer installer;
    private final ILogger logger;

    public ApkInstaller(AdbClient adb, UIService service, Installer installer, ILogger logger) {
        this.adb = adb;
        this.service = service;
        this.installer = installer;
        this.logger = logger;
    }

    public boolean install(String packageName, List<String> apks, InstallOptions options, Deployer.InstallMode installMode, Collection<DeployMetric> metrics) throws DeployerException {
        DeltaInstallResult deltaInstallResult = new DeltaInstallResult(DeltaInstallStatus.UNKNOWN, "");
        boolean allowReinstall = true;
        long deltaInstallStart = System.nanoTime();
        try {
            deltaInstallResult = this.deltaInstall(apks, options, allowReinstall, installMode, packageName);
        }
        catch (DeployerException e) {
            this.logger.info("Unable to delta install: '%s'", new Object[]{e.getDetails()});
        }
        AdbClient.InstallResult result = new AdbClient.InstallResult(InstallStatus.OK, "");
        block2 : switch (deltaInstallResult.status) {
            case SUCCESS: {
                DeployMetric metric = new DeployMetric("DELTAINSTALL", deltaInstallStart);
                InstallReceiver installReceiver = new InstallReceiver();
                String[] lines = deltaInstallResult.packageManagerOutput.split("\\n");
                installReceiver.processNewLines(lines);
                installReceiver.done();
                if (installReceiver.isSuccessfullyCompleted()) {
                    metric.finish(DeltaInstallStatus.SUCCESS.name(), metrics);
                } else {
                    result = ApkInstaller.toInstallerResult(installReceiver);
                    metric.finish(DeltaInstallStatus.ERROR.name() + "." + result.status.name(), metrics);
                }
                switch (result.status) {
                    case NO_CERTIFICATE: 
                    case INSTALL_PARSE_FAILED_NO_CERTIFICATES: {
                        result = this.adb.install(apks, options.getFlags(), allowReinstall);
                        long installStartTime = System.nanoTime();
                        DeployMetric installResult = new DeployMetric("INSTALL", installStartTime);
                        installResult.finish(result.status.name(), metrics);
                        break block2;
                    }
                }
                break;
            }
            case ERROR: 
            case UNKNOWN: 
            case DISABLED: 
            case CANNOT_GENERATE_DELTA: 
            case API_NOT_SUPPORTED: 
            case DUMP_FAILED: 
            case DUMP_UNKNOWN_PACKAGE: 
            case PATCH_SIZE_EXCEEDED: 
            case STREAM_APK_FAILED: 
            case STREAM_APK_NOT_SUPPORTED: {
                this.logger.info(deltaInstallResult.status.name(), new Object[0]);
                DeployMetric deltaNotPatchableMetric = new DeployMetric("DELTAINSTALL", deltaInstallStart);
                deltaNotPatchableMetric.finish(deltaInstallResult.status.name(), metrics);
                long installStartedNs = System.nanoTime();
                result = this.adb.install(apks, options.getFlags(), allowReinstall);
                DeployMetric installResult = new DeployMetric("INSTALL", installStartedNs);
                installResult.finish(result.status.name(), metrics);
                break;
            }
            case NO_CHANGES: {
                result = new AdbClient.InstallResult(InstallStatus.SKIPPED_INSTALL, "APKs have not been modified");
                DeployMetric installMetric = new DeployMetric("INSTALL");
                installMetric.finish(result.status.name(), metrics);
                try {
                    this.adb.shell(new String[]{"am", "force-stop", packageName}, Timeouts.SHELL_AM_STOP);
                    break;
                }
                catch (IOException e) {
                    throw DeployerException.installFailed(InstallStatus.SKIPPED_INSTALL, "Failure to kill " + packageName);
                }
            }
        }
        if (result.metrics != null) {
            metrics.add(new DeployMetric("DDMLIB_UPLOAD", result.metrics.getUploadStartNs(), result.metrics.getUploadFinishNs()));
            metrics.add(new DeployMetric("DDMLIB_INSTALL", result.metrics.getInstallStartNs(), result.metrics.getInstallFinishNs()));
        }
        String message2 = ApkInstaller.message(result);
        switch (result.status) {
            case INSTALL_FAILED_UPDATE_INCOMPATIBLE: 
            case INCONSISTENT_CERTIFICATES: 
            case INSTALL_FAILED_PERMISSION_MODEL_DOWNGRADE: 
            case INSTALL_FAILED_VERSION_DOWNGRADE: 
            case INSTALL_FAILED_DEXOPT: {
                StringBuilder sb = new StringBuilder();
                sb.append(message2).append("\n");
                sb.append("In order to proceed, you will have to uninstall the existing application");
                sb.append("\n\nWARNING: Uninstalling will remove the application data!\n\n");
                sb.append("Do you want to uninstall the existing application?");
                if (!this.service.prompt(sb.toString())) break;
                this.adb.uninstall(packageName);
                result = this.adb.install(apks, options.getFlags(), allowReinstall);
                message2 = ApkInstaller.message(result);
                break;
            }
        }
        boolean installed = true;
        if (result.status == InstallStatus.SKIPPED_INSTALL) {
            installed = false;
        } else if (result.status != InstallStatus.OK) {
            StringBuilder messageBuilder = new StringBuilder("\nList of apks:\n");
            for (int i = 0; i < apks.size(); ++i) {
                String apkPath = apks.get(i);
                String line = String.format("[%d] '%s'\n", i, apkPath);
                messageBuilder.append(line);
            }
            messageBuilder.append(message2);
            throw DeployerException.installFailed(result.status, messageBuilder.toString());
        }
        return installed;
    }

    DeltaInstallResult deltaInstall(List<String> apks, InstallOptions options, boolean allowReinstall, Deployer.InstallMode installMode, String packageName) throws DeployerException {
        Deploy.DeltaInstallResponse res;
        ApplicationDumper.Dump dump2;
        if (installMode == Deployer.InstallMode.FULL) {
            return new DeltaInstallResult(DeltaInstallStatus.DISABLED);
        }
        if (!this.adb.getVersion().isGreaterOrEqualThan(24)) {
            return new DeltaInstallResult(DeltaInstallStatus.API_NOT_SUPPORTED);
        }
        List<Apk> localApks = new ApkParser().parsePaths(apks);
        try {
            dump2 = new ApplicationDumper(this.installer).dump(localApks);
        }
        catch (DeployerException e) {
            if (e.getError() == DeployerException.Error.DUMP_UNKNOWN_PACKAGE) {
                return new DeltaInstallResult(DeltaInstallStatus.DUMP_UNKNOWN_PACKAGE);
            }
            return new DeltaInstallResult(DeltaInstallStatus.DUMP_FAILED);
        }
        Deploy.InstallInfo.Builder builder = Deploy.InstallInfo.newBuilder();
        builder.addAllOptions(options.getFlags());
        if (allowReinstall) {
            builder.addOptions("-r");
        }
        PatchSet patchSet = new PatchSetGenerator(installMode == Deployer.InstallMode.DELTA_NO_SKIP ? PatchSetGenerator.WhenNoChanges.GENERATE_PATCH_ANYWAY : PatchSetGenerator.WhenNoChanges.GENERATE_EMPTY_PATCH, this.logger).generateFromApks(localApks, dump2.apks);
        switch (patchSet.getStatus()) {
            case NoChanges: {
                return new DeltaInstallResult(DeltaInstallStatus.NO_CHANGES);
            }
            case Invalid: 
            case SizeThresholdExceeded: {
                return new DeltaInstallResult(DeltaInstallStatus.CANNOT_GENERATE_DELTA);
            }
            case Ok: {
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled PatchSet status");
            }
        }
        List<Deploy.PatchInstruction> patches = patchSet.getPatches();
        for (Deploy.PatchInstruction patch : patches) {
            this.logger.info("Patch size %d", new Object[]{patch.getSerializedSize()});
        }
        boolean inherit = ApkInstaller.canInherit(apks.size(), new ApkDiffer().diff(dump2.apks, localApks), installMode);
        builder.setInherit(inherit);
        builder.addAllPatchInstructions(patches);
        builder.setPackageName(packageName);
        Deploy.InstallInfo info = builder.build();
        if (info.getSerializedSize() > 0x2800000) {
            return new DeltaInstallResult(DeltaInstallStatus.PATCH_SIZE_EXCEEDED);
        }
        try {
            res = this.installer.deltaInstall(info);
        }
        catch (IOException e) {
            return new DeltaInstallResult(DeltaInstallStatus.UNKNOWN);
        }
        DeltaInstallStatus status = ApkInstaller.convertStatus(res.getStatus());
        return new DeltaInstallResult(status, res.getInstallOutput());
    }

    private static DeltaInstallStatus convertStatus(Deploy.DeltaStatus status) {
        switch (status) {
            case STREAM_APK_FAILED: {
                return DeltaInstallStatus.STREAM_APK_FAILED;
            }
            case OK: {
                return DeltaInstallStatus.SUCCESS;
            }
            case UNKNOWN: {
                return DeltaInstallStatus.UNKNOWN;
            }
            case UNRECOGNIZED: 
            case ERROR: {
                return DeltaInstallStatus.ERROR;
            }
            case STREAM_APK_NOT_SUPPORTED: {
                return DeltaInstallStatus.STREAM_APK_NOT_SUPPORTED;
            }
        }
        return DeltaInstallStatus.SUCCESS;
    }

    public static boolean canInherit(int apkCount, List<FileDiff> diff, Deployer.InstallMode mode) {
        boolean inherit;
        boolean bl = inherit = apkCount > 1;
        if (inherit) {
            for (FileDiff fileDiff : diff) {
                if (fileDiff.oldFile == null || !fileDiff.oldFile.getName().equals("AndroidManifest.xml")) continue;
                inherit = false;
            }
        }
        if (mode == Deployer.InstallMode.DELTA_NO_SKIP) {
            inherit = inherit && !diff.isEmpty();
        }
        return inherit;
    }

    public static AdbClient.InstallResult toInstallerResult(InstallReceiver r) {
        return ApkInstaller.toInstallerResult(r.getErrorCode(), r.getErrorMessage());
    }

    public static AdbClient.InstallResult toInstallerResult(String errorCode, String reason) {
        try {
            return new AdbClient.InstallResult(InstallStatus.valueOf(errorCode), reason);
        }
        catch (IllegalArgumentException i) {
            try {
                int numericValue = Integer.parseInt(errorCode);
                return new AdbClient.InstallResult(InstallStatus.numericErrorCodeToStatus(numericValue), reason);
            }
            catch (NumberFormatException n) {
                return new AdbClient.InstallResult(InstallStatus.UNKNOWN_ERROR, reason);
            }
        }
        catch (Exception e) {
            return new AdbClient.InstallResult(InstallStatus.UNKNOWN_ERROR, reason);
        }
    }

    public static String message(AdbClient.InstallResult result) {
        switch (result.status) {
            case INSTALL_FAILED_VERSION_DOWNGRADE: {
                return "The device already has a newer version of this application.";
            }
            case DEVICE_NOT_RESPONDING: {
                return "Device not responding.";
            }
            case INSTALL_FAILED_UPDATE_INCOMPATIBLE: 
            case INCONSISTENT_CERTIFICATES: {
                return "The device already has an application with the same package but a different signature.";
            }
            case INSTALL_FAILED_DEXOPT: {
                return "The device might have stale dexed jars that don't match the current version (dexopt error).";
            }
            case NO_CERTIFICATE: {
                return "The APK was either not signed, or signed incorrectly.";
            }
            case INSTALL_FAILED_OLDER_SDK: {
                return "The application's minSdkVersion is newer than the device API level.";
            }
            case DEVICE_NOT_FOUND: {
                return "The device has been disconnected.";
            }
            case SHELL_UNRESPONSIVE: {
                return "The device timed out while trying to install the application.";
            }
            case INSTALL_FAILED_INSUFFICIENT_STORAGE: {
                return "The device needs more free storage to install the application (extra space is needed in addition to APK size).";
            }
            case MULTI_APKS_NO_SUPPORTED_BELOW21: {
                return "Multi-APK app installation is not supported on devices with API level < 21.";
            }
            case INSTALL_PARSE_FAILED_NO_CERTIFICATES: {
                return "APK signature verification failed.";
            }
            case INSTALL_FAILED_USER_RESTRICTED: {
                return "Installation via USB is disabled.";
            }
            case INSTALL_FAILED_INVALID_APK: {
                return "The APKs are invalid.";
            }
        }
        return "Installation failed due to: '" + (result.reason == null ? result.status.toString() : result.reason) + "'";
    }

    private static class DeltaInstallResult {
        final DeltaInstallStatus status;
        final String packageManagerOutput;

        private DeltaInstallResult(DeltaInstallStatus status, String output) {
            this.status = status;
            this.packageManagerOutput = output;
        }

        private DeltaInstallResult(DeltaInstallStatus status) {
            this(status, "");
        }
    }

    private static enum DeltaInstallStatus {
        SUCCESS,
        UNKNOWN,
        ERROR,
        DISABLED,
        CANNOT_GENERATE_DELTA,
        API_NOT_SUPPORTED,
        DUMP_FAILED,
        PATCH_SIZE_EXCEEDED,
        NO_CHANGES,
        DUMP_UNKNOWN_PACKAGE,
        STREAM_APK_FAILED,
        STREAM_APK_NOT_SUPPORTED;

    }
}

