/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer;

import com.android.tools.deployer.DeployerException;
import com.android.tools.deployer.model.Apk;
import com.android.tools.deployer.model.FileDiff;
import com.android.tools.manifest.parser.components.ManifestAppComponentInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

class SwapVerifier {
    SwapVerifier() {
    }

    public List<FileDiff> verify(List<Apk> apks, List<FileDiff> diffs, boolean allChanges) throws DeployerException {
        for (Apk apk : apks) {
            List<String> isolatedProcessServicesNames = apk.services.stream().filter(s -> s.isolatedProcess).map(ManifestAppComponentInfo::getQualifiedName).collect(Collectors.toList());
            if (isolatedProcessServicesNames.isEmpty()) continue;
            throw DeployerException.isolatedServiceNotSupported(isolatedProcessServicesNames);
        }
        return this.verify(diffs, allChanges);
    }

    public List<FileDiff> verify(List<FileDiff> diffs, boolean allChanges) throws DeployerException {
        ArrayList<FileDiff> dexes = new ArrayList<FileDiff>();
        for (FileDiff diff : diffs) {
            if (!diff.status.equals((Object)FileDiff.Status.MODIFIED)) continue;
            String name = diff.oldFile.getName();
            if (name.endsWith(".so")) {
                throw DeployerException.changedSharedObject(name);
            }
            if (name.equals("AndroidManifest.xml")) {
                throw DeployerException.changedManifest(name);
            }
            if (name.startsWith("META-INF/")) continue;
            if (name.endsWith(".dex")) {
                dexes.add(diff);
                continue;
            }
            if (allChanges) continue;
            if (name.endsWith("crashlytics-build.properties")) {
                throw DeployerException.changedCrashlyticsBuildId(name);
            }
            throw DeployerException.changedResources(name);
        }
        return dexes;
    }
}

