/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer.model.component;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.tools.deployer.DeployerException;
import com.android.tools.deployer.model.component.AppComponent;
import com.android.tools.deployer.model.component.WearComponent;
import com.android.tools.manifest.parser.components.ManifestAppComponentInfo;
import com.android.utils.ILogger;
import java.util.Locale;

public class Complication
extends WearComponent {
    public Complication(ManifestAppComponentInfo info, String appId, IDevice device2, ILogger logger) {
        super(device2, appId, info, logger);
    }

    @Override
    public void activate(String extraFlags, AppComponent.Mode activationMode, IShellOutputReceiver receiver) throws DeployerException {
        ComplicationParams params = ComplicationParams.parse(extraFlags);
        this.logger.info("Activating WatchFace '%s' %s", new Object[]{this.info.getQualifiedName(), activationMode.equals((Object)AppComponent.Mode.DEBUG) ? "for debug" : ""});
        if (activationMode.equals((Object)AppComponent.Mode.DEBUG)) {
            this.setUpAmDebugApp();
            this.setUpDebugSurfaceDebugApp();
        }
        String command = this.getAddComplicationCommand(params);
        this.runStartCommand(command, receiver, this.logger);
    }

    private String getAddComplicationCommand(ComplicationParams param) {
        return String.format(Locale.US, "am broadcast -a com.google.android.wearable.app.DEBUG_SURFACE --es operation set-complication --ecn component '%s' --ecn watchface '%s' --ei slot %d --ei type %d", this.getFQEscapedName(), AppComponent.getFQEscapedName(param.watchFaceAppId, param.watchFaceName), param.slot, param.type.getTypeValue());
    }

    private static class ComplicationParams {
        static String INCORRECT_FORMAT_ERROR = "Incorrect extra flags for Complication `%s`. Expected format `WATCH_FACE_APP_ID WATCH_FACE_FQ_NAME SLOT_NUM COMPLICATION_TYPE`";
        final String watchFaceAppId;
        final String watchFaceName;
        final int slot;
        final ComplicationType type;

        private ComplicationParams(String watchFaceAppId, String watchFaceName, int slot, ComplicationType type2) {
            this.watchFaceAppId = watchFaceAppId;
            this.watchFaceName = watchFaceName;
            this.slot = slot;
            this.type = type2;
        }

        static ComplicationParams parse(String rawParams) throws DeployerException {
            try {
                String[] params = rawParams.split("\\s+");
                String watchfaceAppId = params[0];
                String watchface = params[1];
                int slot = Integer.parseInt(params[2]);
                ComplicationType type2 = ComplicationType.valueOf(params[3].toUpperCase(Locale.US));
                return new ComplicationParams(watchfaceAppId, watchface, slot, type2);
            }
            catch (Exception e) {
                throw DeployerException.componentActivationException(String.format(INCORRECT_FORMAT_ERROR, rawParams) + ". " + e.getMessage());
            }
        }
    }

    public static class ShellCommand {
        public static String REMOVE_ALL_INSTANCES_FROM_CURRENT_WF = "am broadcast -a com.google.android.wearable.app.DEBUG_SURFACE --es operation unset-complication --ecn component ";
        static final String ADD_COMPLICATION_TO_WATCH_FACE = "am broadcast -a com.google.android.wearable.app.DEBUG_SURFACE --es operation set-complication --ecn component '%s' --ecn watchface '%s' --ei slot %d --ei type %d";
    }

    public static enum ComplicationType {
        SHORT_TEXT(3),
        LONG_TEXT(4),
        RANGED_VALUE(5),
        ICON(6),
        SMALL_IMAGE(7),
        LARGE_IMAGE(8),
        NO_DATA(10);

        private final int typeValue;

        private ComplicationType(int typeValue) {
            this.typeValue = typeValue;
        }

        int getTypeValue() {
            return this.typeValue;
        }
    }
}

