/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.AnnotationDetectorKt;
import com.android.tools.lint.checks.PermissionDetector;
import com.android.tools.lint.checks.PermissionRequirement;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.AnnotationInfo;
import com.android.tools.lint.detector.api.AnnotationUsageInfo;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Constraints;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.PartialResult;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import com.android.utils.XmlUtils;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 -2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001-B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J(\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\u001bH\u0016J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00060\u000fH\u0016J\u0018\u0010\u001d\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J(\u0010 \u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\u0018\u0010'\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020(2\u0006\u0010!\u001a\u00020)H\u0016J \u0010*\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010+\u001a\u00020,H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/android/tools/lint/checks/AlarmDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "()V", "exactAlarmPermissionMethod", "", "numScheduleCalls", "", "shortAlarmMethod", "afterCheckRootProject", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "applicableAnnotations", "", "checkPartialResults", "partialResults", "Lcom/android/tools/lint/detector/api/PartialResult;", "ensureAtLeast", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "parameter", "min", "", "getApplicableElements", "", "getApplicableMethodNames", "getLongValue", "argument", "Lorg/jetbrains/uast/UExpression;", "visitAnnotationUsage", "element", "Lorg/jetbrains/uast/UElement;", "annotationInfo", "Lcom/android/tools/lint/detector/api/AnnotationInfo;", "usageInfo", "Lcom/android/tools/lint/detector/api/AnnotationUsageInfo;", "visitElement", "Lcom/android/tools/lint/detector/api/XmlContext;", "Lorg/w3c/dom/Element;", "visitMethodCall", "method", "Lcom/intellij/psi/PsiMethod;", "Issues", "android.sdktools.lint-checks"})
public final class AlarmDetector
extends Detector
implements SourceCodeScanner,
XmlScanner {
    @NotNull
    public static final Issues Issues = new Issues(null);
    @NotNull
    private final String exactAlarmPermissionMethod;
    @NotNull
    private final String shortAlarmMethod;
    private int numScheduleCalls;
    @NotNull
    private static final Implementation IMPLEMENTATION;
    @JvmField
    @NotNull
    public static final Issue SHORT_ALARM;
    @JvmField
    @NotNull
    public static final Issue EXACT_ALARM;
    @JvmField
    @NotNull
    public static final Issue SCHEDULE_EXACT_ALARM;
    @NotNull
    public static final String USE_EXACT_ALARM_PERMISSION = "android.permission.USE_EXACT_ALARM";
    @NotNull
    public static final String SCHEDULE_EXACT_ALARM_PERMISSION = "android.permission.SCHEDULE_EXACT_ALARM";
    @NotNull
    public static final String CHECKS_EXACT_ALARM_PERMISSION = "ChecksExactAlarmPermission";
    public static final int SCHEDULE_MIN_TARGET = 31;

    public AlarmDetector() {
        this.exactAlarmPermissionMethod = "canScheduleExactAlarms";
        this.shortAlarmMethod = "setRepeating";
    }

    @Override
    @NotNull
    public List<String> getApplicableMethodNames() {
        Object[] objectArray = new String[]{this.shortAlarmMethod, this.exactAlarmPermissionMethod};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public List<String> applicableAnnotations() {
        Object[] objectArray = new String[]{AnnotationDetectorKt.PERMISSION_ANNOTATION.oldName(), AnnotationDetectorKt.PERMISSION_ANNOTATION.newName()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    public void visitAnnotationUsage(@NotNull JavaContext context2, @NotNull UElement element, @NotNull AnnotationInfo annotationInfo, @NotNull AnnotationUsageInfo usageInfo) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)annotationInfo, (String)"annotationInfo");
        Intrinsics.checkNotNullParameter((Object)usageInfo, (String)"usageInfo");
        PermissionRequirement permissionRequirement = PermissionRequirement.create(annotationInfo.getAnnotation());
        Intrinsics.checkNotNullExpressionValue((Object)permissionRequirement, (String)"create(annotationInfo.annotation)");
        PermissionRequirement requirement = permissionRequirement;
        if (requirement.contains(SCHEDULE_EXACT_ALARM_PERMISSION) && !PermissionDetector.Companion.handlesException(element, null, false, "java.lang.SecurityException") && !context2.getDriver().isSuppressed(context2, SCHEDULE_EXACT_ALARM, element)) {
            int n = this.numScheduleCalls;
            this.numScheduleCalls = n + 1;
            context2.getPartialResults(SCHEDULE_EXACT_ALARM).map().put(String.valueOf(n), context2.getLocation(element));
        }
    }

    @Override
    public void visitMethodCall(@NotNull JavaContext context2, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        JavaEvaluator evaluator;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if ((context2.isEnabled(SHORT_ALARM) || context2.isEnabled(SCHEDULE_EXACT_ALARM)) && (evaluator = context2.getEvaluator()).isMemberInClass((PsiMember)method, "android.app.AlarmManager")) {
            if (context2.isEnabled(SHORT_ALARM) && evaluator.getParameterCount(method) == 4) {
                this.ensureAtLeast(context2, node, 1, 5000L);
                this.ensureAtLeast(context2, node, 2, 60000L);
            }
            if (context2.isEnabled(SCHEDULE_EXACT_ALARM) && Intrinsics.areEqual((Object)method.getName(), (Object)this.exactAlarmPermissionMethod)) {
                context2.getPartialResults(SCHEDULE_EXACT_ALARM).map().put(CHECKS_EXACT_ALARM_PERMISSION, true);
            }
        }
    }

    private final void ensureAtLeast(JavaContext context2, UCallExpression node, int parameter, long min) {
        UExpression argument = (UExpression)node.getValueArguments().get(parameter);
        long value = this.getLongValue(context2, argument);
        if (value < min) {
            String message2 = "Value will be forced up to " + min + " as of Android 5.1; don't rely on this to be exact";
            JavaContext.report$default(context2, SHORT_ALARM, (UElement)argument, context2.getLocation((UElement)argument), message2, null, 16, null);
        }
    }

    private final long getLongValue(JavaContext context2, UExpression argument) {
        Object value = ConstantEvaluator.evaluate(context2, (UElement)argument);
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        return Long.MAX_VALUE;
    }

    @Override
    @NotNull
    public Collection<String> getApplicableElements() {
        return CollectionsKt.listOf((Object)"uses-permission");
    }

    @Override
    public void visitElement(@NotNull XmlContext context2, @NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (context2.isEnabled(EXACT_ALARM)) {
            boolean bl = Intrinsics.areEqual((Object)element.getTagName(), (Object)"uses-permission");
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            Attr nameAttr = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name");
            if (nameAttr != null && Intrinsics.areEqual((Object)nameAttr.getValue(), (Object)USE_EXACT_ALARM_PERMISSION)) {
                context2.report(new Incident(EXACT_ALARM, "`USE_EXACT_ALARM` can only be used when targeting API level 33 or higher", context2.getValueLocation(nameAttr)), Constraints.targetSdkLessThan(33));
            }
        }
    }

    @Override
    public void afterCheckRootProject(@NotNull Context context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (context2.isGlobalAnalysis()) {
            this.checkPartialResults(context2, context2.getPartialResults(SCHEDULE_EXACT_ALARM));
        }
    }

    @Override
    public void checkPartialResults(@NotNull Context context2, @NotNull PartialResult partialResults) {
        boolean bl;
        Document mergedManifest;
        block14: {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)partialResults, (String)"partialResults");
            if (!Intrinsics.areEqual((Object)partialResults.getIssue(), (Object)SCHEDULE_EXACT_ALARM)) {
                return;
            }
            if (!context2.isEnabled(SCHEDULE_EXACT_ALARM)) {
                return;
            }
            if (context2.getMainProject().isLibrary()) {
                return;
            }
            if (context2.getMainProject().getTargetSdk() < 31) {
                return;
            }
            Document document = context2.getMainProject().getMergedManifest();
            if (document == null) {
                return;
            }
            mergedManifest = document;
            Iterable $this$any$iv = partialResults.maps();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    LintMap it = (LintMap)element$iv;
                    boolean bl2 = false;
                    if (!it.containsKey(CHECKS_EXACT_ALARM_PERMISSION)) continue;
                    bl = true;
                    break block14;
                }
                bl = false;
            }
        }
        if (bl) {
            return;
        }
        boolean usesUsePermission = false;
        boolean usesSchedulePermission = false;
        for (Element element : XmlUtils.getSubTags((Node)mergedManifest.getDocumentElement())) {
            Attr nameAttr;
            String nodeName = element.getNodeName();
            if (!Intrinsics.areEqual((Object)"uses-permission", (Object)nodeName) || element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name") == null) continue;
            String string = nameAttr.getValue();
            if (Intrinsics.areEqual((Object)string, (Object)USE_EXACT_ALARM_PERMISSION)) {
                usesUsePermission = true;
                continue;
            }
            if (!Intrinsics.areEqual((Object)string, (Object)SCHEDULE_EXACT_ALARM_PERMISSION)) continue;
            usesSchedulePermission = true;
        }
        if (!usesSchedulePermission || usesUsePermission) {
            return;
        }
        for (LintMap perModuleLintMap : partialResults.maps()) {
            Iterable $this$forEach$iv = perModuleLintMap;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Location location2;
                String it = (String)element$iv;
                boolean bl3 = false;
                Intrinsics.checkNotNull((Object)perModuleLintMap.getLocation(it));
                context2.report(new Incident(SCHEDULE_EXACT_ALARM, "When scheduling exact alarms, apps should explicitly call `AlarmManager#canScheduleExactAlarms` or handle `SecurityException`s", location2));
            }
        }
    }

    static {
        Object object = new EnumSet[]{Scope.JAVA_FILE_SCOPE, Scope.MANIFEST_SCOPE};
        IMPLEMENTATION = new Implementation((Class<? extends Detector>)AlarmDetector.class, (EnumSet<Scope>)EnumSet.of((Enum)Scope.JAVA_FILE, (Enum)Scope.MANIFEST), (EnumSet<Scope>)object);
        object = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.WARNING;
        Implementation implementation = IMPLEMENTATION;
        SHORT_ALARM = Issue.Companion.create$default((Issue.Companion)object, "ShortAlarm", "Short or Frequent Alarm", "\n            Frequent alarms are bad for battery life. As of API 22, the `AlarmManager` will override \\\n            near-future and high-frequency alarm requests, delaying the alarm at least 5 seconds into the \\\n            future and ensuring that the repeat interval is at least 60 seconds.\n\n            If you really need to do work sooner than 5 seconds, post a delayed message or runnable to a \\\n            Handler.", implementation, null, category, 6, severity, false, true, null, null, 3344, null);
        object = Issue.Companion;
        category = Category.CORRECTNESS;
        severity = Severity.ERROR;
        implementation = IMPLEMENTATION;
        EXACT_ALARM = Issue.Companion.create$default((Issue.Companion)object, "ExactAlarm", "Invalid Usage of Exact Alarms", "\n                The `USE_EXACT_ALARM` permission is only available when targeting API level 33 \\\n                and above. Also, note that this permission is only permitted for apps whose core \\\n                functionality requires precisely-timed actions for user facing features.\n            ", implementation, "https://developer.android.com/training/scheduling/alarms", category, 6, severity, false, true, null, null, 3328, null);
        object = Issue.Companion;
        category = Category.CORRECTNESS;
        severity = Severity.ERROR;
        implementation = IMPLEMENTATION;
        SCHEDULE_EXACT_ALARM = Issue.Companion.create$default((Issue.Companion)object, "ScheduleExactAlarm", "Scheduling Exact Alarms Without Required Permission", "\n                Applications looking to schedule exact alarms should ensure that the `SCHEDULE_EXACT_ALARM` \\\n                permission is granted by calling the `AlarmManager#canScheduleExactAlarms` API before attempting \\\n                to set an exact alarm. If the permission is not granted to your application, please consider \\\n                requesting it from the user by starting the `ACTION_REQUEST_SCHEDULE_EXACT_ALARM` intent or gracefully \\\n                falling back to another option.\n            ", implementation, "https://developer.android.com/training/scheduling/alarms#exact", category, 6, severity, false, true, null, null, 3328, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/lint/checks/AlarmDetector$Issues;", "", "()V", "CHECKS_EXACT_ALARM_PERMISSION", "", "EXACT_ALARM", "Lcom/android/tools/lint/detector/api/Issue;", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "SCHEDULE_EXACT_ALARM", "SCHEDULE_EXACT_ALARM_PERMISSION", "SCHEDULE_MIN_TARGET", "", "SHORT_ALARM", "USE_EXACT_ALARM_PERMISSION", "android.sdktools.lint-checks"})
    public static final class Issues {
        private Issues() {
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

