/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.BooleanOption;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.utils.StringHelper;
import com.intellij.lang.jvm.JvmParameter;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KtAnalysisSession;
import org.jetbrains.kotlin.analysis.api.lifetime.KtDefaultLifetimeTokenProvider;
import org.jetbrains.kotlin.analysis.api.lifetime.KtLifetimeTokenFactory;
import org.jetbrains.kotlin.analysis.api.session.KtAnalysisSessionProvider;
import org.jetbrains.kotlin.analysis.api.types.KtDynamicType;
import org.jetbrains.kotlin.analysis.api.types.KtFlexibleType;
import org.jetbrains.kotlin.analysis.api.types.KtType;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UAnonymousClass;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UTypeReferenceExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.kotlin.KotlinUastResolveProviderService;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \f2\u00020\u00012\u00020\u0002:\u0003\f\r\u000eB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n0\tH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/lint/checks/InteroperabilityDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "getApplicableUastTypes", "", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UElement;", "Issues", "JavaVisitor", "KotlinVisitor", "android.sdktools.lint-checks"})
public final class InteroperabilityDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Issues Issues = new Issues(null);
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(InteroperabilityDetector.class, Scope.JAVA_FILE_SCOPE);
    private static final boolean IGNORE_DEPRECATED = Intrinsics.areEqual((Object)"true", (Object)System.getenv("ANDROID_LINT_NULLNESS_IGNORE_DEPRECATED")) || Intrinsics.areEqual((Object)"true", (Object)System.getProperty("lint.nullness.ignore-deprecated"));
    @JvmField
    @NotNull
    public static final Issue NO_HARD_KOTLIN_KEYWORDS;
    @JvmField
    @NotNull
    public static final Issue LAMBDA_LAST;
    @NotNull
    private static final BooleanOption CHECK_DEPRECATED;
    @JvmField
    @NotNull
    public static final Issue PLATFORM_NULLNESS;
    @JvmField
    @NotNull
    public static final Issue KOTLIN_PROPERTY;

    @Override
    @Nullable
    public UElementHandler createUastHandler(@NotNull JavaContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        UFile uFile = context2.getUastFile();
        if (Lint.isKotlin((PsiElement)(uFile != null ? uFile.getPsi() : null))) {
            boolean checkNullness = context2.isEnabled(PLATFORM_NULLNESS);
            if (checkNullness) {
                return new KotlinVisitor(context2);
            }
            return null;
        }
        return new JavaVisitor(context2);
    }

    @Override
    @NotNull
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        Object[] objectArray = new Class[]{UMethod.class, UField.class};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.INTEROPERABILITY_KOTLIN;
        Severity severity = Severity.WARNING;
        Implementation implementation = IMPLEMENTATION;
        NO_HARD_KOTLIN_KEYWORDS = Issue.Companion.create$default(companion, "NoHardKeywords", "No Hard Kotlin Keywords", "\n            Do not use Kotlin\u2019s hard keywords as the name of methods or fields. \\\n            These require the use of backticks to escape when calling from Kotlin. \\\n            Soft keywords, modifier keywords, and special identifiers are allowed.\n\n            For example, ActionEvent's `getWhen()` method requires backticks when used from Kotlin:\n            ```kotlin\n            val timestamp = event.`when`\n            ```\n            ", implementation, "https://android.github.io/kotlin-guides/interop.html#no-hard-keywords", category, 6, severity, false, null, null, null, 3584, null);
        companion = Issue.Companion;
        category = Category.INTEROPERABILITY_KOTLIN;
        severity = Severity.WARNING;
        implementation = IMPLEMENTATION;
        LAMBDA_LAST = Issue.Companion.create$default(companion, "LambdaLast", "Lambda Parameters Last", "\n            To improve calling this code from Kotlin, \\\n            parameter types eligible for SAM conversion should be last.\n            ", implementation, "https://android.github.io/kotlin-guides/interop.html#lambda-parameters-last", category, 6, severity, false, null, null, null, 3584, null);
        CHECK_DEPRECATED = new BooleanOption("ignore-deprecated", "Whether to ignore classes and members that have been annotated with `@Deprecated`", false, "\n                Normally this lint check will flag all unannotated elements, but by \\\n                setting this option to `true` it will skip any deprecated elements.\n                ");
        companion = Issue.Companion;
        category = Category.INTEROPERABILITY_KOTLIN;
        severity = Severity.WARNING;
        implementation = IMPLEMENTATION;
        PLATFORM_NULLNESS = Issue.Companion.create$default(companion, "UnknownNullness", "Unknown nullness", "\n                To improve referencing this code from Kotlin, consider adding \\\n                explicit nullness information here with either `@NonNull` or `@Nullable`.\n            ", implementation, "https://developer.android.com/kotlin/interop#nullability_annotations", category, 6, severity, false, null, null, null, 3584, null).setOptions(CollectionsKt.listOf((Object)CHECK_DEPRECATED));
        companion = Issue.Companion;
        category = Category.INTEROPERABILITY_KOTLIN;
        severity = Severity.WARNING;
        implementation = IMPLEMENTATION;
        KOTLIN_PROPERTY = Issue.Companion.create$default(companion, "KotlinPropertyAccess", "Kotlin Property Access", "\n            For a method to be represented as a property in Kotlin, strict \u201cbean\u201d-style prefixing must be used.\n\n            Accessor methods require a `get` prefix or for boolean-returning methods an `is` prefix can be used.\n            ", implementation, "https://android.github.io/kotlin-guides/interop.html#property-prefixes", category, 6, severity, false, null, null, null, 3584, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u0017H\u0002J\u0010\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u0017H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u00020\f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/lint/checks/InteroperabilityDetector$Issues;", "", "()V", "CHECK_DEPRECATED", "Lcom/android/tools/lint/detector/api/BooleanOption;", "IGNORE_DEPRECATED", "", "getIGNORE_DEPRECATED", "()Z", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "KOTLIN_PROPERTY", "Lcom/android/tools/lint/detector/api/Issue;", "LAMBDA_LAST", "NO_HARD_KOTLIN_KEYWORDS", "PLATFORM_NULLNESS", "isApi", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "declaration", "Lorg/jetbrains/uast/UDeclaration;", "isKotlinHardKeyword", "keyword", "", "isNonNullAnnotation", "qualifiedName", "isNullableAnnotation", "android.sdktools.lint-checks"})
    public static final class Issues {
        private Issues() {
        }

        public final boolean getIGNORE_DEPRECATED() {
            return IGNORE_DEPRECATED;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isKotlinHardKeyword(String keyword) {
            String string = keyword;
            switch (string.hashCode()) {
                case 101577: {
                    if (string.equals("for")) return true;
                    return false;
                }
                case 3211: {
                    if (string.equals("do")) return true;
                    return false;
                }
                case 502623545: {
                    if (string.equals("interface")) return true;
                    return false;
                }
                case 113101617: {
                    if (string.equals("while")) return true;
                    return false;
                }
                case 3648314: {
                    if (string.equals("when")) return true;
                    return false;
                }
                case -567202649: {
                    if (string.equals("continue")) return true;
                    return false;
                }
                case 3116345: {
                    if (string.equals("else")) return true;
                    return false;
                }
                case 520977238: {
                    if (string.equals("typealias")) return true;
                    return false;
                }
                case 94742904: {
                    if (string.equals("class")) return true;
                    return false;
                }
                case 3357: {
                    if (string.equals("if")) return true;
                    return false;
                }
                case -858802543: {
                    if (string.equals("typeof")) return true;
                    return false;
                }
                case 116513: {
                    if (string.equals("val")) return true;
                    return false;
                }
                case -807062458: {
                    if (string.equals("package")) return true;
                    return false;
                }
                case 94001407: {
                    if (string.equals("break")) return true;
                    return false;
                }
                case 3365: {
                    if (string.equals("in")) return true;
                    return false;
                }
                case 116519: {
                    if (string.equals("var")) return true;
                    return false;
                }
                case 97196323: {
                    if (string.equals("false")) return true;
                    return false;
                }
                case 3559070: {
                    if (string.equals("this")) return true;
                    return false;
                }
                case 3370: {
                    if (string.equals("is")) return true;
                    return false;
                }
                case 109801339: {
                    if (string.equals("super")) return true;
                    return false;
                }
                case 3122: {
                    if (string.equals("as")) return true;
                    return false;
                }
                case 3392903: {
                    if (string.equals("null")) return true;
                    return false;
                }
                case 110339814: {
                    if (string.equals("throw")) return true;
                    return false;
                }
                case 3569038: {
                    if (string.equals("true")) return true;
                    return false;
                }
                case 115131: {
                    if (string.equals("try")) return true;
                    return false;
                }
                case 101759: {
                    if (string.equals("fun")) return true;
                    return false;
                }
                case -934396624: {
                    if (string.equals("return")) return true;
                    return false;
                }
                case -1023368385: {
                    if (!string.equals("object")) return false;
                    return true;
                }
            }
            return false;
        }

        private final boolean isNullableAnnotation(String qualifiedName) {
            return StringsKt.endsWith$default((String)qualifiedName, (String)"Nullable", (boolean)false, (int)2, null);
        }

        private final boolean isNonNullAnnotation(String qualifiedName) {
            return StringsKt.endsWith$default((String)qualifiedName, (String)"NonNull", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)qualifiedName, (String)"NotNull", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)qualifiedName, (String)"Nonnull", (boolean)false, (int)2, null);
        }

        private final boolean isApi(JavaContext context2, UDeclaration declaration) {
            JavaEvaluator evaluator = context2.getEvaluator();
            if (evaluator.isPublic((PsiModifierListOwner)declaration) || evaluator.isProtected((PsiModifierListOwner)declaration)) {
                UClass uClass = (UClass)UastUtils.getParentOfType$default((UElement)((UElement)declaration), UClass.class, (boolean)false, (int)2, null);
                if (uClass == null) {
                    return true;
                }
                UClass cls = uClass;
                return evaluator.isPublic((PsiModifierListOwner)cls) && !(cls instanceof UAnonymousClass);
            }
            return false;
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000bH\u0002J\u001c\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u0014H\u0016J\f\u0010\u0015\u001a\u00020\b*\u00020\u0016H\u0002J\f\u0010\u0015\u001a\u00020\b*\u00020\u0017H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/lint/checks/InteroperabilityDetector$KotlinVisitor;", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "(Lcom/android/tools/lint/detector/api/JavaContext;)V", "getContext", "()Lcom/android/tools/lint/detector/api/JavaContext;", "hasNullnessAnnotation", "", "node", "Lcom/intellij/psi/PsiModifierListOwner;", "Lorg/jetbrains/uast/UAnnotated;", "reportMissingExplicitType", "", "Lorg/jetbrains/uast/UElement;", "typeString", "", "visitField", "Lorg/jetbrains/uast/UField;", "visitMethod", "Lorg/jetbrains/uast/UMethod;", "isFlexibleRecursive", "Lorg/jetbrains/kotlin/analysis/api/types/KtType;", "Lorg/jetbrains/kotlin/types/KotlinType;", "android.sdktools.lint-checks"})
    public static final class KotlinVisitor
    extends UElementHandler {
        @NotNull
        private final JavaContext context;

        public KotlinVisitor(@NotNull JavaContext context2) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            this.context = context2;
        }

        @NotNull
        public final JavaContext getContext() {
            return this.context;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void visitMethod(@NotNull UMethod node) {
            void this_$iv$iv$iv;
            void this_$iv$iv;
            BindingContext bindingContext;
            KotlinUastResolveProviderService service;
            KtExpression ktExpression;
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (!Issues.isApi(this.context, (UDeclaration)node)) return;
            if (node.getReturnTypeReference() != null) return;
            PsiType psiType = node.getReturnType();
            if (psiType == null) {
                return;
            }
            PsiType uastType = psiType;
            if (uastType instanceof PsiPrimitiveType) {
                return;
            }
            if (this.hasNullnessAnnotation((UAnnotated)node)) {
                return;
            }
            if (this.context.getEvaluator().isSuspend((PsiModifierListOwner)node.getJavaPsi())) {
                return;
            }
            PsiElement psiElement = node.getSourcePsi();
            if (!(psiElement instanceof KtCallableDeclaration)) return;
            KtCallableDeclaration ktCallableDeclaration = (KtCallableDeclaration)psiElement;
            if (ktCallableDeclaration == null) {
                return;
            }
            KtCallableDeclaration declaration = ktCallableDeclaration;
            KtCallableDeclaration ktCallableDeclaration2 = declaration;
            if (ktCallableDeclaration2 instanceof KtFunction) {
                if (((KtFunction)declaration).isLocal()) return;
                if (((KtFunction)declaration).hasDeclaredReturnType()) {
                    return;
                }
            } else {
                if (!(ktCallableDeclaration2 instanceof KtProperty)) return;
                if (((KtProperty)declaration).isLocal()) return;
                if (((KtProperty)declaration).getTypeReference() != null) {
                    return;
                }
            }
            KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)declaration));
            if (ktClassOrObject != null) {
                if (ktClassOrObject.isLocal()) {
                    return;
                }
                bl = false;
            } else {
                bl = false;
            }
            if (bl) {
                return;
            }
            KtCallableDeclaration ktCallableDeclaration3 = declaration;
            if (ktCallableDeclaration3 instanceof KtProperty) {
                ktExpression = ((KtProperty)declaration).getInitializer();
                if (ktExpression == null && (ktExpression = ((KtProperty)declaration).getDelegateExpression()) == null) {
                    return;
                }
            } else {
                if (!(ktCallableDeclaration3 instanceof KtFunction)) return;
                ktExpression = ((KtFunction)declaration).getBodyExpression();
                if (ktExpression == null) {
                    KtBlockExpression ktBlockExpression = ((KtFunction)declaration).getBodyBlockExpression();
                    if (ktBlockExpression == null) return;
                    ktExpression = (KtExpression)ktBlockExpression;
                }
            }
            KtExpression expression = ktExpression;
            KotlinUastResolveProviderService kotlinUastResolveProviderService = service = (KotlinUastResolveProviderService)declaration.getProject().getService(KotlinUastResolveProviderService.class);
            BindingContext bindingContext2 = bindingContext = kotlinUastResolveProviderService != null ? kotlinUastResolveProviderService.getBindingContext((KtElement)declaration) : null;
            if (bindingContext != null) {
                KotlinType kotlinType = bindingContext.getType(expression);
                if (kotlinType == null) {
                    return;
                }
                KotlinType type2 = kotlinType;
                if (DynamicTypesKt.isDynamic((KotlinType)type2)) {
                    return;
                }
                if (!this.isFlexibleRecursive(type2)) {
                    return;
                }
                String typeString = FlexibleTypesKt.isFlexible((KotlinType)type2) ? null : StringsKt.replace$default((String)type2.toString(), (String)"..", (String)" or ", (boolean)false, (int)4, null);
                this.reportMissingExplicitType((UElement)node, typeString);
                return;
            }
            Object nonDefaultLifetimeTokenFactory$iv = null;
            boolean $i$f$analyze = false;
            Project project = ((KtElement)expression).getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"useSiteKtElement.project");
            KtAnalysisSessionProvider ktAnalysisSessionProvider = KtAnalysisSessionProvider.Companion.getInstance(project);
            boolean $i$f$analyse = false;
            KtLifetimeTokenFactory factory$iv$iv = KtDefaultLifetimeTokenProvider.Companion.getService(this_$iv$iv.getProject()).getDefaultLifetimeTokenFactory();
            void var12_14 = this_$iv$iv;
            KtAnalysisSession analysisSession$iv$iv$iv = this_$iv$iv.getAnalysisSession((KtElement)expression, factory$iv$iv);
            boolean $i$f$analyse2 = false;
            this_$iv$iv$iv.getNoWriteActionInAnalyseCallChecker().beforeEnteringAnalysisContext();
            factory$iv$iv.beforeEnteringAnalysisContext(analysisSession$iv$iv$iv.getToken());
            try {
                KtType ktType;
                KtAnalysisSession $this$visitMethod_u24lambda_u240 = analysisSession$iv$iv$iv;
                boolean bl2 = false;
                if ($this$visitMethod_u24lambda_u240.getKtType(expression) == null) {
                    return;
                }
                KtType ktType2 = ktType;
                if (ktType2 instanceof KtDynamicType) {
                    return;
                }
                if (!this.isFlexibleRecursive(ktType2)) {
                    return;
                }
                String typeString = ktType2 instanceof KtFlexibleType ? null : StringsKt.replace$default((String)ktType2.toString(), (String)"..", (String)" or ", (boolean)false, (int)4, null);
                this.reportMissingExplicitType((UElement)node, typeString);
                Unit unit = Unit.INSTANCE;
                return;
            }
            finally {
                factory$iv$iv.afterLeavingAnalysisContext(analysisSession$iv$iv$iv.getToken());
                this_$iv$iv$iv.getNoWriteActionInAnalyseCallChecker().afterLeavingAnalysisContext();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isFlexibleRecursive(KotlinType $this$isFlexibleRecursive) {
            boolean bl;
            if (FlexibleTypesKt.isFlexible((KotlinType)$this$isFlexibleRecursive)) {
                return true;
            }
            Iterable $this$any$iv = $this$isFlexibleRecursive.getArguments();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator = $this$any$iv.iterator();
            do {
                if (!iterator.hasNext()) return false;
                Object element$iv = iterator.next();
                TypeProjection it = (TypeProjection)element$iv;
                boolean bl2 = false;
                if (!it.isStarProjection()) {
                    KotlinType kotlinType = it.getType();
                    Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"it.type");
                    if (this.isFlexibleRecursive(kotlinType)) {
                        return true;
                    }
                }
                bl = false;
            } while (!bl);
            return true;
        }

        private final boolean isFlexibleRecursive(KtType $this$isFlexibleRecursive) {
            throw new IllegalStateException("K2 not supported in Android Studio Flamingo".toString());
        }

        @Override
        public void visitField(@NotNull UField node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        }

        private final void reportMissingExplicitType(UElement node, String typeString) {
            String string = typeString;
            JavaContext.report$default(this.context, PLATFORM_NULLNESS, node, this.context.getNameLocation(node), "Should explicitly declare type here since implicit type does not specify nullness" + (String)(string != null ? " (" + string + ")" : ""), null, 16, null);
        }

        static /* synthetic */ void reportMissingExplicitType$default(KotlinVisitor kotlinVisitor, UElement uElement, String string, int n, Object object) {
            if ((n & 2) != 0) {
                string = null;
            }
            kotlinVisitor.reportMissingExplicitType(uElement, string);
        }

        private final boolean hasNullnessAnnotation(UAnnotated node) {
            for (UAnnotation annotation : this.context.getEvaluator().getAllAnnotations(node, false)) {
                String name;
                if (annotation.getQualifiedName() == null || !Issues.isNullableAnnotation(name) && !Issues.isNonNullAnnotation(name)) continue;
                return true;
            }
            return false;
        }

        private final boolean hasNullnessAnnotation(PsiModifierListOwner node) {
            for (UAnnotation annotation : JavaEvaluator.getAnnotations$default(this.context.getEvaluator(), node, false, null, 4, null)) {
                String name;
                if (annotation.getQualifiedName() == null || !Issues.isNullableAnnotation(name) && !Issues.isNonNullAnnotation(name)) continue;
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\rH\u0002J\u0018\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\rH\u0002J\u0010\u0010\u001e\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\u001f\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0018\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#H\u0002J\u0010\u0010%\u001a\u00020\u00062\u0006\u0010&\u001a\u00020'H\u0002J\"\u0010(\u001a\u00020\u00062\u0006\u0010)\u001a\u00020*2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010+\u001a\u00020\rH\u0002J\u0010\u0010,\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010-\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010.\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010/\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u00100\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0012H\u0002J\u0010\u00101\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020#H\u0002J\u0010\u00102\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u00103\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u00104\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u00105\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u000206H\u0016J\u0010\u00107\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0012H\u0016J\u000e\u00108\u001a\u0004\u0018\u00010#*\u00020\u0012H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lcom/android/tools/lint/checks/InteroperabilityDetector$JavaVisitor;", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "(Lcom/android/tools/lint/detector/api/JavaContext;)V", "checkForKeywords", "", "checkLambdaLast", "checkNullness", "checkPropertyAccess", "getContext", "()Lcom/android/tools/lint/detector/api/JavaContext;", "nonNullAnnotation", "", "nullableAnnotation", "ensureLambdaLastParameter", "", "method", "Lorg/jetbrains/uast/UMethod;", "ensureNonKeyword", "name", "node", "Lorg/jetbrains/uast/UDeclaration;", "typeLabel", "ensureNullnessKnown", "type", "Lcom/intellij/psi/PsiType;", "ensureValidProperty", "setter", "methodName", "getNonNullAnnotation", "getNullableAnnotation", "getPropertyLocation", "Lcom/android/tools/lint/detector/api/Location;", "location1", "Lcom/intellij/psi/PsiMethod;", "location2", "hasNullnessAnnotation", "corresponding", "Lcom/intellij/psi/PsiModifierListOwner;", "hasSetter", "cls", "Lorg/jetbrains/uast/UClass;", "setterName", "initializeAnnotationNames", "isEqualsParameter", "isFunctionalInterface", "isInherited", "isLikelySetter", "isPlatformMethod", "isToStringMethod", "isTypeVariableReference", "overridesUnannotatedPlatformMethod", "visitField", "Lorg/jetbrains/uast/UField;", "visitMethod", "findRootMethod", "android.sdktools.lint-checks"})
    public static final class JavaVisitor
    extends UElementHandler {
        @NotNull
        private final JavaContext context;
        private final boolean checkForKeywords;
        private final boolean checkNullness;
        private final boolean checkLambdaLast;
        private final boolean checkPropertyAccess;
        @Nullable
        private String nonNullAnnotation;
        @Nullable
        private String nullableAnnotation;

        public JavaVisitor(@NotNull JavaContext context2) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            this.context = context2;
            this.checkForKeywords = this.context.isEnabled(NO_HARD_KOTLIN_KEYWORDS);
            this.checkNullness = this.context.isEnabled(PLATFORM_NULLNESS);
            this.checkLambdaLast = this.context.isEnabled(LAMBDA_LAST);
            this.checkPropertyAccess = this.context.isEnabled(KOTLIN_PROPERTY);
        }

        @NotNull
        public final JavaContext getContext() {
            return this.context;
        }

        @Override
        public void visitMethod(@NotNull UMethod node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (Issues.isApi(this.context, (UDeclaration)node)) {
                String methodName = node.getName();
                if (this.checkForKeywords) {
                    this.ensureNonKeyword(methodName, (UDeclaration)node, "method");
                }
                if (this.checkPropertyAccess && this.isLikelySetter(methodName, node)) {
                    this.ensureValidProperty(node, methodName);
                }
                if (this.checkLambdaLast) {
                    this.ensureLambdaLastParameter(node);
                }
                if (this.checkNullness) {
                    PsiType type2 = node.getReturnType();
                    if (type2 != null) {
                        this.ensureNullnessKnown((UDeclaration)node, type2);
                    }
                    for (UParameter parameter : node.getUastParameters()) {
                        this.ensureNullnessKnown((UDeclaration)parameter, parameter.getType());
                    }
                }
            }
        }

        @Override
        public void visitField(@NotNull UField node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (Issues.isApi(this.context, (UDeclaration)node)) {
                if (this.checkForKeywords) {
                    String string = node.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.name");
                    this.ensureNonKeyword(string, (UDeclaration)node, "field");
                }
                if (this.checkNullness) {
                    this.ensureNullnessKnown((UDeclaration)node, node.getType());
                }
            }
        }

        private final boolean isLikelySetter(String methodName, UMethod node) {
            return StringsKt.startsWith$default((String)methodName, (String)"set", (boolean)false, (int)2, null) && methodName.length() > 3 && Character.isUpperCase(methodName.charAt(3)) && node.getUastParameters().size() == 1 && this.context.getEvaluator().isPublic((PsiModifierListOwner)node) && !this.context.getEvaluator().isStatic((PsiModifierListOwner)node);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final void ensureValidProperty(UMethod setter, String methodName) {
            UClass uClass = UastUtils.getContainingUClass((UElement)((UElement)setter));
            if (uClass == null) {
                return;
            }
            UClass cls = uClass;
            String string = methodName.substring(3);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            String propertySuffix = string;
            String propertyName = StringHelper.usLocaleDecapitalize((String)propertySuffix);
            String getterName1 = "get" + propertySuffix;
            String getterName2 = "is" + propertySuffix;
            String badGetterName = "has" + propertySuffix;
            UMethod getter = null;
            UMethod badGetter = null;
            Object $this$forEach$iv = cls.getMethods();
            boolean $i$f$forEach = false;
            int n = ((UMethod[])$this$forEach$iv).length;
            for (int i = 0; i < n; ++i) {
                UMethod element$iv;
                UMethod it = element$iv = $this$forEach$iv[i];
                boolean bl2 = false;
                JvmParameter[] jvmParameterArray = it.getParameters();
                Intrinsics.checkNotNullExpressionValue((Object)jvmParameterArray, (String)"it.parameters");
                if (!(((Object[])jvmParameterArray).length == 0)) continue;
                String name = it.getName();
                if (Intrinsics.areEqual((Object)name, (Object)getterName1) || Intrinsics.areEqual((Object)name, (Object)getterName2)) {
                    getter = it;
                    continue;
                }
                if (!Intrinsics.areEqual((Object)name, (Object)badGetterName) && !Intrinsics.areEqual((Object)name, (Object)propertyName) && !StringsKt.endsWith$default((String)name, (String)propertySuffix, (boolean)false, (int)2, null) || !this.context.getEvaluator().isPublic((PsiModifierListOwner)it) || it.isConstructor()) continue;
                UParameter uParameter = (UParameter)CollectionsKt.firstOrNull((List)setter.getUastParameters());
                if (!Intrinsics.areEqual((Object)it.getReturnType(), (Object)(uParameter != null ? uParameter.getType() : null))) continue;
                badGetter = it;
            }
            if (getter == null) {
                $this$forEach$iv = cls.getUastSuperTypes();
                $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv.iterator();
                block1: while (iterator.hasNext()) {
                    Object element$iv = iterator.next();
                    UTypeReferenceExpression it = (UTypeReferenceExpression)element$iv;
                    boolean bl = false;
                    PsiType bl2 = it.getType();
                    PsiClassType psiClassType = bl2 instanceof PsiClassType ? (PsiClassType)bl2 : null;
                    if (psiClassType != null && (psiClassType = psiClassType.resolve()) != null) {
                        PsiMethod[] psiMethodArray;
                        PsiClassType superClass = psiClassType;
                        boolean bl3 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)superClass.findMethodsByName(getterName1, true), (String)"superClass.findMethodsByName(getterName1, true)");
                        for (PsiMethod inherited : psiMethodArray) {
                            if (inherited.getParameterList().getParametersCount() != 0) continue;
                            getter = inherited;
                            break;
                        }
                        if (getter != null) continue;
                        PsiMethod[] psiMethodArray2 = superClass.findMethodsByName(getterName2, true);
                        Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray2, (String)"superClass.findMethodsByName(getterName2, true)");
                        psiMethodArray = psiMethodArray2;
                        int n2 = psiMethodArray.length;
                        for (int i = 0; i < n2; ++i) {
                            PsiMethod inherited;
                            inherited = psiMethodArray[i];
                            if (inherited.getParameterList().getParametersCount() != 0) continue;
                            getter = inherited;
                            continue block1;
                        }
                    }
                }
            }
            if (getter != null && !(getter instanceof PsiCompiledElement)) {
                PsiMethod getter2 = (PsiMethod)getter;
                if (!this.context.getEvaluator().isPublic((PsiModifierListOwner)getter2)) {
                    String message2 = "This getter should be public such that `" + propertyName + "` can be accessed as a property from Kotlin; see https://android.github.io/kotlin-guides/interop.html#property-prefixes";
                    Location location2 = this.context.getNameLocation((PsiElement)getter2);
                    JavaContext.report$default(this.context, KOTLIN_PROPERTY, (PsiElement)getter2, location2, message2, null, 16, null);
                    return;
                }
                if (this.context.getEvaluator().isStatic((PsiModifierListOwner)getter2)) {
                    PsiElement staticElement = null;
                    PsiModifierList psiModifierList = getter2.getModifierList();
                    Intrinsics.checkNotNullExpressionValue((Object)psiModifierList, (String)"getter.modifierList");
                    PsiModifierList modifierList = psiModifierList;
                    if (modifierList.hasExplicitModifier("static")) {
                        for (PsiElement child = modifierList.getFirstChild(); child != null; child = child.getNextSibling()) {
                            if (!(child instanceof PsiKeyword) || !Intrinsics.areEqual((Object)"static", (Object)((PsiKeyword)child).getText())) continue;
                            staticElement = child;
                            break;
                        }
                    }
                    Location location3 = staticElement != null ? this.context.getLocation(staticElement) : this.context.getNameLocation((PsiElement)getter2);
                    String message3 = "This getter should not be static such that `" + propertyName + "` can be accessed as a property from Kotlin; see https://android.github.io/kotlin-guides/interop.html#property-prefixes";
                    Object bl2 = location3.getSource();
                    PsiElement psiElement = bl2 instanceof PsiElement ? (PsiElement)bl2 : null;
                    if (psiElement == null) {
                        psiElement = (PsiElement)setter;
                    }
                    JavaContext.report$default(this.context, KOTLIN_PROPERTY, psiElement, location3, message3, null, 16, null);
                    return;
                }
                PsiType setterParameterType = ((UParameter)CollectionsKt.first((List)setter.getUastParameters())).getType();
                if (!(Intrinsics.areEqual((Object)setterParameterType, (Object)getter2.getReturnType()) || this.hasSetter(cls, getter2.getReturnType(), setter.getName()) || this.isTypeVariableReference(setterParameterType))) {
                    PsiType psiType = getter2.getReturnType();
                    String message4 = "The getter return type (`" + (psiType != null ? psiType.getPresentableText() : null) + "`) and setter parameter type (`" + setterParameterType.getPresentableText() + "`) getter and setter methods for property `" + propertyName + "` should have exactly the same type to allow be accessed as a property from Kotlin; see https://android.github.io/kotlin-guides/interop.html#property-prefixes";
                    Location location4 = this.getPropertyLocation(getter2, (PsiMethod)setter);
                    Object bl = location4.getSource();
                    PsiElement psiElement = bl instanceof PsiElement ? (PsiElement)bl : null;
                    if (psiElement == null) {
                        psiElement = (PsiElement)setter;
                    }
                    JavaContext.report$default(this.context, KOTLIN_PROPERTY, psiElement, location4, message4, null, 16, null);
                    return;
                }
                PsiMethod[] psiMethodArray = getter2.findSuperMethods();
                Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"getter.findSuperMethods()");
                PsiMethod[] message4 = psiMethodArray;
                int location4 = 0;
                int message3 = message4.length;
                while (location4 < message3) {
                    PsiMethod superMethod = message4[location4];
                    PsiClass psiClass = superMethod.getContainingClass();
                    if (!(psiClass != null ? psiClass.isInterface() : false)) {
                        PsiType superReturnType;
                        if (superMethod.getReturnType() == null) {
                            return;
                        }
                        PsiType getterType = getter2.getReturnType();
                        if (!Intrinsics.areEqual((Object)superReturnType, (Object)getterType)) {
                            PsiType psiType = getterType;
                            String message5 = "The getter return type (`" + (psiType != null ? psiType.getPresentableText() : null) + "`) is not the same as the super return type (`" + superReturnType.getPresentableText() + "`); they should have exactly the same type to allow `" + StringHelper.usLocaleDecapitalize((String)propertySuffix) + "` be accessed as a property from Kotlin; see https://android.github.io/kotlin-guides/interop.html#property-prefixes";
                            Intrinsics.checkNotNullExpressionValue((Object)superMethod, (String)"superMethod");
                            Location location5 = this.getPropertyLocation(getter2, superMethod);
                            Location location6 = location5.getSecondary();
                            if (location6 != null) {
                                location6.setMessage("Super method here");
                            }
                            Object object = location5.getSource();
                            PsiElement psiElement = object instanceof PsiElement ? (PsiElement)object : null;
                            if (psiElement == null) {
                                psiElement = (PsiElement)setter;
                            }
                            JavaContext.report$default(this.context, KOTLIN_PROPERTY, psiElement, location5, message5, null, 16, null);
                            return;
                        }
                    }
                    ++location4;
                }
                return;
            }
            if (badGetter == null) return;
            PsiMethod[] psiMethodArray = badGetter.findSuperMethods();
            Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"badGetter!!.findSuperMethods()");
            if (ArraysKt.any((Object[])psiMethodArray)) return;
            JavaVisitor $this$ensureValidProperty_u24lambda_u244 = this;
            char c = '\u0000';
            Object matchingName = "set" + StringsKt.removePrefix((String)StringsKt.removePrefix((String)StringsKt.removePrefix((String)badGetter.getName(), (CharSequence)"is"), (CharSequence)"get"), (CharSequence)"has");
            if (!Intrinsics.areEqual((Object)methodName, (Object)matchingName)) {
                UMethod[] $this$none$iv = cls.getMethods();
                boolean $i$f$none = false;
                int n3 = $this$none$iv.length;
                for (int i = 0; i < n3; ++i) {
                    UMethod element$iv;
                    UMethod it = element$iv = $this$none$iv[i];
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)matchingName)) continue;
                    return;
                }
                boolean bl = true;
                if (!bl) return;
            }
            boolean bl = true;
            if (!bl) return;
            String name1 = badGetter.getName();
            if (StringsKt.startsWith$default((String)name1, (String)"is", (boolean)false, (int)2, null) && StringsKt.startsWith$default((String)methodName, (String)"setIs", (boolean)false, (int)2, null) && Character.isUpperCase(name1.charAt(2))) {
                c = Character.toLowerCase(name1.charAt(2));
                String string2 = name1.substring(3);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
                matchingName = string2;
                String newProperty = c + (String)matchingName;
                String message6 = "This method should be called `set" + StringHelper.usLocaleCapitalize((String)newProperty) + "` such that (along with the `" + name1 + "` getter) Kotlin code can access it as a property (`" + newProperty + "`); see https://android.github.io/kotlin-guides/interop.html#property-prefixes";
                Location location7 = this.context.getNameLocation(setter);
                this.context.report(KOTLIN_PROPERTY, setter, location7, message6);
                return;
            }
            Location location8 = this.context.getNameLocation(badGetter);
            String message7 = "This method should be called `get" + propertySuffix + "` such that `" + propertyName + "` can be accessed as a property from Kotlin; see https://android.github.io/kotlin-guides/interop.html#property-prefixes";
            this.context.report(KOTLIN_PROPERTY, badGetter, location8, message7);
        }

        private final boolean isTypeVariableReference(PsiType type2) {
            if (type2 instanceof PsiClassType) {
                PsiClass psiClass = ((PsiClassType)type2).resolve();
                if (psiClass == null) {
                    return false;
                }
                PsiClass cls = psiClass;
                return cls instanceof PsiTypeParameter;
            }
            return false;
        }

        private final boolean hasSetter(UClass cls, PsiType type2, String setterName) {
            PsiMethod[] psiMethodArray = cls.findMethodsByName(setterName, true);
            Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"cls.findMethodsByName(setterName, true)");
            for (PsiMethod method : psiMethodArray) {
                PsiParameterList parameterList;
                Intrinsics.checkNotNullExpressionValue((Object)method.getParameterList(), (String)"method.parameterList");
                PsiParameter[] parameters = parameterList.getParameters();
                if (parameters.length != 1 || !Intrinsics.areEqual((Object)parameters[0].getType(), (Object)type2)) continue;
                return true;
            }
            return false;
        }

        private final Location getPropertyLocation(PsiMethod location1, PsiMethod location2) {
            PsiMethod primary = null;
            PsiMethod secondary = null;
            if (location1 instanceof PsiCompiledElement) {
                primary = location2;
                secondary = location1;
            } else {
                primary = location1;
                secondary = location2;
            }
            Location location3 = this.context.getNameLocation((PsiElement)primary);
            Location location4 = this.context.getNameLocation((PsiElement)secondary);
            String string = secondary.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"secondary.name");
            return Location.withSecondary$default(location3, location4, (StringsKt.startsWith$default((String)string, (String)"set", (boolean)false, (int)2, null) ? "Setter" : "Getter") + " here", false, 4, null);
        }

        private final void ensureNullnessKnown(UDeclaration node, PsiType type2) {
            Location location2;
            Location location3;
            UDeclaration curr;
            UClass it;
            if (type2 instanceof PsiPrimitiveType) {
                return;
            }
            if (type2 instanceof PsiClassType && ((PsiClassType)type2).resolve() instanceof PsiTypeParameter) {
                return;
            }
            if (node instanceof UField) {
                PsiModifierList psiModifierList = ((UField)node).getModifierList();
                boolean bl = psiModifierList != null ? psiModifierList.hasModifierProperty("final") : false;
                if (bl) {
                    return;
                }
            }
            JavaEvaluator javaEvaluator = this.context.getEvaluator();
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type org.jetbrains.uast.UAnnotated");
            for (UAnnotation annotation : javaEvaluator.getAllAnnotations((UAnnotated)node, false)) {
                String name;
                if (annotation.getQualifiedName() == null) continue;
                if (Issues.isNullableAnnotation(name)) {
                    if (this.isToStringMethod(node)) {
                        Location location4 = this.context.getLocation((UElement)annotation);
                        String message2 = "Unexpected `@Nullable`: `toString` should never return null";
                        JavaContext.report$default(this.context, PLATFORM_NULLNESS, (UElement)node, location4, message2, null, 16, null);
                    }
                    return;
                }
                if (!Issues.isNonNullAnnotation(name)) continue;
                if (this.isEqualsParameter(node)) {
                    Location location5 = this.context.getLocation((UElement)annotation);
                    String message3 = "Unexpected @NonNull: The `equals` contract allows the parameter to be null";
                    JavaContext.report$default(this.context, PLATFORM_NULLNESS, (UElement)node, location5, message3, null, 16, null);
                }
                return;
            }
            if (this.isEqualsParameter(node) || this.isToStringMethod(node)) {
                return;
            }
            if (node instanceof UMethod) {
                UClass uClass = UastUtils.getContainingUClass((UElement)((UElement)node));
                if (uClass != null) {
                    it = uClass;
                    boolean bl2 = false;
                    if (it.isAnnotationType()) {
                        return;
                    }
                }
            }
            if (Issues.getIGNORE_DEPRECATED() || CHECK_DEPRECATED.getValue(this.context.getConfiguration()).booleanValue()) {
                UElement deprecatedNode;
                UElement uElement = deprecatedNode = node instanceof UParameter ? node.getUastParent() : (UElement)node;
                it = uElement != null ? uElement.getSourcePsi() : null;
                PsiDocCommentOwner psiDocCommentOwner = it instanceof PsiDocCommentOwner ? (PsiDocCommentOwner)it : null;
                boolean bl = psiDocCommentOwner != null ? psiDocCommentOwner.isDeprecated() : false;
                if (bl) {
                    return;
                }
                curr = deprecatedNode;
                while (curr != null) {
                    UClass uClass = UastUtils.getContainingUClass((UElement)curr);
                    if (uClass == null) {
                        break;
                    }
                    curr = (UElement)uClass;
                    PsiElement bl2 = curr.getSourcePsi();
                    PsiDocCommentOwner psiDocCommentOwner2 = bl2 instanceof PsiDocCommentOwner ? (PsiDocCommentOwner)bl2 : null;
                    boolean bl3 = psiDocCommentOwner2 != null ? psiDocCommentOwner2.isDeprecated() : false;
                    if (!bl3) continue;
                    return;
                }
            }
            if (this.overridesUnannotatedPlatformMethod(node)) {
                return;
            }
            curr = node;
            if (curr instanceof UVariable) {
                UTypeReferenceExpression uTypeReferenceExpression = ((UVariable)node).getTypeReference();
                if (uTypeReferenceExpression == null) {
                    return;
                }
                location3 = this.context.getLocation((UElement)uTypeReferenceExpression);
            } else if (curr instanceof UMethod) {
                PsiTypeElement psiTypeElement = ((UMethod)node).getReturnTypeElement();
                if (psiTypeElement == null) {
                    return;
                }
                location3 = this.context.getLocation((PsiElement)psiTypeElement);
            } else {
                return;
            }
            Location location6 = location3;
            if (node instanceof UParameter) {
                location2 = location6;
            } else if (node instanceof UMethod && ((UMethod)node).getModifierList() != null) {
                PsiModifierList psiModifierList = ((UMethod)node).getModifierList();
                Intrinsics.checkNotNullExpressionValue((Object)psiModifierList, (String)"node.modifierList");
                location2 = this.context.getLocation((PsiElement)psiModifierList);
            } else if (node instanceof UField && ((UField)node).getModifierList() != null) {
                PsiModifierList psiModifierList = ((UField)node).getModifierList();
                Intrinsics.checkNotNull((Object)psiModifierList);
                location2 = this.context.getLocation((PsiElement)psiModifierList);
            } else {
                return;
            }
            Location replaceLocation = location2;
            String message4 = "Unknown nullability; explicitly declare as `@Nullable` or `@NonNull` to improve Kotlin interoperability; see https://developer.android.com/kotlin/interop#nullability_annotations";
            LintFix[] lintFixArray = new LintFix[]{LintFix.Companion.create().replace().name("Annotate @NonNull").range(replaceLocation).beginning().shortenNames().reformat(true).with(this.getNonNullAnnotation(this.context) + " ").build(), LintFix.Companion.create().replace().name("Annotate @Nullable").range(replaceLocation).beginning().shortenNames().reformat(true).with(this.getNullableAnnotation(this.context) + " ").build()};
            LintFix fix = LintFix.Companion.create().alternatives(lintFixArray);
            this.context.report(PLATFORM_NULLNESS, (UElement)node, location6, message4, fix);
        }

        private final boolean overridesUnannotatedPlatformMethod(UDeclaration node) {
            if (node instanceof UParameter) {
                UMethod method = (UMethod)UastUtils.getParentOfType$default((UElement)((UElement)node), UMethod.class, (boolean)false, (int)2, null);
                if (method != null && !method.isConstructor()) {
                    PsiMethod psiMethod = this.findRootMethod(method);
                    if (psiMethod == null) {
                        return false;
                    }
                    PsiMethod superMethod = psiMethod;
                    PsiParameter[] superParameters = superMethod.getParameterList().getParameters();
                    int parameterIndex = method.getUastParameters().indexOf(node);
                    if (parameterIndex >= 0 && parameterIndex < superParameters.length && this.isPlatformMethod(superMethod)) {
                        PsiParameter psiParameter = superParameters[parameterIndex];
                        Intrinsics.checkNotNullExpressionValue((Object)psiParameter, (String)"superParameters[parameterIndex]");
                        if (!this.hasNullnessAnnotation((PsiModifierListOwner)psiParameter)) {
                            return true;
                        }
                    }
                    return false;
                }
            } else if (node instanceof UMethod && !((UMethod)node).isConstructor()) {
                PsiMethod psiMethod = this.findRootMethod((UMethod)node);
                if (psiMethod == null) {
                    return false;
                }
                PsiMethod superMethod = psiMethod;
                if (this.isPlatformMethod(superMethod) && !this.hasNullnessAnnotation((PsiModifierListOwner)superMethod)) {
                    return true;
                }
            }
            return false;
        }

        private final PsiMethod findRootMethod(UMethod $this$findRootMethod) {
            PsiMethod[] psiMethodArray = $this$findRootMethod.getJavaPsi().findSuperMethods();
            Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"javaPsi.findSuperMethods()");
            PsiMethod psiMethod = (PsiMethod)ArraysKt.firstOrNull((Object[])psiMethodArray);
            if (psiMethod == null) {
                return null;
            }
            PsiMethod superMethod = psiMethod;
            while (true) {
                PsiMethod[] psiMethodArray2 = superMethod.findSuperMethods();
                Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray2, (String)"superMethod.findSuperMethods()");
                if ((PsiMethod)ArraysKt.firstOrNull((Object[])psiMethodArray2) != null) continue;
                return superMethod;
            }
        }

        private final boolean isPlatformMethod(PsiMethod method) {
            PsiClass psiClass = method.getContainingClass();
            if (psiClass == null) {
                return false;
            }
            PsiClass containingClass = psiClass;
            String string = containingClass.getQualifiedName();
            if (string == null) {
                return false;
            }
            String name = string;
            return StringsKt.startsWith$default((String)name, (String)"android.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)name, (String)"java.", (boolean)false, (int)2, null);
        }

        private final boolean hasNullnessAnnotation(PsiModifierListOwner corresponding) {
            for (PsiAnnotation annotation : this.context.getEvaluator().getAllAnnotations(corresponding, false)) {
                String name;
                if (annotation.getQualifiedName() == null || !Issues.isNullableAnnotation(name) && !Issues.isNonNullAnnotation(name)) continue;
                return true;
            }
            return false;
        }

        private final boolean isEqualsParameter(UDeclaration node) {
            if (node instanceof UParameter) {
                UMethod uMethod = UastUtils.getContainingUMethod((UElement)((UElement)node));
                if (uMethod == null) {
                    return false;
                }
                UMethod method = uMethod;
                if (Intrinsics.areEqual((Object)method.getName(), (Object)"equals") && method.getUastParameters().size() == 1) {
                    return true;
                }
            }
            return false;
        }

        private final boolean isToStringMethod(UDeclaration node) {
            UDeclaration method;
            return node instanceof UMethod && Intrinsics.areEqual((Object)((UMethod)(method = node)).getName(), (Object)"toString") && ((UMethod)method).getUastParameters().isEmpty();
        }

        private final String getNonNullAnnotation(JavaContext context2) {
            this.initializeAnnotationNames(context2);
            String string = this.nonNullAnnotation;
            Intrinsics.checkNotNull((Object)string);
            return string;
        }

        private final String getNullableAnnotation(JavaContext context2) {
            this.initializeAnnotationNames(context2);
            String string = this.nullableAnnotation;
            Intrinsics.checkNotNull((Object)string);
            return string;
        }

        private final void initializeAnnotationNames(JavaContext context2) {
            if (this.nonNullAnnotation == null) {
                if (context2.getEvaluator().findClass("android.support.annotation.NonNull") != null) {
                    this.nonNullAnnotation = "@android.support.annotation.NonNull";
                    this.nullableAnnotation = "@android.support.annotation.Nullable";
                } else {
                    this.nonNullAnnotation = "@androidx.annotation.NonNull";
                    this.nullableAnnotation = "@androidx.annotation.Nullable";
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isInherited(UDeclaration node) {
            if (!(node instanceof UMethod)) return false;
            PsiMethod[] psiMethodArray = ((UMethod)node).getJavaPsi().findSuperMethods();
            Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"node.javaPsi.findSuperMethods()");
            if (((Object[])psiMethodArray).length != 0) return true;
            return false;
        }

        private final void ensureNonKeyword(String name, UDeclaration node, String typeLabel) {
            if (Issues.isKotlinHardKeyword(name) && !this.isInherited(node)) {
                if (node instanceof UMethod && JavaEvaluator.isOverride$default(this.context.getEvaluator(), (UMethod)node, false, 2, null)) {
                    return;
                }
                String message2 = "Avoid " + typeLabel + " names that are Kotlin hard keywords (\"" + name + "\"); see https://android.github.io/kotlin-guides/interop.html#no-hard-keywords";
                Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type org.jetbrains.uast.UElement");
                JavaContext.report$default(this.context, NO_HARD_KOTLIN_KEYWORDS, (UElement)node, this.context.getNameLocation((UElement)node), message2, null, 16, null);
            }
        }

        private final void ensureLambdaLastParameter(UMethod method) {
            int lastIndex;
            List parameters = method.getUastParameters();
            if (parameters.size() > 1 && !this.isFunctionalInterface(((UParameter)parameters.get(lastIndex = parameters.size() - 1)).getType())) {
                for (int i = lastIndex - 1; -1 < i; --i) {
                    UParameter parameter = (UParameter)parameters.get(i);
                    if (!this.isFunctionalInterface(parameter.getType()) || Intrinsics.areEqual((Object)parameter.getType().getCanonicalText(), (Object)"java.util.concurrent.Executor")) continue;
                    if (this.isInherited((UDeclaration)method)) {
                        return;
                    }
                    PsiClass psiClass = method.getContainingClass();
                    String message2 = "Functional interface parameters (such as parameter " + (i + 1) + ", \"" + parameter.getName() + "\", in " + (psiClass != null ? psiClass.getQualifiedName() : null) + "." + method.getName() + ") should be last to improve Kotlin interoperability; see https://kotlinlang.org/docs/reference/java-interop.html#sam-conversions";
                    Object e = parameters.get(lastIndex);
                    Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type org.jetbrains.uast.UElement");
                    UElement last = (UElement)e;
                    JavaContext.report$default(this.context, LAMBDA_LAST, last, this.context.getLocation(last), message2, null, 16, null);
                    break;
                }
            }
        }

        private final boolean isFunctionalInterface(PsiType type2) {
            if (!(type2 instanceof PsiClassType)) {
                return false;
            }
            PsiClass psiClass = ((PsiClassType)type2).resolve();
            if (psiClass == null) {
                return false;
            }
            PsiClass cls = psiClass;
            if (!cls.isInterface()) {
                return false;
            }
            int abstractCount = 0;
            PsiMethod[] psiMethodArray = cls.getMethods();
            Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"cls.methods");
            for (PsiMethod method : psiMethodArray) {
                if (!method.getModifierList().hasModifierProperty("abstract")) continue;
                ++abstractCount;
            }
            if (abstractCount != 1) {
                if (abstractCount > 1) {
                    abstractCount = 0;
                    PsiMethod[] psiMethodArray2 = cls.getMethods();
                    Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray2, (String)"cls.methods");
                    for (PsiMethod method : psiMethodArray2) {
                        if (!method.getModifierList().hasModifierProperty("abstract")) continue;
                        JavaEvaluator javaEvaluator = this.context.getEvaluator();
                        Intrinsics.checkNotNullExpressionValue((Object)method, (String)"method");
                        if (javaEvaluator.isOverride(method, true)) continue;
                        ++abstractCount;
                    }
                }
                if (abstractCount != 1) {
                    return false;
                }
            }
            PsiClass psiClass2 = cls.getSuperClass();
            return !(psiClass2 != null ? psiClass2.isInterface() : false);
        }
    }
}

