/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.gradle.Version;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.VersionCatalogNamingUtilKt;
import com.android.tools.lint.checks.GradleDetector;
import com.android.tools.lint.client.api.LintTomlDocument;
import com.android.tools.lint.client.api.LintTomlLiteralValue;
import com.android.tools.lint.client.api.LintTomlMapValue;
import com.android.tools.lint.client.api.LintTomlValue;
import com.android.tools.lint.detector.api.GradleContext;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.uast.UElement;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u0080\u0001\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\r\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010&\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\u001az\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u00132\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010\u0016\u001a\u00020\u00132\b\b\u0002\u0010\u0017\u001a\u00020\u0013H\u0002\u001a4\u0010\u0018\u001a\u0004\u0018\u00010\u00052\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0018\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u00012\u0006\u0010\u001e\u001a\u00020\u001fH\u0002\u001a<\u0010 \u001a\u0004\u0018\u00010\u00052\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u001b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a@\u0010\"\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0004\u0012\u00020\u0005\u0018\u00010#2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u001f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001\u001a<\u0010$\u001a\u00020%2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010!\u001a\u00020\u00012\u0006\u0010&\u001a\u00020\u00132\n\b\u0002\u0010'\u001a\u0004\u0018\u00010\u0001H\u0002\u001a:\u0010(\u001a\u0004\u0018\u00010%2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010)\u001a\u00020\u001f2\u0006\u0010*\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010&\u001a\u00020\u0013H\u0002\u001a2\u0010+\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u001f\u0018\u00010,2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010-\u001a\u0004\u0018\u00010\t2\b\u0010.\u001a\u0004\u0018\u00010\tH\u0002\u001a\u001c\u0010/\u001a\u0004\u0018\u00010\u001f2\b\u00100\u001a\u0004\u0018\u00010\t2\u0006\u0010'\u001a\u00020\u0001H\u0002\u001a\u0010\u00101\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0018\u00102\u001a\u0002032\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a&\u00104\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u001f\u0018\u00010#2\b\u0010-\u001a\u0004\u0018\u00010\t2\u0006\u0010)\u001a\u00020\u001f\u001a&\u00105\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u001f\u0018\u00010#2\b\u0010-\u001a\u0004\u0018\u00010\t2\u0006\u0010)\u001a\u00020\u001f\u001a\u0016\u00106\u001a\b\u0012\u0004\u0012\u00020\u0001072\u0006\u0010*\u001a\u00020\u0001H\u0002\u001a\u001c\u00108\u001a\u0004\u0018\u00010\u001f2\u0006\u0010)\u001a\u00020\t2\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002\u001a,\u00109\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u001f0:2\u0006\u0010\u0014\u001a\u00020\u0013H\u0007\u001a<\u0010;\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u001f\u0018\u00010:2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0007\u001a\u0012\u0010<\u001a\u00020\u00132\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002\u001a\u0016\u0010=\u001a\u00020\u0013*\u0004\u0018\u00010\t2\u0006\u0010'\u001a\u00020\u0001H\u0002\u001a\u0014\u0010>\u001a\u00020?*\u00020\u001a2\u0006\u0010@\u001a\u00020?H\u0002\u001a\f\u0010A\u001a\u00020\u0013*\u00020\tH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"VC_LIBRARIES", "", "VC_PLUGINS", "VC_VERSIONS", "createAddNewCatalogLibrary", "Lcom/android/tools/lint/detector/api/LintFix;", "gc", "Lcom/android/ide/common/repository/GradleCoordinate;", "versionsMap", "Lcom/android/tools/lint/client/api/LintTomlMapValue;", "librariesMap", "document", "Lcom/android/tools/lint/client/api/LintTomlDocument;", "context", "Lcom/android/tools/lint/detector/api/GradleContext;", "valueCookie", "", "versionVar", "allowExistingVersionVar", "", "includeVersionInKey", "overrideMessage", "autoFix", "independent", "createAddVersionFix", "source", "", "versionVariable", "createChangeVersionFix", "version", "versionNode", "Lcom/android/tools/lint/client/api/LintTomlValue;", "createInsertLibraryFix", "libraryVariable", "createMoveToTomlFix", "Lkotlin/Pair;", "createReplaceWithLibraryReferenceFix", "Lcom/android/tools/lint/detector/api/LintFix$ReplaceString;", "safe", "name", "createSwitchToLibraryFix", "library", "key", "findExistingVariable", "", "versions", "libraries", "getBeforeIfAlphabeticOrder", "mapOwner", "getCatalogName", "getGradleDependencyStringLocation", "Lcom/android/tools/lint/detector/api/Location;", "getLibraryFromTomlEntry", "getPluginFromTomlEntry", "getReservedQuickfixNames", "", "getVersion", "pickLibraryVariableName", "", "pickVersionVariableName", "spaceAroundEquals", "contains", "findNextLineStart", "", "start", "isInAlphabeticalOrder", "android.sdktools.lint-checks"})
@JvmName(name="Lint")
public final class Lint {
    @NotNull
    public static final String VC_LIBRARIES = "libraries";
    @NotNull
    public static final String VC_PLUGINS = "plugins";
    @NotNull
    public static final String VC_VERSIONS = "versions";

    @Nullable
    public static final Pair<String, LintTomlValue> getLibraryFromTomlEntry(@Nullable LintTomlMapValue versions, @NotNull LintTomlValue library2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)library2, (String)"library");
        if (library2 instanceof LintTomlLiteralValue) {
            Object object2 = library2.getActualValue();
            if (object2 == null || (object2 = object2.toString()) == null || (object2 = ((Object)StringsKt.trim((CharSequence)((CharSequence)object2))).toString()) == null) {
                return null;
            }
            Object coordinate = object2;
            return new Pair(coordinate, (Object)library2);
        }
        if (!(library2 instanceof LintTomlMapValue)) {
            return null;
        }
        LintTomlValue lintTomlValue = Lint.getVersion((LintTomlMapValue)library2, versions);
        if (lintTomlValue == null) {
            return null;
        }
        LintTomlValue versionNode = lintTomlValue;
        Object object3 = versionNode.getActualValue();
        if (object3 == null || (object3 = object3.toString()) == null || (object3 = ((Object)StringsKt.trim((CharSequence)((CharSequence)object3))).toString()) == null) {
            return null;
        }
        Object version2 = object3;
        LintTomlValue module = ((LintTomlMapValue)library2).get("module");
        if (module instanceof LintTomlLiteralValue) {
            object = ((LintTomlLiteralValue)module).getActualValue();
            if (object == null || (object = object.toString()) == null || (object = ((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString()) == null) {
                return null;
            }
        } else {
            Object object4 = ((LintTomlMapValue)library2).get("group");
            if (object4 == null || (object4 = object4.getActualValue()) == null || (object4 = object4.toString()) == null || (object4 = ((Object)StringsKt.trim((CharSequence)((CharSequence)object4))).toString()) == null) {
                return null;
            }
            Object group = object4;
            Object object5 = ((LintTomlMapValue)library2).get("name");
            if (object5 == null || (object5 = object5.getActualValue()) == null || (object5 = object5.toString()) == null || (object5 = ((Object)StringsKt.trim((CharSequence)((CharSequence)object5))).toString()) == null) {
                return null;
            }
            Object name = object5;
            object = (String)group + ":" + (String)name;
        }
        Object artifact = object;
        return new Pair((Object)((String)artifact + ":" + (String)version2), (Object)versionNode);
    }

    @Nullable
    public static final Pair<String, LintTomlValue> getPluginFromTomlEntry(@Nullable LintTomlMapValue versions, @NotNull LintTomlValue library2) {
        Intrinsics.checkNotNullParameter((Object)library2, (String)"library");
        if (library2 instanceof LintTomlLiteralValue) {
            Object object = library2.getActualValue();
            if (object == null || (object = object.toString()) == null || (object = ((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString()) == null) {
                return null;
            }
            Object coordinate = object;
            return new Pair(coordinate, (Object)library2);
        }
        if (!(library2 instanceof LintTomlMapValue)) {
            return null;
        }
        LintTomlValue lintTomlValue = Lint.getVersion((LintTomlMapValue)library2, versions);
        if (lintTomlValue == null) {
            return null;
        }
        LintTomlValue versionNode = lintTomlValue;
        Object object = versionNode.getActualValue();
        if (object == null || (object = object.toString()) == null || (object = ((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString()) == null) {
            return null;
        }
        Object version2 = object;
        LintTomlValue id = ((LintTomlMapValue)library2).get("id");
        if (id instanceof LintTomlLiteralValue) {
            Object object2 = ((LintTomlLiteralValue)id).getActualValue();
            if (object2 == null || (object2 = object2.toString()) == null || (object2 = ((Object)StringsKt.trim((CharSequence)((CharSequence)object2))).toString()) == null) {
                return null;
            }
            Object artifact = object2;
            return new Pair((Object)((String)artifact + ":" + (String)version2), (Object)versionNode);
        }
        return null;
    }

    private static final LintTomlValue getVersion(LintTomlMapValue library2, LintTomlMapValue versionsMap) {
        LintTomlValue lintTomlValue = library2.get("version");
        if (lintTomlValue == null) {
            return null;
        }
        LintTomlValue version2 = lintTomlValue;
        LintTomlValue lintTomlValue2 = version2;
        if (lintTomlValue2 instanceof LintTomlLiteralValue) {
            return version2;
        }
        if (lintTomlValue2 instanceof LintTomlMapValue) {
            LintTomlMapValue lintTomlMapValue;
            LintTomlValue ref = ((LintTomlMapValue)version2).get("ref");
            if (ref != null) {
                if (versionsMap == null) {
                    return null;
                }
                Object object = ref.getActualValue();
                if (object == null || (object = object.toString()) == null || (object = ((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString()) == null) {
                    return null;
                }
                Object versionVariable = object;
                LintTomlValue lintTomlValue3 = versionsMap.get((String)versionVariable);
                if (lintTomlValue3 == null) {
                    return null;
                }
                LintTomlValue referenced = lintTomlValue3;
                if (!(referenced instanceof LintTomlMapValue)) {
                    return referenced;
                }
                lintTomlMapValue = (LintTomlMapValue)referenced;
            } else {
                lintTomlMapValue = (LintTomlMapValue)version2;
            }
            LintTomlMapValue richVersion = lintTomlMapValue;
            return richVersion.first();
        }
        return null;
    }

    private static final int findNextLineStart(CharSequence $this$findNextLineStart, int start2) {
        int lineEnd = StringsKt.indexOf$default((CharSequence)$this$findNextLineStart, (char)'\n', (int)start2, (boolean)false, (int)4, null);
        if (lineEnd != -1) {
            return lineEnd + 1;
        }
        return -1;
    }

    @Nullable
    public static final Pair<String, LintFix> createMoveToTomlFix(@NotNull GradleContext context2, @NotNull LintTomlValue librariesMap, @NotNull GradleCoordinate gc, @NotNull Object valueCookie, @Nullable String versionVar) {
        LintFix fix;
        String matchExistingVar;
        LintTomlValue existingVersionNode;
        Object object;
        LintTomlValue lintTomlValue;
        LintFix[] versionNode;
        LintFix[] lintFixArray;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)librariesMap, (String)"librariesMap");
        Intrinsics.checkNotNullParameter((Object)gc, (String)"gc");
        Intrinsics.checkNotNullParameter((Object)valueCookie, (String)"valueCookie");
        if (!(librariesMap instanceof LintTomlMapValue)) {
            return null;
        }
        LintTomlDocument document = librariesMap.getDocument();
        LintTomlValue lintTomlValue2 = document.getValue(VC_VERSIONS);
        LintTomlMapValue versionsMap = lintTomlValue2 instanceof LintTomlMapValue ? (LintTomlMapValue)lintTomlValue2 : null;
        LintTomlValue artifactLibrary = null;
        LintFix[] artifactVersionNode = null;
        Version artifactVersion = null;
        String revision = gc.getRevision();
        for (Map.Entry<String, LintTomlValue> entry : ((LintTomlMapValue)librariesMap).getMappedValues().entrySet()) {
            GradleCoordinate c;
            String key2 = entry.getKey();
            LintTomlValue library2 = entry.getValue();
            if (Lint.getLibraryFromTomlEntry(versionsMap, library2) == null) continue;
            String coordinate = (String)lintFixArray.component1();
            versionNode = (LintFix[])lintFixArray.component2();
            if (GradleCoordinate.parseCoordinateString((String)coordinate) == null || !Intrinsics.areEqual((Object)c.getGroupId(), (Object)gc.getGroupId()) || !Intrinsics.areEqual((Object)c.getArtifactId(), (Object)gc.getArtifactId())) continue;
            if (Intrinsics.areEqual((Object)c.getRevision(), (Object)revision)) {
                LintFix.ReplaceString replaceString = Lint.createSwitchToLibraryFix(document, library2, key2, context2, valueCookie, true);
                if (replaceString == null) {
                    return null;
                }
                LintFix.ReplaceString fix2 = replaceString;
                return TuplesKt.to((Object)("Use the existing version catalog reference (`" + fix2.getReplacement() + "`) instead"), (Object)fix2);
            }
            if (artifactLibrary != null && (artifactVersion == null || c.getLowerBoundVersion().compareTo(artifactVersion) <= 0)) continue;
            artifactLibrary = library2;
            artifactVersionNode = versionNode;
            artifactVersion = c.getLowerBoundVersion();
        }
        if (artifactLibrary != null) {
            LintFix lintFix;
            boolean higher;
            LintFix addNew = Lint.createAddNewCatalogLibrary$default(gc, versionsMap, (LintTomlMapValue)librariesMap, document, context2, valueCookie, versionVar, false, true, null, false, false, 3712, null);
            boolean bl = higher = artifactVersion != null && gc.getLowerBoundVersion().compareTo(artifactVersion) > 0;
            if (higher) {
                Intrinsics.checkNotNullExpressionValue((Object)revision, (String)"revision");
                Intrinsics.checkNotNull(artifactVersionNode);
                lintFix = Lint.createChangeVersionFix(revision, artifactVersionNode);
            } else {
                lintFix = null;
            }
            LintFix changeVersionFix = lintFix;
            String string = artifactLibrary.getKey();
            Intrinsics.checkNotNull((Object)string);
            String key3 = string;
            LintFix.ReplaceString switchToVersion = Lint.createSwitchToLibraryFix(document, artifactLibrary, key3, context2, valueCookie, false);
            versionNode = new LintFix[]{addNew, changeVersionFix, switchToVersion};
            LintFix fix3 = LintFix.Companion.create().alternatives(versionNode);
            String artifact = gc.getGroupId() + ":" + gc.getArtifactId();
            String message2 = "Use version catalog instead (" + artifact + " is already available as `" + key3 + "`, but using version " + artifactVersion + " instead)";
            return TuplesKt.to((Object)message2, (Object)fix3);
        }
        if (versionVar != null) {
            LintTomlMapValue lintTomlMapValue = versionsMap;
            lintTomlValue = lintTomlMapValue != null ? lintTomlMapValue.get(versionVar) : null;
        } else {
            lintTomlValue = null;
        }
        String existingVersion = (object = (existingVersionNode = lintTomlValue)) != null && (object = object.getActualValue()) != null ? object.toString() : null;
        Map.Entry<String, LintTomlValue> entry = Lint.findExistingVariable(gc, versionsMap, (LintTomlMapValue)librariesMap);
        String string = matchExistingVar = entry != null ? entry.getKey() : null;
        if (existingVersion == null || Intrinsics.areEqual((Object)existingVersion, (Object)revision)) {
            lintFixArray = new LintFix[2];
            LintFix lintFix = lintFixArray[0] = matchExistingVar != null ? Lint.createAddNewCatalogLibrary$default(gc, versionsMap, (LintTomlMapValue)librariesMap, document, context2, valueCookie, matchExistingVar, true, false, "Replace with new library catalog declaration, reusing version variable " + matchExistingVar, false, false, 3328, null) : (LintFix)null;
            if (Lint.createAddNewCatalogLibrary$default(gc, versionsMap, (LintTomlMapValue)librariesMap, document, context2, valueCookie, versionVar, true, false, null, true, false, 768, null) == null) {
                LintFix cfr_ignored_0 = lintFixArray[1];
                return null;
            }
            fix = LintFix.Companion.create().alternatives(lintFixArray);
            return TuplesKt.to(null, (Object)fix);
        }
        LintFix.Builder builder = LintFix.Companion.create();
        lintFixArray = new LintFix[3];
        lintFixArray[0] = Lint.createAddNewCatalogLibrary$default(gc, versionsMap, (LintTomlMapValue)librariesMap, document, context2, valueCookie, versionVar, true, false, "Replace with new library catalog declaration, reusing version variable " + versionVar + " (version=" + existingVersion + ")", false, false, 2304, null);
        Intrinsics.checkNotNullExpressionValue((Object)revision, (String)"revision");
        lintFixArray[1] = Lint.createChangeVersionFix(revision, existingVersionNode);
        lintFixArray[2] = Lint.createAddNewCatalogLibrary$default(gc, versionsMap, (LintTomlMapValue)librariesMap, document, context2, valueCookie, versionVar, false, false, null, false, false, 3840, null);
        fix = builder.alternatives(lintFixArray);
        return TuplesKt.to(null, (Object)fix);
    }

    private static final Map.Entry<String, LintTomlValue> findExistingVariable(GradleCoordinate gc, LintTomlMapValue versions, LintTomlMapValue libraries2) {
        if (versions == null) {
            return null;
        }
        if (libraries2 == null) {
            return null;
        }
        String revision = gc.getRevision();
        String group = gc.getGroupId();
        for (Map.Entry<String, LintTomlValue> versionEntry : versions.getMappedValues().entrySet()) {
            LintTomlValue versionNode = versionEntry.getValue();
            Object value = versionNode.getActualValue();
            if (!Intrinsics.areEqual((Object)value, (Object)revision)) continue;
            for (Map.Entry<String, LintTomlValue> entry : libraries2.getMappedValues().entrySet()) {
                LintTomlValue libraryVersion;
                LintTomlValue lintTomlValue = entry.getValue();
                LintTomlMapValue lintTomlMapValue = lintTomlValue instanceof LintTomlMapValue ? (LintTomlMapValue)lintTomlValue : null;
                if (lintTomlMapValue == null) continue;
                LintTomlMapValue library2 = lintTomlMapValue;
                if (Lint.getVersion(library2, versions) == null) {
                    return null;
                }
                if (!Intrinsics.areEqual((Object)libraryVersion, (Object)versionNode)) continue;
                LintTomlValue module = library2.get("module");
                if (module instanceof LintTomlLiteralValue) {
                    int index2;
                    Object object = ((LintTomlLiteralValue)module).getActualValue();
                    String artifact = object != null && (object = object.toString()) != null ? ((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString() : null;
                    if (artifact == null || (index2 = StringsKt.indexOf$default((CharSequence)artifact, (char)':', (int)0, (boolean)false, (int)6, null)) == -1) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)group, (String)"group");
                    if (!StringsKt.regionMatches$default((String)group, (int)0, (String)artifact, (int)0, (int)index2, (boolean)false, (int)16, null)) continue;
                    return versionEntry;
                }
                Object object = library2.get("group");
                String libraryGroup = object != null && (object = object.getActualValue()) != null && (object = object.toString()) != null ? ((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString() : null;
                if (!Intrinsics.areEqual(libraryGroup, (Object)group)) continue;
                return versionEntry;
            }
        }
        return null;
    }

    private static final LintFix createChangeVersionFix(String version2, LintTomlValue versionNode) {
        return LintFix.Companion.create().name("Change " + versionNode.getKey() + " to " + version2).replace().range(versionNode.getLocation()).all().with("\"" + version2 + "\"").build();
    }

    private static final LintFix createAddNewCatalogLibrary(GradleCoordinate gc, LintTomlMapValue versionsMap, LintTomlMapValue librariesMap, LintTomlDocument document, GradleContext context2, Object valueCookie, String versionVar, boolean allowExistingVersionVar, boolean includeVersionInKey, String overrideMessage, boolean autoFix, boolean independent) {
        LintTomlMapValue lintTomlMapValue = versionsMap;
        String versionVariable = Lint.pickVersionVariableName(gc, lintTomlMapValue != null ? lintTomlMapValue.getMappedValues() : null, versionVar, allowExistingVersionVar);
        String libraryVariable = Lint.pickLibraryVariableName(gc, librariesMap.getMappedValues(), includeVersionInKey);
        CharSequence source = document.getSource();
        LintFix versionVariableFix = null;
        String usedVariable = null;
        if (versionsMap == null || !Lint.contains(versionsMap, versionVariable)) {
            versionVariableFix = Lint.createAddVersionFix(versionsMap, source, document, versionVariable, gc);
            usedVariable = versionVariableFix == null ? null : versionVariable;
        } else {
            versionVariableFix = null;
            usedVariable = versionVariable;
        }
        LintFix lintFix = Lint.createInsertLibraryFix(librariesMap, source, libraryVariable, gc, usedVariable, document);
        if (lintFix == null) {
            return null;
        }
        LintFix insertLibraryFix = lintFix;
        LintFix.ReplaceString gradleFix = Lint.createReplaceWithLibraryReferenceFix$default(document, context2, valueCookie, libraryVariable, true, null, 32, null);
        LintFix.Builder builder = LintFix.Companion.create();
        Object object = overrideMessage;
        if (object == null) {
            object = "Replace with new library catalog declaration for " + libraryVariable;
        }
        LintFix[] lintFixArray = new LintFix[]{versionVariableFix, insertLibraryFix, gradleFix};
        return builder.name((String)object).composite(lintFixArray).autoFix(autoFix, independent);
    }

    static /* synthetic */ LintFix createAddNewCatalogLibrary$default(GradleCoordinate gradleCoordinate, LintTomlMapValue lintTomlMapValue, LintTomlMapValue lintTomlMapValue2, LintTomlDocument lintTomlDocument, GradleContext gradleContext, Object object, String string, boolean bl, boolean bl2, String string2, boolean bl3, boolean bl4, int n, Object object2) {
        if ((n & 0x80) != 0) {
            bl = false;
        }
        if ((n & 0x100) != 0) {
            bl2 = false;
        }
        if ((n & 0x200) != 0) {
            string2 = null;
        }
        if ((n & 0x400) != 0) {
            bl3 = true;
        }
        if ((n & 0x800) != 0) {
            bl4 = bl3;
        }
        return Lint.createAddNewCatalogLibrary(gradleCoordinate, lintTomlMapValue, lintTomlMapValue2, lintTomlDocument, gradleContext, object, string, bl, bl2, string2, bl3, bl4);
    }

    private static final LintFix.ReplaceString createSwitchToLibraryFix(LintTomlDocument document, LintTomlValue library2, String key2, GradleContext context2, Object valueCookie, boolean safe) {
        String string = library2.getFullKey();
        if (string == null || (string = StringsKt.removePrefix((String)string, (CharSequence)"libraries.")) == null) {
            return null;
        }
        String variableName = string;
        return Lint.createReplaceWithLibraryReferenceFix(document, context2, valueCookie, variableName, safe, "Replace with existing version catalog reference `" + key2 + "`");
    }

    private static final LintFix.ReplaceString createReplaceWithLibraryReferenceFix(LintTomlDocument document, GradleContext context2, Object valueCookie, String libraryVariable, boolean safe, String name) {
        LintFix.ReplaceStringBuilder replaceStringBuilder;
        String catalogName = Lint.getCatalogName(document);
        StringBuilder gradleKey = new StringBuilder();
        int n = libraryVariable.length();
        for (int i = 0; i < n; ++i) {
            char c = libraryVariable.charAt(i);
            if (c == '-' || c == '_' && (i == 0 || !Character.isDigit(libraryVariable.charAt(i)) && (i == libraryVariable.length() - 1 || !Character.isDigit(libraryVariable.charAt(i + 1))))) {
                gradleKey.append('.');
                continue;
            }
            gradleKey.append(c);
        }
        String replacement = catalogName + "." + gradleKey;
        Location range = Lint.getGradleDependencyStringLocation(context2, valueCookie);
        LintFix.ReplaceStringBuilder $this$createReplaceWithLibraryReferenceFix_u24lambda_u240 = replaceStringBuilder = LintFix.Companion.create().replace().range(range).all().with(replacement).autoFix(safe, safe);
        boolean bl = false;
        if (name != null) {
            $this$createReplaceWithLibraryReferenceFix_u24lambda_u240.name(name);
        }
        LintFix lintFix = replaceStringBuilder.build();
        Intrinsics.checkNotNull((Object)lintFix, (String)"null cannot be cast to non-null type com.android.tools.lint.detector.api.LintFix.ReplaceString");
        return (LintFix.ReplaceString)lintFix;
    }

    static /* synthetic */ LintFix.ReplaceString createReplaceWithLibraryReferenceFix$default(LintTomlDocument lintTomlDocument, GradleContext gradleContext, Object object, String string, boolean bl, String string2, int n, Object object2) {
        if ((n & 0x20) != 0) {
            string2 = null;
        }
        return Lint.createReplaceWithLibraryReferenceFix(lintTomlDocument, gradleContext, object, string, bl, string2);
    }

    /*
     * WARNING - void declaration
     */
    private static final Location getGradleDependencyStringLocation(GradleContext context2, Object valueCookie) {
        PsiElement sourcePsi;
        UElement uElement = valueCookie instanceof UElement ? (UElement)valueCookie : null;
        Object object = sourcePsi = uElement != null ? uElement.getSourcePsi() : null;
        if (sourcePsi instanceof KtLiteralStringTemplateEntry) {
            void $this$getParentOfType$iv;
            PsiElement psiElement = sourcePsi;
            boolean strict$iv = true;
            boolean $i$f$getParentOfType = false;
            KtValueArgument argument = (KtValueArgument)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtValueArgument.class, (boolean)strict$iv);
            if (argument != null) {
                return context2.getLocation(argument);
            }
        }
        return context2.getLocation(valueCookie);
    }

    private static final String getCatalogName(LintTomlDocument document) {
        String string = document.getFile().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"document.getFile().name");
        return StringsKt.substringBefore$default((String)string, (char)'.', null, (int)2, null);
    }

    private static final boolean isInAlphabeticalOrder(LintTomlMapValue $this$isInAlphabeticalOrder) {
        String lastKey = "";
        int correctCount = 0;
        Map<String, LintTomlValue> map2 = $this$isInAlphabeticalOrder.getMappedValues();
        int keyCount = map2.size();
        if (keyCount <= 3) {
            return true;
        }
        Iterator<Map.Entry<String, LintTomlValue>> iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            String key2 = iterator.next().getKey();
            if (StringsKt.compareTo((String)key2, (String)lastKey, (boolean)true) >= 0) {
                ++correctCount;
            }
            lastKey = key2;
        }
        return correctCount - keyCount <= 3 || correctCount * 100 / keyCount >= 90;
    }

    private static final LintTomlValue getBeforeIfAlphabeticOrder(LintTomlMapValue mapOwner, String name) {
        if (mapOwner == null) {
            return null;
        }
        if (!Lint.isInAlphabeticalOrder(mapOwner)) {
            return null;
        }
        for (Map.Entry<String, LintTomlValue> entry : mapOwner.getMappedValues().entrySet()) {
            String key2 = entry.getKey();
            LintTomlValue value = entry.getValue();
            if (StringsKt.compareTo((String)key2, (String)name, (boolean)true) < 0) continue;
            return value;
        }
        return null;
    }

    private static final LintFix createAddVersionFix(LintTomlMapValue versionsMap, CharSequence source, LintTomlDocument document, String versionVariable, GradleCoordinate gc) {
        int n;
        String separator = Lint.spaceAroundEquals(versionsMap) ? " = " : "=";
        String variableDeclaration = versionVariable + separator + "\"" + gc.getRevision() + "\"\n";
        boolean independent = true;
        LintTomlValue before = Lint.getBeforeIfAlphabeticOrder(versionsMap, versionVariable);
        if (before != null) {
            n = before.getKeyStartOffset();
        } else {
            LintTomlValue lastVersion;
            LintTomlMapValue lintTomlMapValue = versionsMap;
            LintTomlValue lintTomlValue = lastVersion = lintTomlMapValue != null ? lintTomlMapValue.last() : null;
            if (lastVersion != null) {
                int it = Lint.findNextLineStart(source, lastVersion.getEndOffset());
                boolean bl = false;
                n = it == -1 ? source.length() : it;
            } else {
                int versionsIndex = StringsKt.indexOf$default((CharSequence)source, (String)"[versions]", (int)0, (boolean)false, (int)6, null);
                if (versionsIndex != -1) {
                    n = Lint.findNextLineStart(source, versionsIndex);
                } else {
                    return null;
                }
            }
        }
        int versionInsertOffset = n;
        return LintFix.Companion.create().replace().range(Location.Companion.create(document.getFile(), source, versionInsertOffset, versionInsertOffset)).beginning().with(variableDeclaration).autoFix(true, independent).build();
    }

    private static final LintFix createInsertLibraryFix(LintTomlMapValue librariesMap, CharSequence source, String libraryVariable, GradleCoordinate gc, String versionVariable, LintTomlDocument document) {
        int n;
        LintTomlValue before = Lint.getBeforeIfAlphabeticOrder(librariesMap, libraryVariable);
        if (before != null) {
            n = before.getKeyStartOffset();
        } else {
            LintTomlValue lastLibrary = librariesMap.last();
            if (lastLibrary != null) {
                n = Lint.findNextLineStart(source, lastLibrary.getEndOffset());
            } else {
                int librariesIndex = StringsKt.indexOf$default((CharSequence)source, (String)"[libraries]", (int)0, (boolean)false, (int)6, null);
                if (librariesIndex != -1) {
                    n = Lint.findNextLineStart(source, librariesIndex);
                } else {
                    return null;
                }
            }
        }
        int libraryInsertOffset = n;
        String prefix = "";
        String suffix = "";
        if (libraryInsertOffset == -1) {
            LintTomlValue nextSection = librariesMap.next();
            if (nextSection != null) {
                libraryInsertOffset = nextSection.getKeyStartOffset();
                if (libraryInsertOffset == -1) {
                    libraryInsertOffset = nextSection.getStartOffset();
                }
                source.charAt(libraryInsertOffset);
                while (libraryInsertOffset > 0 && source.charAt(libraryInsertOffset - 1) != '\n') {
                    --libraryInsertOffset;
                }
                prefix = "";
                suffix = "\n";
            } else {
                libraryInsertOffset = source.length();
            }
        }
        if (libraryInsertOffset > 0 && source.charAt(libraryInsertOffset - 1) != '\n') {
            prefix = "\n";
        } else {
            suffix = "\n";
        }
        String string = versionVariable;
        String version2 = string != null ? "version.ref = \"" + string + "\"" : "version = \"" + gc.getRevision() + "\"";
        String moduleDeclaration = prefix + libraryVariable + " = { module = \"" + gc.getGroupId() + ":" + gc.getArtifactId() + "\", " + version2 + " }" + suffix;
        return LintFix.Companion.create().replace().range(Location.Companion.create(document.getFile(), source, libraryInsertOffset, libraryInsertOffset)).beginning().with(moduleDeclaration).autoFix().build();
    }

    private static final boolean spaceAroundEquals(LintTomlMapValue versionsMap) {
        LintTomlValue first;
        if (versionsMap == null) {
            return true;
        }
        LintTomlValue lintTomlValue = first = versionsMap.first();
        if (lintTomlValue == null) {
            return true;
        }
        int keyStart = lintTomlValue.getKeyStartOffset();
        int valueStart = first.getStartOffset();
        int indexOf = StringsKt.indexOf$default((CharSequence)first.getDocument().getSource(), (String)" =", (int)keyStart, (boolean)false, (int)4, null);
        return indexOf != -1 && indexOf < valueStart;
    }

    @VisibleForTesting
    @NotNull
    public static final String pickLibraryVariableName(@NotNull GradleCoordinate gc, @NotNull Map<String, ? extends LintTomlValue> libraries2, boolean includeVersionInKey) {
        Intrinsics.checkNotNullParameter((Object)gc, (String)"gc");
        Intrinsics.checkNotNullParameter(libraries2, (String)VC_LIBRARIES);
        TreeSet<String> reserved = new TreeSet<String>(StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE));
        Iterator<Map.Entry<String, ? extends LintTomlValue>> iterator = libraries2.entrySet().iterator();
        while (iterator.hasNext()) {
            String key2 = iterator.next().getKey();
            reserved.add(key2);
        }
        Set<String> reservedQuickfixNames = Lint.getReservedQuickfixNames(VC_LIBRARIES);
        for (String key2 : reservedQuickfixNames) {
            reserved.add(key2);
        }
        String suggestion = VersionCatalogNamingUtilKt.pickLibraryVariableName((GradleCoordinate)gc, (boolean)includeVersionInKey, (Set)reserved);
        reservedQuickfixNames.add(suggestion);
        return suggestion;
    }

    private static final boolean contains(LintTomlMapValue $this$contains, String name) {
        boolean bl;
        block4: {
            if ($this$contains == null) {
                return false;
            }
            Map<String, LintTomlValue> $this$any$iv = $this$contains.getMappedValues();
            boolean $i$f$any = false;
            if ($this$any$iv.isEmpty()) {
                bl = false;
            } else {
                Iterator<Map.Entry<String, LintTomlValue>> iterator = $this$any$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, LintTomlValue> element$iv;
                    Map.Entry<String, LintTomlValue> it = element$iv = iterator.next();
                    boolean bl2 = false;
                    if (!StringsKt.equals((String)it.getKey(), (String)name, (boolean)true)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    @VisibleForTesting
    @NotNull
    public static final String pickVersionVariableName(@NotNull GradleCoordinate gc, @Nullable Map<String, ? extends LintTomlValue> versionsMap, @Nullable String versionVar, boolean allowExistingVersionVar) {
        Intrinsics.checkNotNullParameter((Object)gc, (String)"gc");
        if (allowExistingVersionVar && versionVar != null) {
            return versionVar;
        }
        TreeSet<String> reserved = new TreeSet<String>(StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE));
        if (versionsMap != null) {
            Iterator<Map.Entry<String, ? extends LintTomlValue>> iterator = versionsMap.entrySet().iterator();
            while (iterator.hasNext()) {
                String key2 = iterator.next().getKey();
                reserved.add(key2);
            }
        }
        Set<String> reservedQuickfixNames = Lint.getReservedQuickfixNames(VC_VERSIONS);
        for (String key2 : reservedQuickfixNames) {
            reserved.add(key2);
        }
        if (versionVar != null && !reserved.contains(versionVar)) {
            return versionVar;
        }
        String suggestion = VersionCatalogNamingUtilKt.pickVersionVariableName((GradleCoordinate)gc, (Set)reserved);
        reservedQuickfixNames.add(suggestion);
        return suggestion;
    }

    public static /* synthetic */ String pickVersionVariableName$default(GradleCoordinate gradleCoordinate, Map map2, String string, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            string = null;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        return Lint.pickVersionVariableName(gradleCoordinate, map2, string, bl);
    }

    private static final Set<String> getReservedQuickfixNames(String key2) {
        Map<String, Set<String>> reservedQuickfixNames;
        Object object;
        Object it;
        Object object2;
        Map<String, Set<String>> map2 = GradleDetector.Companion.getReservedQuickfixNames();
        if (map2 == null) {
            it = object2 = (Map)new LinkedHashMap();
            boolean bl = false;
            GradleDetector.Companion.setReservedQuickfixNames((Map<String, Set<String>>)it);
            map2 = object2;
        }
        if ((object = (reservedQuickfixNames = map2).get(key2)) == null) {
            it = object2 = (Set)new LinkedHashSet();
            boolean bl = false;
            reservedQuickfixNames.put(key2, (Set<String>)it);
            object = object2;
        }
        return object;
    }
}

