/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.rendering.api.ResourceValue;
import com.android.resources.ResourceType;
import com.android.tools.lint.client.api.ResourceReference;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.Pair;
import com.android.utils.SdkUtils;
import com.intellij.psi.PsiMethod;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001f2\u00020\u00012\u00020\u0002:\u0001\u001fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0006H\u0002J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0012H\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J \u0010\u0019\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0007\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\t\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/android/tools/lint/checks/MergeRootFrameLayoutDetector;", "Lcom/android/tools/lint/detector/api/LayoutDetector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "allowedLayouts", "", "", "pending", "", "Lcom/android/utils/Pair;", "Lcom/android/tools/lint/detector/api/Location$Handle;", "afterCheckRootProject", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "allowLayout", "layout", "getApplicableElements", "", "getApplicableMethodNames", "", "visitElement", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "Lorg/w3c/dom/Element;", "visitMethodCall", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "Companion", "android.sdktools.lint-checks"})
public final class MergeRootFrameLayoutDetector
extends LayoutDetector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Set<String> allowedLayouts;
    @Nullable
    private List<Pair<String, Location.Handle>> pending;
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    @NotNull
    private static final String ATTR_FITS_SYSTEM_WINDOWS = "fitsSystemWindows";

    @Override
    public void afterCheckRootProject(@NotNull Context context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        List<Pair<String, Location.Handle>> list2 = this.pending;
        if (list2 == null) {
            return;
        }
        List<Pair<String, Location.Handle>> pending = list2;
        Set<String> set = this.allowedLayouts;
        if (set == null) {
            return;
        }
        Set<String> allowedLayouts = set;
        for (Pair<String, Location.Handle> pair2 : pending) {
            Location.Handle handle2;
            Object clientData;
            String layout = (String)pair2.getFirst();
            if (!allowedLayouts.contains(layout) || (clientData = (handle2 = (Location.Handle)pair2.getSecond()).getClientData()) instanceof Node && context2.getDriver().isSuppressed(null, ISSUE, (Node)clientData)) continue;
            Location location2 = handle2.resolve();
            Context.report$default(context2, ISSUE, location2, "This `<FrameLayout>` can be replaced with a `<merge>` tag", null, 8, null);
        }
    }

    @Override
    @NotNull
    public Collection<String> getApplicableElements() {
        Object[] objectArray = new String[]{"include", "FrameLayout"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    public void visitElement(@NotNull XmlContext context2, @NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String tag = element.getTagName();
        if (Intrinsics.areEqual((Object)tag, (Object)"include")) {
            String layout;
            String string = layout = element.getAttribute("layout");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"layout");
            if (StringsKt.startsWith$default((String)string, (String)"@layout/", (boolean)false, (int)2, null)) {
                String string2 = layout;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"layout");
                String string3 = string2;
                int n = 8;
                String string4 = string3.substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).substring(startIndex)");
                String string5 = layout = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"layout");
                this.allowLayout(string5);
            }
        } else {
            boolean layout = Intrinsics.areEqual((Object)tag, (Object)"FrameLayout");
            if (_Assertions.ENABLED && !layout) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            if (Lint.isRootElement(element) && (MergeRootFrameLayoutDetector.Companion.isWidthFillParent(element) && MergeRootFrameLayoutDetector.Companion.isHeightFillParent(element) || !element.hasAttributeNS("http://schemas.android.com/apk/res/android", "layout_gravity")) && !element.hasAttributeNS("http://schemas.android.com/apk/res/android", "background") && !element.hasAttributeNS("http://schemas.android.com/apk/res/android", "foreground") && !Intrinsics.areEqual((Object)element.getAttributeNS("http://schemas.android.com/apk/res/android", ATTR_FITS_SYSTEM_WINDOWS), (Object)"true") && !MergeRootFrameLayoutDetector.Companion.hasPadding(element)) {
                if (!context2.getProject().getReportIssues()) {
                    return;
                }
                Object object = element.getAttributeNode("style");
                if (object != null && (object = object.getValue()) != null) {
                    Object url = object;
                    boolean bl = false;
                    List styles = Lint.getStyleAttributes$default(context2.getProject(), context2.getClient(), (String)url, "http://schemas.android.com/apk/res/android", ATTR_FITS_SYSTEM_WINDOWS, false, 32, null);
                    if (styles != null) {
                        boolean bl2;
                        block13: {
                            Iterable $this$any$iv = styles;
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl2 = false;
                            } else {
                                for (Object element$iv : $this$any$iv) {
                                    ResourceValue it = (ResourceValue)element$iv;
                                    boolean bl3 = false;
                                    if (!Intrinsics.areEqual((Object)it.getValue(), (Object)"true")) continue;
                                    bl2 = true;
                                    break block13;
                                }
                                bl2 = false;
                            }
                        }
                        if (bl2) {
                            return;
                        }
                    }
                }
                String layout2 = SdkUtils.getLayoutName((File)context2.file);
                Location.Handle handle2 = context2.createLocationHandle(element);
                handle2.setClientData(element);
                List list2 = this.pending;
                if (list2 == null) {
                    ArrayList arrayList;
                    ArrayList it = arrayList = new ArrayList();
                    boolean bl = false;
                    this.pending = it;
                    list2 = arrayList;
                }
                List pending = list2;
                Pair pair2 = Pair.of((Object)layout2, (Object)handle2);
                Intrinsics.checkNotNullExpressionValue((Object)pair2, (String)"of(layout, handle)");
                pending.add((Pair<String, Location.Handle>)pair2);
            }
        }
    }

    private final void allowLayout(String layout) {
        Set set = this.allowedLayouts;
        if (set == null) {
            HashSet hashSet;
            HashSet it = hashSet = new HashSet();
            boolean bl = false;
            this.allowedLayouts = it;
            set = hashSet;
        }
        Set allowedLayouts = set;
        allowedLayouts.add((String)layout);
    }

    @Override
    @NotNull
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object)"setContentView");
    }

    @Override
    public void visitMethodCall(@NotNull JavaContext context2, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        ResourceReference reference;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        List expressions = node.getValueArguments();
        if (expressions.size() == 1 && (reference = UastLintUtils.Companion.toAndroidReferenceViaResolve((UElement)expressions.get(0))) != null && reference.getType() == ResourceType.LAYOUT) {
            this.allowLayout(reference.getName());
        }
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.PERFORMANCE;
        Severity severity = Severity.WARNING;
        Implementation implementation = new Implementation(MergeRootFrameLayoutDetector.class, EnumSet.of((Enum)Scope.ALL_RESOURCE_FILES, (Enum)Scope.JAVA_FILE));
        ISSUE = Issue.Companion.create$default(companion, "MergeRootFrame", "FrameLayout can be replaced with `<merge>` tag", "\n                If a `<FrameLayout>` is the root of a layout and does not provide background or padding \\\n                etc, it can often be replaced with a `<merge>` tag which is slightly more efficient. \\\n                Note that this depends on context, so make sure you understand how the `<merge>` tag \\\n                works before proceeding.\n                ", implementation, "https://android-developers.googleblog.com/2009/03/android-layout-tricks-3-optimize-by.html", category, 4, severity, false, null, null, null, 3840, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u0004H\u0002J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\nH\u0002J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/lint/checks/MergeRootFrameLayoutDetector$Companion;", "", "()V", "ATTR_FITS_SYSTEM_WINDOWS", "", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "hasPadding", "", "root", "Lorg/w3c/dom/Element;", "isFillParent", "element", "dimension", "isHeightFillParent", "isWidthFillParent", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isFillParent(Element element, String dimension) {
            String width = element.getAttributeNS("http://schemas.android.com/apk/res/android", dimension);
            return Intrinsics.areEqual((Object)width, (Object)"match_parent") || Intrinsics.areEqual((Object)width, (Object)"fill_parent");
        }

        private final boolean isWidthFillParent(Element element) {
            return this.isFillParent(element, "layout_width");
        }

        private final boolean isHeightFillParent(Element element) {
            return this.isFillParent(element, "layout_height");
        }

        private final boolean hasPadding(Element root) {
            return root.hasAttributeNS("http://schemas.android.com/apk/res/android", "padding") || root.hasAttributeNS("http://schemas.android.com/apk/res/android", "paddingLeft") || root.hasAttributeNS("http://schemas.android.com/apk/res/android", "paddingRight") || root.hasAttributeNS("http://schemas.android.com/apk/res/android", "paddingTop") || root.hasAttributeNS("http://schemas.android.com/apk/res/android", "paddingBottom");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

