/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.ApiDetector;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.ApiConstraint;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UastUtils;

public class OverrideConcreteDetector
extends Detector
implements SourceCodeScanner {
    public static final Issue ISSUE = Issue.create("OverrideAbstract", "Not overriding abstract methods on older platforms", "To improve the usability of some APIs, some methods that used to be `abstract` have been made concrete by adding default implementations. This means that when compiling with new versions of the SDK, your code does not have to override these methods.\n\nHowever, if your code is also targeting older versions of the platform where these methods were still `abstract`, the code will crash. You must override all methods that used to be abstract in any versions targeted by your application's `minSdkVersion`.", Category.CORRECTNESS, 6, Severity.ERROR, new Implementation(OverrideConcreteDetector.class, Scope.JAVA_FILE_SCOPE)).setAndroidSpecific(true);
    private static final String NOTIFICATION_LISTENER_SERVICE_FQN = "android.service.notification.NotificationListenerService";
    public static final String STATUS_BAR_NOTIFICATION_FQN = "android.service.notification.StatusBarNotification";
    private static final String ON_NOTIFICATION_POSTED = "onNotificationPosted";
    private static final String ON_NOTIFICATION_REMOVED = "onNotificationRemoved";
    private static final int CONCRETE_IN = 21;

    @Override
    public List<String> applicableSuperClasses() {
        return Collections.singletonList(NOTIFICATION_LISTENER_SERVICE_FQN);
    }

    @Override
    public void visitClass(JavaContext context2, UClass declaration) {
        String[] methodNames;
        JavaEvaluator evaluator = context2.getEvaluator();
        if (evaluator.isAbstract((PsiModifierListOwner)declaration)) {
            return;
        }
        ApiConstraint minSdk = ApiConstraint.Companion.max(context2.getProject().getMinSdkVersions(), OverrideConcreteDetector.getTargetApi(context2.getEvaluator(), declaration), false);
        ApiConstraint.SdkApiConstraint platformConstraint = minSdk.findSdk(0, true);
        if (platformConstraint == null || platformConstraint.min() >= 21) {
            return;
        }
        for (String methodName : methodNames = new String[]{ON_NOTIFICATION_POSTED, ON_NOTIFICATION_REMOVED}) {
            boolean found = false;
            for (PsiMethod method : declaration.findMethodsByName(methodName, true)) {
                PsiClass containingClass = method.getContainingClass();
                if (containingClass == null || NOTIFICATION_LISTENER_SERVICE_FQN.equals(containingClass.getQualifiedName()) || evaluator.isAbstract((PsiModifierListOwner)method) || method.getParameterList().getParametersCount() != 1 || !evaluator.parameterHasType(method, 0, STATUS_BAR_NOTIFICATION_FQN)) continue;
                found = true;
                break;
            }
            if (found) continue;
            String message2 = String.format(Locale.US, "Must override `%1$s.%2$s(%3$s)`: Method was abstract until %4$d, and your `minSdkVersion` is %5$d", NOTIFICATION_LISTENER_SERVICE_FQN, methodName, STATUS_BAR_NOTIFICATION_FQN, 21, minSdk.min());
            context2.report(ISSUE, declaration, context2.getNameLocation(declaration), message2);
            break;
        }
    }

    private static ApiConstraint getTargetApi(JavaEvaluator evaluator, UClass node) {
        while (node != null) {
            ApiConstraint targetApi = ApiDetector.getTargetApi(evaluator, (UElement)node);
            if (targetApi != null) {
                return targetApi;
            }
            node = (UClass)UastUtils.getParentOfType((UElement)node, UClass.class, (boolean)true);
        }
        return null;
    }
}

