/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UFile;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u00012\u00020\u0002:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/lint/checks/PendingIntentMutableFlagDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "filterIncident", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "incident", "Lcom/android/tools/lint/detector/api/Incident;", "map", "Lcom/android/tools/lint/detector/api/LintMap;", "getApplicableMethodNames", "", "", "visitMethodCall", "", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "Companion", "android.sdktools.lint-checks"})
public final class PendingIntentMutableFlagDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final List<String> METHOD_NAMES;
    private static final int FLAG_ARGUMENT_POSITION = 3;
    private static final int FLAG_IMMUTABLE = 0x4000000;
    private static final int FLAG_MUTABLE = 0x2000000;
    private static final int FLAG_UPDATE_CURRENT = 0x8000000;
    private static final int FLAG_MASK = 0xE000000;
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    @NotNull
    public static final String FLAG_IMMUTABLE_STR = "android.app.PendingIntent.FLAG_IMMUTABLE";
    @NotNull
    public static final String FLAG_MUTABLE_STR = "android.app.PendingIntent.FLAG_MUTABLE";

    @Override
    @NotNull
    public List<String> getApplicableMethodNames() {
        return METHOD_NAMES;
    }

    @Override
    public void visitMethodCall(@NotNull JavaContext context2, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (!context2.getEvaluator().isMemberInClass((PsiMember)method, "android.app.PendingIntent")) {
            return;
        }
        UExpression uExpression = node.getArgumentForParameter(3);
        if (uExpression == null) {
            return;
        }
        UExpression flagsArgument = uExpression;
        LintFix[] lintFixArray = ConstantEvaluator.evaluate(context2, (UElement)flagsArgument);
        Integer n = lintFixArray instanceof Integer ? (Integer)lintFixArray : null;
        if (n == null) {
            return;
        }
        int flags = n;
        if ((flags & 0xE000000) == 0) {
            lintFixArray = new LintFix[]{com.android.tools.lint.checks.PendingIntentMutableFlagDetector$Companion.buildMutabilityFlagFix$default(Companion, context2, flagsArgument, false, 4, null), PendingIntentMutableFlagDetector.Companion.buildMutabilityFlagFix(context2, flagsArgument, true)};
            LintFix fix = this.fix().alternatives(lintFixArray);
            Incident incident = new Incident(ISSUE, node, context2.getLocation((UElement)flagsArgument), "Missing `PendingIntent` mutability flag", fix);
            context2.report(incident, this.map());
        }
    }

    @Override
    public boolean filterIncident(@NotNull Context context2, @NotNull Incident incident, @NotNull LintMap map2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)incident, (String)"incident");
        Intrinsics.checkNotNullParameter((Object)map2, (String)"map");
        if (context2.getMainProject().getTargetSdk() < 23) {
            return false;
        }
        if (context2.getMainProject().getTargetSdk() < 31) {
            incident.overrideSeverity(Severity.WARNING);
        }
        return true;
    }

    static {
        Object object = new String[]{"getActivity", "getActivities", "getBroadcast", "getService"};
        METHOD_NAMES = CollectionsKt.listOf((Object[])object);
        object = Issue.Companion;
        Category category = Category.SECURITY;
        Severity severity = Severity.FATAL;
        Implementation implementation = new Implementation(PendingIntentMutableFlagDetector.class, Scope.JAVA_FILE_SCOPE);
        ISSUE = Issue.Companion.create$default((Issue.Companion)object, "UnspecifiedImmutableFlag", "Missing `PendingIntent` mutability flag", "\n                Apps targeting Android 12 and higher must specify either `FLAG_IMMUTABLE` or \\\n                `FLAG_MUTABLE` when constructing a `PendingIntent`.\n\n                `FLAG_IMMUTABLE` is available since target SDK 23, and is almost always the best choice. \\\n                See https://developer.android.com/guide/components/intents-filters#CreateImmutablePendingIntents \\\n                for a list of common exceptions to this rule.\n            ", implementation, "https://developer.android.com/about/versions/12/behavior-changes-12#pending-intent-mutability", category, 5, severity, false, true, null, null, 3328, null).addMoreInfo("https://goo.gle/UnspecifiedImmutableFlag");
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/lint/checks/PendingIntentMutableFlagDetector$Companion;", "", "()V", "FLAG_ARGUMENT_POSITION", "", "FLAG_IMMUTABLE", "FLAG_IMMUTABLE_STR", "", "FLAG_MASK", "FLAG_MUTABLE", "FLAG_MUTABLE_STR", "FLAG_UPDATE_CURRENT", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "METHOD_NAMES", "", "buildMutabilityFlagFix", "Lcom/android/tools/lint/detector/api/LintFix;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "originalArg", "Lorg/jetbrains/uast/UExpression;", "mutable", "", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        private final LintFix buildMutabilityFlagFix(JavaContext context2, UExpression originalArg, boolean mutable) {
            String addFlagText = mutable ? PendingIntentMutableFlagDetector.FLAG_MUTABLE_STR : PendingIntentMutableFlagDetector.FLAG_IMMUTABLE_STR;
            String name = mutable ? "Add FLAG_MUTABLE" : "Add FLAG_IMMUTABLE (preferred)";
            UFile uFile = context2.getUastFile();
            boolean isKotlin = Intrinsics.areEqual((Object)(uFile != null ? uFile.getLang() : null), (Object)KotlinLanguage.INSTANCE);
            String originalArgString = originalArg.asSourceString();
            String fixText = Intrinsics.areEqual((Object)originalArgString, (Object)"0") ? addFlagText : (isKotlin ? originalArgString + " or " + addFlagText : originalArgString + " | " + addFlagText);
            return LintFix.Companion.create().name(name).replace().reformat(true).shortenNames().range(context2.getLocation((UElement)originalArg)).with(fixText).build();
        }

        static /* synthetic */ LintFix buildMutabilityFlagFix$default(Companion companion, JavaContext javaContext, UExpression uExpression, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                bl = false;
            }
            return companion.buildMutabilityFlagFix(javaContext, uExpression, bl);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

