/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.plurals.CLDR36Database;
import com.android.tools.lint.checks.plurals.CLDR38Database;
import com.android.tools.lint.checks.plurals.CLDR41Database;
import com.android.tools.lint.checks.plurals.CLDR42Database;
import com.android.tools.lint.detector.api.Lint;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\b&\u0018\u0000 \u001c2\u00020\u0001:\u0002\u001c\u001dB#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u0011\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0010J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0012\u001a\u00020\u0004H$J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0012\u001a\u00020\u0004H$J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0012\u001a\u00020\u0004H$J\u0010\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0004H\u0002J\u0010\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0004H\u0004J\u0016\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f2\u0006\u0010\u0012\u001a\u00020\u0004J\u0016\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0010R\u0014\u0010\u0007\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/lint/checks/PluralsDatabase;", "", "languageCodes", "", "", "languageFlags", "", "apiLevel", "", "([Ljava/lang/String;[II)V", "getApiLevel$android_sdktools_lint_checks", "()I", "[Ljava/lang/String;", "plurals", "", "Ljava/util/EnumSet;", "Lcom/android/tools/lint/checks/PluralsDatabase$Quantity;", "findIntegerExamples", "language", "quantity", "getExampleForQuantityOne", "getExampleForQuantityTwo", "getExampleForQuantityZero", "getFlags", "getLanguageIndex", "getRelevant", "hasMultipleValuesForQuantity", "", "Companion", "Quantity", "android.sdktools.lint-checks"})
public abstract class PluralsDatabase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String[] languageCodes;
    @NotNull
    private final int[] languageFlags;
    private final int apiLevel;
    @NotNull
    private final Map<String, EnumSet<Quantity>> plurals;
    private static final EnumSet<Quantity> EMPTY_SET = EnumSet.noneOf(Quantity.class);
    public static final int FLAG_ZERO = 1;
    public static final int FLAG_ONE = 2;
    public static final int FLAG_TWO = 4;
    public static final int FLAG_FEW = 8;
    public static final int FLAG_MANY = 16;
    public static final int FLAG_MULTIPLE_ZERO = 32;
    public static final int FLAG_MULTIPLE_ONE = 64;
    public static final int FLAG_MULTIPLE_TWO = 128;
    @NotNull
    private static final Map<Integer, PluralsDatabase> datasets;

    public PluralsDatabase(@NotNull String[] languageCodes, @NotNull int[] languageFlags, int apiLevel) {
        Intrinsics.checkNotNullParameter((Object)languageCodes, (String)"languageCodes");
        Intrinsics.checkNotNullParameter((Object)languageFlags, (String)"languageFlags");
        this.languageCodes = languageCodes;
        this.languageFlags = languageFlags;
        this.apiLevel = apiLevel;
        this.plurals = new LinkedHashMap();
        if (!(this.languageCodes.length == this.languageFlags.length)) {
            boolean bl = false;
            String string = "Language code list and flag list have different lengths";
            throw new IllegalStateException(string.toString());
        }
    }

    public final int getApiLevel$android_sdktools_lint_checks() {
        return this.apiLevel;
    }

    @Nullable
    public final EnumSet<Quantity> getRelevant(@NotNull String language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        EnumSet<Quantity> set = this.plurals.get(language);
        if (set == null) {
            int index2 = this.getLanguageIndex(language);
            if (index2 == -1) {
                Map<String, EnumSet<Quantity>> map2 = this.plurals;
                EnumSet<Quantity> enumSet = EMPTY_SET;
                Intrinsics.checkNotNullExpressionValue(enumSet, (String)"EMPTY_SET");
                EnumSet<Quantity> enumSet2 = enumSet;
                map2.put(language, enumSet2);
                return null;
            }
            int flag = this.languageFlags[index2];
            set = EnumSet.noneOf(Quantity.class);
            if ((flag & 1) != 0) {
                set.add(Quantity.zero);
            }
            if ((flag & 2) != 0) {
                set.add(Quantity.one);
            }
            if ((flag & 4) != 0) {
                set.add(Quantity.two);
            }
            if ((flag & 8) != 0) {
                set.add(Quantity.few);
            }
            if ((flag & 0x10) != 0) {
                set.add(Quantity.many);
            }
            this.plurals.put(language, set);
        }
        return set == EMPTY_SET ? null : set;
    }

    public final boolean hasMultipleValuesForQuantity(@NotNull String language, @NotNull Quantity quantity) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)((Object)quantity), (String)"quantity");
        return switch (WhenMappings.$EnumSwitchMapping$0[quantity.ordinal()]) {
            case 1 -> {
                if ((this.getFlags(language) & 0x40) != 0) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if ((this.getFlags(language) & 0x80) != 0) {
                    yield true;
                }
                yield false;
            }
            default -> quantity == Quantity.zero && (this.getFlags(language) & 0x20) != 0;
        };
    }

    @Nullable
    public final String findIntegerExamples(@NotNull String language, @NotNull Quantity quantity) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)((Object)quantity), (String)"quantity");
        return switch (WhenMappings.$EnumSwitchMapping$0[quantity.ordinal()]) {
            case 1 -> this.getExampleForQuantityOne(language);
            case 2 -> this.getExampleForQuantityTwo(language);
            case 3 -> this.getExampleForQuantityZero(language);
            default -> null;
        };
    }

    @Nullable
    protected abstract String getExampleForQuantityZero(@NotNull String var1);

    @Nullable
    protected abstract String getExampleForQuantityOne(@NotNull String var1);

    @Nullable
    protected abstract String getExampleForQuantityTwo(@NotNull String var1);

    private final int getFlags(String language) {
        int index2 = this.getLanguageIndex(language);
        return index2 != -1 ? this.languageFlags[index2] : 0;
    }

    protected final int getLanguageIndex(@NotNull String language) {
        int n;
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        int index2 = Arrays.binarySearch(this.languageCodes, language);
        if (index2 >= 0) {
            if (!Intrinsics.areEqual((Object)this.languageCodes[index2], (Object)language)) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            n = index2;
        } else {
            n = -1;
        }
        return n;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)30, (Object)CLDR36Database.INSTANCE), TuplesKt.to((Object)31, (Object)CLDR38Database.INSTANCE), TuplesKt.to((Object)32, (Object)CLDR38Database.INSTANCE), TuplesKt.to((Object)33, (Object)CLDR41Database.INSTANCE)};
        datasets = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\bH\u0086\u0002R2\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/android/tools/lint/checks/PluralsDatabase$Companion;", "", "()V", "EMPTY_SET", "Ljava/util/EnumSet;", "Lcom/android/tools/lint/checks/PluralsDatabase$Quantity;", "kotlin.jvm.PlatformType", "FLAG_FEW", "", "FLAG_MANY", "FLAG_MULTIPLE_ONE", "FLAG_MULTIPLE_TWO", "FLAG_MULTIPLE_ZERO", "FLAG_ONE", "FLAG_TWO", "FLAG_ZERO", "LATEST", "Lcom/android/tools/lint/checks/plurals/CLDR42Database;", "getLATEST", "()Lcom/android/tools/lint/checks/plurals/CLDR42Database;", "OLDEST", "Lcom/android/tools/lint/checks/plurals/CLDR36Database;", "getOLDEST", "()Lcom/android/tools/lint/checks/plurals/CLDR36Database;", "datasets", "", "Lcom/android/tools/lint/checks/PluralsDatabase;", "get", "version", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CLDR36Database getOLDEST() {
            return CLDR36Database.INSTANCE;
        }

        @NotNull
        public final CLDR42Database getLATEST() {
            return CLDR42Database.INSTANCE;
        }

        @NotNull
        public final PluralsDatabase get(int version2) {
            PluralsDatabase pluralsDatabase = (PluralsDatabase)datasets.get(version2);
            if (pluralsDatabase == null) {
                pluralsDatabase = version2 < this.getOLDEST().getApiLevel$android_sdktools_lint_checks() && version2 != -1 ? (PluralsDatabase)this.getOLDEST() : (PluralsDatabase)this.getLATEST();
            }
            return pluralsDatabase;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\t\b\u0086\u0001\u0018\u0000 \t2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\tB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\n"}, d2={"Lcom/android/tools/lint/checks/PluralsDatabase$Quantity;", "", "(Ljava/lang/String;I)V", "few", "many", "one", "two", "zero", "other", "Companion", "android.sdktools.lint-checks"})
    public static final class Quantity
    extends Enum<Quantity> {
        @NotNull
        public static final Companion Companion;
        public static final /* enum */ Quantity few;
        public static final /* enum */ Quantity many;
        public static final /* enum */ Quantity one;
        public static final /* enum */ Quantity two;
        public static final /* enum */ Quantity zero;
        public static final /* enum */ Quantity other;
        private static final /* synthetic */ Quantity[] $VALUES;

        public static Quantity[] values() {
            return (Quantity[])$VALUES.clone();
        }

        public static Quantity valueOf(String value) {
            return Enum.valueOf(Quantity.class, value);
        }

        static {
            few = new Quantity();
            many = new Quantity();
            one = new Quantity();
            two = new Quantity();
            zero = new Quantity();
            other = new Quantity();
            $VALUES = quantityArray = new Quantity[]{Quantity.few, Quantity.many, Quantity.one, Quantity.two, Quantity.zero, Quantity.other};
            Companion = new Companion(null);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\u0013\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\u0004H\u0086\u0002\u00a8\u0006\n"}, d2={"Lcom/android/tools/lint/checks/PluralsDatabase$Quantity$Companion;", "", "()V", "formatSet", "", "set", "Ljava/util/EnumSet;", "Lcom/android/tools/lint/checks/PluralsDatabase$Quantity;", "get", "name", "android.sdktools.lint-checks"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final Quantity get(@NotNull String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                for (Quantity quantity : Quantity.values()) {
                    if (!Intrinsics.areEqual((Object)name, (Object)quantity.name())) continue;
                    return quantity;
                }
                return null;
            }

            @NotNull
            public final String formatSet(@NotNull EnumSet<Quantity> set) {
                Intrinsics.checkNotNullParameter(set, (String)"set");
                List list2 = new ArrayList(set.size());
                for (Quantity quantity : set) {
                    list2.add("`" + quantity.name() + "`");
                }
                return Lint.formatList(list2, Integer.MAX_VALUE);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Quantity.values().length];
            try {
                nArray[Quantity.one.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Quantity.two.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Quantity.zero.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

