/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.Api;
import com.android.tools.lint.checks.ApiClassBase;
import com.android.tools.lint.checks.Restriction;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001d\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\rJ\u001d\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\u000fJ\u001d\u0010\u0010\u001a\u00020\u00112\u000e\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0013H\u0010\u00a2\u0006\u0002\b\u0014J-\u0010\u0015\u001a\u00020\u000b2\u000e\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u00132\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0018H\u0010\u00a2\u0006\u0002\b\u0019J%\u0010\u001a\u001a\u00020\u000b2\u000e\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0010\u00a2\u0006\u0002\b\u001bR*\u0010\u0005\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0006j\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0006j\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/lint/checks/PrivateApiClass;", "Lcom/android/tools/lint/checks/ApiClassBase;", "name", "", "(Ljava/lang/String;)V", "fields", "Ljava/util/HashMap;", "Lcom/android/tools/lint/checks/Restriction;", "Lkotlin/collections/HashMap;", "methods", "addField", "", "restriction", "addField$android_sdktools_lint_checks", "addMethod", "addMethod$android_sdktools_lint_checks", "computeExtraStorageNeeded", "", "info", "Lcom/android/tools/lint/checks/Api;", "computeExtraStorageNeeded$android_sdktools_lint_checks", "writeMemberData", "member", "buffer", "Ljava/nio/ByteBuffer;", "writeMemberData$android_sdktools_lint_checks", "writeSuperInterfaces", "writeSuperInterfaces$android_sdktools_lint_checks", "android.sdktools.lint-checks"})
public final class PrivateApiClass
extends ApiClassBase {
    @NotNull
    private final HashMap<String, Restriction> fields;
    @NotNull
    private final HashMap<String, Restriction> methods;

    public PrivateApiClass(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(name);
        this.fields = new HashMap();
        this.methods = new HashMap();
    }

    public final void addField$android_sdktools_lint_checks(@NotNull String name, @NotNull Restriction restriction) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)restriction), (String)"restriction");
        ((Map)this.fields).put(name, restriction);
    }

    public final void addMethod$android_sdktools_lint_checks(@NotNull String name, @NotNull Restriction restriction) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)restriction), (String)"restriction");
        ((Map)this.methods).put(name, restriction);
    }

    public int computeExtraStorageNeeded$android_sdktools_lint_checks(@NotNull Api<? extends ApiClassBase> info) {
        Intrinsics.checkNotNullParameter(info, (String)"info");
        int estimatedSize = 0;
        this.members = new ArrayList(this.fields.size() + this.methods.size());
        Set<String> set = this.fields.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"fields.keys");
        this.members.addAll((Collection<String>)set);
        Set<String> set2 = this.methods.keySet();
        Intrinsics.checkNotNullExpressionValue(set2, (String)"methods.keys");
        this.members.addAll((Collection<String>)set2);
        List<String> list2 = this.members;
        Intrinsics.checkNotNullExpressionValue(list2, (String)"members");
        CollectionsKt.sort(list2);
        this.includeNames = true;
        for (String member : this.members) {
            estimatedSize += member.length();
            estimatedSize += 8;
        }
        return estimatedSize;
    }

    public void writeSuperInterfaces$android_sdktools_lint_checks(@NotNull Api<? extends ApiClassBase> info, @NotNull ByteBuffer buffer2) {
        Intrinsics.checkNotNullParameter(info, (String)"info");
        Intrinsics.checkNotNullParameter((Object)buffer2, (String)"buffer");
    }

    public void writeMemberData$android_sdktools_lint_checks(@NotNull Api<? extends ApiClassBase> info, @NotNull String member, @NotNull ByteBuffer buffer2) {
        int n;
        Intrinsics.checkNotNullParameter(info, (String)"info");
        Intrinsics.checkNotNullParameter((Object)member, (String)"member");
        Intrinsics.checkNotNullParameter((Object)buffer2, (String)"buffer");
        Restriction restriction = StringsKt.indexOf$default((CharSequence)member, (char)'(', (int)0, (boolean)false, (int)6, null) >= 0 ? this.methods.get(member) : this.fields.get(member);
        if (restriction == null) {
            return;
        }
        Restriction payload = restriction;
        String string = member;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        byte[] signature = byArray;
        int n2 = signature.length;
        for (n = 0; n < n2; ++n) {
            boolean bl;
            byte b = signature[n];
            boolean bl2 = bl = b == (b & 0x7F);
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string2 = member;
                throw new AssertionError((Object)string2);
            }
            buffer2.put(b);
            if (b == 41) break;
        }
        buffer2.put((byte)0);
        int n3 = n = payload.getEncoding() == (payload.getEncoding() & 0xFFFFFF7F) ? 1 : 0;
        if (_Assertions.ENABLED && n == 0) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        buffer2.put((byte)payload.getEncoding());
    }
}

