/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.BroadcastReceiverUtils;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UastLiteralUtils;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u00012\u00020\u0002:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/lint/checks/RegisterReceiverFlagDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "getApplicableMethodNames", "", "", "visitMethodCall", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "Companion", "android.sdktools.lint-checks"})
public final class RegisterReceiverFlagDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int RECEIVER_EXPORTED = 2;
    private static final int RECEIVER_NOT_EXPORTED = 4;
    private static final int RECEIVER_EXPORTED_FLAG_PRESENT_MASK = 6;
    @NotNull
    private static final String EXPLANATION = "\n            A future platform release will require all receivers registering for non-system broadcasts \\\n            to include a flag indicating the receiver's exported state. Apps registering for non-system \\\n            broadcasts should use the `ContextCompat#registerReceiver` APIs with flags set to either \\\n            `RECEIVER_EXPORTED` or `RECEIVER_NOT_EXPORTED`.\n\n            If you are not expecting broadcasts from other apps on the device, \\\n            register your receiver with `RECEIVER_NOT_EXPORTED` to protect your receiver on all platform releases.\n        ";
    @JvmField
    @NotNull
    public static final Issue RECEIVER_EXPORTED_FLAG;

    @Override
    @NotNull
    public List<String> getApplicableMethodNames() {
        return BroadcastReceiverUtils.INSTANCE.getBROADCAST_RECEIVER_METHOD_NAMES();
    }

    @Override
    public void visitMethodCall(@NotNull JavaContext context2, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (!JavaEvaluator.isMemberInSubClassOf$default(context2.getEvaluator(), (PsiMember)method, "android.content.Context", false, 4, null)) {
            return;
        }
        UExpression uExpression = UastLintUtils.Companion.findArgument(node, "android.content.BroadcastReceiver");
        if (uExpression == null) {
            return;
        }
        UExpression receiverArg = uExpression;
        if (UastLiteralUtils.isNullLiteral((UElement)((UElement)receiverArg))) {
            return;
        }
        UExpression uExpression2 = UastLintUtils.Companion.findArgument(node, "android.content.IntentFilter");
        if (uExpression2 == null) {
            return;
        }
        UExpression filterArg = uExpression2;
        UExpression flagsArg = UastLintUtils.Companion.findArgument(node, "int");
        ConstantEvaluator evaluator = new ConstantEvaluator().allowFieldInitializers();
        Pair<Boolean, List<String>> pair2 = BroadcastReceiverUtils.checkIsProtectedReceiverAndReturnUnprotectedActions(filterArg, node, context2.getEvaluator());
        boolean isProtected2 = (Boolean)pair2.component1();
        List unprotectedActionsList2 = (List)pair2.component2();
        if (!isProtected2) {
            CharSequence charSequence;
            Object object = evaluator.evaluate((UElement)flagsArg);
            Integer flags = object instanceof Integer ? (Integer)object : null;
            String actionsList = CollectionsKt.joinToString$default((Iterable)unprotectedActionsList2, (CharSequence)", ", (CharSequence)"", (CharSequence)"", (int)-1, (CharSequence)"", null, (int)32, null);
            CharSequence charSequence2 = actionsList;
            if (charSequence2.length() == 0) {
                boolean bl = false;
                charSequence = "an IntentFilter that cannot be inspected by lint";
            } else {
                charSequence = charSequence2;
            }
            String registeredFor = (String)charSequence;
            PsiElement psiElement = receiverArg.getSourcePsi();
            String string = psiElement != null ? psiElement.getText() : null;
            if (string == null) {
                string = receiverArg.asSourceString();
            }
            String message2 = StringsKt.trimMargin$default((String)("`" + string + "` \\\n                |is missing `RECEIVER_EXPORTED` or `RECEIVER_NOT_EXPORTED` flag for unprotected \\\n                |broadcasts registered for " + registeredFor), null, (int)1, null);
            if (flagsArg == null) {
                JavaContext.report$default(context2, RECEIVER_EXPORTED_FLAG, (UElement)node, context2.getLocation((UElement)node), message2, null, 16, null);
            } else if (flags != null && (flags & 6) == 0) {
                JavaContext.report$default(context2, RECEIVER_EXPORTED_FLAG, (UElement)node, context2.getLocation((UElement)flagsArg), message2, null, 16, null);
            }
        }
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.SECURITY;
        Severity severity = Severity.WARNING;
        Implementation implementation = new Implementation(RegisterReceiverFlagDetector.class, Scope.JAVA_FILE_SCOPE);
        RECEIVER_EXPORTED_FLAG = Issue.Companion.create$default(companion, "UnspecifiedRegisterReceiverFlag", "Missing `registerReceiver()` exported flag", EXPLANATION, implementation, "https://developer.android.com/reference/androidx/core/content/ContextCompat#registerReceiver(android.content.Context,android.content.BroadcastReceiver,android.content.IntentFilter,int)", category, 5, severity, false, true, null, null, 3328, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/lint/checks/RegisterReceiverFlagDetector$Companion;", "", "()V", "EXPLANATION", "", "RECEIVER_EXPORTED", "", "RECEIVER_EXPORTED_FLAG", "Lcom/android/tools/lint/detector/api/Issue;", "RECEIVER_EXPORTED_FLAG_PRESENT_MASK", "RECEIVER_NOT_EXPORTED", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

