/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.PartialResult;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.utils.XmlUtils;
import com.google.common.collect.Maps;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiModifierListOwner;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UClass;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RegistrationDetector
extends LayoutDetector
implements SourceCodeScanner {
    public static final Issue ISSUE = Issue.create("Registered", "Class is not registered in the manifest", "Activities, services and content providers should be registered in the `AndroidManifest.xml` file using `<activity>`, `<service>` and `<provider>` tags.\n\nIf your activity is simply a parent class intended to be subclassed by other \"real\" activities, make it an abstract class.", Category.CORRECTNESS, 6, Severity.WARNING, new Implementation(RegistrationDetector.class, Scope.JAVA_FILE_SCOPE)).addMoreInfo("https://developer.android.com/guide/topics/manifest/manifest-intro.html").setAndroidSpecific(true).setEnabledByDefault(false);
    protected Map<String, String> mManifestRegistrations;
    private static final String KEY_LOCATION = "location";
    private static final String KEY_ID = "id";
    private static final String[] sTags = new String[]{"activity", "service", "receiver", "provider", "application"};
    private static final String[] sClasses = new String[]{"android.app.Activity", "android.app.Service", "android.content.BroadcastReceiver", "android.content.ContentProvider", "android.app.Application"};

    private Map<String, String> getManifestRegistrations(Project mainProject) {
        if (this.mManifestRegistrations == null) {
            Document mergedManifest = mainProject.getMergedManifest();
            if (mergedManifest == null || mergedManifest.getDocumentElement() == null) {
                return null;
            }
            this.mManifestRegistrations = Maps.newHashMap();
            Element application = XmlUtils.getFirstSubTagByName((Node)mergedManifest.getDocumentElement(), (String)"application");
            if (application != null) {
                this.registerElement(application);
                for (Element c : XmlUtils.getSubTags((Node)application)) {
                    this.registerElement(c);
                }
            }
        }
        return this.mManifestRegistrations;
    }

    private void registerElement(Element c) {
        String fqcn = Lint.resolveManifestName(c);
        String tag = c.getTagName();
        String frameworkClass = RegistrationDetector.tagToClass(tag);
        if (frameworkClass != null) {
            this.mManifestRegistrations.put(fqcn, frameworkClass);
            if (fqcn.indexOf(36) != -1) {
                fqcn = fqcn.replace('$', '.');
                this.mManifestRegistrations.put(fqcn, frameworkClass);
            }
        }
    }

    @Override
    public List<String> applicableSuperClasses() {
        return Arrays.asList("android.content.ComponentCallbacks2", "android.content.BroadcastReceiver");
    }

    @Override
    public void visitClass(JavaContext context2, UClass cls) {
        String framework;
        if (context2.getProject().isLibrary()) {
            return;
        }
        if (context2.isTestSource()) {
            return;
        }
        if (cls.getName() == null) {
            return;
        }
        JavaEvaluator evaluator = context2.getEvaluator();
        if (evaluator.isAbstract((PsiModifierListOwner)cls) || evaluator.isPrivate((PsiModifierListOwner)cls)) {
            return;
        }
        String rightTag = RegistrationDetector.getTag(evaluator, cls);
        if (rightTag == null) {
            return;
        }
        if (rightTag.equals("receiver")) {
            return;
        }
        String className = cls.getQualifiedName();
        if (className == null) {
            return;
        }
        if (!context2.isGlobalAnalysis()) {
            if (!context2.getDriver().isSuppressed(context2, ISSUE, (UAnnotated)cls)) {
                LintMap map2 = new LintMap();
                map2.put(KEY_LOCATION, context2.getNameLocation(cls));
                map2.put(KEY_ID, rightTag);
                context2.getPartialResults(ISSUE).map().put(className, map2);
            }
            return;
        }
        Map<String, String> manifestRegistrations = this.getManifestRegistrations(context2.getMainProject());
        if (manifestRegistrations != null && (framework = manifestRegistrations.get(className)) == null) {
            Location location2 = context2.getNameLocation(cls);
            String message2 = RegistrationDetector.getMissingMessage(className, rightTag);
            context2.report(ISSUE, cls, location2, message2);
        }
    }

    @Override
    public void checkPartialResults(Context context2, PartialResult partialResults) {
        Map<String, String> manifestRegistrations = this.getManifestRegistrations(context2.getMainProject());
        if (manifestRegistrations != null) {
            for (LintMap map2 : partialResults.maps()) {
                for (String className : map2) {
                    LintMap m;
                    String framework = manifestRegistrations.get(className);
                    if (framework != null || (m = map2.getMap(className)) == null) continue;
                    Location location2 = m.getLocation(KEY_LOCATION);
                    String rightTag = m.getString(KEY_ID, null);
                    if (location2 == null || rightTag == null) continue;
                    String message2 = RegistrationDetector.getMissingMessage(className, rightTag);
                    context2.report(new Incident(ISSUE, location2, message2));
                }
            }
        }
    }

    private static String getMissingMessage(String className, String tag) {
        return String.format("The `<%1$s> %2$s` is not registered in the manifest", tag, className);
    }

    private static String getTag(JavaEvaluator evaluator, UClass cls) {
        String tag = null;
        for (String s : sClasses) {
            if (!evaluator.extendsClass((PsiClass)cls, s, false)) continue;
            tag = RegistrationDetector.classToTag(s);
            break;
        }
        return tag;
    }

    private static String tagToClass(String tag) {
        int n = sTags.length;
        for (int i = 0; i < n; ++i) {
            if (!sTags[i].equals(tag)) continue;
            return sClasses[i];
        }
        return null;
    }

    protected static String classToTag(String className) {
        int n = sClasses.length;
        for (int i = 0; i < n; ++i) {
            if (!sClasses[i].equals(className)) continue;
            return sTags[i];
        }
        return null;
    }
}

