/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.TypeEvaluator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u00012\u00020\u0002:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/lint/checks/SecureRandomDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "getApplicableMethodNames", "", "", "isSecureRandomReceiver", "", "call", "Lorg/jetbrains/uast/UCallExpression;", "isSecureRandomType", "node", "Lorg/jetbrains/uast/UElement;", "visitMethodCall", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "method", "Lcom/intellij/psi/PsiMethod;", "Companion", "android.sdktools.lint-checks"})
public final class SecureRandomDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    @NotNull
    public static final String JAVA_SECURITY_SECURE_RANDOM = "java.security.SecureRandom";
    @NotNull
    public static final String JAVA_UTIL_RANDOM = "java.util.Random";
    @NotNull
    private static final String SET_SEED = "setSeed";

    @Override
    @NotNull
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object)SET_SEED);
    }

    @Override
    public void visitMethodCall(@NotNull JavaContext context2, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        List arguments = node.getValueArguments();
        if (arguments.isEmpty()) {
            return;
        }
        UExpression uExpression = UastUtils.skipParenthesizedExprDown((UExpression)((UExpression)arguments.get(0)));
        if (uExpression == null) {
            return;
        }
        UExpression seedArgument = uExpression;
        JavaEvaluator evaluator = context2.getEvaluator();
        if (evaluator.isMemberInClass((PsiMember)method, JAVA_SECURITY_SECURE_RANDOM) || evaluator.isMemberInSubClassOf((PsiMember)method, JAVA_UTIL_RANDOM, false) && this.isSecureRandomReceiver(node)) {
            Object seed = ConstantEvaluator.evaluate(context2, (UElement)seedArgument);
            if (seed != null) {
                JavaContext.report$default(context2, ISSUE, (UElement)node, context2.getLocation((UElement)node), "Do not call `setSeed()` on a `SecureRandom` with a fixed seed: it is not secure. Use `getSeed()`.", null, 16, null);
            } else {
                PsiElement seedMethod = UastUtils.tryResolve((UElement)((UElement)seedArgument));
                if (seedMethod instanceof PsiMethod) {
                    String string = ((PsiMethod)seedMethod).getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"seedMethod.name");
                    String methodName = string;
                    if (Intrinsics.areEqual((Object)methodName, (Object)"currentTimeMillis") || Intrinsics.areEqual((Object)methodName, (Object)"nanoTime")) {
                        JavaContext.report$default(context2, ISSUE, (UElement)node, context2.getLocation((UElement)node), "It is dangerous to seed `SecureRandom` with the current time because that value is more predictable to an attacker than the default seed", null, 16, null);
                    }
                }
            }
        }
    }

    private final boolean isSecureRandomReceiver(UCallExpression call) {
        UExpression uExpression = call.getReceiver();
        UExpression operand = uExpression != null ? UastUtils.skipParenthesizedExprDown((UExpression)uExpression) : null;
        return operand != null && this.isSecureRandomType((UElement)operand);
    }

    private final boolean isSecureRandomType(UElement node) {
        PsiType psiType = TypeEvaluator.evaluate(node);
        return Intrinsics.areEqual((Object)JAVA_SECURITY_SECURE_RANDOM, (Object)(psiType != null ? psiType.getCanonicalText() : null));
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.SECURITY;
        Severity severity = Severity.WARNING;
        Implementation implementation = new Implementation(SecureRandomDetector.class, Scope.JAVA_FILE_SCOPE);
        ISSUE = Issue.Companion.create$default(companion, "SecureRandom", "Using a fixed seed with `SecureRandom`", "\n                Specifying a fixed seed will cause the instance to return a predictable \\\n                sequence of numbers. This may be useful for testing but it is not appropriate \\\n                for secure use.\n                ", implementation, "https://goo.gle/SecureRandom", category, 9, severity, false, null, null, null, 3840, null).addMoreInfo("https://developer.android.com/reference/java/security/SecureRandom.html");
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/android/tools/lint/checks/SecureRandomDetector$Companion;", "", "()V", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "JAVA_SECURITY_SECURE_RANDOM", "", "JAVA_UTIL_RANDOM", "SET_SEED", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

