/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Constraints;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import java.util.Collections;
import java.util.List;
import org.jetbrains.uast.UBinaryExpressionWithType;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.util.UastExpressionUtils;

public class ServiceCastDetector
extends Detector
implements SourceCodeScanner {
    public static final Implementation IMPLEMENTATION = new Implementation(ServiceCastDetector.class, Scope.JAVA_FILE_SCOPE);
    public static final Issue ISSUE = Issue.create("ServiceCast", "Wrong system service casts", "When you call `Context#getSystemService()`, the result is typically cast to a specific interface. This lint check ensures that the cast is compatible with the expected type of the return value.", Category.CORRECTNESS, 6, Severity.ERROR, IMPLEMENTATION).setAndroidSpecific(true);
    public static final Issue WIFI_MANAGER = Issue.create("WifiManagerLeak", "WifiManager Leak", "On versions prior to Android N (24), initializing the `WifiManager` via `Context#getSystemService` can cause a memory leak if the context is not the application context. Change `context.getSystemService(...)` to `context.getApplicationContext().getSystemService(...)`.", Category.CORRECTNESS, 6, Severity.ERROR, IMPLEMENTATION).setAndroidSpecific(true);
    public static final Issue WIFI_MANAGER_UNCERTAIN = Issue.create("WifiManagerPotentialLeak", "WifiManager Potential Leak", "On versions prior to Android N (24), initializing the `WifiManager` via `Context#getSystemService` can cause a memory leak if the context is not the application context.\n\nIn many cases, it's not obvious from the code where the `Context` is coming from (e.g. it might be a parameter to a method, or a field initialized from various method calls). It's possible that the context being passed in is the application context, but to be on the safe side, you should consider changing `context.getSystemService(...)` to `context.getApplicationContext().getSystemService(...)`.", Category.CORRECTNESS, 6, Severity.WARNING, IMPLEMENTATION).setAndroidSpecific(true);
    private static final String GET_APPLICATION_CONTEXT = "getApplicationContext";
    private static final String WIFI_SERVICE = "WIFI_SERVICE";

    @Override
    public List<String> getApplicableMethodNames() {
        return Collections.singletonList("getSystemService");
    }

    @Override
    public void visitMethodCall(JavaContext context2, UCallExpression call, PsiMethod method) {
        UElement parent;
        List args = call.getValueArguments();
        if (args.size() != 1) {
            return;
        }
        UExpression argument = UastUtils.skipParenthesizedExprDown((UExpression)((UExpression)args.get(0)));
        if (!(argument instanceof UReferenceExpression)) {
            return;
        }
        PsiElement resolvedServiceConst = ((UReferenceExpression)argument).resolve();
        if (!(resolvedServiceConst instanceof PsiField)) {
            return;
        }
        String name = ((PsiField)resolvedServiceConst).getName();
        if (WIFI_SERVICE.equals(name)) {
            this.checkWifiService(context2, call);
        }
        if ((parent = UastUtils.skipParenthesizedExprUp((UElement)UastUtils.getQualifiedParentOrThis((UExpression)call).getUastParent())) != null && UastExpressionUtils.isTypeCast((UElement)parent)) {
            UBinaryExpressionWithType cast = (UBinaryExpressionWithType)parent;
            String expectedClass = ServiceCastDetector.getExpectedType(name);
            if (expectedClass != null) {
                String castType = cast.getType().getCanonicalText();
                if (castType.indexOf(46) == -1) {
                    expectedClass = ServiceCastDetector.stripPackage(expectedClass);
                }
                if (!castType.equals(expectedClass)) {
                    String expected;
                    if (ServiceCastDetector.isClipboard(castType) && ServiceCastDetector.isClipboard(expectedClass)) {
                        return;
                    }
                    String actual = ServiceCastDetector.stripPackage(castType);
                    if (actual.equals(expected = ServiceCastDetector.stripPackage(expectedClass)) && expectedClass.contains(".")) {
                        actual = castType;
                        expected = expectedClass;
                    }
                    String message2 = String.format("Suspicious cast to `%1$s` for a `%2$s`: expected `%3$s`", actual, name, expected);
                    context2.report(ISSUE, (UElement)call, context2.getLocation((UElement)cast), message2);
                }
            }
        }
    }

    private void checkWifiService(JavaContext context2, UCallExpression call) {
        JavaEvaluator evaluator = context2.getEvaluator();
        UExpression qualifier = call.getReceiver();
        PsiMethod resolvedMethod = call.resolve();
        if (resolvedMethod != null && (evaluator.isMemberInSubClassOf((PsiMember)resolvedMethod, "android.app.Activity", false) || evaluator.isMemberInSubClassOf((PsiMember)resolvedMethod, "android.view.View", false))) {
            this.reportWifiServiceLeak(WIFI_MANAGER, context2, call);
            return;
        }
        if (qualifier == null) {
            UMethod currentMethod = (UMethod)UastUtils.getParentOfType((UElement)call, UMethod.class, (boolean)true);
            if (currentMethod != null && !evaluator.isMemberInSubClassOf((PsiMember)currentMethod, "android.app.Application", true)) {
                this.reportWifiServiceLeak(WIFI_MANAGER, context2, call);
            }
        } else {
            this.checkContextReference(context2, (UElement)qualifier, call);
        }
    }

    private boolean checkContextReference(JavaContext context2, UElement element, UCallExpression call) {
        if (element == null) {
            return false;
        }
        if (element instanceof UCallExpression) {
            PsiMethod resolvedMethod = ((UCallExpression)element).resolve();
            if (resolvedMethod != null && !GET_APPLICATION_CONTEXT.equals(resolvedMethod.getName())) {
                this.reportWifiServiceLeak(WIFI_MANAGER, context2, call);
                return true;
            }
        } else if (element instanceof UQualifiedReferenceExpression) {
            UQualifiedReferenceExpression refExp = (UQualifiedReferenceExpression)element;
            PsiElement resolved = refExp.resolve();
            if (resolved instanceof PsiMethod && !GET_APPLICATION_CONTEXT.equals(refExp.getResolvedName())) {
                this.reportWifiServiceLeak(WIFI_MANAGER, context2, call);
                return true;
            }
        } else if (element instanceof UReferenceExpression) {
            PsiElement resolved = ((UReferenceExpression)element).resolve();
            if (resolved instanceof PsiField) {
                PsiType type2 = ((PsiField)resolved).getType();
                return this.checkWifiContextType(context2, call, type2, true);
            }
            if (resolved instanceof PsiParameter) {
                PsiType type3 = ((PsiParameter)resolved).getType();
                return this.checkWifiContextType(context2, call, type3, true);
            }
            if (resolved instanceof PsiLocalVariable) {
                PsiLocalVariable variable = (PsiLocalVariable)resolved;
                PsiType type4 = variable.getType();
                if (!type4.isValid()) {
                    return false;
                }
                if (this.checkWifiContextType(context2, call, type4, false)) {
                    return true;
                }
                UExpression lastAssignment = UastLintUtils.findLastAssignment((PsiVariable)variable, (UElement)call);
                if (lastAssignment != null) {
                    return this.checkContextReference(context2, (UElement)lastAssignment, call);
                }
            }
        } else if (element instanceof UParenthesizedExpression) {
            return this.checkContextReference(context2, (UElement)((UParenthesizedExpression)element).getExpression(), call);
        }
        return false;
    }

    private boolean checkWifiContextType(JavaContext context2, UCallExpression call, PsiType type2, boolean flagPlainContext) {
        PsiClass psiClass;
        JavaEvaluator evaluator = context2.getEvaluator();
        if (type2 instanceof PsiClassType && evaluator.extendsClass(psiClass = ((PsiClassType)type2).resolve(), "android.app.Application", false)) {
            return false;
        }
        if (evaluator.typeMatches(type2, "android.content.Context")) {
            if (flagPlainContext) {
                this.reportWifiServiceLeak(WIFI_MANAGER_UNCERTAIN, context2, call);
                return true;
            }
            return false;
        }
        this.reportWifiServiceLeak(WIFI_MANAGER, context2, call);
        return true;
    }

    private void reportWifiServiceLeak(Issue issue, JavaContext context2, UCallExpression call) {
        LintFix fix;
        if (context2.getProject().getMinSdk() >= 24) {
            return;
        }
        Object message2 = "The WIFI_SERVICE must be looked up on the Application context or memory will leak on devices < Android N. ";
        if (call.getReceiver() != null) {
            qualifier = call.getReceiver().asSourceString();
            message2 = (String)message2 + String.format("Try changing `%1$s` to `%1$s.getApplicationContext()`", qualifier);
            fix = this.fix().name("Add getApplicationContext()").replace().text(qualifier).with(qualifier + ".getApplicationContext()").build();
        } else {
            qualifier = Lint.getMethodName(call);
            message2 = (String)message2 + String.format("Try changing `%1$s` to `getApplicationContext().%1$s`", qualifier);
            fix = this.fix().name("Add getApplicationContext()").replace().text(qualifier).with("getApplicationContext()." + qualifier).build();
        }
        Incident incident = new Incident(issue, call, context2.getLocation((UElement)call), (String)message2, fix);
        context2.report(incident, Constraints.minSdkLessThan(24));
    }

    private static boolean isClipboard(String cls) {
        return cls.equals("android.content.ClipboardManager") || cls.equals("android.text.ClipboardManager");
    }

    private static String stripPackage(String fqcn) {
        int index2 = fqcn.lastIndexOf(46);
        if (index2 != -1) {
            fqcn = fqcn.substring(index2 + 1);
        }
        return fqcn;
    }

    @VisibleForTesting
    static String getExpectedType(String value) {
        if (value == null) {
            return null;
        }
        switch (value) {
            case "ACCESSIBILITY_SERVICE": {
                return "android.view.accessibility.AccessibilityManager";
            }
            case "ACCOUNT_SERVICE": {
                return "android.accounts.AccountManager";
            }
            case "ACTIVITY_SERVICE": {
                return "android.app.ActivityManager";
            }
            case "ALARM_SERVICE": {
                return "android.app.AlarmManager";
            }
            case "APPWIDGET_SERVICE": {
                return "android.appwidget.AppWidgetManager";
            }
            case "APP_OPS_SERVICE": {
                return "android.app.AppOpsManager";
            }
            case "AUDIO_SERVICE": {
                return "android.media.AudioManager";
            }
            case "BATTERY_SERVICE": {
                return "android.os.BatteryManager";
            }
            case "BIOMETRIC_SERVICE": {
                return "android.hardware.biometrics.BiometricManager";
            }
            case "BLUETOOTH_SERVICE": {
                return "android.bluetooth.BluetoothManager";
            }
            case "CAMERA_SERVICE": {
                return "android.hardware.camera2.CameraManager";
            }
            case "CAPTIONING_SERVICE": {
                return "android.view.accessibility.CaptioningManager";
            }
            case "CARRIER_CONFIG_SERVICE": {
                return "android.telephony.CarrierConfigManager";
            }
            case "CLIPBOARD_SERVICE": {
                return "android.text.ClipboardManager";
            }
            case "COMPANION_DEVICE_SERVICE": {
                return "android.companion.CompanionDeviceManager";
            }
            case "CONNECTIVITY_SERVICE": {
                return "android.net.ConnectivityManager";
            }
            case "CONSUMER_IR_SERVICE": {
                return "android.hardware.ConsumerIrManager";
            }
            case "CROSS_PROFILE_APPS_SERVICE": {
                return "android.content.pm.CrossProfileApps";
            }
            case "EUICC_SERVICE": {
                return "android.telephony.euicc.EuiccManager";
            }
            case "DEVICE_POLICY_SERVICE": {
                return "android.app.admin.DevicePolicyManager";
            }
            case "DISPLAY_HASH_SERVICE": {
                return "android.view.displayhash.DisplayHashManager";
            }
            case "DISPLAY_SERVICE": {
                return "android.hardware.display.DisplayManager";
            }
            case "DOMAIN_VERIFICATION_SERVICE": {
                return "android.content.pm.verify.domain.DomainVerificationManager";
            }
            case "DOWNLOAD_SERVICE": {
                return "android.app.DownloadManager";
            }
            case "DROPBOX_SERVICE": {
                return "android.os.DropBoxManager";
            }
            case "FINGERPRINT_SERVICE": {
                return "android.hardware.fingerprint.FingerprintManager";
            }
            case "HARDWARE_PROPERTIES_SERVICE": {
                return "android.os.HardwarePropertiesManager";
            }
            case "INPUT_METHOD_SERVICE": {
                return "android.view.inputmethod.InputMethodManager";
            }
            case "INPUT_SERVICE": {
                return "android.hardware.input.InputManager";
            }
            case "IPSEC_SERVICE": {
                return "android.net.IpSecManager";
            }
            case "JOB_SCHEDULER_SERVICE": {
                return "android.app.job.JobScheduler";
            }
            case "KEYGUARD_SERVICE": {
                return "android.app.KeyguardManager";
            }
            case "LAUNCHER_APPS_SERVICE": {
                return "android.content.pm.LauncherApps";
            }
            case "LAYOUT_INFLATER_SERVICE": {
                return "android.view.LayoutInflater";
            }
            case "LOCALE_SERVICE": {
                return "android.app.LocaleManager";
            }
            case "LOCATION_SERVICE": {
                return "android.location.LocationManager";
            }
            case "MEDIA_COMMUNICATION_SERVICE": {
                return "android.media.MediaCommunicationManager";
            }
            case "MEDIA_METRICS_SERVICE": {
                return "android.media.metrics.MediaMetricsManager";
            }
            case "MEDIA_PROJECTION_SERVICE": {
                return "android.media.projection.MediaProjectionManager";
            }
            case "MEDIA_ROUTER_SERVICE": {
                return "android.media.MediaRouter";
            }
            case "MEDIA_SESSION_SERVICE": {
                return "android.media.session.MediaSessionManager";
            }
            case "MIDI_SERVICE": {
                return "android.media.midi.MidiManager";
            }
            case "NETWORK_STATS_SERVICE": {
                return "android.app.usage.NetworkStatsManager";
            }
            case "NFC_SERVICE": {
                return "android.nfc.NfcManager";
            }
            case "NOTIFICATION_SERVICE": {
                return "android.app.NotificationManager";
            }
            case "NSD_SERVICE": {
                return "android.net.nsd.NsdManager";
            }
            case "POWER_SERVICE": {
                return "android.os.PowerManager";
            }
            case "PRINT_SERVICE": {
                return "android.print.PrintManager";
            }
            case "RESTRICTIONS_SERVICE": {
                return "android.content.RestrictionsManager";
            }
            case "ROLE_SERVICE": {
                return "android.app.role.RoleManager";
            }
            case "SEARCH_SERVICE": {
                return "android.app.SearchManager";
            }
            case "SENSOR_SERVICE": {
                return "android.hardware.SensorManager";
            }
            case "SHORTCUT_SERVICE": {
                return "android.content.pm.ShortcutManager";
            }
            case "STORAGE_SERVICE": {
                return "android.os.storage.StorageManager";
            }
            case "STORAGE_STATS_SERVICE": {
                return "android.app.usage.StorageStatsManager";
            }
            case "SYSTEM_HEALTH_SERVICE": {
                return "android.os.health.SystemHealthManager";
            }
            case "TELECOM_SERVICE": {
                return "android.telecom.TelecomManager";
            }
            case "TELEPHONY_SERVICE": {
                return "android.telephony.TelephonyManager";
            }
            case "TELEPHONY_SUBSCRIPTION_SERVICE": {
                return "android.telephony.SubscriptionManager";
            }
            case "TEXT_CLASSIFICATION_SERVICE": {
                return "android.view.textclassifier.TextClassificationManager";
            }
            case "TEXT_SERVICES_MANAGER_SERVICE": {
                return "android.view.textservice.TextServicesManager";
            }
            case "TV_INPUT_SERVICE": {
                return "android.media.tv.TvInputManager";
            }
            case "TV_INTERACTIVE_APP_SERVICE": {
                return "android.media.tv.interactive.TvInteractiveAppManager";
            }
            case "UI_MODE_SERVICE": {
                return "android.app.UiModeManager";
            }
            case "USAGE_STATS_SERVICE": {
                return "android.app.usage.UsageStatsManager";
            }
            case "USB_SERVICE": {
                return "android.hardware.usb.UsbManager";
            }
            case "USER_SERVICE": {
                return "android.os.UserManager";
            }
            case "VIBRATOR_MANAGER_SERVICE": {
                return "android.os.VibratorManager";
            }
            case "VIBRATOR_SERVICE": {
                return "android.os.Vibrator";
            }
            case "VPN_MANAGEMENT_SERVICE": {
                return "android.net.VpnManager";
            }
            case "WALLPAPER_SERVICE": {
                return "android.app.WallpaperManager";
            }
            case "WIFI_AWARE_SERVICE": {
                return "android.net.wifi.aware.WifiAwareManager";
            }
            case "WIFI_P2P_SERVICE": {
                return "android.net.wifi.p2p.WifiP2pManager";
            }
            case "WIFI_RTT_RANGING_SERVICE": {
                return "android.net.wifi.rtt.WifiRttManager";
            }
            case "WIFI_SERVICE": {
                return "android.net.wifi.WifiManager";
            }
            case "WINDOW_SERVICE": {
                return "android.view.WindowManager";
            }
        }
        return null;
    }
}

