/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.resources.ResourceFolderType;
import com.android.tools.lint.detector.api.BinaryResourceScanner;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.ResourceContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import com.android.utils.XmlUtils;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\u0018\u0000 (2\u00020\u00012\u00020\u00022\u00020\u0003:\u0002'(B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u001dH\u0016J\u0018\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\u0018\u0010\"\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000e0$H\u0016J\u0018\u0010%\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020!H\u0016R \u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR&\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006)"}, d2={"Lcom/android/tools/lint/checks/TileProviderDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "Lcom/android/tools/lint/detector/api/BinaryResourceScanner;", "()V", "foundIconLocations", "", "Lcom/android/tools/lint/detector/api/Location;", "getFoundIconLocations", "()Ljava/util/List;", "setFoundIconLocations", "(Ljava/util/List;)V", "foundIcons", "", "", "Lcom/android/tools/lint/checks/TileProviderDetector$IconInfo;", "getFoundIcons", "()Ljava/util/Map;", "setFoundIcons", "(Ljava/util/Map;)V", "afterCheckRootProject", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "appliesTo", "", "folderType", "Lcom/android/resources/ResourceFolderType;", "checkBinaryResource", "Lcom/android/tools/lint/detector/api/ResourceContext;", "checkResourcesWithIcons", "Lcom/android/tools/lint/detector/api/XmlContext;", "service", "Lorg/w3c/dom/Element;", "checkTileProvider", "getApplicableElements", "", "visitElement", "element", "IconInfo", "Issues", "android.sdktools.lint-checks"})
public final class TileProviderDetector
extends Detector
implements XmlScanner,
BinaryResourceScanner {
    @NotNull
    public static final Issues Issues = new Issues(null);
    @NotNull
    private Map<String, IconInfo> foundIcons = new LinkedHashMap();
    @NotNull
    private List<Location> foundIconLocations = new ArrayList();
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(TileProviderDetector.class, EnumSet.of((Enum)Scope.BINARY_RESOURCE_FILE, (Enum)Scope.MANIFEST));
    @JvmField
    @NotNull
    public static final Issue TILE_PROVIDER_PERMISSIONS;
    @JvmField
    @NotNull
    public static final Issue SQUARE_AND_ROUND_TILE_PREVIEWS;
    @NotNull
    public static final String BIND_TILE_PROVIDER_PERMISSION = "com.google.android.wearable.permission.BIND_TILE_PROVIDER";
    @NotNull
    public static final String TILES_PREVIEW_ATTR_NAME = "androidx.wear.tiles.PREVIEW";
    @NotNull
    public static final String BIND_TILE_PROVIDER_ACTION = "androidx.wear.tiles.action.BIND_TILE_PROVIDER";

    @NotNull
    public final Map<String, IconInfo> getFoundIcons() {
        return this.foundIcons;
    }

    public final void setFoundIcons(@NotNull Map<String, IconInfo> map2) {
        Intrinsics.checkNotNullParameter(map2, (String)"<set-?>");
        this.foundIcons = map2;
    }

    @NotNull
    public final List<Location> getFoundIconLocations() {
        return this.foundIconLocations;
    }

    public final void setFoundIconLocations(@NotNull List<Location> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
        this.foundIconLocations = list2;
    }

    @Override
    public void afterCheckRootProject(@NotNull Context context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        for (Map.Entry<String, IconInfo> entry : this.foundIcons.entrySet()) {
            String icon = entry.getKey();
            IconInfo metadata = entry.getValue();
            if (metadata.getFoundRoundPreview() && metadata.getFoundSquarePreview()) continue;
            context2.report(new Incident(SQUARE_AND_ROUND_TILE_PREVIEWS, metadata.getIssueScope(), metadata.getIssueLocation(), "Tiles need a preview asset in both drawable-round and drawable"));
        }
    }

    @NotNull
    public List<String> getApplicableElements() {
        return CollectionsKt.listOf((Object)"service");
    }

    @Override
    public void visitElement(@NotNull XmlContext context2, @NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Iterator iterator = TileProviderDetector.Issues.subElementsByTag(element, "intent-filter");
        while (iterator.hasNext()) {
            Element intentFilter = (Element)iterator.next();
            Iterator iterator2 = TileProviderDetector.Issues.subElementsByTag(intentFilter, "action");
            while (iterator2.hasNext()) {
                Element action = (Element)iterator2.next();
                if (!Intrinsics.areEqual((Object)action.getAttributeNS("http://schemas.android.com/apk/res/android", "name"), (Object)BIND_TILE_PROVIDER_ACTION)) continue;
                this.checkTileProvider(context2, element);
                this.checkResourcesWithIcons(context2, element);
            }
        }
    }

    @Override
    public boolean appliesTo(@NotNull ResourceFolderType folderType) {
        Intrinsics.checkNotNullParameter((Object)folderType, (String)"folderType");
        return folderType == ResourceFolderType.DRAWABLE;
    }

    @Override
    public void checkBinaryResource(@NotNull ResourceContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        String iconFileName = context2.file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)iconFileName, (String)"iconFileName");
        String iconName = StringsKt.dropLast((String)iconFileName, (int)(StringsKt.substringAfterLast$default((String)iconFileName, (String)".", null, (int)2, null).length() + 1));
        String dirName = context2.file.getParentFile().getName();
        Intrinsics.checkNotNullExpressionValue((Object)dirName, (String)"dirName");
        if (StringsKt.startsWith$default((String)dirName, (String)"drawable-round", (boolean)false, (int)2, null)) {
            IconInfo iconInfo = this.foundIcons.get(iconName);
            if (iconInfo != null) {
                iconInfo.setFoundRoundPreview(true);
            }
        } else if (StringsKt.startsWith$default((String)dirName, (String)"drawable", (boolean)false, (int)2, null)) {
            IconInfo iconInfo = this.foundIcons.get(iconName);
            if (iconInfo != null) {
                iconInfo.setFoundSquarePreview(true);
            }
        }
    }

    private final void checkResourcesWithIcons(XmlContext context2, Element service) {
        Element foundMetaData = null;
        Iterator iterator = TileProviderDetector.Issues.subElementsByTag(service, "meta-data");
        while (iterator.hasNext()) {
            String iconName;
            Attr iconAttr;
            Element metaData = (Element)iterator.next();
            if (!Intrinsics.areEqual((Object)metaData.getAttributeNS("http://schemas.android.com/apk/res/android", "name"), (Object)TILES_PREVIEW_ATTR_NAME) || (foundMetaData = metaData).getAttributeNodeNS("http://schemas.android.com/apk/res/android", "resource") == null) continue;
            String iconUrl = iconAttr.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)iconUrl, (String)"iconUrl");
            if (!StringsKt.startsWith$default((String)iconUrl, (String)"@drawable/", (boolean)false, (int)2, null)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)iconUrl.substring(10), (String)"this as java.lang.String).substring(startIndex)");
            this.foundIcons.put(iconName, new IconInfo(foundMetaData, context2.getValueLocation(iconAttr), false, false, 12, null));
        }
        if (foundMetaData == null) {
            context2.report(new Incident(SQUARE_AND_ROUND_TILE_PREVIEWS, service, context2.getLocation(service), "Tiles need preview assets"));
        }
    }

    private final void checkTileProvider(XmlContext context2, Element service) {
        String permission = service.getAttributeNS("http://schemas.android.com/apk/res/android", "permission");
        if (!Intrinsics.areEqual((Object)permission, (Object)BIND_TILE_PROVIDER_PERMISSION)) {
            LintFix.SetAttributeBuilder setAttributeBuilder = this.fix().set().attribute("permission").value(BIND_TILE_PROVIDER_PERMISSION).android();
            Intrinsics.checkNotNullExpressionValue((Object)permission, (String)"permission");
            LintFix fix = setAttributeBuilder.name(((CharSequence)permission).length() == 0 ? "Add BIND_TILE_PROVIDER permission" : "Change permission to BIND_TILE_PROVIDER").build();
            context2.report(new Incident(TILE_PROVIDER_PERMISSIONS, service, context2.getNameLocation(service), "TileProvider does not specify BIND_TILE_PROVIDER permission", fix));
        }
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.SECURITY;
        Severity severity = Severity.WARNING;
        Implementation implementation = new Implementation(TileProviderDetector.class, Scope.MANIFEST_SCOPE);
        TILE_PROVIDER_PERMISSIONS = Issue.Companion.create$default(companion, "TileProviderPermissions", "TileProvider does not set permission", "\n                TileProviders should require the `com.google.android.wearable.permission.BIND_TILE_PROVIDER` \\\n                permission to prevent arbitrary apps from binding to it.\n            ", implementation, null, category, 6, severity, false, true, null, null, 3344, null);
        companion = Issue.Companion;
        category = Category.ICONS;
        severity = Severity.WARNING;
        implementation = IMPLEMENTATION;
        SQUARE_AND_ROUND_TILE_PREVIEWS = Issue.Companion.create$default(companion, "SquareAndRoundTilePreviews", "TileProvider does not have round and square previews", "\n                Tile projects should specify preview resources for different screen shapes. \\\n                The preview resource is specified in the manifest under tile service. \\\n                And you have to make sure they have resources for different screen shapes.\n            ", implementation, null, category, 6, severity, false, true, null, null, 3344, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0012B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0010\u0010\n\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/lint/checks/TileProviderDetector$Issues;", "", "()V", "BIND_TILE_PROVIDER_ACTION", "", "BIND_TILE_PROVIDER_PERMISSION", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "getIMPLEMENTATION", "()Lcom/android/tools/lint/detector/api/Implementation;", "SQUARE_AND_ROUND_TILE_PREVIEWS", "Lcom/android/tools/lint/detector/api/Issue;", "TILES_PREVIEW_ATTR_NAME", "TILE_PROVIDER_PERMISSIONS", "subElementsByTag", "", "Lorg/w3c/dom/Element;", "tag", "TagIterator", "android.sdktools.lint-checks"})
    public static final class Issues {
        private Issues() {
        }

        @NotNull
        public final Implementation getIMPLEMENTATION() {
            return IMPLEMENTATION;
        }

        private final Iterator<Element> subElementsByTag(Element $this$subElementsByTag, String tag) {
            return new TagIterator($this$subElementsByTag, tag);
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000e\u001a\u00020\u000fH\u0096\u0002J\t\u0010\u0010\u001a\u00020\u0002H\u0096\u0002R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\u0002X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/lint/checks/TileProviderDetector$Issues$TagIterator;", "", "Lorg/w3c/dom/Element;", "element", "tag", "", "(Lorg/w3c/dom/Element;Ljava/lang/String;)V", "subElement", "getSubElement", "()Lorg/w3c/dom/Element;", "setSubElement", "(Lorg/w3c/dom/Element;)V", "getTag", "()Ljava/lang/String;", "hasNext", "", "next", "android.sdktools.lint-checks"})
        public static final class TagIterator
        implements Iterator<Element>,
        KMappedMarker {
            @NotNull
            private final String tag;
            @Nullable
            private Element subElement;

            public TagIterator(@NotNull Element element, @NotNull String tag) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
                this.tag = tag;
                this.subElement = XmlUtils.getFirstSubTagByName((Node)element, (String)this.tag);
            }

            @NotNull
            public final String getTag() {
                return this.tag;
            }

            @Nullable
            public final Element getSubElement() {
                return this.subElement;
            }

            public final void setSubElement(@Nullable Element element) {
                this.subElement = element;
            }

            @Override
            public boolean hasNext() {
                return this.subElement != null;
            }

            @Override
            @NotNull
            public Element next() {
                Element tmp = this.subElement;
                this.subElement = XmlUtils.getNextTagByName((Node)this.subElement, (String)this.tag);
                Element element = tmp;
                Intrinsics.checkNotNull((Object)element);
                return element;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0014\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0007H\u00c6\u0003J1\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u00072\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\b\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000b\"\u0004\b\u000f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001f"}, d2={"Lcom/android/tools/lint/checks/TileProviderDetector$IconInfo;", "", "issueScope", "Lorg/w3c/dom/Node;", "issueLocation", "Lcom/android/tools/lint/detector/api/Location;", "foundRoundPreview", "", "foundSquarePreview", "(Lorg/w3c/dom/Node;Lcom/android/tools/lint/detector/api/Location;ZZ)V", "getFoundRoundPreview", "()Z", "setFoundRoundPreview", "(Z)V", "getFoundSquarePreview", "setFoundSquarePreview", "getIssueLocation", "()Lcom/android/tools/lint/detector/api/Location;", "getIssueScope", "()Lorg/w3c/dom/Node;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "", "android.sdktools.lint-checks"})
    public static final class IconInfo {
        @NotNull
        private final Node issueScope;
        @NotNull
        private final Location issueLocation;
        private boolean foundRoundPreview;
        private boolean foundSquarePreview;

        public IconInfo(@NotNull Node issueScope, @NotNull Location issueLocation, boolean foundRoundPreview, boolean foundSquarePreview) {
            Intrinsics.checkNotNullParameter((Object)issueScope, (String)"issueScope");
            Intrinsics.checkNotNullParameter((Object)issueLocation, (String)"issueLocation");
            this.issueScope = issueScope;
            this.issueLocation = issueLocation;
            this.foundRoundPreview = foundRoundPreview;
            this.foundSquarePreview = foundSquarePreview;
        }

        public /* synthetic */ IconInfo(Node node, Location location2, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl = false;
            }
            if ((n & 8) != 0) {
                bl2 = false;
            }
            this(node, location2, bl, bl2);
        }

        @NotNull
        public final Node getIssueScope() {
            return this.issueScope;
        }

        @NotNull
        public final Location getIssueLocation() {
            return this.issueLocation;
        }

        public final boolean getFoundRoundPreview() {
            return this.foundRoundPreview;
        }

        public final void setFoundRoundPreview(boolean bl) {
            this.foundRoundPreview = bl;
        }

        public final boolean getFoundSquarePreview() {
            return this.foundSquarePreview;
        }

        public final void setFoundSquarePreview(boolean bl) {
            this.foundSquarePreview = bl;
        }

        @NotNull
        public final Node component1() {
            return this.issueScope;
        }

        @NotNull
        public final Location component2() {
            return this.issueLocation;
        }

        public final boolean component3() {
            return this.foundRoundPreview;
        }

        public final boolean component4() {
            return this.foundSquarePreview;
        }

        @NotNull
        public final IconInfo copy(@NotNull Node issueScope, @NotNull Location issueLocation, boolean foundRoundPreview, boolean foundSquarePreview) {
            Intrinsics.checkNotNullParameter((Object)issueScope, (String)"issueScope");
            Intrinsics.checkNotNullParameter((Object)issueLocation, (String)"issueLocation");
            return new IconInfo(issueScope, issueLocation, foundRoundPreview, foundSquarePreview);
        }

        public static /* synthetic */ IconInfo copy$default(IconInfo iconInfo, Node node, Location location2, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                node = iconInfo.issueScope;
            }
            if ((n & 2) != 0) {
                location2 = iconInfo.issueLocation;
            }
            if ((n & 4) != 0) {
                bl = iconInfo.foundRoundPreview;
            }
            if ((n & 8) != 0) {
                bl2 = iconInfo.foundSquarePreview;
            }
            return iconInfo.copy(node, location2, bl, bl2);
        }

        @NotNull
        public String toString() {
            return "IconInfo(issueScope=" + this.issueScope + ", issueLocation=" + this.issueLocation + ", foundRoundPreview=" + this.foundRoundPreview + ", foundSquarePreview=" + this.foundSquarePreview + ")";
        }

        public int hashCode() {
            int result = this.issueScope.hashCode();
            result = result * 31 + this.issueLocation.hashCode();
            int n = this.foundRoundPreview ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result = result * 31 + n;
            int n2 = this.foundSquarePreview ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            result = result * 31 + n2;
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof IconInfo)) {
                return false;
            }
            IconInfo iconInfo = (IconInfo)other;
            if (!Intrinsics.areEqual((Object)this.issueScope, (Object)iconInfo.issueScope)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.issueLocation, (Object)iconInfo.issueLocation)) {
                return false;
            }
            if (this.foundRoundPreview != iconInfo.foundRoundPreview) {
                return false;
            }
            return this.foundSquarePreview == iconInfo.foundSquarePreview;
        }
    }
}

