/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.DataFlowAnalyzer;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.PartialResult;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import com.android.utils.DomExtensions;
import com.intellij.psi.PsiMethod;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.UastVisitor;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 )2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001)B\u0005\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000bH\u0002J\u0018\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0017H\u0016J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0017H\u0016J\u001a\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u001a2\u0006\u0010\u001b\u001a\u00020\bJ$\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u001d2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000bH\u0002J.\u0010\u001e\u001a\u0018\u0012\u0004\u0012\u00020 \u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u001f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u000e\u001a\u00020#H\u0002J \u0010$\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020#2\u0006\u0010!\u001a\u00020\"2\u0006\u0010%\u001a\u00020&H\u0016J\u0018\u0010'\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020(2\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006*"}, d2={"Lcom/android/tools/lint/checks/UnsafeImplicitIntentDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "()V", "addActions", "", "element", "Lorg/w3c/dom/Element;", "actions", "", "", "buildQuickFix", "Lcom/android/tools/lint/detector/api/LintFix;", "context", "Lcom/android/tools/lint/detector/api/Context;", "location", "Lcom/android/tools/lint/detector/api/Location;", "longClassName", "checkPartialResults", "partialResults", "Lcom/android/tools/lint/detector/api/PartialResult;", "getApplicableConstructorTypes", "", "getApplicableElements", "getElementsAndGetActions", "", "root", "getPackageNameAndClassName", "Lkotlin/Pair;", "isIntentImplicit", "Lkotlin/Triple;", "", "node", "Lorg/jetbrains/uast/UCallExpression;", "Lcom/android/tools/lint/detector/api/JavaContext;", "visitConstructor", "constructor", "Lcom/intellij/psi/PsiMethod;", "visitElement", "Lcom/android/tools/lint/detector/api/XmlContext;", "Companion", "android.sdktools.lint-checks"})
public final class UnsafeImplicitIntentDetector
extends Detector
implements SourceCodeScanner,
XmlScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String LOCATIONS_KEY = "locations";
    @NotNull
    private static final String INTENTS_KEY = "intents";
    @NotNull
    private static final String ACTIONS_KEY = "actions";
    @NotNull
    private static final String PACKAGES_KEY = "packages";
    @NotNull
    private static final Implementation IMPLEMENTATION;
    @JvmField
    @NotNull
    public static final Issue ISSUE;

    @Override
    @NotNull
    public List<String> getApplicableConstructorTypes() {
        return CollectionsKt.listOf((Object)"android.content.Intent");
    }

    @NotNull
    public List<String> getApplicableElements() {
        Object[] objectArray = new String[]{"activity", "receiver"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    public void visitElement(@NotNull XmlContext context2, @NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (context2.isGlobalAnalysis()) {
            return;
        }
        Attr exported = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "exported");
        if (exported == null || Intrinsics.areEqual((Object)"false", (Object)exported.getValue())) {
            String action;
            String packageName = element.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
            Element element2 = DomExtensions.subtag((Element)element, (String)"intent-filter");
            if (element2 == null) {
                return;
            }
            Element intentFilter = element2;
            Element element3 = DomExtensions.subtag((Element)intentFilter, (String)"action");
            String string = action = element3 != null ? element3.getAttributeNS("http://schemas.android.com/apk/res/android", "name") : null;
            if (action != null) {
                LintMap lintMap = context2.getPartialResults(ISSUE).map();
                LintMap lintMap2 = lintMap.getMap(ACTIONS_KEY);
                if (lintMap2 == null) {
                    lintMap2 = new LintMap();
                }
                LintMap actions = lintMap2;
                actions.put(action, action);
                lintMap.put(ACTIONS_KEY, actions);
                LintMap lintMap3 = lintMap.getMap(PACKAGES_KEY);
                if (lintMap3 == null) {
                    lintMap3 = new LintMap();
                }
                LintMap packages = lintMap3;
                Intrinsics.checkNotNullExpressionValue((Object)packageName, (String)"packageName");
                packages.put(action, packageName);
                lintMap.put(PACKAGES_KEY, packages);
            }
        }
    }

    @Override
    public void visitConstructor(@NotNull JavaContext context2, @NotNull UCallExpression node, @NotNull PsiMethod constructor) {
        String action;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
        String[] stringArray = new String[]{"android.content.Context", "java.lang.Class"};
        if (context2.getEvaluator().parametersMatch(constructor, stringArray)) {
            return;
        }
        UExpression uExpression = (UExpression)CollectionsKt.firstOrNull((List)node.getValueArguments());
        if (uExpression != null) {
            UExpression it = uExpression;
            boolean bl = false;
            v1 = ConstantEvaluator.evaluateString(context2, (UElement)it, false);
        } else {
            v1 = action = null;
        }
        if (context2.isGlobalAnalysis()) {
            String actualAction;
            Project mainProject = context2.getMainProject();
            Document mergedManifest = mainProject.getMergedManifest();
            if (mergedManifest == null || mergedManifest.getDocumentElement() == null) {
                return;
            }
            Element element = mergedManifest.getDocumentElement();
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"mergedManifest.documentElement");
            Map<String, String> actions = this.getElementsAndGetActions(element);
            Triple<Boolean, String, Location> bl = this.isIntentImplicit(node, context2);
            boolean isIntentImplicit2 = (Boolean)bl.component1();
            String actionFromSetAction = (String)bl.component2();
            Location location2 = (Location)bl.component3();
            String string = actionFromSetAction;
            if (string == null) {
                string = actualAction = action;
            }
            if (isIntentImplicit2) {
                if (!actions.containsKey(actualAction)) {
                    return;
                }
                String message2 = StringsKt.trimIndent((String)("\n                This intent matches an internal non-exported component.\n                If you are trying to invoke the component matching the action `" + actualAction + "`,\n                then you should use an explicit intent.\n                "));
                Location location3 = location2;
                if (location3 == null) {
                    location3 = context2.getLocation((UElement)node);
                }
                Location actualLocation = location3;
                Context context3 = context2;
                String string2 = actions.get(actualAction);
                Intrinsics.checkNotNull((Object)string2);
                context2.report(new Incident(ISSUE, actualLocation, message2, this.buildQuickFix(context3, actualLocation, string2)));
            }
        } else {
            Triple<Boolean, String, Location> triple = this.isIntentImplicit(node, context2);
            boolean isIntentImplicit3 = (Boolean)triple.component1();
            String actionFromSetAction = (String)triple.component2();
            Location location4 = (Location)triple.component3();
            String string = actionFromSetAction;
            if (string == null && (string = action) == null) {
                return;
            }
            String actualAction = string;
            if (isIntentImplicit3) {
                LintMap lintMap = context2.getPartialResults(ISSUE).map();
                LintMap lintMap2 = lintMap.getMap(INTENTS_KEY);
                if (lintMap2 == null) {
                    lintMap2 = new LintMap();
                }
                LintMap intents = lintMap2;
                intents.put(actualAction, actualAction);
                lintMap.put(INTENTS_KEY, intents);
                if (location4 != null) {
                    LintMap lintMap3 = lintMap.getMap(LOCATIONS_KEY);
                    if (lintMap3 == null) {
                        lintMap3 = new LintMap();
                    }
                    LintMap locations = lintMap3;
                    locations.put(actualAction, location4);
                    lintMap.put(LOCATIONS_KEY, locations);
                } else {
                    LintMap lintMap4 = lintMap.getMap(LOCATIONS_KEY);
                    if (lintMap4 == null) {
                        lintMap4 = new LintMap();
                    }
                    LintMap locations = lintMap4;
                    locations.put(actualAction, context2.getLocation((UElement)node));
                    lintMap.put(LOCATIONS_KEY, locations);
                }
            }
        }
    }

    @NotNull
    public final Map<String, String> getElementsAndGetActions(@NotNull Element root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Element element = DomExtensions.subtag((Element)root, (String)"application");
        if (element == null) {
            return MapsKt.emptyMap();
        }
        Element application = element;
        HashMap actions = new HashMap();
        Iterator iterator = DomExtensions.iterator((Element)application);
        while (iterator.hasNext()) {
            Element component = (Element)iterator.next();
            String string = component.getTagName();
            if (!(Intrinsics.areEqual((Object)string, (Object)"activity") ? true : Intrinsics.areEqual((Object)string, (Object)"receiver"))) continue;
            this.addActions(component, actions);
        }
        return actions;
    }

    private final void addActions(Element element, Map<String, String> actions) {
        Attr exported = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "exported");
        String componentName = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name").getValue();
        Attr attr = exported;
        if (!Intrinsics.areEqual((Object)(attr != null ? attr.getValue() : null), (Object)"true")) {
            Element element2 = DomExtensions.subtag((Element)element, (String)"intent-filter");
            if (element2 == null) {
                return;
            }
            Element intentFilter = element2;
            Element element3 = DomExtensions.subtag((Element)intentFilter, (String)"action");
            String string = element3 != null ? element3.getAttributeNS("http://schemas.android.com/apk/res/android", "name") : null;
            if (string == null) {
                return;
            }
            String action = string;
            Intrinsics.checkNotNullExpressionValue((Object)componentName, (String)"componentName");
            actions.put(action, componentName);
        }
    }

    @Override
    public void checkPartialResults(@NotNull Context context2, @NotNull PartialResult partialResults) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)partialResults, (String)"partialResults");
        LintMap lintMap = partialResults.map().getMap(ACTIONS_KEY);
        if (lintMap == null) {
            return;
        }
        LintMap actions = lintMap;
        LintMap lintMap2 = partialResults.map().getMap(INTENTS_KEY);
        if (lintMap2 == null) {
            return;
        }
        LintMap intents = lintMap2;
        LintMap lintMap3 = partialResults.map().getMap(LOCATIONS_KEY);
        if (lintMap3 == null) {
            return;
        }
        LintMap locations = lintMap3;
        LintMap lintMap4 = partialResults.map().getMap(PACKAGES_KEY);
        if (lintMap4 == null) {
            return;
        }
        LintMap packages = lintMap4;
        for (String intent : intents) {
            Location location2;
            String intentAction = intents.get(intent);
            if (intentAction == null || !actions.containsKey(intentAction)) continue;
            String message2 = StringsKt.trimIndent((String)("\n            This intent matches an internal non-exported component.\n            If you are trying to invoke the component matching the action `" + intentAction + "`,\n            then you should use an explicit intent.\n            "));
            Location location3 = location2 = locations.getLocation(intent);
            Intrinsics.checkNotNull((Object)location3);
            String string = packages.get(intentAction);
            Intrinsics.checkNotNull((Object)string);
            context2.report(new Incident(ISSUE, location3, message2, this.buildQuickFix(context2, location2, string)));
        }
    }

    private final Triple<Boolean, String, Location> isIntentImplicit(UCallExpression node, JavaContext context2) {
        Ref.ObjectRef location2;
        Ref.ObjectRef action;
        Ref.BooleanRef isIntentImplicit2;
        block0: {
            UMethod parent;
            isIntentImplicit2 = new Ref.BooleanRef();
            isIntentImplicit2.element = true;
            action = new Ref.ObjectRef();
            location2 = new Ref.ObjectRef();
            Set set = SetsKt.setOf((Object)node);
            DataFlowAnalyzer visitor2 = new DataFlowAnalyzer(isIntentImplicit2, (Ref.ObjectRef<String>)action, (Ref.ObjectRef<Location>)location2, context2, set){
                final /* synthetic */ Ref.BooleanRef $isIntentImplicit;
                final /* synthetic */ Ref.ObjectRef<String> $action;
                final /* synthetic */ Ref.ObjectRef<Location> $location;
                final /* synthetic */ JavaContext $context;
                {
                    this.$isIntentImplicit = $isIntentImplicit;
                    this.$action = $action;
                    this.$location = $location;
                    this.$context = $context;
                    super($super_call_param$1, null, 2, null);
                }

                public void receiver(@NotNull UCallExpression call) {
                    Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                    if (Intrinsics.areEqual((Object)call.getMethodName(), (Object)"setComponent") || Intrinsics.areEqual((Object)call.getMethodName(), (Object)"setClass") || Intrinsics.areEqual((Object)call.getMethodName(), (Object)"setPackage") || Intrinsics.areEqual((Object)call.getMethodName(), (Object)"setClassName")) {
                        this.$isIntentImplicit.element = false;
                    }
                    if (Intrinsics.areEqual((Object)call.getMethodName(), (Object)"setAction")) {
                        this.$action.element = UastUtils.evaluateString((UExpression)((UExpression)call.getValueArguments().get(0)));
                        this.$location.element = this.$context.getLocation((UElement)call);
                    }
                }
            };
            UMethod uMethod = parent = (UMethod)UastUtils.getParentOfType$default((UElement)((UElement)node), UMethod.class, (boolean)false, (int)2, null);
            if (uMethod == null) break block0;
            uMethod.accept((UastVisitor)visitor2);
        }
        return new Triple((Object)isIntentImplicit2.element, action.element, location2.element);
    }

    private final LintFix buildQuickFix(Context context2, Location location2, String longClassName) {
        Pair<String, String> pair2 = this.getPackageNameAndClassName(context2, longClassName);
        String packageName = (String)pair2.component1();
        String className = (String)pair2.component2();
        String explicitifyWithClassName = ".setClassName(\"" + packageName + "\", \"" + packageName + "." + className + "\")";
        String explicitifyWithPackage = ".setPackage(\"" + packageName + "\")";
        LintFix setPackage = LintFix.Companion.create().name("Set package name").replace().reformat(true).range(location2).end().with(explicitifyWithPackage).build();
        LintFix setClassName = LintFix.Companion.create().name("Set class name").replace().reformat(true).range(location2).end().with(explicitifyWithClassName).build();
        LintFix[] lintFixArray = new LintFix[]{setPackage, setClassName};
        return this.fix().alternatives(lintFixArray);
    }

    private final Pair<String, String> getPackageNameAndClassName(Context context2, String longClassName) {
        int lastDot = StringsKt.lastIndexOf$default((CharSequence)longClassName, (char)'.', (int)0, (boolean)false, (int)6, null);
        String string = longClassName.substring(0, lastDot);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        String subpackage = string;
        String string2 = longClassName.substring(lastDot + 1, longClassName.length());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        String className = string2;
        String packageName = "";
        packageName = lastDot <= 0 ? context2.getProject().getPackage() : subpackage;
        return new Pair((Object)packageName, (Object)className);
    }

    static {
        Object object = new EnumSet[]{Scope.JAVA_FILE_SCOPE};
        IMPLEMENTATION = new Implementation((Class<? extends Detector>)UnsafeImplicitIntentDetector.class, (EnumSet<Scope>)EnumSet.of((Enum)Scope.JAVA_FILE, (Enum)Scope.MANIFEST), (EnumSet<Scope>)object);
        object = Issue.Companion;
        Category category = Category.SECURITY;
        Severity severity = Severity.ERROR;
        Implementation implementation = IMPLEMENTATION;
        ISSUE = Issue.Companion.create$default((Issue.Companion)object, "UnsafeImplicitIntentLaunch", "Implicit intent matches an internal non-exported component", "\n                    This intent matches a non-exported component within the same app. \\\n                    In many cases, the app developer could instead use an explicit Intent \\\n                    to send messages to their internal components, ensuring that the messages \\\n                    are safely delivered without exposure to malicious apps on the device. \\\n                    Using such implicit intents will result in a crash in an upcoming version of Android.\n                    ", implementation, "https://goo.gle/ImplicitIntentHijack", category, 9, severity, false, true, null, null, 3072, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/android/tools/lint/checks/UnsafeImplicitIntentDetector$Companion;", "", "()V", "ACTIONS_KEY", "", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "INTENTS_KEY", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "LOCATIONS_KEY", "PACKAGES_KEY", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

