/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.BroadcastReceiverUtils;
import com.android.tools.lint.checks.DataFlowAnalyzer;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.PartialResult;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.android.tools.lint.detector.api.UastLintUtilsKt;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import com.android.utils.DomExtensions;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.USwitchClauseExpression;
import org.jetbrains.uast.USwitchExpression;
import org.jetbrains.uast.UThisExpression;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastLiteralUtils;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 82\u00020\u00012\u00020\u00022\u00020\u0003:\u000289B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u0018\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\"\u0010\u0015\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00142\b\u0010\u0018\u001a\u0004\u0018\u00010\u0007H\u0002J \u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0012\u0010 \u001a\u00020\u00162\b\u0010!\u001a\u0004\u0018\u00010\u0007H\u0002J\u001e\u0010\"\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\u001bJ\u0018\u0010$\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u0010%\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J \u0010&\u001a\u00020\t2\u0006\u0010\n\u001a\u00020'2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u001c\u0010(\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\n\u0010)\u001a\u00060*R\u00020\u0000H\u0002J\"\u0010+\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00072\u0006\u0010,\u001a\u00020-H\u0002J\u0018\u0010.\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010/\u001a\u00020\u0007H\u0002J\u0018\u00100\u001a\u00020\t2\u0006\u0010\n\u001a\u00020'2\u0006\u00101\u001a\u000202H\u0016J\u0018\u00103\u001a\u00020\t2\u0006\u0010\n\u001a\u0002042\u0006\u00105\u001a\u00020\u0014H\u0016J \u00106\u001a\u00020\t2\u0006\u0010\n\u001a\u00020'2\u0006\u00107\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/android/tools/lint/checks/UnsafeIntentLaunchDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "()V", "registerReceiverMethods", "", "", "afterCheckRootProject", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "applicableSuperClasses", "checkPartialResults", "partialResults", "Lcom/android/tools/lint/detector/api/PartialResult;", "getApplicableElements", "getApplicableMethodNames", "getProtectedComponent", "component", "Lorg/w3c/dom/Element;", "isComponentExported", "", "root", "incidentComponent", "isParseUnsafeUri", "evaluator", "Lcom/android/tools/lint/client/api/JavaEvaluator;", "call", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "isProbablyProtectedBySignaturePermission", "permission", "isRuntimeReceiverProtected", "javaEvaluator", "isUnParcellingIntentMethods", "isUnParcellingStringMethods", "processRuntimeReceiver", "Lcom/android/tools/lint/detector/api/JavaContext;", "reportIncident", "visitor", "Lcom/android/tools/lint/checks/UnsafeIntentLaunchDetector$IntentLaunchChecker;", "reportIssue", "location", "Lcom/android/tools/lint/detector/api/Location;", "storeUnprotectedComponents", "unprotectedComponentName", "visitClass", "declaration", "Lorg/jetbrains/uast/UClass;", "visitElement", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "visitMethodCall", "node", "Companion", "IntentLaunchChecker", "android.sdktools.lint-checks"})
public final class UnsafeIntentLaunchDetector
extends Detector
implements SourceCodeScanner,
XmlScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<String> registerReceiverMethods = BroadcastReceiverUtils.INSTANCE.getBROADCAST_RECEIVER_METHOD_NAMES();
    @NotNull
    private static final Implementation IMPLEMENTATION;
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    private static final int RECEIVER_NOT_EXPORTED = 4;
    @NotNull
    private static final String KEY_UNPROTECTED = "unprotected";
    @NotNull
    private static final String KEY_INCIDENTS = "incidents";
    @NotNull
    private static final String KEY_INCIDENT_CLASS = "incidentClass";
    @NotNull
    private static final String KEY_LOCATION = "location";
    @NotNull
    private static final String KEY_SECONDARY_LOCATION = "secondaryLocation";
    @NotNull
    private static final String CONTEXT_CLASS = "android.content.Context";
    @NotNull
    private static final String ACTIVITY_CLASS = "android.app.Activity";
    @NotNull
    private static final String SERVICE_CLASS = "android.app.Service";
    @NotNull
    private static final String BROADCAST_RECEIVER_CLASS = "android.content.BroadcastReceiver";
    @NotNull
    private static final String PENDING_INTENT_CLASS = "android.app.PendingIntent";
    @NotNull
    private static final String INTENT_CLASS = "android.content.Intent";
    @NotNull
    private static final String BUNDLE_CLASS = "android.os.Bundle";
    @NotNull
    private static final String INTENT_COMPAT_CLASS = "androidx.core.content.IntentCompat";
    @NotNull
    private static final String BUNDLE_COMPAT_CLASS = "androidx.core.os.BundleCompat";
    @NotNull
    private static final String CONTEXT_COMPAT_CLASS = "androidx.core.content.ContextCompat";
    @NotNull
    private static final String ACTIVITY_COMPAT_CLASS = "androidx.core.app.ActivityCompat";
    private static final int MAX_CALL_DEPTH = 3;
    @NotNull
    private static final Map<String, String[]> UNSAFE_INTENT_AS_PARAMETER_METHODS;
    @NotNull
    private static final List<String> ACTIVITY_INTENT_LAUNCH_METHODS;
    @NotNull
    private static final List<String> PENDING_INTENT_LAUNCH_METHODS;
    @NotNull
    private static final String[] INTENT_METHODS_RETURNS_INTENT_BUT_NOT_SELF;
    @NotNull
    private static final List<String> KNOWN_NORMAL_PERMISSIONS;

    @Override
    @NotNull
    public List<String> getApplicableMethodNames() {
        Object[] objectArray = new String[]{"getParcelableExtra", "getParcelable", "getIntent", "parseUri"};
        return CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])objectArray), (Iterable)this.registerReceiverMethods);
    }

    @Override
    @NotNull
    public List<String> applicableSuperClasses() {
        Object[] objectArray = new String[]{ACTIVITY_CLASS, BROADCAST_RECEIVER_CLASS, SERVICE_CLASS};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public List<String> getApplicableElements() {
        Object[] objectArray = new String[]{"activity", "service", "receiver"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    public void visitElement(@NotNull XmlContext context2, @NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String string = this.getProtectedComponent(context2, element);
        if (string == null) {
            return;
        }
        this.storeUnprotectedComponents(context2, string);
    }

    /*
     * Unable to fully structure code
     */
    private final boolean isComponentExported(Context context, Element root, String incidentComponent) {
        v0 = DomExtensions.subtag((Element)root, (String)"application");
        if (v0 == null) {
            return false;
        }
        application = v0;
        var5_5 = DomExtensions.iterator((Element)application);
        block5: while (var5_5.hasNext()) {
            component = (Element)var5_5.next();
            var7_7 = component.getTagName();
            if (var7_7 == null) continue;
            switch (var7_7.hashCode()) {
                case -1655966961: {
                    if (!var7_7.equals("activity")) {
                        continue block5;
                    }
                    ** GOTO lbl21
                }
                case -808719889: {
                    if (!var7_7.equals("receiver")) {
                        continue block5;
                    }
                    ** GOTO lbl21
                }
                case 1984153269: {
                    if (!var7_7.equals("service")) continue block5;
lbl21:
                    // 3 sources

                    if (!Intrinsics.areEqual((Object)incidentComponent, (Object)this.getProtectedComponent(context, component))) continue block5;
                    return true;
                }
            }
        }
        return false;
    }

    private final String getProtectedComponent(Context context2, Element component) {
        block6: {
            String permission;
            block5: {
                String exportedAttr = component.getAttributeNS("http://schemas.android.com/apk/res/android", "exported");
                if (Intrinsics.areEqual((Object)"true", (Object)exportedAttr)) break block5;
                Intrinsics.checkNotNullExpressionValue((Object)exportedAttr, (String)"exportedAttr");
                if (!(((CharSequence)exportedAttr).length() == 0) || component.getElementsByTagName("intent-filter").getLength() <= 0) break block6;
            }
            if (!this.isProbablyProtectedBySignaturePermission(permission = component.getAttributeNS("http://schemas.android.com/apk/res/android", "permission"))) {
                Object componentName = component.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
                String string = componentName;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"componentName");
                if (StringsKt.startsWith$default((String)string, (String)".", (boolean)false, (int)2, null)) {
                    componentName = context2.getProject().getPackage() + (String)componentName;
                }
                return componentName;
            }
        }
        return null;
    }

    private final boolean isProbablyProtectedBySignaturePermission(String permission) {
        CharSequence charSequence = permission;
        return !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) && !KNOWN_NORMAL_PERMISSIONS.contains(permission);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void visitClass(@NotNull JavaContext context2, @NotNull UClass declaration) {
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        JavaEvaluator evaluator = context2.getEvaluator();
        if (evaluator.extendsClass(declaration.getJavaPsi(), ACTIVITY_CLASS, true)) {
            stringArray = UNSAFE_INTENT_AS_PARAMETER_METHODS.get(ACTIVITY_CLASS);
        } else if (evaluator.extendsClass(declaration.getJavaPsi(), SERVICE_CLASS, true)) {
            stringArray = UNSAFE_INTENT_AS_PARAMETER_METHODS.get(SERVICE_CLASS);
        } else {
            if (!evaluator.extendsClass(declaration.getJavaPsi(), BROADCAST_RECEIVER_CLASS, true)) return;
            stringArray = UNSAFE_INTENT_AS_PARAMETER_METHODS.get(BROADCAST_RECEIVER_CLASS);
        }
        if (stringArray == null) {
            return;
        }
        String[] methodNames = stringArray;
        int n = 0;
        int n2 = methodNames.length;
        while (n < n2) {
            PsiMethod[] psiMethodArray;
            String methodName = methodNames[n];
            Intrinsics.checkNotNullExpressionValue((Object)declaration.getJavaPsi().findMethodsByName(methodName, false), (String)"declaration.javaPsi.find\u2026ByName(methodName, false)");
            for (PsiMethod psiMethod : psiMethodArray) {
                UParameter intentParam;
                void $this$toUElementOfType$iv;
                void element$iv;
                PsiElement $this$firstOrNull$iv;
                UMethod method;
                block10: {
                    PsiElement $this$toUElementOfType$iv2 = (PsiElement)psiMethod;
                    boolean $i$f$toUElementOfType22 = false;
                    method = (UMethod)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv2, UMethod.class);
                    if (method == null) return;
                    PsiMethod $i$f$toUElementOfType22 = method.getJavaPsi();
                    if ($i$f$toUElementOfType22 == null) return;
                    PsiParameterList psiParameterList = $i$f$toUElementOfType22.getParameterList();
                    if (psiParameterList == null) return;
                    PsiParameter[] psiParameterArray = psiParameterList.getParameters();
                    if (psiParameterArray == null) return;
                    PsiParameter[] psiParameterArray2 = psiParameterArray;
                    boolean $i$f$firstOrNull = false;
                    int n3 = 0;
                    int n4 = ((void)$this$firstOrNull$iv).length;
                    while (n3 < n4) {
                        void it = element$iv = $this$firstOrNull$iv[n3];
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getType().getCanonicalText(), (Object)INTENT_CLASS)) {
                            ++n3;
                            continue;
                        }
                        break block10;
                    }
                    return;
                }
                Object v1 = element$iv;
                Object var17_19 = v1;
                if (var17_19 == null) return;
                $this$firstOrNull$iv = var17_19;
                boolean $i$f$toUElementOfType = false;
                UParameter uParameter = (UParameter)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UParameter.class);
                UParameter uParameter2 = intentParam = uParameter;
                if (uParameter2 == null) {
                    return;
                }
                Object[] objectArray = UNSAFE_INTENT_AS_PARAMETER_METHODS.get(BROADCAST_RECEIVER_CLASS);
                IntentLaunchChecker visitor2 = new IntentLaunchChecker(this, SetsKt.setOf(uParameter2), context2, Context.getLocation$default(context2, intentParam.getSourcePsi(), null, 2, null), null, false, false, false, 0, objectArray != null ? ArraysKt.contains((Object[])objectArray, (Object)methodName) : false, 248, null);
                method.accept((UastVisitor)visitor2);
                if (!visitor2.getLaunched()) continue;
                this.reportIncident(context2, visitor2);
            }
            ++n;
        }
    }

    @Override
    public void visitMethodCall(@NotNull JavaContext context2, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        JavaEvaluator evaluator = context2.getEvaluator();
        if (this.registerReceiverMethods.contains(method.getName()) && JavaEvaluator.isMemberInSubClassOf$default(evaluator, (PsiMember)method, CONTEXT_CLASS, false, 4, null)) {
            this.processRuntimeReceiver(context2, node, method);
        } else if (this.isUnParcellingIntentMethods(evaluator, method) | this.isParseUnsafeUri(evaluator, node, method)) {
            UMethod containingMethod;
            IntentLaunchChecker visitor2 = new IntentLaunchChecker(this, SetsKt.setOf((Object)node), context2, context2.getLocation((UElement)node), null, false, false, false, 0, false, 504, null);
            UMethod uMethod = containingMethod = (UMethod)UastUtils.getParentOfType$default((UElement)((UElement)node), UMethod.class, (boolean)false, (int)2, null);
            if (uMethod != null) {
                uMethod.accept((UastVisitor)visitor2);
            }
            if (visitor2.getLaunched()) {
                if (visitor2.getUnprotectedReceiver()) {
                    this.reportIssue(context2, null, visitor2.getLocation());
                } else {
                    this.reportIncident(context2, visitor2);
                }
            }
        }
    }

    private final boolean isParseUnsafeUri(JavaEvaluator evaluator, UCallExpression call, PsiMethod method) {
        if (Intrinsics.areEqual((Object)method.getName(), (Object)"parseUri") && evaluator.isMemberInClass((PsiMember)method, INTENT_CLASS)) {
            UExpression getUriStringCall;
            UExpression uExpression;
            UExpression intentArg;
            UExpression uExpression2 = call.getArgumentForParameter(0);
            Object object = intentArg = uExpression2 != null ? UastUtils.skipParenthesizedExprDown((UExpression)uExpression2) : null;
            if (intentArg instanceof USimpleNameReferenceExpression) {
                PsiElement psiElement = ((USimpleNameReferenceExpression)intentArg).resolve();
                PsiVariable psiVariable = psiElement instanceof PsiVariable ? (PsiVariable)psiElement : null;
                if (psiVariable == null) {
                    return false;
                }
                uExpression = UastLintUtils.Companion.findLastAssignment(psiVariable, (UElement)call);
            } else {
                uExpression = intentArg;
            }
            UExpression uExpression3 = getUriStringCall = uExpression;
            UElement uElement = uExpression3 != null ? UastLintUtilsKt.findSelector((UElement)uExpression3) : null;
            UCallExpression uCallExpression = uElement instanceof UCallExpression ? (UCallExpression)uElement : null;
            if (uCallExpression == null || (uCallExpression = uCallExpression.resolve()) == null) {
                return false;
            }
            UCallExpression getUriStringMethod = uCallExpression;
            return this.isUnParcellingStringMethods(evaluator, (PsiMethod)getUriStringMethod);
        }
        return false;
    }

    /*
     * WARNING - bad return control flow
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isUnParcellingIntentMethods(JavaEvaluator evaluator, PsiMethod method) {
        block6: {
            String string = method.getName();
            switch (string.hashCode()) {
                case 1712857305: {
                    if (string.equals("getParcelable")) break;
                    return false;
                }
                case 512252306: {
                    if (!string.equals("getIntent")) {
                        return false;
                    }
                    break block6;
                }
                case -1169415497: {
                    if (!string.equals("getParcelableExtra")) return false;
                    if (JavaEvaluator.isMemberInSubClassOf$default(evaluator, (PsiMember)method, INTENT_CLASS, false, 4, null)) return true;
                    if (!evaluator.isMemberInClass((PsiMember)method, INTENT_COMPAT_CLASS)) return false;
                    return true;
                }
            }
            if (JavaEvaluator.isMemberInSubClassOf$default(evaluator, (PsiMember)method, BUNDLE_CLASS, false, 4, null)) return true;
            if (!evaluator.isMemberInClass((PsiMember)method, BUNDLE_COMPAT_CLASS)) return false;
            return true;
            return false;
        }
        boolean bl = JavaEvaluator.isMemberInSubClassOf$default(evaluator, (PsiMember)method, CONTEXT_CLASS, false, 4, null);
        return bl;
    }

    private final boolean isUnParcellingStringMethods(JavaEvaluator evaluator, PsiMethod method) {
        return Intrinsics.areEqual((Object)method.getName(), (Object)"getStringExtra") && JavaEvaluator.isMemberInSubClassOf$default(evaluator, (PsiMember)method, INTENT_CLASS, false, 4, null) || Intrinsics.areEqual((Object)method.getName(), (Object)"getString") && JavaEvaluator.isMemberInSubClassOf$default(evaluator, (PsiMember)method, BUNDLE_CLASS, false, 4, null);
    }

    private final void processRuntimeReceiver(JavaContext context2, UCallExpression call, PsiMethod method) {
        UExpression uExpression = UastLintUtils.Companion.findArgument(call, method, BROADCAST_RECEIVER_CLASS);
        if (uExpression == null) {
            return;
        }
        UExpression receiverArg = uExpression;
        if (UastLiteralUtils.isNullLiteral((UElement)((UElement)receiverArg))) {
            return;
        }
        if (!this.isRuntimeReceiverProtected(call, method, context2.getEvaluator())) {
            UCallExpression receiverConstructor;
            UCallExpression uCallExpression = receiverConstructor = UastLintUtils.Companion.findConstruction(BROADCAST_RECEIVER_CLASS, receiverArg, (UElement)call, true);
            String string = UastUtils.getQualifiedName((UReferenceExpression)(uCallExpression != null ? uCallExpression.getClassReference() : null));
            if (string == null) {
                return;
            }
            String unprotectedReceiverClassName = string;
            this.storeUnprotectedComponents(context2, unprotectedReceiverClassName);
        }
    }

    public final boolean isRuntimeReceiverProtected(@NotNull UCallExpression call, @NotNull PsiMethod method, @NotNull JavaEvaluator javaEvaluator) {
        String permission;
        Integer flags;
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)javaEvaluator, (String)"javaEvaluator");
        UExpression flagsArg = UastLintUtils.Companion.findArgument(call, method, "int");
        ConstantEvaluator evaluator = new ConstantEvaluator().allowFieldInitializers();
        Object object = evaluator.evaluate((UElement)flagsArg);
        Integer n = flags = object instanceof Integer ? (Integer)object : null;
        if (flags != null && (flags & 4) != 0) {
            return true;
        }
        UExpression permissionArg = UastLintUtils.Companion.findArgument(call, method, "java.lang.String");
        Object object2 = evaluator.evaluate((UElement)permissionArg);
        String string = permission = object2 instanceof String ? (String)object2 : null;
        if (this.isProbablyProtectedBySignaturePermission(permission)) {
            return true;
        }
        UExpression uExpression = UastLintUtils.Companion.findArgument(call, method, "android.content.IntentFilter");
        if (uExpression == null) {
            return true;
        }
        UExpression filterArg = uExpression;
        boolean isProtected2 = (Boolean)BroadcastReceiverUtils.checkIsProtectedReceiverAndReturnUnprotectedActions(filterArg, call, javaEvaluator).component1();
        return isProtected2;
    }

    private final void storeUnprotectedComponents(Context context2, String unprotectedComponentName) {
        LintMap lintMap = context2.getPartialResults(ISSUE).map();
        LintMap lintMap2 = lintMap.getMap(KEY_UNPROTECTED);
        if (lintMap2 == null) {
            LintMap lintMap3;
            LintMap it = lintMap3 = this.map();
            boolean bl = false;
            lintMap.put(KEY_UNPROTECTED, it);
            lintMap2 = lintMap3;
        }
        LintMap unprotectedComponents = lintMap2;
        unprotectedComponents.put(unprotectedComponentName, true);
    }

    /*
     * WARNING - void declaration
     */
    private final void reportIncident(Context context2, IntentLaunchChecker visitor2) {
        if (context2.isGlobalAnalysis()) {
            String incidentComponent = visitor2.getIncidentClass();
            Document document = context2.getMainProject().getMergedManifest();
            Element element = document != null ? document.getDocumentElement() : null;
            if (element == null) {
                return;
            }
            if (this.isComponentExported(context2, element, incidentComponent)) {
                this.reportIssue(context2, incidentComponent, visitor2.getLocation());
            }
        } else {
            void $this$reportIncident_u24lambda_u243;
            LintMap lintMap;
            LintMap lintMap2;
            LintMap lintMap3 = context2.getPartialResults(ISSUE).map();
            LintMap lintMap4 = lintMap3.getMap(KEY_INCIDENTS);
            if (lintMap4 == null) {
                LintMap it = lintMap2 = this.map();
                boolean bl = false;
                lintMap3.put(KEY_INCIDENTS, it);
                lintMap4 = lintMap2;
            }
            LintMap incidents = lintMap4;
            lintMap2 = lintMap = this.map();
            String string = String.valueOf(incidents.getSize());
            LintMap lintMap5 = incidents;
            boolean bl = false;
            $this$reportIncident_u24lambda_u243.put(KEY_LOCATION, visitor2.getLocation());
            Location location2 = visitor2.getLocation().getSecondary();
            if (location2 == null) {
                return;
            }
            $this$reportIncident_u24lambda_u243.put(KEY_SECONDARY_LOCATION, location2);
            String string2 = visitor2.getIncidentClass();
            if (string2 == null) {
                return;
            }
            $this$reportIncident_u24lambda_u243.put(KEY_INCIDENT_CLASS, string2);
            Unit unit = Unit.INSTANCE;
            lintMap5.put(string, lintMap);
        }
    }

    @Override
    public void afterCheckRootProject(@NotNull Context context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (context2.isGlobalAnalysis()) {
            this.checkPartialResults(context2, context2.getPartialResults(ISSUE));
        }
    }

    @Override
    public void checkPartialResults(@NotNull Context context2, @NotNull PartialResult partialResults) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)partialResults, (String)"partialResults");
        LintMap lintMap = partialResults.map().getMap(KEY_INCIDENTS);
        if (lintMap == null) {
            return;
        }
        LintMap incidents = lintMap;
        LintMap lintMap2 = partialResults.map().getMap(KEY_UNPROTECTED);
        if (lintMap2 == null) {
            return;
        }
        LintMap unprotectedComponents = lintMap2;
        for (String key2 : incidents) {
            Location location2;
            Object incidentComponent;
            LintMap incidentMap = incidents.getMap(key2);
            Object object = incidentMap;
            if (object == null) continue;
            if ((object = ((LintMap)object).get(KEY_INCIDENT_CLASS)) == null || !unprotectedComponents.containsKey((String)(incidentComponent = object)) || incidentMap.getLocation(KEY_LOCATION) == null) continue;
            location2.setSecondary(incidentMap.getLocation(KEY_SECONDARY_LOCATION));
            this.reportIssue(context2, (String)incidentComponent, location2);
        }
    }

    private final void reportIssue(Context context2, String incidentComponent, Location location2) {
        CharSequence charSequence = incidentComponent;
        Object component = charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? "" : " " + incidentComponent;
        String message2 = StringsKt.trimIndent((String)("\n          This intent could be coming from an untrusted source. It is later launched by \\\n          an unprotected component" + (String)component + ". You could either make the component" + (String)component + " \\\n          protected; or sanitize this intent using androidx.core.content.IntentSanitizer.\n      "));
        context2.report(new Incident(ISSUE, location2, message2));
    }

    public static final /* synthetic */ List access$getRegisterReceiverMethods$p(UnsafeIntentLaunchDetector $this) {
        return $this.registerReceiverMethods;
    }

    static {
        Object[] objectArray = new EnumSet[]{Scope.JAVA_FILE_SCOPE};
        IMPLEMENTATION = new Implementation((Class<? extends Detector>)UnsafeIntentLaunchDetector.class, (EnumSet<Scope>)EnumSet.of((Enum)Scope.JAVA_FILE, (Enum)Scope.MANIFEST), (EnumSet<Scope>[])objectArray);
        objectArray = Issue.Companion;
        String[] stringArray = Category.SECURITY;
        Severity severity = Severity.WARNING;
        Implementation implementation = IMPLEMENTATION;
        ISSUE = Issue.Companion.create$default((Issue.Companion)objectArray, "UnsafeIntentLaunch", "Launched Unsafe Intent", "\n                    Intent that potentially could come from an untrusted source should not be \\\n                    launched from an unprotected component without first being sanitized. See \\\n                    this support FAQ for details: https://support.google.com/faqs/answer/9267555\n                    ", implementation, null, (Category)stringArray, 6, severity, false, true, null, null, 3344, null);
        objectArray = new Pair[3];
        stringArray = new String[]{"onReceive"};
        objectArray[0] = TuplesKt.to((Object)BROADCAST_RECEIVER_CLASS, (Object)stringArray);
        stringArray = new String[]{"onNewIntent", "onActivityResult", "onActivityReenter"};
        objectArray[1] = TuplesKt.to((Object)ACTIVITY_CLASS, (Object)stringArray);
        stringArray = new String[]{"onBind", "onUnbind", "onRebind", "onTaskRemoved", "onStartCommand", "onStart"};
        objectArray[2] = TuplesKt.to((Object)SERVICE_CLASS, (Object)stringArray);
        UNSAFE_INTENT_AS_PARAMETER_METHODS = MapsKt.mapOf((Pair[])objectArray);
        objectArray = new String[]{"createPendingResult", "navigateUpTo", "navigateUpToFromChild", "startActivityIfNeeded", "startActivityForResult", "startActivityFromChild", "startActivityFromFragment", "startIntentSender", "startIntentSenderFromChild", "startIntentSenderForResult", "startNextMatchingActivity", "setResult"};
        ACTIVITY_INTENT_LAUNCH_METHODS = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"getActivity", "getBroadcast", "getService", "getForegroundService"};
        PENDING_INTENT_LAUNCH_METHODS = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"cloneFilter", "getOriginalIntent", "getSelector", "getParcelableExtra"};
        INTENT_METHODS_RETURNS_INTENT_BUT_NOT_SELF = objectArray;
        objectArray = new String[]{"android.permission.READ_BASIC_PHONE_STATE", "android.permission.MANAGE_OWN_CALLS", "android.permission.CALL_COMPANION_APP", "android.permission.HIGH_SAMPLING_RATE_SENSORS", "android.permission.USE_FINGERPRINT", "android.permission.USE_BIOMETRIC", "android.permission.READ_PROFILE", "android.permission.WRITE_PROFILE", "android.permission.READ_SOCIAL_STREAM", "android.permission.WRITE_SOCIAL_STREAM", "android.permission.READ_USER_DICTIONARY", "android.permission.WRITE_USER_DICTIONARY", "android.permission.WRITE_SMS", "com.android.browser.permission.READ_HISTORY_BOOKMARKS", "com.android.browser.permission.WRITE_HISTORY_BOOKMARKS", "android.permission.AUTHENTICATE_ACCOUNTS", "android.permission.MANAGE_ACCOUNTS", "android.permission.USE_CREDENTIALS", "android.permission.SUBSCRIBED_FEEDS_READ", "android.permission.SUBSCRIBED_FEEDS_WRITE", "android.permission.FLASHLIGHT", "com.android.alarm.permission.SET_ALARM", "android.permission.ACCESS_LOCATION_EXTRA_COMMANDS", "android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE", "android.permission.ACCESS_WIFI_STATE", "android.permission.CHANGE_WIFI_STATE", "android.permission.BLUETOOTH", "android.permission.BLUETOOTH_ADMIN", "android.permission.NFC", "android.permission.NFC_TRANSACTION_EVENT", "android.permission.NFC_PREFERRED_PAYMENT_INFO", "android.permission.CHANGE_WIFI_MULTICAST_STATE", "android.permission.VIBRATE", "android.permission.WAKE_LOCK", "android.permission.TRANSMIT_IR", "android.permission.TURN_SCREEN_ON", "android.permission.MODIFY_AUDIO_SETTINGS", "android.permission.DISABLE_KEYGUARD", "android.permission.REQUEST_PASSWORD_COMPLEXITY", "android.permission.GET_TASKS", "android.permission.REORDER_TASKS", "android.permission.RESTART_PACKAGES", "android.permission.KILL_BACKGROUND_PROCESSES", "android.permission.REQUEST_COMPANION_RUN_IN_BACKGROUND", "android.permission.REQUEST_COMPANION_START_FOREGROUND_SERVICES_FROM_BACKGROUND", "android.permission.REQUEST_COMPANION_USE_DATA_IN_BACKGROUND", "android.permission.REQUEST_COMPANION_PROFILE_WATCH", "android.permission.HIDE_OVERLAY_WINDOWS", "android.permission.SET_WALLPAPER", "android.permission.SET_WALLPAPER_HINTS", "android.permission.EXPAND_STATUS_BAR", "com.android.launcher.permission.INSTALL_SHORTCUT", "com.android.launcher.permission.UNINSTALL_SHORTCUT", "android.permission.READ_SYNC_SETTINGS", "android.permission.WRITE_SYNC_SETTINGS", "android.permission.READ_SYNC_STATS", "android.permission.PERSISTENT_ACTIVITY", "android.permission.GET_PACKAGE_SIZE", "android.permission.RECEIVE_BOOT_COMPLETED", "android.permission.BROADCAST_STICKY", "android.permission.CHANGE_NETWORK_STATE", "android.permission.SCHEDULE_EXACT_ALARM", "android.permission.USE_EXACT_ALARM", "android.permission.REQUEST_DELETE_PACKAGES", "android.permission.REQUEST_OBSERVE_COMPANION_DEVICE_PRESENCE", "android.permission.DELIVER_COMPANION_MESSAGES", "android.permission.REQUEST_IGNORE_BATTERY_OPTIMIZATIONS", "android.permission.ACCESS_NOTIFICATION_POLICY", "android.permission.READ_INSTALL_SESSIONS", "android.permission.FOREGROUND_SERVICE", "android.permission.USE_FULL_SCREEN_INTENT", "android.permission.QUERY_ALL_PACKAGES", "android.permission.READ_NEARBY_STREAMING_POLICY", "android.permission.UPDATE_PACKAGES_WITHOUT_USER_ACTION"};
        KNOWN_NORMAL_PERMISSIONS = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u001d\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001:\u0001LBa\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\f\u0012\b\b\u0002\u0010\u000e\u001a\u00020\f\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u0012\b\b\u0002\u0010\u0011\u001a\u00020\f\u00a2\u0006\u0002\u0010\u0012J\u0018\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u0004H\u0016J\u0014\u00102\u001a\u0004\u0018\u0001002\b\u00103\u001a\u0004\u0018\u000104H\u0002J\u0012\u00105\u001a\u0004\u0018\u0001062\u0006\u00107\u001a\u000204H\u0002J\u0010\u00108\u001a\u00020\f2\u0006\u0010/\u001a\u000200H\u0002J \u00109\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u0004H\u0002J \u0010:\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u0004H\u0002J\u0018\u0010;\u001a\u00020\f2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u0004H\u0002J\u001a\u0010<\u001a\u00020\f2\b\u00103\u001a\u0004\u0018\u0001042\u0006\u0010=\u001a\u00020\u0004H\u0002J\u0018\u0010>\u001a\u00020\f2\u0006\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020BH\u0002J\u0018\u0010C\u001a\u00020\f2\u0006\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020BH\u0002J\u0018\u0010D\u001a\u00020\f2\u0006\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020BH\u0002J\u0018\u0010E\u001a\u00020\f2\u0006\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020BH\u0002J\u0018\u0010F\u001a\u00020\f2\u0006\u0010?\u001a\u00020@2\u0006\u0010/\u001a\u000200H\u0002J\u0012\u0010G\u001a\u00020\f2\b\u00103\u001a\u0004\u0018\u000104H\u0002J\u0010\u0010H\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0016J\u0010\u0010I\u001a\u00020.2\u0006\u00103\u001a\u00020JH\u0016J\u0010\u0010K\u001a\u00020\f2\u0006\u0010/\u001a\u000200H\u0016R\u001a\u0010\u0011\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0014\"\u0004\b \u0010\u0016R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001a\u0010\r\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u0014\"\u0004\b*\u0010\u0016R\u001a\u0010\u000e\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\u0014\"\u0004\b,\u0010\u0016\u00a8\u0006M"}, d2={"Lcom/android/tools/lint/checks/UnsafeIntentLaunchDetector$IntentLaunchChecker;", "Lcom/android/tools/lint/checks/DataFlowAnalyzer;", "initial", "", "Lorg/jetbrains/uast/UElement;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "location", "Lcom/android/tools/lint/detector/api/Location;", "incidentClass", "", "launched", "", "returned", "unprotectedReceiver", "resolveCallDepth", "", "checkProtectedBroadcast", "(Lcom/android/tools/lint/checks/UnsafeIntentLaunchDetector;Ljava/util/Collection;Lcom/android/tools/lint/detector/api/JavaContext;Lcom/android/tools/lint/detector/api/Location;Ljava/lang/String;ZZZIZ)V", "getCheckProtectedBroadcast", "()Z", "setCheckProtectedBroadcast", "(Z)V", "getContext", "()Lcom/android/tools/lint/detector/api/JavaContext;", "setContext", "(Lcom/android/tools/lint/detector/api/JavaContext;)V", "getIncidentClass", "()Ljava/lang/String;", "setIncidentClass", "(Ljava/lang/String;)V", "getLaunched", "setLaunched", "getLocation", "()Lcom/android/tools/lint/detector/api/Location;", "setLocation", "(Lcom/android/tools/lint/detector/api/Location;)V", "getResolveCallDepth", "()I", "setResolveCallDepth", "(I)V", "getReturned", "setReturned", "getUnprotectedReceiver", "setUnprotectedReceiver", "argument", "", "call", "Lorg/jetbrains/uast/UCallExpression;", "reference", "findIntentActionAssignmentCall", "expression", "Lorg/jetbrains/uast/UExpression;", "getThisExpression", "Lorg/jetbrains/uast/UThisExpression;", "block", "handleAnonymousBroadcastReceiver", "inProtectedBroadcastBranch", "inProtectedBroadcastIfBranch", "inProtectedBroadcastSwitchCase", "isIntentAction", "intentRef", "isIntentLaunchedByActivityMethods", "evaluator", "Lcom/android/tools/lint/client/api/JavaEvaluator;", "method", "Lcom/intellij/psi/PsiMethod;", "isIntentLaunchedByBroadcastReceiver", "isIntentLaunchedByContextMethods", "isIntentLaunchedByPendingIntentMethods", "isIntentLaunchedBySystem", "isProtectedBroadcastAction", "receiver", "returns", "Lorg/jetbrains/uast/UReturnExpression;", "returnsSelf", "ReturnsTracker", "android.sdktools.lint-checks"})
    private final class IntentLaunchChecker
    extends DataFlowAnalyzer {
        @NotNull
        private JavaContext context;
        @NotNull
        private Location location;
        @Nullable
        private String incidentClass;
        private boolean launched;
        private boolean returned;
        private boolean unprotectedReceiver;
        private int resolveCallDepth;
        private boolean checkProtectedBroadcast;
        final /* synthetic */ UnsafeIntentLaunchDetector this$0;

        public IntentLaunchChecker(@NotNull UnsafeIntentLaunchDetector this$0, @NotNull Collection<? extends UElement> initial, @NotNull JavaContext context2, @Nullable Location location2, String incidentClass, boolean launched, boolean returned, boolean unprotectedReceiver, int resolveCallDepth, boolean checkProtectedBroadcast) {
            Intrinsics.checkNotNullParameter(initial, (String)"initial");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)location2, (String)UnsafeIntentLaunchDetector.KEY_LOCATION);
            this.this$0 = this$0;
            super(initial, null, 2, null);
            this.context = context2;
            this.location = location2;
            this.incidentClass = incidentClass;
            this.launched = launched;
            this.returned = returned;
            this.unprotectedReceiver = unprotectedReceiver;
            this.resolveCallDepth = resolveCallDepth;
            this.checkProtectedBroadcast = checkProtectedBroadcast;
        }

        public /* synthetic */ IntentLaunchChecker(UnsafeIntentLaunchDetector unsafeIntentLaunchDetector, Collection collection, JavaContext javaContext, Location location2, String string, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 8) != 0) {
                string = null;
            }
            if ((n2 & 0x10) != 0) {
                bl = false;
            }
            if ((n2 & 0x20) != 0) {
                bl2 = false;
            }
            if ((n2 & 0x40) != 0) {
                bl3 = false;
            }
            if ((n2 & 0x80) != 0) {
                n = 0;
            }
            if ((n2 & 0x100) != 0) {
                bl4 = false;
            }
            this(unsafeIntentLaunchDetector, collection, javaContext, location2, string, bl, bl2, bl3, n, bl4);
        }

        @NotNull
        public final JavaContext getContext() {
            return this.context;
        }

        public final void setContext(@NotNull JavaContext javaContext) {
            Intrinsics.checkNotNullParameter((Object)javaContext, (String)"<set-?>");
            this.context = javaContext;
        }

        @NotNull
        public final Location getLocation() {
            return this.location;
        }

        public final void setLocation(@NotNull Location location2) {
            Intrinsics.checkNotNullParameter((Object)location2, (String)"<set-?>");
            this.location = location2;
        }

        @Nullable
        public final String getIncidentClass() {
            return this.incidentClass;
        }

        public final void setIncidentClass(@Nullable String string) {
            this.incidentClass = string;
        }

        public final boolean getLaunched() {
            return this.launched;
        }

        public final void setLaunched(boolean bl) {
            this.launched = bl;
        }

        public final boolean getReturned() {
            return this.returned;
        }

        public final void setReturned(boolean bl) {
            this.returned = bl;
        }

        public final boolean getUnprotectedReceiver() {
            return this.unprotectedReceiver;
        }

        public final void setUnprotectedReceiver(boolean bl) {
            this.unprotectedReceiver = bl;
        }

        public final int getResolveCallDepth() {
            return this.resolveCallDepth;
        }

        public final void setResolveCallDepth(int n) {
            this.resolveCallDepth = n;
        }

        public final boolean getCheckProtectedBroadcast() {
            return this.checkProtectedBroadcast;
        }

        public final void setCheckProtectedBroadcast(boolean bl) {
            this.checkProtectedBroadcast = bl;
        }

        @Override
        public boolean returnsSelf(@NotNull UCallExpression call) {
            Intrinsics.checkNotNullParameter((Object)call, (String)"call");
            if (ArraysKt.contains((Object[])INTENT_METHODS_RETURNS_INTENT_BUT_NOT_SELF, (Object)call.getMethodName())) {
                PsiType psiType = call.getReceiverType();
                if (Intrinsics.areEqual((Object)(psiType != null ? psiType.getCanonicalText() : null), (Object)UnsafeIntentLaunchDetector.INTENT_CLASS)) {
                    return false;
                }
            }
            if (UastLintUtilsKt.isReturningLambdaResult(call)) {
                UExpression lambda;
                Iterator iterator = call.getValueArguments().iterator();
                while (iterator.hasNext() && (lambda = (UExpression)iterator.next()) instanceof ULambdaExpression && (((ULambdaExpression)lambda).getValueParameters().isEmpty() ? (UAnnotated)this.getThisExpression(((ULambdaExpression)lambda).getBody()) : (UAnnotated)((ULambdaExpression)lambda).getValueParameters().get(0)) != null) {
                    UAnnotated tracked;
                    tracked = tracked;
                    ReturnsTracker returnsTracker = new ReturnsTracker(this, this.context, (UElement)tracked, false, 0, 12, null);
                    ((ULambdaExpression)lambda).getBody().accept((UastVisitor)returnsTracker);
                    if (!returnsTracker.getReturned()) continue;
                    return true;
                }
            }
            return super.returnsSelf(call);
        }

        @Override
        public void argument(@NotNull UCallExpression call, @NotNull UElement reference) {
            block14: {
                PsiMethod psiMethod;
                block16: {
                    block15: {
                        block13: {
                            Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                            Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
                            if (this.incidentClass == null) {
                                UClass uClass = (UClass)UastUtils.getParentOfType$default((UElement)((UElement)call), UClass.class, (boolean)false, (int)2, null);
                                String string = this.incidentClass = uClass != null ? uClass.getQualifiedName() : null;
                                if (this.incidentClass == null) {
                                    this.unprotectedReceiver = this.handleAnonymousBroadcastReceiver(call);
                                }
                            }
                            if (!this.isIntentLaunchedBySystem(this.context.getEvaluator(), call)) break block13;
                            if (!this.checkProtectedBroadcast || !this.inProtectedBroadcastBranch(this.context, call, reference)) {
                                this.launched = true;
                                this.location.setSecondary(this.context.getLocation((UElement)call));
                                Location location2 = this.location.getSecondary();
                                if (location2 != null) {
                                    location2.setMessage("The unsafe intent is launched here.");
                                }
                            }
                            break block14;
                        }
                        if (this.resolveCallDepth > 3) {
                            return;
                        }
                        psiMethod = call.resolve();
                        if (psiMethod == null) break block15;
                        PsiElement $this$toUElementOfType$iv = (PsiElement)psiMethod;
                        boolean $i$f$toUElementOfType = false;
                        psiMethod = (UMethod)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UMethod.class);
                        if (psiMethod != null) break block16;
                    }
                    return;
                }
                PsiMethod containingMethod = psiMethod;
                PsiParameter intentParameter = this.context.getEvaluator().computeArgumentMapping(call, containingMethod.getJavaPsi()).get(reference);
                UElement uElement = UastContextKt.toUElement((PsiElement)((PsiElement)intentParameter));
                if (uElement == null) {
                    return;
                }
                IntentLaunchChecker visitor2 = new IntentLaunchChecker(this.this$0, SetsKt.setOf((Object)uElement), this.context, this.location, this.incidentClass, false, false, false, this.resolveCallDepth + 1, false, 368, null);
                containingMethod.accept((UastVisitor)visitor2);
                if (visitor2.launched) {
                    this.this$0.reportIncident(this.context, visitor2);
                } else if (visitor2.returned) {
                    this.getInstances().add((UElement)call);
                }
            }
        }

        private final boolean isProtectedBroadcastAction(UExpression expression) {
            Object object = new ConstantEvaluator().allowFieldInitializers().evaluate((UElement)expression);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
            return BroadcastReceiverUtils.isProtectedBroadcast((String)object);
        }

        private final boolean inProtectedBroadcastBranch(JavaContext context2, UCallExpression call, UElement reference) {
            return this.inProtectedBroadcastIfBranch(context2, call, reference) || this.inProtectedBroadcastSwitchCase(call, reference);
        }

        private final boolean inProtectedBroadcastIfBranch(JavaContext context2, UCallExpression call, UElement reference) {
            UElement $this$getParentOfType_u24default$iv = (UElement)call;
            boolean strict$iv = true;
            UElement $this$getParentOfType$iv$iv = $this$getParentOfType_u24default$iv;
            boolean $i$f$getParentOfType = false;
            UIfExpression ifExp = (UIfExpression)UastUtils.getParentOfType((UElement)$this$getParentOfType$iv$iv, UIfExpression.class, (boolean)strict$iv);
            while (ifExp != null) {
                UExpression op1 = null;
                UExpression op2 = null;
                UExpression condition = ifExp.getCondition();
                if (condition instanceof UBinaryExpression && ((UBinaryExpression)condition).getOperator() == UastBinaryOperator.EQUALS) {
                    op1 = ((UBinaryExpression)condition).getLeftOperand();
                    op2 = ((UBinaryExpression)condition).getRightOperand();
                } else if (condition instanceof UQualifiedReferenceExpression) {
                    UCallExpression methodCall;
                    UExpression uExpression = ((UQualifiedReferenceExpression)condition).getSelector();
                    UCallExpression uCallExpression = methodCall = uExpression instanceof UCallExpression ? (UCallExpression)uExpression : null;
                    if (Intrinsics.areEqual((Object)(uCallExpression != null ? uCallExpression.getMethodName() : null), (Object)"equals")) {
                        op1 = ((UQualifiedReferenceExpression)condition).getReceiver();
                        op2 = (UExpression)methodCall.getValueArguments().get(0);
                    }
                }
                if (op1 != null && op2 != null && (this.isIntentAction(op1, reference) && this.isProtectedBroadcastAction(op2) || this.isIntentAction(op2, reference) && this.isProtectedBroadcastAction(op1))) {
                    return Context.getLocation$default(context2, ifExp.getThenExpression(), null, 2, null).contains(context2.getLocation((UElement)call));
                }
                UElement $this$getParentOfType_u24default$iv2 = (UElement)ifExp;
                boolean strict$iv2 = true;
                UElement $this$getParentOfType$iv$iv2 = $this$getParentOfType_u24default$iv2;
                boolean $i$f$getParentOfType2 = false;
                ifExp = (UIfExpression)UastUtils.getParentOfType((UElement)$this$getParentOfType$iv$iv2, UIfExpression.class, (boolean)strict$iv2);
            }
            return false;
        }

        private final boolean inProtectedBroadcastSwitchCase(UCallExpression call, UElement reference) {
            UElement $this$getParentOfType_u24default$iv = (UElement)call;
            boolean strict$iv2 = true;
            UElement $this$getParentOfType$iv$iv = $this$getParentOfType_u24default$iv;
            boolean $i$f$getParentOfType = false;
            USwitchExpression switchExp = (USwitchExpression)UastUtils.getParentOfType((UElement)$this$getParentOfType$iv$iv, USwitchExpression.class, (boolean)strict$iv2);
            while (switchExp != null) {
                UExpression caseValue;
                USwitchClauseExpression caseExpression;
                UExpression strict$iv2 = switchExp.getExpression();
                UReferenceExpression subject = strict$iv2 instanceof UReferenceExpression ? (UReferenceExpression)strict$iv2 : null;
                UElement $this$getParentOfType_u24default$iv2 = (UElement)call;
                boolean strict$iv32 = true;
                UElement $this$getParentOfType$iv$iv2 = $this$getParentOfType_u24default$iv2;
                boolean $i$f$getParentOfType2 = false;
                if ((USwitchClauseExpression)UastUtils.getParentOfType((UElement)$this$getParentOfType$iv$iv2, USwitchClauseExpression.class, (boolean)strict$iv32) == null) {
                    return false;
                }
                if ((UExpression)CollectionsKt.firstOrNull((List)caseExpression.getCaseValues()) == null) {
                    return false;
                }
                PsiElement strict$iv32 = caseValue.getSourcePsi();
                PsiSwitchLabelStatementBase psiSwitchLabelStatementBase = strict$iv32 instanceof PsiSwitchLabelStatementBase ? (PsiSwitchLabelStatementBase)strict$iv32 : null;
                boolean bl = psiSwitchLabelStatementBase != null ? psiSwitchLabelStatementBase.isDefaultCase() : false;
                if (bl) {
                    return false;
                }
                if (this.isIntentAction((UExpression)subject, reference) && this.isProtectedBroadcastAction(caseValue)) {
                    return true;
                }
                $this$getParentOfType_u24default$iv2 = (UElement)switchExp;
                strict$iv32 = true;
                $this$getParentOfType$iv$iv2 = $this$getParentOfType_u24default$iv2;
                $i$f$getParentOfType2 = false;
                switchExp = (USwitchExpression)UastUtils.getParentOfType((UElement)$this$getParentOfType$iv$iv2, USwitchExpression.class, (boolean)strict$iv32);
            }
            return false;
        }

        private final boolean isIntentAction(UExpression expression, UElement intentRef) {
            UCallExpression actionAssignmentCall = this.findIntentActionAssignmentCall(expression);
            UCallExpression uCallExpression = actionAssignmentCall;
            return (uCallExpression != null && (uCallExpression = uCallExpression.getReceiver()) != null && (uCallExpression = UastUtils.skipParenthesizedExprDown((UExpression)uCallExpression)) != null ? UastUtils.tryResolve((UElement)((UElement)uCallExpression)) : null) == UastUtils.tryResolve((UElement)intentRef);
        }

        private final UCallExpression findIntentActionAssignmentCall(UExpression expression) {
            PsiElement resolved;
            UExpression actionExpr;
            UExpression uExpression = expression;
            UExpression uExpression2 = actionExpr = uExpression != null ? UastUtils.skipParenthesizedExprDown((UExpression)uExpression) : null;
            Object object = resolved = uExpression2 != null ? UastUtils.tryResolve((UElement)((UElement)uExpression2)) : null;
            if (resolved instanceof PsiVariable) {
                UExpression uExpression3 = UastLintUtils.Companion.findLastAssignment((PsiVariable)resolved, (UElement)actionExpr);
                if (uExpression3 == null) {
                    return null;
                }
                UExpression assignment = uExpression3;
                return this.findIntentActionAssignmentCall(assignment);
            }
            if (actionExpr instanceof UQualifiedReferenceExpression) {
                UExpression uExpression4 = ((UQualifiedReferenceExpression)actionExpr).getSelector();
                UCallExpression uCallExpression = uExpression4 instanceof UCallExpression ? (UCallExpression)uExpression4 : null;
                if (uCallExpression == null) {
                    return null;
                }
                UCallExpression call = uCallExpression;
                return UastLintUtilsKt.isReturningContext(call) ? this.findIntentActionAssignmentCall(((UQualifiedReferenceExpression)actionExpr).getReceiver()) : this.findIntentActionAssignmentCall((UExpression)call);
            }
            PsiMethod psiMethod = resolved instanceof PsiMethod ? (PsiMethod)resolved : null;
            if (psiMethod == null) {
                return null;
            }
            PsiMethod method = psiMethod;
            return Intrinsics.areEqual((Object)"getAction", (Object)method.getName()) ? (actionExpr instanceof UCallExpression ? (UCallExpression)actionExpr : null) : (UCallExpression)null;
        }

        @Override
        public void receiver(@NotNull UCallExpression call) {
            Intrinsics.checkNotNullParameter((Object)call, (String)"call");
            if (this.resolveCallDepth > 3) {
                return;
            }
            if (UastLintUtilsKt.isScopingThis(call)) {
                UExpression lambda;
                Iterator iterator = call.getValueArguments().iterator();
                while (iterator.hasNext() && (lambda = (UExpression)iterator.next()) instanceof ULambdaExpression && this.getThisExpression(((ULambdaExpression)lambda).getBody()) != null) {
                    UThisExpression tracked;
                    IntentLaunchChecker visitor2 = new IntentLaunchChecker(this.this$0, SetsKt.setOf((Object)tracked), this.context, this.location, null, false, false, false, this.resolveCallDepth + 1, false, 376, null);
                    ((ULambdaExpression)lambda).getBody().accept((UastVisitor)visitor2);
                    if (!visitor2.launched) continue;
                    this.this$0.reportIncident(this.context, visitor2);
                }
            }
        }

        @Override
        public void returns(@NotNull UReturnExpression expression) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            this.returned = true;
        }

        private final boolean isIntentLaunchedBySystem(JavaEvaluator evaluator, UCallExpression call) {
            PsiMethod psiMethod = call.resolve();
            if (psiMethod == null) {
                return false;
            }
            PsiMethod method = psiMethod;
            return this.isIntentLaunchedByContextMethods(evaluator, method) || this.isIntentLaunchedByActivityMethods(evaluator, method) || this.isIntentLaunchedByBroadcastReceiver(evaluator, method) || this.isIntentLaunchedByPendingIntentMethods(evaluator, method);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isIntentLaunchedByContextMethods(JavaEvaluator evaluator, PsiMethod method) {
            PsiClass psiClass = method.getContainingClass();
            if (Intrinsics.areEqual((Object)(psiClass != null ? psiClass.getQualifiedName() : null), (Object)UnsafeIntentLaunchDetector.CONTEXT_CLASS)) return true;
            PsiClass psiClass2 = method.getContainingClass();
            if (Intrinsics.areEqual((Object)(psiClass2 != null ? psiClass2.getQualifiedName() : null), (Object)UnsafeIntentLaunchDetector.CONTEXT_COMPAT_CLASS)) return true;
            PsiMethod[] psiMethodArray = method.findSuperMethods(evaluator.findClass(UnsafeIntentLaunchDetector.CONTEXT_CLASS));
            Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"method.findSuperMethods(\u2026findClass(CONTEXT_CLASS))");
            if (((Object[])psiMethodArray).length != 0) return true;
            return false;
        }

        private final boolean isIntentLaunchedByActivityMethods(JavaEvaluator evaluator, PsiMethod method) {
            return ACTIVITY_INTENT_LAUNCH_METHODS.contains(method.getName()) && (JavaEvaluator.isMemberInSubClassOf$default(evaluator, (PsiMember)method, UnsafeIntentLaunchDetector.ACTIVITY_CLASS, false, 4, null) || evaluator.isMemberInClass((PsiMember)method, UnsafeIntentLaunchDetector.ACTIVITY_COMPAT_CLASS));
        }

        private final boolean isIntentLaunchedByBroadcastReceiver(JavaEvaluator evaluator, PsiMethod method) {
            return Intrinsics.areEqual((Object)method.getName(), (Object)"peekService") && JavaEvaluator.isMemberInSubClassOf$default(evaluator, (PsiMember)method, UnsafeIntentLaunchDetector.BROADCAST_RECEIVER_CLASS, false, 4, null);
        }

        private final boolean isIntentLaunchedByPendingIntentMethods(JavaEvaluator evaluator, PsiMethod method) {
            return PENDING_INTENT_LAUNCH_METHODS.contains(method.getName()) && evaluator.isMemberInClass((PsiMember)method, UnsafeIntentLaunchDetector.PENDING_INTENT_CLASS);
        }

        private final boolean handleAnonymousBroadcastReceiver(UCallExpression call) {
            Ref.BooleanRef result;
            block1: {
                UClass anonymousClass = (UClass)UastUtils.getParentOfType((UElement)((UElement)call), UClass.class, (boolean)true);
                UClass uClass = anonymousClass;
                if (uClass == null || (uClass = uClass.getUastParent()) == null) {
                    return false;
                }
                UClass parent = uClass;
                result = new Ref.BooleanRef();
                Set set = SetsKt.setOf((Object)parent);
                DataFlowAnalyzer visitor2 = new DataFlowAnalyzer(this.this$0, this, result, set){
                    final /* synthetic */ UnsafeIntentLaunchDetector this$0;
                    final /* synthetic */ IntentLaunchChecker this$1;
                    final /* synthetic */ Ref.BooleanRef $result;
                    {
                        this.this$0 = $receiver;
                        this.this$1 = $receiver2;
                        this.$result = $result;
                        super($super_call_param$1, null, 2, null);
                    }

                    public void argument(@NotNull UCallExpression call, @NotNull UElement reference) {
                        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
                        if (CollectionsKt.contains((Iterable)UnsafeIntentLaunchDetector.access$getRegisterReceiverMethods$p(this.this$0), (Object)call.getMethodName())) {
                            PsiMethod psiMethod = call.resolve();
                            if (psiMethod == null) {
                                return;
                            }
                            PsiMethod method = psiMethod;
                            if (!this.this$0.isRuntimeReceiverProtected(call, method, this.this$1.getContext().getEvaluator())) {
                                this.$result.element = true;
                            }
                        }
                    }
                };
                UMethod uMethod = (UMethod)UastUtils.getParentOfType$default((UElement)parent, UMethod.class, (boolean)false, (int)2, null);
                if (uMethod == null) break block1;
                uMethod.accept((UastVisitor)visitor2);
            }
            return result.element;
        }

        private final UThisExpression getThisExpression(UExpression block) {
            Ref.ObjectRef result = new Ref.ObjectRef();
            block.accept((UastVisitor)new AbstractUastVisitor((Ref.ObjectRef<UThisExpression>)result){
                final /* synthetic */ Ref.ObjectRef<UThisExpression> $result;
                {
                    this.$result = $result;
                }

                public boolean visitThisExpression(@NotNull UThisExpression node) {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    this.$result.element = node;
                    return super.visitThisExpression(node);
                }
            });
            return (UThisExpression)result.element;
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0005H\u0016J\u0010\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001d"}, d2={"Lcom/android/tools/lint/checks/UnsafeIntentLaunchDetector$IntentLaunchChecker$ReturnsTracker;", "Lcom/android/tools/lint/checks/DataFlowAnalyzer;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "tracked", "Lorg/jetbrains/uast/UElement;", "returned", "", "resolveCallDepth", "", "(Lcom/android/tools/lint/checks/UnsafeIntentLaunchDetector$IntentLaunchChecker;Lcom/android/tools/lint/detector/api/JavaContext;Lorg/jetbrains/uast/UElement;ZI)V", "getContext", "()Lcom/android/tools/lint/detector/api/JavaContext;", "getResolveCallDepth", "()I", "setResolveCallDepth", "(I)V", "getReturned", "()Z", "setReturned", "(Z)V", "argument", "", "call", "Lorg/jetbrains/uast/UCallExpression;", "reference", "returns", "expression", "Lorg/jetbrains/uast/UReturnExpression;", "android.sdktools.lint-checks"})
        public final class ReturnsTracker
        extends DataFlowAnalyzer {
            @NotNull
            private final JavaContext context;
            private boolean returned;
            private int resolveCallDepth;
            final /* synthetic */ IntentLaunchChecker this$0;

            public ReturnsTracker(@NotNull IntentLaunchChecker this$0, @NotNull JavaContext context2, UElement tracked, boolean returned, int resolveCallDepth) {
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                Intrinsics.checkNotNullParameter((Object)tracked, (String)"tracked");
                this.this$0 = this$0;
                super(SetsKt.setOf((Object)tracked), null, 2, null);
                this.context = context2;
                this.returned = returned;
                this.resolveCallDepth = resolveCallDepth;
            }

            public /* synthetic */ ReturnsTracker(IntentLaunchChecker intentLaunchChecker, JavaContext javaContext, UElement uElement, boolean bl, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n2 & 4) != 0) {
                    bl = false;
                }
                if ((n2 & 8) != 0) {
                    n = 0;
                }
                this(intentLaunchChecker, javaContext, uElement, bl, n);
            }

            @NotNull
            public final JavaContext getContext() {
                return this.context;
            }

            public final boolean getReturned() {
                return this.returned;
            }

            public final void setReturned(boolean bl) {
                this.returned = bl;
            }

            public final int getResolveCallDepth() {
                return this.resolveCallDepth;
            }

            public final void setResolveCallDepth(int n) {
                this.resolveCallDepth = n;
            }

            @Override
            public void returns(@NotNull UReturnExpression expression) {
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                this.returned = true;
            }

            @Override
            public void argument(@NotNull UCallExpression call, @NotNull UElement reference) {
                PsiMethod psiMethod;
                block8: {
                    block7: {
                        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
                        if (this.resolveCallDepth > 3) {
                            return;
                        }
                        psiMethod = call.resolve();
                        if (psiMethod == null) break block7;
                        PsiElement $this$toUElementOfType$iv = (PsiElement)psiMethod;
                        boolean $i$f$toUElementOfType = false;
                        psiMethod = (UMethod)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UMethod.class);
                        if (psiMethod != null) break block8;
                    }
                    return;
                }
                PsiMethod containingMethod = psiMethod;
                UElement uElement = UastContextKt.toUElement((PsiElement)((PsiElement)this.context.getEvaluator().computeArgumentMapping(call, containingMethod.getJavaPsi()).get(reference)));
                if (uElement == null) {
                    return;
                }
                UElement tracked = uElement;
                ReturnsTracker returnsTracker = new ReturnsTracker(this.this$0, this.context, tracked, false, this.resolveCallDepth + 1, 4, null);
                PsiMethod psiMethod2 = call.resolve();
                if (psiMethod2 != null) {
                    PsiElement $this$toUElementOfType$iv = (PsiElement)psiMethod2;
                    boolean $i$f$toUElementOfType = false;
                    psiMethod2 = (UMethod)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UMethod.class);
                    if (psiMethod2 != null) {
                        psiMethod2.accept((UastVisitor)returnsTracker);
                    }
                }
                this.returned = returnsTracker.returned;
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010$\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u0012X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u0010\u0010\u0014\u001a\u00020\u00158\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u001dX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R \u0010\"\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00120#X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/android/tools/lint/checks/UnsafeIntentLaunchDetector$Companion;", "", "()V", "ACTIVITY_CLASS", "", "ACTIVITY_COMPAT_CLASS", "ACTIVITY_INTENT_LAUNCH_METHODS", "", "BROADCAST_RECEIVER_CLASS", "BUNDLE_CLASS", "BUNDLE_COMPAT_CLASS", "CONTEXT_CLASS", "CONTEXT_COMPAT_CLASS", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "INTENT_CLASS", "INTENT_COMPAT_CLASS", "INTENT_METHODS_RETURNS_INTENT_BUT_NOT_SELF", "", "[Ljava/lang/String;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "KEY_INCIDENTS", "KEY_INCIDENT_CLASS", "KEY_LOCATION", "KEY_SECONDARY_LOCATION", "KEY_UNPROTECTED", "KNOWN_NORMAL_PERMISSIONS", "MAX_CALL_DEPTH", "", "PENDING_INTENT_CLASS", "PENDING_INTENT_LAUNCH_METHODS", "RECEIVER_NOT_EXPORTED", "SERVICE_CLASS", "UNSAFE_INTENT_AS_PARAMETER_METHODS", "", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

