/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.resources.ResourceUrl;
import com.android.tools.lint.checks.VectorDetector;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.ResourceRepositoryScope;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Constraints;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class VectorPathDetector
extends ResourceXmlDetector {
    public static final Issue PATH_LENGTH = Issue.create("VectorPath", "Long vector paths", "Using long vector paths is bad for performance. There are several ways to make the `pathData` shorter:\n* Using less precision\n* Removing some minor details\n* Using the Android Studio vector conversion tool\n* Rasterizing the image (converting to PNG)", Category.PERFORMANCE, 5, Severity.WARNING, new Implementation(VectorPathDetector.class, Scope.RESOURCE_FILE_SCOPE));
    public static final Issue PATH_VALID = Issue.create("InvalidVectorPath", "Invalid vector paths", "This check ensures that vector paths are valid. For example, it makes sure that the numbers are not using scientific notation (such as 1.0e3) which can lead to runtime crashes on older devices. As another example, it flags numbers like `.5` which should be written as `0.5` instead to avoid crashes on some pre-Marshmallow devices.", Category.CORRECTNESS, 5, Severity.ERROR, new Implementation(VectorPathDetector.class, Scope.RESOURCE_FILE_SCOPE)).addMoreInfo("https://issuetracker.google.com/37008268");
    static final int MAX_PATH_DATA_LENGTH = 800;

    @Override
    public Collection<String> getApplicableAttributes() {
        return Collections.singletonList("pathData");
    }

    @Override
    public void visitAttribute(XmlContext context2, Attr attribute) {
        Element root;
        String value = attribute.getValue();
        if (value.startsWith("@")) {
            Project project;
            ResourceUrl url = ResourceUrl.parse((String)value);
            if (url == null || url.isFramework()) {
                return;
            }
            LintClient client = context2.getClient();
            ResourceRepository repository2 = client.getResources(project = context2.getProject(), ResourceRepositoryScope.ALL_DEPENDENCIES);
            List item = repository2.getResources(ResourceNamespace.TODO(), url.type, url.name);
            if (item.isEmpty()) {
                return;
            }
            ResourceValue resourceValue = ((ResourceItem)item.get(0)).getResourceValue();
            if (resourceValue == null) {
                return;
            }
            value = resourceValue.getValue();
            if (value == null) {
                return;
            }
        }
        if ((root = attribute.getOwnerDocument().getDocumentElement()) == null || !root.getTagName().equals("vector")) {
            return;
        }
        this.validatePath(context2, attribute, value);
        int length = this.countPathLength(value);
        if (length < 800) {
            return;
        }
        if (VectorPathDetector.isRasterizingVector(context2)) {
            return;
        }
        String message2 = String.format(Locale.getDefault(), "Very long vector path (%1$d characters), which is bad for performance. Considering reducing precision, removing minor details or rasterizing vector.", length);
        Incident incident = new Incident(PATH_LENGTH, attribute, context2.getValueLocation(attribute), message2);
        context2.report(incident);
    }

    private int countPathLength(String value) {
        int count = 0;
        boolean prevSpace = false;
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            boolean isSpace = Character.isWhitespace(c);
            if (!isSpace || !prevSpace) {
                ++count;
            }
            prevSpace = isSpace;
        }
        return count;
    }

    private static boolean isRasterizingVector(XmlContext context2) {
        Project project = context2.getProject();
        if (project.getMinSdkVersion().getFeatureLevel() >= 21) {
            return false;
        }
        if (context2.getFolderVersion() >= 21) {
            return false;
        }
        if (!VectorDetector.isVectorGenerationSupported(context2.getProject())) {
            return false;
        }
        if (VectorDetector.usingSupportLibVectors(project)) {
            return false;
        }
        return project.isGradleProject();
    }

    public void validatePath(XmlContext context2, Attr attribute, String path2) {
        if (context2.getProject().getMinSdkVersion().getFeatureLevel() >= 23) {
            return;
        }
        int start2 = 0;
        int end2 = 1;
        while (end2 < path2.length()) {
            int trimEnd;
            int trimStart;
            end2 = VectorPathDetector.findNextStart(path2, end2);
            for (trimStart = start2; trimStart < end2 && Character.isWhitespace(path2.charAt(trimStart)); ++trimStart) {
            }
            for (trimEnd = end2; trimEnd > trimStart + 1 && Character.isWhitespace(path2.charAt(trimEnd - 1)); --trimEnd) {
            }
            if (trimEnd > trimStart) {
                this.checkFloats(context2, attribute, path2, trimStart, trimEnd);
            }
            start2 = end2++;
        }
    }

    private void checkFloats(XmlContext context2, Attr attribute, String s, int start2, int end2) {
        if (s.charAt(start2) == 'z' || s.charAt(start2) == 'Z') {
            return;
        }
        int startPosition = start2 + 1;
        while (startPosition < end2) {
            Object message2;
            int currentIndex;
            boolean foundSeparator = false;
            boolean endWithNegOrDot = false;
            boolean hasExponential = false;
            boolean secondDot = false;
            boolean isExponential = false;
            for (currentIndex = startPosition; currentIndex < end2; ++currentIndex) {
                boolean isPrevExponential = isExponential;
                isExponential = false;
                char currentChar = s.charAt(currentIndex);
                switch (currentChar) {
                    case '\t': 
                    case '\n': 
                    case ' ': 
                    case ',': {
                        foundSeparator = true;
                        break;
                    }
                    case '-': {
                        if (currentIndex == startPosition || isPrevExponential) break;
                        foundSeparator = true;
                        endWithNegOrDot = true;
                        break;
                    }
                    case '.': {
                        if (!secondDot) {
                            secondDot = true;
                            break;
                        }
                        foundSeparator = true;
                        endWithNegOrDot = true;
                        break;
                    }
                    case 'E': 
                    case 'e': {
                        isExponential = true;
                        hasExponential = true;
                    }
                }
                if (foundSeparator) break;
            }
            if (hasExponential && startPosition < currentIndex && context2.getProject().getMinSdkVersion().getFeatureLevel() < 21) {
                String number = s.substring(startPosition, currentIndex);
                String converted = null;
                try {
                    DecimalFormat df = new DecimalFormat("0", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
                    df.setMaximumFractionDigits(340);
                    converted = df.format(Double.parseDouble(number));
                }
                catch (NumberFormatException df) {
                    // empty catch block
                }
                message2 = String.format("Avoid scientific notation (`%1$s`) in vector paths because it can lead to crashes on some devices.", number);
                if (converted != null) {
                    message2 = (String)message2 + " Use `" + converted + "` instead.";
                }
                this.reportInvalidPathData(context2, attribute, s, startPosition, currentIndex, number, converted, (String)message2, "Replace scientific notation", 21);
            }
            if (s.startsWith(".", startPosition) || s.startsWith("-.", startPosition) && context2.getProject().getMinSdkVersion().getFeatureLevel() < 23) {
                String number = s.substring(startPosition, currentIndex);
                String replace = number.startsWith(".") ? "0" + number : "-0." + number.substring(2);
                message2 = String.format("Use %1$s instead of %2$s to avoid crashes on some devices", replace, number);
                if (number.startsWith(".") && startPosition > 0 && Character.isDigit(s.charAt(startPosition - 1))) {
                    replace = " " + replace;
                }
                this.reportInvalidPathData(context2, attribute, s, startPosition, currentIndex, number, replace, (String)message2, "Add leading 0", 23);
            }
            int endPosition = currentIndex;
            if (endWithNegOrDot) {
                startPosition = endPosition;
                continue;
            }
            startPosition = endPosition + 1;
        }
    }

    private void reportInvalidPathData(XmlContext context2, Attr attribute, String s, int startPosition, int currentIndex, String number, String replace, String message2, String sharedName, int minApiLessThan) {
        Location location2 = context2.getValueLocation(attribute);
        Position startPos = location2.getStart();
        assert (startPos != null);
        LintFix lintFix = null;
        if (s.equals(attribute.getValue())) {
            location2 = Location.create(context2.file, context2.getContents(), startPos.getOffset() + startPosition, startPos.getOffset() + currentIndex);
            if (replace != null) {
                lintFix = this.fix().name("Replace with " + replace.trim()).sharedName(sharedName).replace().text(number).with(replace).range(location2).autoFix().build();
            }
        }
        Incident incident = new Incident(PATH_VALID, attribute, location2, message2, lintFix);
        context2.report(incident, Constraints.minSdkLessThan(minApiLessThan));
    }

    private static int findNextStart(String s, int end2) {
        while (end2 < s.length()) {
            char c = s.charAt(end2);
            if (((c - 65) * (c - 90) <= 0 || (c - 97) * (c - 122) <= 0) && c != 'e' && c != 'E') {
                return end2;
            }
            ++end2;
        }
        return end2;
    }
}

