/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.ControlFlowGraph;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.ClassScanner;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.analysis.AnalyzerException;

public class WakelockDetector
extends Detector
implements ClassScanner,
SourceCodeScanner {
    public static final String ANDROID_APP_ACTIVITY = "android.app.Activity";
    public static final Issue ISSUE = Issue.create("Wakelock", "Incorrect `WakeLock` usage", "Failing to release a wakelock properly can keep the Android device in a high power mode, which reduces battery life. There are several causes of this, such as releasing the wake lock in `onDestroy()` instead of in `onPause()`, failing to call `release()` in all possible code paths after an `acquire()`, and so on.\n\nNOTE: If you are using the lock just to keep the screen on, you should strongly consider using `FLAG_KEEP_SCREEN_ON` instead. This window flag will be correctly managed by the platform as the user moves between applications and doesn't require a special permission. See https://developer.android.com/reference/android/view/WindowManager.LayoutParams.html#FLAG_KEEP_SCREEN_ON.", Category.PERFORMANCE, 9, Severity.WARNING, new Implementation(WakelockDetector.class, Scope.CLASS_FILE_SCOPE)).setAndroidSpecific(true);
    public static final Issue TIMEOUT = Issue.create("WakelockTimeout", "Using wakeLock without timeout", "Wakelocks have two acquire methods: one with a timeout, and one without. You should generally always use the one with a timeout. A typical timeout is 10 minutes. If the task takes longer than it is critical that it happens (i.e. can't use `JobScheduler`) then maybe they should consider a foreground service instead (which is a stronger run guarantee and lets the user know something long/important is happening).", Category.PERFORMANCE, 9, Severity.WARNING, new Implementation(WakelockDetector.class, Scope.JAVA_FILE_SCOPE)).setAndroidSpecific(true);
    private static final String WAKELOCK_OWNER = "android/os/PowerManager$WakeLock";
    private static final String RELEASE_METHOD = "release";
    private static final String ACQUIRE_METHOD = "acquire";
    private static final String IS_HELD_METHOD = "isHeld";
    private static final String POWER_MANAGER = "android/os/PowerManager";
    private static final String NEW_WAKE_LOCK_METHOD = "newWakeLock";
    private boolean mHasAcquire;
    private boolean mHasRelease;
    private static final int SEEN_TARGET = 1;
    private static final int SEEN_BRANCH = 2;
    private static final int SEEN_EXCEPTION = 4;
    private static final int SEEN_RETURN = 8;

    @Override
    public void afterCheckRootProject(Context context2) {
        if (this.mHasAcquire && !this.mHasRelease && context2.getDriver().getPhase() == 1) {
            context2.getDriver().requestRepeat(this, Scope.CLASS_FILE_SCOPE);
        }
    }

    @Override
    public List<String> getApplicableCallNames() {
        return Arrays.asList(ACQUIRE_METHOD, RELEASE_METHOD, NEW_WAKE_LOCK_METHOD);
    }

    @Override
    public void checkCall(ClassContext context2, ClassNode classNode, MethodNode method, MethodInsnNode call) {
        if (!context2.getProject().getReportIssues()) {
            return;
        }
        if (call.owner.equals(WAKELOCK_OWNER)) {
            String name = call.name;
            if (name.equals(ACQUIRE_METHOD)) {
                if (call.desc.equals("(J)V")) {
                    return;
                }
                this.mHasAcquire = true;
                if (context2.getDriver().getPhase() == 2) {
                    assert (!this.mHasRelease);
                    context2.report(ISSUE, method, (AbstractInsnNode)call, context2.getLocation((AbstractInsnNode)call), "Found a wakelock `acquire()` but no `release()` calls anywhere");
                } else {
                    assert (context2.getDriver().getPhase() == 1);
                    WakelockDetector.checkFlow(context2, classNode, method, call);
                }
            } else if (name.equals(RELEASE_METHOD)) {
                this.mHasRelease = true;
                if ("onDestroy".equals(method.name)) {
                    PsiClass psiClass = context2.findPsiClass(classNode);
                    PsiClass activityClass = context2.findPsiClass(ANDROID_APP_ACTIVITY);
                    if (psiClass != null && activityClass != null && psiClass.isInheritor(activityClass, true)) {
                        context2.report(ISSUE, method, (AbstractInsnNode)call, context2.getLocation((AbstractInsnNode)call), "Wakelocks should be released in `onPause`, not `onDestroy`");
                    }
                }
            }
        } else if (call.owner.equals(POWER_MANAGER) && call.name.equals(NEW_WAKE_LOCK_METHOD)) {
            AbstractInsnNode prev = Lint.getPrevInstruction((AbstractInsnNode)call);
            if (prev == null) {
                return;
            }
            if ((prev = Lint.getPrevInstruction(prev)) == null || prev.getOpcode() != 18) {
                return;
            }
            LdcInsnNode ldc = (LdcInsnNode)prev;
            Object constant = ldc.cst;
            if (constant instanceof Integer) {
                int flag = (Integer)constant;
                boolean PARTIAL_WAKE_LOCK = true;
                int ACQUIRE_CAUSES_WAKEUP = 0x10000000;
                int both = 0x10000001;
                if ((flag & 0x10000001) == 0x10000001) {
                    context2.report(ISSUE, method, (AbstractInsnNode)call, context2.getLocation((AbstractInsnNode)call), "Should not set both `PARTIAL_WAKE_LOCK` and `ACQUIRE_CAUSES_WAKEUP`. If you do not want the screen to turn on, get rid of `ACQUIRE_CAUSES_WAKEUP`");
                }
            }
        }
    }

    private static void checkFlow(ClassContext context2, ClassNode classNode, MethodNode method, MethodInsnNode acquire) {
        InsnList instructions = method.instructions;
        MethodInsnNode release = null;
        int n = instructions.size();
        for (int i = 0; i < n; ++i) {
            AbstractInsnNode instruction = instructions.get(i);
            int type2 = instruction.getType();
            if (type2 != 5) continue;
            MethodInsnNode call = (MethodInsnNode)instruction;
            if (!call.name.equals(RELEASE_METHOD) || !call.owner.equals(WAKELOCK_OWNER)) continue;
            release = call;
            break;
        }
        if (release == null) {
            return;
        }
        try {
            MyGraph graph = new MyGraph();
            ControlFlowGraph.create(graph, classNode, method);
            int status = WakelockDetector.dfs(graph.getNode((AbstractInsnNode)acquire));
            if ((status & 8) != 0) {
                String message2 = (status & 4) != 0 ? "The `release()` call is not always reached (via exceptional flow)" : "The `release()` call is not always reached";
                context2.report(ISSUE, method, (AbstractInsnNode)acquire, context2.getLocation((AbstractInsnNode)release), message2);
            }
        }
        catch (AnalyzerException e) {
            context2.log(e, null, new Object[0]);
        }
    }

    protected static int dfs(ControlFlowGraph.Node node) {
        int opcode;
        AbstractInsnNode instruction = node.instruction;
        if (instruction.getType() == 7 && ((opcode = instruction.getOpcode()) == 177 || opcode == 176 || opcode == 173 || opcode == 172 || opcode == 175 || opcode == 174 || opcode == 191)) {
            return 8;
        }
        if (node.visit != 0) {
            return 0;
        }
        node.visit = 1;
        if (instruction.getType() == 5) {
            MethodInsnNode method = (MethodInsnNode)instruction;
            if (method.name.equals(RELEASE_METHOD) && method.owner.equals(WAKELOCK_OWNER)) {
                return 1;
            }
            if (!(method.name.equals(ACQUIRE_METHOD) && method.owner.equals(WAKELOCK_OWNER) || method.name.equals(IS_HELD_METHOD) && method.owner.equals(WAKELOCK_OWNER) || !node.exceptions.isEmpty())) {
                boolean foundFrame = false;
                for (AbstractInsnNode curr = method.getPrevious(); curr != null; curr = curr.getPrevious()) {
                    if (curr.getType() != 14) continue;
                    foundFrame = true;
                    break;
                }
                if (!foundFrame) {
                    return 8;
                }
            }
        }
        int status = 0;
        boolean implicitReturn = true;
        List<ControlFlowGraph.Node> successors2 = node.successors;
        List<ControlFlowGraph.Node> exceptions = node.exceptions;
        if (!exceptions.isEmpty()) {
            implicitReturn = false;
        }
        for (ControlFlowGraph.Node successor : exceptions) {
            status = WakelockDetector.dfs(successor) | status;
            if ((status & 8) == 0) continue;
            return status;
        }
        if (status != 0) {
            status |= 4;
        }
        if (!successors2.isEmpty()) {
            implicitReturn = false;
            if (successors2.size() > 1) {
                status |= 2;
            }
        }
        for (ControlFlowGraph.Node successor : successors2) {
            status = WakelockDetector.dfs(successor) | status;
            if ((status & 8) == 0) continue;
            return status;
        }
        if (implicitReturn) {
            status |= 8;
        }
        return status;
    }

    @Override
    public List<String> getApplicableMethodNames() {
        return Collections.singletonList(ACQUIRE_METHOD);
    }

    @Override
    public void visitMethodCall(JavaContext context2, UCallExpression call, PsiMethod method) {
        if (call.getValueArgumentCount() > 0) {
            return;
        }
        if (!context2.getEvaluator().isMemberInClass((PsiMember)method, "android.os.PowerManager.WakeLock")) {
            return;
        }
        Location location2 = context2.getLocation((UElement)call);
        LintFix fix = this.fix().name("Set timeout to 10 minutes").replace().pattern("acquire\\s*\\(()\\s*\\)").with("10*60*1000L /*10 minutes*/").build();
        context2.report(TIMEOUT, (UElement)call, location2, "Provide a timeout when requesting a wakelock with `PowerManager.Wakelock.acquire(long timeout)`. This will ensure the OS will cleanup any wakelocks that last longer than you intend, and will save your user's battery.", fix);
    }

    private static class MyGraph
    extends ControlFlowGraph {
        private MyGraph() {
        }

        @Override
        protected void add(AbstractInsnNode from, AbstractInsnNode to) {
            if (from.getOpcode() == 198) {
                AbstractInsnNode next;
                JumpInsnNode jump = (JumpInsnNode)from;
                if (jump.label == to && (next = Lint.getNextInstruction(from)) != null && next.getType() == 2 && (next = Lint.getNextInstruction(next)) != null && next.getType() == 5) {
                    MethodInsnNode method = (MethodInsnNode)next;
                    if (method.name.equals(WakelockDetector.RELEASE_METHOD) && method.owner.equals(WakelockDetector.WAKELOCK_OWNER)) {
                        return;
                    }
                }
            } else if (from.getOpcode() == 153) {
                AbstractInsnNode prev;
                JumpInsnNode jump = (JumpInsnNode)from;
                if (jump.label == to && (prev = Lint.getPrevInstruction(from)) != null && prev.getType() == 5) {
                    AbstractInsnNode next;
                    MethodInsnNode method = (MethodInsnNode)prev;
                    if (method.name.equals(WakelockDetector.IS_HELD_METHOD) && method.owner.equals(WakelockDetector.WAKELOCK_OWNER) && (next = Lint.getNextInstruction(from)) != null) {
                        super.add(from, next);
                        return;
                    }
                }
            }
            super.add(from, to);
        }
    }
}

